"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_s3_1 = require("@aws-sdk/client-s3");
async function handler(event) {
    const request = event.Records[0].cf.request;
    try {
        const s3Origin = request.origin?.s3;
        if (!s3Origin) {
            throw new Error('No S3 origin');
        }
        const s3Client = new client_s3_1.S3Client({ region: s3Origin.region });
        const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), '');
        const key = request.uri.substring(1); // remove first slash
        const data = await s3Client.send(new client_s3_1.GetObjectCommand({
            Bucket: bucket,
            Key: key,
        }));
        if (!data.Body) {
            throw new Error('No body');
        }
        const redirect = JSON.parse(await data.Body.transformToString());
        return {
            status: '301',
            statusDescription: 'Moved Permanently',
            headers: {
                location: [{
                        key: 'Location',
                        value: redirect.url,
                    }],
            },
        };
    }
    catch (err) {
        console.log(err);
        return {
            status: '404',
            statusDescription: 'Not Found',
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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