"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
/* eslint-disable no-console */
const url_1 = require("url");
const client_dynamodb_1 = require("@aws-sdk/client-dynamodb");
const client_s3_1 = require("@aws-sdk/client-s3");
const lib_dynamodb_1 = require("@aws-sdk/lib-dynamodb");
function base62Encode(int) {
    const characterSet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    if (int === 0)
        return '0';
    let s = '';
    while (int > 0) {
        s = characterSet[int % 62] + s;
        int = Math.floor(int / 62);
    }
    return s;
}
;
function getEnv(name) {
    const value = process.env[name];
    if (!value) {
        throw new Error(`The environment variable ${name} is not defined`);
    }
    return value;
}
function isUrlValid(url) {
    if (!url) {
        return false;
    }
    try {
        new url_1.URL(url);
        return true;
    }
    catch (err) {
        return false;
    }
}
const dynamoDBClient = new client_dynamodb_1.DynamoDBClient({});
const documentClient = lib_dynamodb_1.DynamoDBDocumentClient.from(dynamoDBClient);
const s3Client = new client_s3_1.S3Client({});
async function handler(event) {
    console.log('Event: %j', event);
    const response = {
        statusCode: 201,
        body: '',
        headers: process.env.CORS_ALLOW_ORIGINS
            ? { 'Access-Control-Allow-Origin': process.env.CORS_ALLOW_ORIGINS }
            : undefined,
    };
    try {
        const body = JSON.parse(event.body ?? '{}');
        if (!isUrlValid(body.url)) {
            return {
                ...response,
                statusCode: 400,
            };
        }
        // Get next counter value
        const update = await documentClient.send(new lib_dynamodb_1.UpdateCommand({
            TableName: getEnv('TABLE_NAME'),
            Key: { key: 'counter' },
            UpdateExpression: 'ADD #value :incr',
            ExpressionAttributeNames: { '#value': 'value' },
            ExpressionAttributeValues: { ':incr': 1 },
            ReturnValues: 'UPDATED_NEW',
        }));
        const value = update.Attributes?.value;
        if (!value) {
            throw new Error('Cannot get next counter value');
        }
        const key = base62Encode(value);
        console.log('Key: %j', key);
        const putObject = await s3Client.send(new client_s3_1.PutObjectCommand({
            Bucket: getEnv('BUCKET_NAME'),
            Key: key,
            ContentType: 'application/json',
            Body: JSON.stringify({ url: body.url }),
        }));
        console.log('Put object: %j', putObject);
        // Return short url
        return {
            ...response,
            body: JSON.stringify({
                url: body.url,
                shortUrl: `https://${getEnv('DOMAIN_NAME')}/${key}`,
            }),
        };
    }
    catch (err) {
        console.log(err);
        return {
            ...response,
            statusCode: 500,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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