import type { OptionalArgument } from '../helpers';
import type { OptionalTeamAssignable, TokenOverridable } from './common';
interface ReminderRecurrenceDailyMonthlyYearly {
    /** @description Specifies the repeating behavior of a reminder. */
    frequency: 'daily' | 'monthly' | 'yearly';
}
type DaysOfTheWeek = 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday' | 'sunday';
interface ReminderRecurrenceWeekly {
    /** @description Specifies the repeating behavior of a reminder. */
    frequency: 'weekly';
    /** @description Specifies the day-of-the-week repeating behaviour when `frequency` is set to `weekly`. */
    weekdays: [DaysOfTheWeek, ...DaysOfTheWeek[]];
}
type ReminderRecurrence = ReminderRecurrenceWeekly | ReminderRecurrenceDailyMonthlyYearly;
export interface RemindersAddArguments extends TokenOverridable, OptionalTeamAssignable {
    /** @description The content of the reminder. */
    text: string;
    /**
     * @description When this reminder should happen, one of:
     * - the Unix timestamp (up to five years from now),
     * - the number of seconds until the reminder (if within 24 hours), or
     * - a natural language description (Ex. "in 15 minutes," or "every Thursday").
     */
    time: string | number;
    /**
     * @description No longer supported - reminders cannot be set for other users.
     * @deprecated
     * @see {@link https://api.slack.com/changelog/2023-07-its-later-already-for-stars-and-reminders#what Changes to `reminders.*` APIs announcement}.
     */
    user?: string;
    /**
     * @description Specify the repeating behavior of a reminder. If you set the sub-property `frequency` to `weekly`,
     * you must also set the `weekdays` array to specify which days of the week to recur on.
     */
    recurrence?: ReminderRecurrence;
}
export interface RemindersCompleteArguments extends TokenOverridable, OptionalTeamAssignable {
    /** @description The ID of the reminder to be marked as complete. */
    reminder: string;
}
export interface RemindersDeleteArguments extends TokenOverridable, OptionalTeamAssignable {
    /** @description The ID of the reminder to delete. */
    reminder: string;
}
export interface RemindersInfoArguments extends TokenOverridable, OptionalTeamAssignable {
    /** @description The ID of the reminder to retrieve information about. */
    reminder: string;
}
export type RemindersListArguments = OptionalArgument<TokenOverridable & OptionalTeamAssignable>;
export {};
//# sourceMappingURL=reminders.d.ts.map