# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input['AlertConditionArgs'],
                 display_name: pulumi.Input[_builtins.str],
                 query_id: pulumi.Input[_builtins.str],
                 custom_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_on_ok: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_retrigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input['AlertConditionArgs'] condition: Trigger conditions of the alert. Block consists of the following attributes:
        :param pulumi.Input[_builtins.str] display_name: Name of the alert.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.str] custom_body: Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] custom_subject: Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.bool] notify_on_ok: Whether to notify alert subscribers when alert returns back to normal.
        :param pulumi.Input[_builtins.str] owner_user_name: Alert owner's username.
        :param pulumi.Input[_builtins.str] parent_path: The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        :param pulumi.Input[_builtins.int] seconds_to_retrigger: Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "query_id", query_id)
        if custom_body is not None:
            pulumi.set(__self__, "custom_body", custom_body)
        if custom_subject is not None:
            pulumi.set(__self__, "custom_subject", custom_subject)
        if notify_on_ok is not None:
            pulumi.set(__self__, "notify_on_ok", notify_on_ok)
        if owner_user_name is not None:
            pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parent_path is not None:
            pulumi.set(__self__, "parent_path", parent_path)
        if seconds_to_retrigger is not None:
            pulumi.set(__self__, "seconds_to_retrigger", seconds_to_retrigger)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Input['AlertConditionArgs']:
        """
        Trigger conditions of the alert. Block consists of the following attributes:
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['AlertConditionArgs']):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the alert.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the query evaluated by the alert.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query_id", value)

    @_builtins.property
    @pulumi.getter(name="customBody")
    def custom_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        """
        return pulumi.get(self, "custom_body")

    @custom_body.setter
    def custom_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_body", value)

    @_builtins.property
    @pulumi.getter(name="customSubject")
    def custom_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        """
        return pulumi.get(self, "custom_subject")

    @custom_subject.setter
    def custom_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_subject", value)

    @_builtins.property
    @pulumi.getter(name="notifyOnOk")
    def notify_on_ok(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to notify alert subscribers when alert returns back to normal.
        """
        return pulumi.get(self, "notify_on_ok")

    @notify_on_ok.setter
    def notify_on_ok(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notify_on_ok", value)

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert owner's username.
        """
        return pulumi.get(self, "owner_user_name")

    @owner_user_name.setter
    def owner_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_user_name", value)

    @_builtins.property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        """
        return pulumi.get(self, "parent_path")

    @parent_path.setter
    def parent_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_path", value)

    @_builtins.property
    @pulumi.getter(name="secondsToRetrigger")
    def seconds_to_retrigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        """
        return pulumi.get(self, "seconds_to_retrigger")

    @seconds_to_retrigger.setter
    def seconds_to_retrigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "seconds_to_retrigger", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['AlertConditionArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_state: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_on_ok: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_retrigger: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_time: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input['AlertConditionArgs'] condition: Trigger conditions of the alert. Block consists of the following attributes:
        :param pulumi.Input[_builtins.str] create_time: The timestamp string indicating when the alert was created.
        :param pulumi.Input[_builtins.str] custom_body: Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] custom_subject: Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] display_name: Name of the alert.
        :param pulumi.Input[_builtins.str] lifecycle_state: The workspace state of the alert. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        :param pulumi.Input[_builtins.bool] notify_on_ok: Whether to notify alert subscribers when alert returns back to normal.
        :param pulumi.Input[_builtins.str] owner_user_name: Alert owner's username.
        :param pulumi.Input[_builtins.str] parent_path: The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.int] seconds_to_retrigger: Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        :param pulumi.Input[_builtins.str] state: Current state of the alert's trigger status (`UNKNOWN`, `OK`, `TRIGGERED`). This field is set to `UNKNOWN` if the alert has not yet been evaluated or ran into an error during the last evaluation.
        :param pulumi.Input[_builtins.str] trigger_time: The timestamp string when the alert was last triggered if the alert has been triggered before.
        :param pulumi.Input[_builtins.str] update_time: The timestamp string indicating when the alert was updated.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_body is not None:
            pulumi.set(__self__, "custom_body", custom_body)
        if custom_subject is not None:
            pulumi.set(__self__, "custom_subject", custom_subject)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if notify_on_ok is not None:
            pulumi.set(__self__, "notify_on_ok", notify_on_ok)
        if owner_user_name is not None:
            pulumi.set(__self__, "owner_user_name", owner_user_name)
        if parent_path is not None:
            pulumi.set(__self__, "parent_path", parent_path)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if seconds_to_retrigger is not None:
            pulumi.set(__self__, "seconds_to_retrigger", seconds_to_retrigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if trigger_time is not None:
            pulumi.set(__self__, "trigger_time", trigger_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AlertConditionArgs']]:
        """
        Trigger conditions of the alert. Block consists of the following attributes:
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AlertConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp string indicating when the alert was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customBody")
    def custom_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        """
        return pulumi.get(self, "custom_body")

    @custom_body.setter
    def custom_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_body", value)

    @_builtins.property
    @pulumi.getter(name="customSubject")
    def custom_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        """
        return pulumi.get(self, "custom_subject")

    @custom_subject.setter
    def custom_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_subject", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the alert.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace state of the alert. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        """
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_state", value)

    @_builtins.property
    @pulumi.getter(name="notifyOnOk")
    def notify_on_ok(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to notify alert subscribers when alert returns back to normal.
        """
        return pulumi.get(self, "notify_on_ok")

    @notify_on_ok.setter
    def notify_on_ok(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notify_on_ok", value)

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alert owner's username.
        """
        return pulumi.get(self, "owner_user_name")

    @owner_user_name.setter
    def owner_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_user_name", value)

    @_builtins.property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        """
        return pulumi.get(self, "parent_path")

    @parent_path.setter
    def parent_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_path", value)

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the query evaluated by the alert.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_id", value)

    @_builtins.property
    @pulumi.getter(name="secondsToRetrigger")
    def seconds_to_retrigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        """
        return pulumi.get(self, "seconds_to_retrigger")

    @seconds_to_retrigger.setter
    def seconds_to_retrigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "seconds_to_retrigger", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current state of the alert's trigger status (`UNKNOWN`, `OK`, `TRIGGERED`). This field is set to `UNKNOWN` if the alert has not yet been evaluated or ran into an error during the last evaluation.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="triggerTime")
    def trigger_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp string when the alert was last triggered if the alert has been triggered before.
        """
        return pulumi.get(self, "trigger_time")

    @trigger_time.setter
    def trigger_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_time", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp string indicating when the alert was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("databricks:index/alert:Alert")
class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['AlertConditionArgs', 'AlertConditionArgsDict']]] = None,
                 custom_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_on_ok: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_retrigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        This resource can be imported using alert ID:

        hcl

        import {

          to = databricks_alert.this

          id = "<alert-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/alert:Alert this <alert-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertConditionArgs', 'AlertConditionArgsDict']] condition: Trigger conditions of the alert. Block consists of the following attributes:
        :param pulumi.Input[_builtins.str] custom_body: Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] custom_subject: Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] display_name: Name of the alert.
        :param pulumi.Input[_builtins.bool] notify_on_ok: Whether to notify alert subscribers when alert returns back to normal.
        :param pulumi.Input[_builtins.str] owner_user_name: Alert owner's username.
        :param pulumi.Input[_builtins.str] parent_path: The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.int] seconds_to_retrigger: Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This resource can be imported using alert ID:

        hcl

        import {

          to = databricks_alert.this

          id = "<alert-id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/alert:Alert this <alert-id>
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[Union['AlertConditionArgs', 'AlertConditionArgsDict']]] = None,
                 custom_body: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_on_ok: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_path: Optional[pulumi.Input[_builtins.str]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seconds_to_retrigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["custom_body"] = custom_body
            __props__.__dict__["custom_subject"] = custom_subject
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["notify_on_ok"] = notify_on_ok
            __props__.__dict__["owner_user_name"] = owner_user_name
            __props__.__dict__["parent_path"] = parent_path
            if query_id is None and not opts.urn:
                raise TypeError("Missing required property 'query_id'")
            __props__.__dict__["query_id"] = query_id
            __props__.__dict__["seconds_to_retrigger"] = seconds_to_retrigger
            __props__.__dict__["create_time"] = None
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["trigger_time"] = None
            __props__.__dict__["update_time"] = None
        super(Alert, __self__).__init__(
            'databricks:index/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            condition: Optional[pulumi.Input[Union['AlertConditionArgs', 'AlertConditionArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_body: Optional[pulumi.Input[_builtins.str]] = None,
            custom_subject: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_state: Optional[pulumi.Input[_builtins.str]] = None,
            notify_on_ok: Optional[pulumi.Input[_builtins.bool]] = None,
            owner_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_path: Optional[pulumi.Input[_builtins.str]] = None,
            query_id: Optional[pulumi.Input[_builtins.str]] = None,
            seconds_to_retrigger: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_time: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertConditionArgs', 'AlertConditionArgsDict']] condition: Trigger conditions of the alert. Block consists of the following attributes:
        :param pulumi.Input[_builtins.str] create_time: The timestamp string indicating when the alert was created.
        :param pulumi.Input[_builtins.str] custom_body: Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] custom_subject: Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        :param pulumi.Input[_builtins.str] display_name: Name of the alert.
        :param pulumi.Input[_builtins.str] lifecycle_state: The workspace state of the alert. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        :param pulumi.Input[_builtins.bool] notify_on_ok: Whether to notify alert subscribers when alert returns back to normal.
        :param pulumi.Input[_builtins.str] owner_user_name: Alert owner's username.
        :param pulumi.Input[_builtins.str] parent_path: The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        :param pulumi.Input[_builtins.str] query_id: ID of the query evaluated by the alert.
        :param pulumi.Input[_builtins.int] seconds_to_retrigger: Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        :param pulumi.Input[_builtins.str] state: Current state of the alert's trigger status (`UNKNOWN`, `OK`, `TRIGGERED`). This field is set to `UNKNOWN` if the alert has not yet been evaluated or ran into an error during the last evaluation.
        :param pulumi.Input[_builtins.str] trigger_time: The timestamp string when the alert was last triggered if the alert has been triggered before.
        :param pulumi.Input[_builtins.str] update_time: The timestamp string indicating when the alert was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["condition"] = condition
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_body"] = custom_body
        __props__.__dict__["custom_subject"] = custom_subject
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["notify_on_ok"] = notify_on_ok
        __props__.__dict__["owner_user_name"] = owner_user_name
        __props__.__dict__["parent_path"] = parent_path
        __props__.__dict__["query_id"] = query_id
        __props__.__dict__["seconds_to_retrigger"] = seconds_to_retrigger
        __props__.__dict__["state"] = state
        __props__.__dict__["trigger_time"] = trigger_time
        __props__.__dict__["update_time"] = update_time
        return Alert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output['outputs.AlertCondition']:
        """
        Trigger conditions of the alert. Block consists of the following attributes:
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp string indicating when the alert was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customBody")
    def custom_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom body of alert notification, if it exists. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        """
        return pulumi.get(self, "custom_body")

    @_builtins.property
    @pulumi.getter(name="customSubject")
    def custom_subject(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom subject of alert notification, if it exists. This includes email subject, Slack notification header, etc. See [Alerts API reference](https://docs.databricks.com/en/sql/user/alerts/index.html) for custom templating instructions.
        """
        return pulumi.get(self, "custom_subject")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the alert.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[_builtins.str]:
        """
        The workspace state of the alert. Used for tracking trashed status. (Possible values are `ACTIVE` or `TRASHED`).
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter(name="notifyOnOk")
    def notify_on_ok(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to notify alert subscribers when alert returns back to normal.
        """
        return pulumi.get(self, "notify_on_ok")

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alert owner's username.
        """
        return pulumi.get(self, "owner_user_name")

    @_builtins.property
    @pulumi.getter(name="parentPath")
    def parent_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to a workspace folder containing the alert. The default is the user's home folder.  If changed, the alert will be recreated.
        """
        return pulumi.get(self, "parent_path")

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the query evaluated by the alert.
        """
        return pulumi.get(self, "query_id")

    @_builtins.property
    @pulumi.getter(name="secondsToRetrigger")
    def seconds_to_retrigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of seconds an alert must wait after being triggered to rearm itself. After rearming, it can be triggered again. If 0 or not specified, the alert will not be triggered again.
        """
        return pulumi.get(self, "seconds_to_retrigger")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Current state of the alert's trigger status (`UNKNOWN`, `OK`, `TRIGGERED`). This field is set to `UNKNOWN` if the alert has not yet been evaluated or ran into an error during the last evaluation.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="triggerTime")
    def trigger_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp string when the alert was last triggered if the alert has been triggered before.
        """
        return pulumi.get(self, "trigger_time")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp string indicating when the alert was updated.
        """
        return pulumi.get(self, "update_time")

