# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CleanRoomAssetArgs', 'CleanRoomAsset']

@pulumi.input_type
class CleanRoomAssetArgs:
    def __init__(__self__, *,
                 asset_type: pulumi.Input[_builtins.str],
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 foreign_table: Optional[pulumi.Input['CleanRoomAssetForeignTableArgs']] = None,
                 foreign_table_local_details: Optional[pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook: Optional[pulumi.Input['CleanRoomAssetNotebookArgs']] = None,
                 table: Optional[pulumi.Input['CleanRoomAssetTableArgs']] = None,
                 table_local_details: Optional[pulumi.Input['CleanRoomAssetTableLocalDetailsArgs']] = None,
                 view: Optional[pulumi.Input['CleanRoomAssetViewArgs']] = None,
                 view_local_details: Optional[pulumi.Input['CleanRoomAssetViewLocalDetailsArgs']] = None,
                 volume_local_details: Optional[pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs']] = None):
        """
        The set of arguments for constructing a CleanRoomAsset resource.
        :param pulumi.Input[_builtins.str] asset_type: The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this asset belongs to.
               This field is required for create operations and populated by the server for responses
        :param pulumi.Input['CleanRoomAssetForeignTableArgs'] foreign_table: Foreign table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs'] foreign_table_local_details: Local details for a foreign that are only available to its owner.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input[_builtins.str] name: A fully qualified name that uniquely identifies the asset within the clean room.
               This is also the name displayed in the clean room UI.
               
               For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*
               
               For notebooks, the name is the notebook file name.
               For jar analyses, the name is the jar analysis name
        :param pulumi.Input['CleanRoomAssetNotebookArgs'] notebook: Notebook details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **NOTEBOOK_FILE**
        :param pulumi.Input['CleanRoomAssetTableArgs'] table: Table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input['CleanRoomAssetTableLocalDetailsArgs'] table_local_details: Local details for a table that are only available to its owner.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input['CleanRoomAssetViewArgs'] view: View details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input['CleanRoomAssetViewLocalDetailsArgs'] view_local_details: Local details for a view that are only available to its owner.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs'] volume_local_details: Local details for a volume that are only available to its owner.
               Present if and only if **asset_type** is **VOLUME**
        """
        pulumi.set(__self__, "asset_type", asset_type)
        if clean_room_name is not None:
            pulumi.set(__self__, "clean_room_name", clean_room_name)
        if foreign_table is not None:
            pulumi.set(__self__, "foreign_table", foreign_table)
        if foreign_table_local_details is not None:
            pulumi.set(__self__, "foreign_table_local_details", foreign_table_local_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notebook is not None:
            pulumi.set(__self__, "notebook", notebook)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_local_details is not None:
            pulumi.set(__self__, "table_local_details", table_local_details)
        if view is not None:
            pulumi.set(__self__, "view", view)
        if view_local_details is not None:
            pulumi.set(__self__, "view_local_details", view_local_details)
        if volume_local_details is not None:
            pulumi.set(__self__, "volume_local_details", volume_local_details)

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "asset_type", value)

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the clean room this asset belongs to.
        This field is required for create operations and populated by the server for responses
        """
        return pulumi.get(self, "clean_room_name")

    @clean_room_name.setter
    def clean_room_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clean_room_name", value)

    @_builtins.property
    @pulumi.getter(name="foreignTable")
    def foreign_table(self) -> Optional[pulumi.Input['CleanRoomAssetForeignTableArgs']]:
        """
        Foreign table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table")

    @foreign_table.setter
    def foreign_table(self, value: Optional[pulumi.Input['CleanRoomAssetForeignTableArgs']]):
        pulumi.set(self, "foreign_table", value)

    @_builtins.property
    @pulumi.getter(name="foreignTableLocalDetails")
    def foreign_table_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs']]:
        """
        Local details for a foreign that are only available to its owner.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table_local_details")

    @foreign_table_local_details.setter
    def foreign_table_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs']]):
        pulumi.set(self, "foreign_table_local_details", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A fully qualified name that uniquely identifies the asset within the clean room.
        This is also the name displayed in the clean room UI.

        For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*

        For notebooks, the name is the notebook file name.
        For jar analyses, the name is the jar analysis name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notebook(self) -> Optional[pulumi.Input['CleanRoomAssetNotebookArgs']]:
        """
        Notebook details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **NOTEBOOK_FILE**
        """
        return pulumi.get(self, "notebook")

    @notebook.setter
    def notebook(self, value: Optional[pulumi.Input['CleanRoomAssetNotebookArgs']]):
        pulumi.set(self, "notebook", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['CleanRoomAssetTableArgs']]:
        """
        Table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['CleanRoomAssetTableArgs']]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="tableLocalDetails")
    def table_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetTableLocalDetailsArgs']]:
        """
        Local details for a table that are only available to its owner.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table_local_details")

    @table_local_details.setter
    def table_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetTableLocalDetailsArgs']]):
        pulumi.set(self, "table_local_details", value)

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['CleanRoomAssetViewArgs']]:
        """
        View details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['CleanRoomAssetViewArgs']]):
        pulumi.set(self, "view", value)

    @_builtins.property
    @pulumi.getter(name="viewLocalDetails")
    def view_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetViewLocalDetailsArgs']]:
        """
        Local details for a view that are only available to its owner.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view_local_details")

    @view_local_details.setter
    def view_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetViewLocalDetailsArgs']]):
        pulumi.set(self, "view_local_details", value)

    @_builtins.property
    @pulumi.getter(name="volumeLocalDetails")
    def volume_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs']]:
        """
        Local details for a volume that are only available to its owner.
        Present if and only if **asset_type** is **VOLUME**
        """
        return pulumi.get(self, "volume_local_details")

    @volume_local_details.setter
    def volume_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs']]):
        pulumi.set(self, "volume_local_details", value)


@pulumi.input_type
class _CleanRoomAssetState:
    def __init__(__self__, *,
                 added_at: Optional[pulumi.Input[_builtins.int]] = None,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 foreign_table: Optional[pulumi.Input['CleanRoomAssetForeignTableArgs']] = None,
                 foreign_table_local_details: Optional[pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook: Optional[pulumi.Input['CleanRoomAssetNotebookArgs']] = None,
                 owner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input['CleanRoomAssetTableArgs']] = None,
                 table_local_details: Optional[pulumi.Input['CleanRoomAssetTableLocalDetailsArgs']] = None,
                 view: Optional[pulumi.Input['CleanRoomAssetViewArgs']] = None,
                 view_local_details: Optional[pulumi.Input['CleanRoomAssetViewLocalDetailsArgs']] = None,
                 volume_local_details: Optional[pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering CleanRoomAsset resources.
        :param pulumi.Input[_builtins.int] added_at: (integer) - When the asset is added to the clean room, in epoch milliseconds
        :param pulumi.Input[_builtins.str] asset_type: The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this asset belongs to.
               This field is required for create operations and populated by the server for responses
        :param pulumi.Input['CleanRoomAssetForeignTableArgs'] foreign_table: Foreign table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs'] foreign_table_local_details: Local details for a foreign that are only available to its owner.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input[_builtins.str] name: A fully qualified name that uniquely identifies the asset within the clean room.
               This is also the name displayed in the clean room UI.
               
               For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*
               
               For notebooks, the name is the notebook file name.
               For jar analyses, the name is the jar analysis name
        :param pulumi.Input['CleanRoomAssetNotebookArgs'] notebook: Notebook details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **NOTEBOOK_FILE**
        :param pulumi.Input[_builtins.str] owner_collaborator_alias: (string) - The alias of the collaborator who owns this asset
        :param pulumi.Input[_builtins.str] status: (string) - Status of the asset. Possible values are: `ACTIVE`, `PENDING`, `PERMISSION_DENIED`
        :param pulumi.Input['CleanRoomAssetTableArgs'] table: Table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input['CleanRoomAssetTableLocalDetailsArgs'] table_local_details: Local details for a table that are only available to its owner.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input['CleanRoomAssetViewArgs'] view: View details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input['CleanRoomAssetViewLocalDetailsArgs'] view_local_details: Local details for a view that are only available to its owner.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs'] volume_local_details: Local details for a volume that are only available to its owner.
               Present if and only if **asset_type** is **VOLUME**
        """
        if added_at is not None:
            pulumi.set(__self__, "added_at", added_at)
        if asset_type is not None:
            pulumi.set(__self__, "asset_type", asset_type)
        if clean_room_name is not None:
            pulumi.set(__self__, "clean_room_name", clean_room_name)
        if foreign_table is not None:
            pulumi.set(__self__, "foreign_table", foreign_table)
        if foreign_table_local_details is not None:
            pulumi.set(__self__, "foreign_table_local_details", foreign_table_local_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notebook is not None:
            pulumi.set(__self__, "notebook", notebook)
        if owner_collaborator_alias is not None:
            pulumi.set(__self__, "owner_collaborator_alias", owner_collaborator_alias)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_local_details is not None:
            pulumi.set(__self__, "table_local_details", table_local_details)
        if view is not None:
            pulumi.set(__self__, "view", view)
        if view_local_details is not None:
            pulumi.set(__self__, "view_local_details", view_local_details)
        if volume_local_details is not None:
            pulumi.set(__self__, "volume_local_details", volume_local_details)

    @_builtins.property
    @pulumi.getter(name="addedAt")
    def added_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - When the asset is added to the clean room, in epoch milliseconds
        """
        return pulumi.get(self, "added_at")

    @added_at.setter
    def added_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "added_at", value)

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_type", value)

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the clean room this asset belongs to.
        This field is required for create operations and populated by the server for responses
        """
        return pulumi.get(self, "clean_room_name")

    @clean_room_name.setter
    def clean_room_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clean_room_name", value)

    @_builtins.property
    @pulumi.getter(name="foreignTable")
    def foreign_table(self) -> Optional[pulumi.Input['CleanRoomAssetForeignTableArgs']]:
        """
        Foreign table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table")

    @foreign_table.setter
    def foreign_table(self, value: Optional[pulumi.Input['CleanRoomAssetForeignTableArgs']]):
        pulumi.set(self, "foreign_table", value)

    @_builtins.property
    @pulumi.getter(name="foreignTableLocalDetails")
    def foreign_table_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs']]:
        """
        Local details for a foreign that are only available to its owner.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table_local_details")

    @foreign_table_local_details.setter
    def foreign_table_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetForeignTableLocalDetailsArgs']]):
        pulumi.set(self, "foreign_table_local_details", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A fully qualified name that uniquely identifies the asset within the clean room.
        This is also the name displayed in the clean room UI.

        For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*

        For notebooks, the name is the notebook file name.
        For jar analyses, the name is the jar analysis name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notebook(self) -> Optional[pulumi.Input['CleanRoomAssetNotebookArgs']]:
        """
        Notebook details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **NOTEBOOK_FILE**
        """
        return pulumi.get(self, "notebook")

    @notebook.setter
    def notebook(self, value: Optional[pulumi.Input['CleanRoomAssetNotebookArgs']]):
        pulumi.set(self, "notebook", value)

    @_builtins.property
    @pulumi.getter(name="ownerCollaboratorAlias")
    def owner_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The alias of the collaborator who owns this asset
        """
        return pulumi.get(self, "owner_collaborator_alias")

    @owner_collaborator_alias.setter
    def owner_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_collaborator_alias", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Status of the asset. Possible values are: `ACTIVE`, `PENDING`, `PERMISSION_DENIED`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['CleanRoomAssetTableArgs']]:
        """
        Table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['CleanRoomAssetTableArgs']]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="tableLocalDetails")
    def table_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetTableLocalDetailsArgs']]:
        """
        Local details for a table that are only available to its owner.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table_local_details")

    @table_local_details.setter
    def table_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetTableLocalDetailsArgs']]):
        pulumi.set(self, "table_local_details", value)

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['CleanRoomAssetViewArgs']]:
        """
        View details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['CleanRoomAssetViewArgs']]):
        pulumi.set(self, "view", value)

    @_builtins.property
    @pulumi.getter(name="viewLocalDetails")
    def view_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetViewLocalDetailsArgs']]:
        """
        Local details for a view that are only available to its owner.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view_local_details")

    @view_local_details.setter
    def view_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetViewLocalDetailsArgs']]):
        pulumi.set(self, "view_local_details", value)

    @_builtins.property
    @pulumi.getter(name="volumeLocalDetails")
    def volume_local_details(self) -> Optional[pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs']]:
        """
        Local details for a volume that are only available to its owner.
        Present if and only if **asset_type** is **VOLUME**
        """
        return pulumi.get(self, "volume_local_details")

    @volume_local_details.setter
    def volume_local_details(self, value: Optional[pulumi.Input['CleanRoomAssetVolumeLocalDetailsArgs']]):
        pulumi.set(self, "volume_local_details", value)


@pulumi.type_token("databricks:index/cleanRoomAsset:CleanRoomAsset")
class CleanRoomAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 foreign_table: Optional[pulumi.Input[Union['CleanRoomAssetForeignTableArgs', 'CleanRoomAssetForeignTableArgsDict']]] = None,
                 foreign_table_local_details: Optional[pulumi.Input[Union['CleanRoomAssetForeignTableLocalDetailsArgs', 'CleanRoomAssetForeignTableLocalDetailsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook: Optional[pulumi.Input[Union['CleanRoomAssetNotebookArgs', 'CleanRoomAssetNotebookArgsDict']]] = None,
                 table: Optional[pulumi.Input[Union['CleanRoomAssetTableArgs', 'CleanRoomAssetTableArgsDict']]] = None,
                 table_local_details: Optional[pulumi.Input[Union['CleanRoomAssetTableLocalDetailsArgs', 'CleanRoomAssetTableLocalDetailsArgsDict']]] = None,
                 view: Optional[pulumi.Input[Union['CleanRoomAssetViewArgs', 'CleanRoomAssetViewArgsDict']]] = None,
                 view_local_details: Optional[pulumi.Input[Union['CleanRoomAssetViewLocalDetailsArgs', 'CleanRoomAssetViewLocalDetailsArgsDict']]] = None,
                 volume_local_details: Optional[pulumi.Input[Union['CleanRoomAssetVolumeLocalDetailsArgs', 'CleanRoomAssetVolumeLocalDetailsArgsDict']]] = None,
                 __props__=None):
        """
        Clean room assets are data and code objects -- tables, volumes, and notebooks that are shared with the clean room.

        ## Example Usage

        # Example: Clean Room Asset Resource

        ### Example for sharing a table
        This is an example for sharing an asset (table) in a clean room:
        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.index.CleanRoomsAsset("this",
            clean_room_name=existing_clean_room,
            name=creator.default.myasset,
            asset_type=TABLE,
            table_local_details={
                localName: some_creator.default.myasset,
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = clean_room_name,name,asset_type

          to = databricks_clean_room_asset.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/cleanRoomAsset:CleanRoomAsset databricks_clean_room_asset clean_room_name,name,asset_type
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asset_type: The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this asset belongs to.
               This field is required for create operations and populated by the server for responses
        :param pulumi.Input[Union['CleanRoomAssetForeignTableArgs', 'CleanRoomAssetForeignTableArgsDict']] foreign_table: Foreign table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input[Union['CleanRoomAssetForeignTableLocalDetailsArgs', 'CleanRoomAssetForeignTableLocalDetailsArgsDict']] foreign_table_local_details: Local details for a foreign that are only available to its owner.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input[_builtins.str] name: A fully qualified name that uniquely identifies the asset within the clean room.
               This is also the name displayed in the clean room UI.
               
               For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*
               
               For notebooks, the name is the notebook file name.
               For jar analyses, the name is the jar analysis name
        :param pulumi.Input[Union['CleanRoomAssetNotebookArgs', 'CleanRoomAssetNotebookArgsDict']] notebook: Notebook details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **NOTEBOOK_FILE**
        :param pulumi.Input[Union['CleanRoomAssetTableArgs', 'CleanRoomAssetTableArgsDict']] table: Table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input[Union['CleanRoomAssetTableLocalDetailsArgs', 'CleanRoomAssetTableLocalDetailsArgsDict']] table_local_details: Local details for a table that are only available to its owner.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input[Union['CleanRoomAssetViewArgs', 'CleanRoomAssetViewArgsDict']] view: View details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input[Union['CleanRoomAssetViewLocalDetailsArgs', 'CleanRoomAssetViewLocalDetailsArgsDict']] view_local_details: Local details for a view that are only available to its owner.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input[Union['CleanRoomAssetVolumeLocalDetailsArgs', 'CleanRoomAssetVolumeLocalDetailsArgsDict']] volume_local_details: Local details for a volume that are only available to its owner.
               Present if and only if **asset_type** is **VOLUME**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CleanRoomAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Clean room assets are data and code objects -- tables, volumes, and notebooks that are shared with the clean room.

        ## Example Usage

        # Example: Clean Room Asset Resource

        ### Example for sharing a table
        This is an example for sharing an asset (table) in a clean room:
        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.index.CleanRoomsAsset("this",
            clean_room_name=existing_clean_room,
            name=creator.default.myasset,
            asset_type=TABLE,
            table_local_details={
                localName: some_creator.default.myasset,
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = clean_room_name,name,asset_type

          to = databricks_clean_room_asset.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/cleanRoomAsset:CleanRoomAsset databricks_clean_room_asset clean_room_name,name,asset_type
        ```

        :param str resource_name: The name of the resource.
        :param CleanRoomAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CleanRoomAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 foreign_table: Optional[pulumi.Input[Union['CleanRoomAssetForeignTableArgs', 'CleanRoomAssetForeignTableArgsDict']]] = None,
                 foreign_table_local_details: Optional[pulumi.Input[Union['CleanRoomAssetForeignTableLocalDetailsArgs', 'CleanRoomAssetForeignTableLocalDetailsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notebook: Optional[pulumi.Input[Union['CleanRoomAssetNotebookArgs', 'CleanRoomAssetNotebookArgsDict']]] = None,
                 table: Optional[pulumi.Input[Union['CleanRoomAssetTableArgs', 'CleanRoomAssetTableArgsDict']]] = None,
                 table_local_details: Optional[pulumi.Input[Union['CleanRoomAssetTableLocalDetailsArgs', 'CleanRoomAssetTableLocalDetailsArgsDict']]] = None,
                 view: Optional[pulumi.Input[Union['CleanRoomAssetViewArgs', 'CleanRoomAssetViewArgsDict']]] = None,
                 view_local_details: Optional[pulumi.Input[Union['CleanRoomAssetViewLocalDetailsArgs', 'CleanRoomAssetViewLocalDetailsArgsDict']]] = None,
                 volume_local_details: Optional[pulumi.Input[Union['CleanRoomAssetVolumeLocalDetailsArgs', 'CleanRoomAssetVolumeLocalDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CleanRoomAssetArgs.__new__(CleanRoomAssetArgs)

            if asset_type is None and not opts.urn:
                raise TypeError("Missing required property 'asset_type'")
            __props__.__dict__["asset_type"] = asset_type
            __props__.__dict__["clean_room_name"] = clean_room_name
            __props__.__dict__["foreign_table"] = foreign_table
            __props__.__dict__["foreign_table_local_details"] = foreign_table_local_details
            __props__.__dict__["name"] = name
            __props__.__dict__["notebook"] = notebook
            __props__.__dict__["table"] = table
            __props__.__dict__["table_local_details"] = table_local_details
            __props__.__dict__["view"] = view
            __props__.__dict__["view_local_details"] = view_local_details
            __props__.__dict__["volume_local_details"] = volume_local_details
            __props__.__dict__["added_at"] = None
            __props__.__dict__["owner_collaborator_alias"] = None
            __props__.__dict__["status"] = None
        super(CleanRoomAsset, __self__).__init__(
            'databricks:index/cleanRoomAsset:CleanRoomAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            added_at: Optional[pulumi.Input[_builtins.int]] = None,
            asset_type: Optional[pulumi.Input[_builtins.str]] = None,
            clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
            foreign_table: Optional[pulumi.Input[Union['CleanRoomAssetForeignTableArgs', 'CleanRoomAssetForeignTableArgsDict']]] = None,
            foreign_table_local_details: Optional[pulumi.Input[Union['CleanRoomAssetForeignTableLocalDetailsArgs', 'CleanRoomAssetForeignTableLocalDetailsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notebook: Optional[pulumi.Input[Union['CleanRoomAssetNotebookArgs', 'CleanRoomAssetNotebookArgsDict']]] = None,
            owner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            table: Optional[pulumi.Input[Union['CleanRoomAssetTableArgs', 'CleanRoomAssetTableArgsDict']]] = None,
            table_local_details: Optional[pulumi.Input[Union['CleanRoomAssetTableLocalDetailsArgs', 'CleanRoomAssetTableLocalDetailsArgsDict']]] = None,
            view: Optional[pulumi.Input[Union['CleanRoomAssetViewArgs', 'CleanRoomAssetViewArgsDict']]] = None,
            view_local_details: Optional[pulumi.Input[Union['CleanRoomAssetViewLocalDetailsArgs', 'CleanRoomAssetViewLocalDetailsArgsDict']]] = None,
            volume_local_details: Optional[pulumi.Input[Union['CleanRoomAssetVolumeLocalDetailsArgs', 'CleanRoomAssetVolumeLocalDetailsArgsDict']]] = None) -> 'CleanRoomAsset':
        """
        Get an existing CleanRoomAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] added_at: (integer) - When the asset is added to the clean room, in epoch milliseconds
        :param pulumi.Input[_builtins.str] asset_type: The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this asset belongs to.
               This field is required for create operations and populated by the server for responses
        :param pulumi.Input[Union['CleanRoomAssetForeignTableArgs', 'CleanRoomAssetForeignTableArgsDict']] foreign_table: Foreign table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input[Union['CleanRoomAssetForeignTableLocalDetailsArgs', 'CleanRoomAssetForeignTableLocalDetailsArgsDict']] foreign_table_local_details: Local details for a foreign that are only available to its owner.
               Present if and only if **asset_type** is **FOREIGN_TABLE**
        :param pulumi.Input[_builtins.str] name: A fully qualified name that uniquely identifies the asset within the clean room.
               This is also the name displayed in the clean room UI.
               
               For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*
               
               For notebooks, the name is the notebook file name.
               For jar analyses, the name is the jar analysis name
        :param pulumi.Input[Union['CleanRoomAssetNotebookArgs', 'CleanRoomAssetNotebookArgsDict']] notebook: Notebook details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **NOTEBOOK_FILE**
        :param pulumi.Input[_builtins.str] owner_collaborator_alias: (string) - The alias of the collaborator who owns this asset
        :param pulumi.Input[_builtins.str] status: (string) - Status of the asset. Possible values are: `ACTIVE`, `PENDING`, `PERMISSION_DENIED`
        :param pulumi.Input[Union['CleanRoomAssetTableArgs', 'CleanRoomAssetTableArgsDict']] table: Table details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input[Union['CleanRoomAssetTableLocalDetailsArgs', 'CleanRoomAssetTableLocalDetailsArgsDict']] table_local_details: Local details for a table that are only available to its owner.
               Present if and only if **asset_type** is **TABLE**
        :param pulumi.Input[Union['CleanRoomAssetViewArgs', 'CleanRoomAssetViewArgsDict']] view: View details available to all collaborators of the clean room.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input[Union['CleanRoomAssetViewLocalDetailsArgs', 'CleanRoomAssetViewLocalDetailsArgsDict']] view_local_details: Local details for a view that are only available to its owner.
               Present if and only if **asset_type** is **VIEW**
        :param pulumi.Input[Union['CleanRoomAssetVolumeLocalDetailsArgs', 'CleanRoomAssetVolumeLocalDetailsArgsDict']] volume_local_details: Local details for a volume that are only available to its owner.
               Present if and only if **asset_type** is **VOLUME**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CleanRoomAssetState.__new__(_CleanRoomAssetState)

        __props__.__dict__["added_at"] = added_at
        __props__.__dict__["asset_type"] = asset_type
        __props__.__dict__["clean_room_name"] = clean_room_name
        __props__.__dict__["foreign_table"] = foreign_table
        __props__.__dict__["foreign_table_local_details"] = foreign_table_local_details
        __props__.__dict__["name"] = name
        __props__.__dict__["notebook"] = notebook
        __props__.__dict__["owner_collaborator_alias"] = owner_collaborator_alias
        __props__.__dict__["status"] = status
        __props__.__dict__["table"] = table
        __props__.__dict__["table_local_details"] = table_local_details
        __props__.__dict__["view"] = view
        __props__.__dict__["view_local_details"] = view_local_details
        __props__.__dict__["volume_local_details"] = volume_local_details
        return CleanRoomAsset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addedAt")
    def added_at(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - When the asset is added to the clean room, in epoch milliseconds
        """
        return pulumi.get(self, "added_at")

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the asset. Possible values are: `FOREIGN_TABLE`, `NOTEBOOK_FILE`, `TABLE`, `VIEW`, `VOLUME`
        """
        return pulumi.get(self, "asset_type")

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the clean room this asset belongs to.
        This field is required for create operations and populated by the server for responses
        """
        return pulumi.get(self, "clean_room_name")

    @_builtins.property
    @pulumi.getter(name="foreignTable")
    def foreign_table(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetForeignTable']]:
        """
        Foreign table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table")

    @_builtins.property
    @pulumi.getter(name="foreignTableLocalDetails")
    def foreign_table_local_details(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetForeignTableLocalDetails']]:
        """
        Local details for a foreign that are only available to its owner.
        Present if and only if **asset_type** is **FOREIGN_TABLE**
        """
        return pulumi.get(self, "foreign_table_local_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A fully qualified name that uniquely identifies the asset within the clean room.
        This is also the name displayed in the clean room UI.

        For UC securable assets (tables, volumes, etc.), the format is *shared_catalog*.*shared_schema*.*asset_name*

        For notebooks, the name is the notebook file name.
        For jar analyses, the name is the jar analysis name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notebook(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetNotebook']]:
        """
        Notebook details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **NOTEBOOK_FILE**
        """
        return pulumi.get(self, "notebook")

    @_builtins.property
    @pulumi.getter(name="ownerCollaboratorAlias")
    def owner_collaborator_alias(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The alias of the collaborator who owns this asset
        """
        return pulumi.get(self, "owner_collaborator_alias")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Status of the asset. Possible values are: `ACTIVE`, `PENDING`, `PERMISSION_DENIED`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetTable']]:
        """
        Table details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter(name="tableLocalDetails")
    def table_local_details(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetTableLocalDetails']]:
        """
        Local details for a table that are only available to its owner.
        Present if and only if **asset_type** is **TABLE**
        """
        return pulumi.get(self, "table_local_details")

    @_builtins.property
    @pulumi.getter
    def view(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetView']]:
        """
        View details available to all collaborators of the clean room.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view")

    @_builtins.property
    @pulumi.getter(name="viewLocalDetails")
    def view_local_details(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetViewLocalDetails']]:
        """
        Local details for a view that are only available to its owner.
        Present if and only if **asset_type** is **VIEW**
        """
        return pulumi.get(self, "view_local_details")

    @_builtins.property
    @pulumi.getter(name="volumeLocalDetails")
    def volume_local_details(self) -> pulumi.Output[Optional['outputs.CleanRoomAssetVolumeLocalDetails']]:
        """
        Local details for a volume that are only available to its owner.
        Present if and only if **asset_type** is **VOLUME**
        """
        return pulumi.get(self, "volume_local_details")

