# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CleanRoomAutoApprovalRuleArgs', 'CleanRoomAutoApprovalRule']

@pulumi.input_type
class CleanRoomAutoApprovalRuleArgs:
    def __init__(__self__, *,
                 author_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 author_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CleanRoomAutoApprovalRule resource.
        :param pulumi.Input[_builtins.str] author_collaborator_alias: Collaborator alias of the author covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set
        :param pulumi.Input[_builtins.str] author_scope: Scope of authors covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this auto-approval rule belongs to
        :param pulumi.Input[_builtins.str] runner_collaborator_alias: Collaborator alias of the runner covered by the rule
        """
        if author_collaborator_alias is not None:
            pulumi.set(__self__, "author_collaborator_alias", author_collaborator_alias)
        if author_scope is not None:
            pulumi.set(__self__, "author_scope", author_scope)
        if clean_room_name is not None:
            pulumi.set(__self__, "clean_room_name", clean_room_name)
        if runner_collaborator_alias is not None:
            pulumi.set(__self__, "runner_collaborator_alias", runner_collaborator_alias)

    @_builtins.property
    @pulumi.getter(name="authorCollaboratorAlias")
    def author_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Collaborator alias of the author covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set
        """
        return pulumi.get(self, "author_collaborator_alias")

    @author_collaborator_alias.setter
    def author_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_collaborator_alias", value)

    @_builtins.property
    @pulumi.getter(name="authorScope")
    def author_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of authors covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        """
        return pulumi.get(self, "author_scope")

    @author_scope.setter
    def author_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_scope", value)

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the clean room this auto-approval rule belongs to
        """
        return pulumi.get(self, "clean_room_name")

    @clean_room_name.setter
    def clean_room_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clean_room_name", value)

    @_builtins.property
    @pulumi.getter(name="runnerCollaboratorAlias")
    def runner_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Collaborator alias of the runner covered by the rule
        """
        return pulumi.get(self, "runner_collaborator_alias")

    @runner_collaborator_alias.setter
    def runner_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runner_collaborator_alias", value)


@pulumi.input_type
class _CleanRoomAutoApprovalRuleState:
    def __init__(__self__, *,
                 author_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 author_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_owner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CleanRoomAutoApprovalRule resources.
        :param pulumi.Input[_builtins.str] author_collaborator_alias: Collaborator alias of the author covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set
        :param pulumi.Input[_builtins.str] author_scope: Scope of authors covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this auto-approval rule belongs to
        :param pulumi.Input[_builtins.int] created_at: (integer) - Timestamp of when the rule was created, in epoch milliseconds
        :param pulumi.Input[_builtins.str] rule_id: (string) - A generated UUID identifying the rule
        :param pulumi.Input[_builtins.str] rule_owner_collaborator_alias: (string) - The owner of the rule to whom the rule applies
        :param pulumi.Input[_builtins.str] runner_collaborator_alias: Collaborator alias of the runner covered by the rule
        """
        if author_collaborator_alias is not None:
            pulumi.set(__self__, "author_collaborator_alias", author_collaborator_alias)
        if author_scope is not None:
            pulumi.set(__self__, "author_scope", author_scope)
        if clean_room_name is not None:
            pulumi.set(__self__, "clean_room_name", clean_room_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if rule_owner_collaborator_alias is not None:
            pulumi.set(__self__, "rule_owner_collaborator_alias", rule_owner_collaborator_alias)
        if runner_collaborator_alias is not None:
            pulumi.set(__self__, "runner_collaborator_alias", runner_collaborator_alias)

    @_builtins.property
    @pulumi.getter(name="authorCollaboratorAlias")
    def author_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Collaborator alias of the author covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set
        """
        return pulumi.get(self, "author_collaborator_alias")

    @author_collaborator_alias.setter
    def author_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_collaborator_alias", value)

    @_builtins.property
    @pulumi.getter(name="authorScope")
    def author_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of authors covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        """
        return pulumi.get(self, "author_scope")

    @author_scope.setter
    def author_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_scope", value)

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the clean room this auto-approval rule belongs to
        """
        return pulumi.get(self, "clean_room_name")

    @clean_room_name.setter
    def clean_room_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clean_room_name", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - Timestamp of when the rule was created, in epoch milliseconds
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - A generated UUID identifying the rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleOwnerCollaboratorAlias")
    def rule_owner_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The owner of the rule to whom the rule applies
        """
        return pulumi.get(self, "rule_owner_collaborator_alias")

    @rule_owner_collaborator_alias.setter
    def rule_owner_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_owner_collaborator_alias", value)

    @_builtins.property
    @pulumi.getter(name="runnerCollaboratorAlias")
    def runner_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Collaborator alias of the runner covered by the rule
        """
        return pulumi.get(self, "runner_collaborator_alias")

    @runner_collaborator_alias.setter
    def runner_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runner_collaborator_alias", value)


@pulumi.type_token("databricks:index/cleanRoomAutoApprovalRule:CleanRoomAutoApprovalRule")
class CleanRoomAutoApprovalRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 author_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = rule_id

          to = databricks_clean_room_auto_approval_rule.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/cleanRoomAutoApprovalRule:CleanRoomAutoApprovalRule databricks_clean_room_auto_approval_rule rule_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] author_collaborator_alias: Collaborator alias of the author covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set
        :param pulumi.Input[_builtins.str] author_scope: Scope of authors covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this auto-approval rule belongs to
        :param pulumi.Input[_builtins.str] runner_collaborator_alias: Collaborator alias of the runner covered by the rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CleanRoomAutoApprovalRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = rule_id

          to = databricks_clean_room_auto_approval_rule.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/cleanRoomAutoApprovalRule:CleanRoomAutoApprovalRule databricks_clean_room_auto_approval_rule rule_id
        ```

        :param str resource_name: The name of the resource.
        :param CleanRoomAutoApprovalRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CleanRoomAutoApprovalRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 author_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CleanRoomAutoApprovalRuleArgs.__new__(CleanRoomAutoApprovalRuleArgs)

            __props__.__dict__["author_collaborator_alias"] = author_collaborator_alias
            __props__.__dict__["author_scope"] = author_scope
            __props__.__dict__["clean_room_name"] = clean_room_name
            __props__.__dict__["runner_collaborator_alias"] = runner_collaborator_alias
            __props__.__dict__["created_at"] = None
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["rule_owner_collaborator_alias"] = None
        super(CleanRoomAutoApprovalRule, __self__).__init__(
            'databricks:index/cleanRoomAutoApprovalRule:CleanRoomAutoApprovalRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
            author_scope: Optional[pulumi.Input[_builtins.str]] = None,
            clean_room_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            rule_owner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
            runner_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None) -> 'CleanRoomAutoApprovalRule':
        """
        Get an existing CleanRoomAutoApprovalRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] author_collaborator_alias: Collaborator alias of the author covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set
        :param pulumi.Input[_builtins.str] author_scope: Scope of authors covered by the rule.
               Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        :param pulumi.Input[_builtins.str] clean_room_name: The name of the clean room this auto-approval rule belongs to
        :param pulumi.Input[_builtins.int] created_at: (integer) - Timestamp of when the rule was created, in epoch milliseconds
        :param pulumi.Input[_builtins.str] rule_id: (string) - A generated UUID identifying the rule
        :param pulumi.Input[_builtins.str] rule_owner_collaborator_alias: (string) - The owner of the rule to whom the rule applies
        :param pulumi.Input[_builtins.str] runner_collaborator_alias: Collaborator alias of the runner covered by the rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CleanRoomAutoApprovalRuleState.__new__(_CleanRoomAutoApprovalRuleState)

        __props__.__dict__["author_collaborator_alias"] = author_collaborator_alias
        __props__.__dict__["author_scope"] = author_scope
        __props__.__dict__["clean_room_name"] = clean_room_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["rule_owner_collaborator_alias"] = rule_owner_collaborator_alias
        __props__.__dict__["runner_collaborator_alias"] = runner_collaborator_alias
        return CleanRoomAutoApprovalRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorCollaboratorAlias")
    def author_collaborator_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Collaborator alias of the author covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set
        """
        return pulumi.get(self, "author_collaborator_alias")

    @_builtins.property
    @pulumi.getter(name="authorScope")
    def author_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scope of authors covered by the rule.
        Only one of `author_collaborator_alias` and `author_scope` can be set. Possible values are: `ANY_AUTHOR`
        """
        return pulumi.get(self, "author_scope")

    @_builtins.property
    @pulumi.getter(name="cleanRoomName")
    def clean_room_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the clean room this auto-approval rule belongs to
        """
        return pulumi.get(self, "clean_room_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - Timestamp of when the rule was created, in epoch milliseconds
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - A generated UUID identifying the rule
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleOwnerCollaboratorAlias")
    def rule_owner_collaborator_alias(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The owner of the rule to whom the rule applies
        """
        return pulumi.get(self, "rule_owner_collaborator_alias")

    @_builtins.property
    @pulumi.getter(name="runnerCollaboratorAlias")
    def runner_collaborator_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Collaborator alias of the runner covered by the rule
        """
        return pulumi.get(self, "runner_collaborator_alias")

