# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseDatabaseCatalogArgs', 'DatabaseDatabaseCatalog']

@pulumi.input_type
class DatabaseDatabaseCatalogArgs:
    def __init__(__self__, *,
                 database_instance_name: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 create_database_if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseDatabaseCatalog resource.
        :param pulumi.Input[_builtins.str] database_instance_name: The name of the DatabaseInstance housing the database
        :param pulumi.Input[_builtins.str] database_name: The name of the database (in a instance) associated with the catalog
        :param pulumi.Input[_builtins.str] name: The name of the catalog in UC
        """
        pulumi.set(__self__, "database_instance_name", database_instance_name)
        pulumi.set(__self__, "database_name", database_name)
        if create_database_if_not_exists is not None:
            pulumi.set(__self__, "create_database_if_not_exists", create_database_if_not_exists)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the DatabaseInstance housing the database
        """
        return pulumi.get(self, "database_instance_name")

    @database_instance_name.setter
    def database_instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database (in a instance) associated with the catalog
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="createDatabaseIfNotExists")
    def create_database_if_not_exists(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "create_database_if_not_exists")

    @create_database_if_not_exists.setter
    def create_database_if_not_exists(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_database_if_not_exists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the catalog in UC
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DatabaseDatabaseCatalogState:
    def __init__(__self__, *,
                 create_database_if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseDatabaseCatalog resources.
        :param pulumi.Input[_builtins.str] database_instance_name: The name of the DatabaseInstance housing the database
        :param pulumi.Input[_builtins.str] database_name: The name of the database (in a instance) associated with the catalog
        :param pulumi.Input[_builtins.str] name: The name of the catalog in UC
        :param pulumi.Input[_builtins.str] uid: (string)
        """
        if create_database_if_not_exists is not None:
            pulumi.set(__self__, "create_database_if_not_exists", create_database_if_not_exists)
        if database_instance_name is not None:
            pulumi.set(__self__, "database_instance_name", database_instance_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="createDatabaseIfNotExists")
    def create_database_if_not_exists(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "create_database_if_not_exists")

    @create_database_if_not_exists.setter
    def create_database_if_not_exists(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_database_if_not_exists", value)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DatabaseInstance housing the database
        """
        return pulumi.get(self, "database_instance_name")

    @database_instance_name.setter
    def database_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database (in a instance) associated with the catalog
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the catalog in UC
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string)
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("databricks:index/databaseDatabaseCatalog:DatabaseDatabaseCatalog")
class DatabaseDatabaseCatalog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_database_if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Database Catalogs are databases inside a Lakebase Database Instance which are synced into a Postgres Catalog inside Unity Catalog.

        ## Example Usage

        ### Example

        This example creates a Database Catalog based on an existing database in the Database Instance
        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseDatabaseCatalog("this",
            name="my_registered_catalog",
            database_instance_name="my-database-instance",
            database_name="databricks_postgres")
        ```

        This example creates a Database Catalog along with a new database inside an existing Database Instance
        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseDatabaseCatalog("this",
            name="my_registered_catalog",
            database_instance_name="my-database-instance",
            database_name="new_registered_catalog_database",
            create_database_if_not_exists=True)
        ```

        This example creates a DatabaseInstance and then a Database Catalog inside it
        ```python
        import pulumi
        import pulumi_databricks as databricks

        instance = databricks.DatabaseInstance("instance",
            name="my-database-instance",
            capacity="CU_1")
        catalog = databricks.DatabaseDatabaseCatalog("catalog",
            name="my_registered_catalog",
            database_instance_name=instance.name,
            database_name="new_registered_catalog_database",
            create_database_if_not_exists=True)
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_database_database_catalog.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseDatabaseCatalog:DatabaseDatabaseCatalog databricks_database_database_catalog name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_instance_name: The name of the DatabaseInstance housing the database
        :param pulumi.Input[_builtins.str] database_name: The name of the database (in a instance) associated with the catalog
        :param pulumi.Input[_builtins.str] name: The name of the catalog in UC
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseDatabaseCatalogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Database Catalogs are databases inside a Lakebase Database Instance which are synced into a Postgres Catalog inside Unity Catalog.

        ## Example Usage

        ### Example

        This example creates a Database Catalog based on an existing database in the Database Instance
        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseDatabaseCatalog("this",
            name="my_registered_catalog",
            database_instance_name="my-database-instance",
            database_name="databricks_postgres")
        ```

        This example creates a Database Catalog along with a new database inside an existing Database Instance
        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseDatabaseCatalog("this",
            name="my_registered_catalog",
            database_instance_name="my-database-instance",
            database_name="new_registered_catalog_database",
            create_database_if_not_exists=True)
        ```

        This example creates a DatabaseInstance and then a Database Catalog inside it
        ```python
        import pulumi
        import pulumi_databricks as databricks

        instance = databricks.DatabaseInstance("instance",
            name="my-database-instance",
            capacity="CU_1")
        catalog = databricks.DatabaseDatabaseCatalog("catalog",
            name="my_registered_catalog",
            database_instance_name=instance.name,
            database_name="new_registered_catalog_database",
            create_database_if_not_exists=True)
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_database_database_catalog.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseDatabaseCatalog:DatabaseDatabaseCatalog databricks_database_database_catalog name
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseDatabaseCatalogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseDatabaseCatalogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_database_if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseDatabaseCatalogArgs.__new__(DatabaseDatabaseCatalogArgs)

            __props__.__dict__["create_database_if_not_exists"] = create_database_if_not_exists
            if database_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_instance_name'")
            __props__.__dict__["database_instance_name"] = database_instance_name
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["name"] = name
            __props__.__dict__["uid"] = None
        super(DatabaseDatabaseCatalog, __self__).__init__(
            'databricks:index/databaseDatabaseCatalog:DatabaseDatabaseCatalog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_database_if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
            database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseDatabaseCatalog':
        """
        Get an existing DatabaseDatabaseCatalog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_instance_name: The name of the DatabaseInstance housing the database
        :param pulumi.Input[_builtins.str] database_name: The name of the database (in a instance) associated with the catalog
        :param pulumi.Input[_builtins.str] name: The name of the catalog in UC
        :param pulumi.Input[_builtins.str] uid: (string)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseDatabaseCatalogState.__new__(_DatabaseDatabaseCatalogState)

        __props__.__dict__["create_database_if_not_exists"] = create_database_if_not_exists
        __props__.__dict__["database_instance_name"] = database_instance_name
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["name"] = name
        __props__.__dict__["uid"] = uid
        return DatabaseDatabaseCatalog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createDatabaseIfNotExists")
    def create_database_if_not_exists(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "create_database_if_not_exists")

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the DatabaseInstance housing the database
        """
        return pulumi.get(self, "database_instance_name")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database (in a instance) associated with the catalog
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the catalog in UC
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        (string)
        """
        return pulumi.get(self, "uid")

