# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseInstanceArgs', 'DatabaseInstance']

@pulumi.input_type
class DatabaseInstanceArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_instance_ref: Optional[pulumi.Input['DatabaseInstanceParentInstanceRefArgs']] = None,
                 purge_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a DatabaseInstance resource.
        :param pulumi.Input[_builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[_builtins.bool] enable_readable_secondaries: Whether to enable secondaries to serve read-only traffic. Defaults to false
        :param pulumi.Input[_builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
               1 primary and 0 secondaries
        :param pulumi.Input['DatabaseInstanceParentInstanceRefArgs'] parent_instance_ref: The ref of the parent instance. This is only available if the instance is
               child instance.
               Input: For specifying the parent instance to create a child instance. Optional.
               Output: Only populated if provided as input to create a child instance
        :param pulumi.Input[_builtins.bool] purge_on_delete: Purge the resource on delete
        :param pulumi.Input[_builtins.int] retention_window_in_days: The retention window for the instance. This is the time window in days
               for which the historical data is retained. The default value is 7 days.
               Valid values are 2 to 35 days
        :param pulumi.Input[_builtins.bool] stopped: Whether the instance is stopped
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if enable_readable_secondaries is not None:
            pulumi.set(__self__, "enable_readable_secondaries", enable_readable_secondaries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if parent_instance_ref is not None:
            pulumi.set(__self__, "parent_instance_ref", parent_instance_ref)
        if purge_on_delete is not None:
            pulumi.set(__self__, "purge_on_delete", purge_on_delete)
        if retention_window_in_days is not None:
            pulumi.set(__self__, "retention_window_in_days", retention_window_in_days)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="enableReadableSecondaries")
    def enable_readable_secondaries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable secondaries to serve read-only traffic. Defaults to false
        """
        return pulumi.get(self, "enable_readable_secondaries")

    @enable_readable_secondaries.setter
    def enable_readable_secondaries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_readable_secondaries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
        1 primary and 0 secondaries
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="parentInstanceRef")
    def parent_instance_ref(self) -> Optional[pulumi.Input['DatabaseInstanceParentInstanceRefArgs']]:
        """
        The ref of the parent instance. This is only available if the instance is
        child instance.
        Input: For specifying the parent instance to create a child instance. Optional.
        Output: Only populated if provided as input to create a child instance
        """
        return pulumi.get(self, "parent_instance_ref")

    @parent_instance_ref.setter
    def parent_instance_ref(self, value: Optional[pulumi.Input['DatabaseInstanceParentInstanceRefArgs']]):
        pulumi.set(self, "parent_instance_ref", value)

    @_builtins.property
    @pulumi.getter(name="purgeOnDelete")
    def purge_on_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Purge the resource on delete
        """
        return pulumi.get(self, "purge_on_delete")

    @purge_on_delete.setter
    def purge_on_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_on_delete", value)

    @_builtins.property
    @pulumi.getter(name="retentionWindowInDays")
    def retention_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention window for the instance. This is the time window in days
        for which the historical data is retained. The default value is 7 days.
        Valid values are 2 to 35 days
        """
        return pulumi.get(self, "retention_window_in_days")

    @retention_window_in_days.setter
    def retention_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @stopped.setter
    def stopped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stopped", value)


@pulumi.input_type
class _DatabaseInstanceState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 child_instance_refs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceChildInstanceRefArgs']]]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 effective_retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 effective_stopped: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_instance_ref: Optional[pulumi.Input['DatabaseInstanceParentInstanceRefArgs']] = None,
                 pg_version: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_only_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_dns: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseInstance resources.
        :param pulumi.Input[_builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceChildInstanceRefArgs']]] child_instance_refs: (list of DatabaseInstanceRef) - The refs of the child instances. This is only available if the instance is
               parent instance
        :param pulumi.Input[_builtins.str] creation_time: (string) - The timestamp when the instance was created
        :param pulumi.Input[_builtins.str] creator: (string) - The email of the creator of the instance
        :param pulumi.Input[_builtins.bool] effective_enable_readable_secondaries: (boolean) - xref AIP-129. `enable_readable_secondaries` is owned by the client, while `effective_enable_readable_secondaries` is owned by the server.
               `enable_readable_secondaries` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_enable_readable_secondaries` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.int] effective_node_count: (integer) - xref AIP-129. `node_count` is owned by the client, while `effective_node_count` is owned by the server.
               `node_count` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_node_count` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.int] effective_retention_window_in_days: (integer) - xref AIP-129. `retention_window_in_days` is owned by the client, while `effective_retention_window_in_days` is owned by the server.
               `retention_window_in_days` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_retention_window_in_days` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.bool] effective_stopped: (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
               `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.bool] enable_readable_secondaries: Whether to enable secondaries to serve read-only traffic. Defaults to false
        :param pulumi.Input[_builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
               1 primary and 0 secondaries
        :param pulumi.Input['DatabaseInstanceParentInstanceRefArgs'] parent_instance_ref: The ref of the parent instance. This is only available if the instance is
               child instance.
               Input: For specifying the parent instance to create a child instance. Optional.
               Output: Only populated if provided as input to create a child instance
        :param pulumi.Input[_builtins.str] pg_version: (string) - The version of Postgres running on the instance
        :param pulumi.Input[_builtins.bool] purge_on_delete: Purge the resource on delete
        :param pulumi.Input[_builtins.str] read_only_dns: (string) - The DNS endpoint to connect to the instance for read only access. This is only available if
               enable_readable_secondaries is true
        :param pulumi.Input[_builtins.str] read_write_dns: (string) - The DNS endpoint to connect to the instance for read+write access
        :param pulumi.Input[_builtins.int] retention_window_in_days: The retention window for the instance. This is the time window in days
               for which the historical data is retained. The default value is 7 days.
               Valid values are 2 to 35 days
        :param pulumi.Input[_builtins.str] state: (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        :param pulumi.Input[_builtins.bool] stopped: Whether the instance is stopped
        :param pulumi.Input[_builtins.str] uid: (string) - Id of the ref database instance
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if child_instance_refs is not None:
            pulumi.set(__self__, "child_instance_refs", child_instance_refs)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if effective_enable_readable_secondaries is not None:
            pulumi.set(__self__, "effective_enable_readable_secondaries", effective_enable_readable_secondaries)
        if effective_node_count is not None:
            pulumi.set(__self__, "effective_node_count", effective_node_count)
        if effective_retention_window_in_days is not None:
            pulumi.set(__self__, "effective_retention_window_in_days", effective_retention_window_in_days)
        if effective_stopped is not None:
            pulumi.set(__self__, "effective_stopped", effective_stopped)
        if enable_readable_secondaries is not None:
            pulumi.set(__self__, "enable_readable_secondaries", enable_readable_secondaries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if parent_instance_ref is not None:
            pulumi.set(__self__, "parent_instance_ref", parent_instance_ref)
        if pg_version is not None:
            pulumi.set(__self__, "pg_version", pg_version)
        if purge_on_delete is not None:
            pulumi.set(__self__, "purge_on_delete", purge_on_delete)
        if read_only_dns is not None:
            pulumi.set(__self__, "read_only_dns", read_only_dns)
        if read_write_dns is not None:
            pulumi.set(__self__, "read_write_dns", read_write_dns)
        if retention_window_in_days is not None:
            pulumi.set(__self__, "retention_window_in_days", retention_window_in_days)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stopped is not None:
            pulumi.set(__self__, "stopped", stopped)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="childInstanceRefs")
    def child_instance_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceChildInstanceRefArgs']]]]:
        """
        (list of DatabaseInstanceRef) - The refs of the child instances. This is only available if the instance is
        parent instance
        """
        return pulumi.get(self, "child_instance_refs")

    @child_instance_refs.setter
    def child_instance_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInstanceChildInstanceRefArgs']]]]):
        pulumi.set(self, "child_instance_refs", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The timestamp when the instance was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The email of the creator of the instance
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter(name="effectiveEnableReadableSecondaries")
    def effective_enable_readable_secondaries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (boolean) - xref AIP-129. `enable_readable_secondaries` is owned by the client, while `effective_enable_readable_secondaries` is owned by the server.
        `enable_readable_secondaries` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_enable_readable_secondaries` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_enable_readable_secondaries")

    @effective_enable_readable_secondaries.setter
    def effective_enable_readable_secondaries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "effective_enable_readable_secondaries", value)

    @_builtins.property
    @pulumi.getter(name="effectiveNodeCount")
    def effective_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - xref AIP-129. `node_count` is owned by the client, while `effective_node_count` is owned by the server.
        `node_count` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_node_count` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_node_count")

    @effective_node_count.setter
    def effective_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "effective_node_count", value)

    @_builtins.property
    @pulumi.getter(name="effectiveRetentionWindowInDays")
    def effective_retention_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - xref AIP-129. `retention_window_in_days` is owned by the client, while `effective_retention_window_in_days` is owned by the server.
        `retention_window_in_days` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_retention_window_in_days` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_retention_window_in_days")

    @effective_retention_window_in_days.setter
    def effective_retention_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "effective_retention_window_in_days", value)

    @_builtins.property
    @pulumi.getter(name="effectiveStopped")
    def effective_stopped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
        `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_stopped")

    @effective_stopped.setter
    def effective_stopped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "effective_stopped", value)

    @_builtins.property
    @pulumi.getter(name="enableReadableSecondaries")
    def enable_readable_secondaries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable secondaries to serve read-only traffic. Defaults to false
        """
        return pulumi.get(self, "enable_readable_secondaries")

    @enable_readable_secondaries.setter
    def enable_readable_secondaries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_readable_secondaries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
        1 primary and 0 secondaries
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="parentInstanceRef")
    def parent_instance_ref(self) -> Optional[pulumi.Input['DatabaseInstanceParentInstanceRefArgs']]:
        """
        The ref of the parent instance. This is only available if the instance is
        child instance.
        Input: For specifying the parent instance to create a child instance. Optional.
        Output: Only populated if provided as input to create a child instance
        """
        return pulumi.get(self, "parent_instance_ref")

    @parent_instance_ref.setter
    def parent_instance_ref(self, value: Optional[pulumi.Input['DatabaseInstanceParentInstanceRefArgs']]):
        pulumi.set(self, "parent_instance_ref", value)

    @_builtins.property
    @pulumi.getter(name="pgVersion")
    def pg_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The version of Postgres running on the instance
        """
        return pulumi.get(self, "pg_version")

    @pg_version.setter
    def pg_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pg_version", value)

    @_builtins.property
    @pulumi.getter(name="purgeOnDelete")
    def purge_on_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Purge the resource on delete
        """
        return pulumi.get(self, "purge_on_delete")

    @purge_on_delete.setter
    def purge_on_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_on_delete", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyDns")
    def read_only_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The DNS endpoint to connect to the instance for read only access. This is only available if
        enable_readable_secondaries is true
        """
        return pulumi.get(self, "read_only_dns")

    @read_only_dns.setter
    def read_only_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_only_dns", value)

    @_builtins.property
    @pulumi.getter(name="readWriteDns")
    def read_write_dns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The DNS endpoint to connect to the instance for read+write access
        """
        return pulumi.get(self, "read_write_dns")

    @read_write_dns.setter
    def read_write_dns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_write_dns", value)

    @_builtins.property
    @pulumi.getter(name="retentionWindowInDays")
    def retention_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention window for the instance. This is the time window in days
        for which the historical data is retained. The default value is 7 days.
        Valid values are 2 to 35 days
        """
        return pulumi.get(self, "retention_window_in_days")

    @retention_window_in_days.setter
    def retention_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @stopped.setter
    def stopped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stopped", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Id of the ref database instance
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("databricks:index/databaseInstance:DatabaseInstance")
class DatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_instance_ref: Optional[pulumi.Input[Union['DatabaseInstanceParentInstanceRefArgs', 'DatabaseInstanceParentInstanceRefArgsDict']]] = None,
                 purge_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Lakebase Database Instances are managed Postgres instances, composed of a primary Postgres compute instance and 0 or more read replica instances.

        ## Example Usage

        ### Basic Example

        This example creates a simple Database Instance with the specified name and capacity.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseInstance("this",
            name="my-database-instance",
            capacity="CU_2")
        ```

        ### Example with Readable Secondaries

        This example creates a Database Instance with readable secondaries (and HA) enabled.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseInstance("this",
            name="my-database-instance",
            capacity="CU_2",
            node_count=2,
            enable_readable_secondaries=True)
        ```

        ### Example Child Instance Created From Parent

        This example creates a child Database Instance from a specified parent Database Instance at the current point in time.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        child = databricks.DatabaseInstance("child",
            name="my-database-instance",
            capacity="CU_2",
            parent_instance_ref={
                "name": "my-parent-instance",
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_database_instance.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseInstance:DatabaseInstance databricks_database_instance name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[_builtins.bool] enable_readable_secondaries: Whether to enable secondaries to serve read-only traffic. Defaults to false
        :param pulumi.Input[_builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
               1 primary and 0 secondaries
        :param pulumi.Input[Union['DatabaseInstanceParentInstanceRefArgs', 'DatabaseInstanceParentInstanceRefArgsDict']] parent_instance_ref: The ref of the parent instance. This is only available if the instance is
               child instance.
               Input: For specifying the parent instance to create a child instance. Optional.
               Output: Only populated if provided as input to create a child instance
        :param pulumi.Input[_builtins.bool] purge_on_delete: Purge the resource on delete
        :param pulumi.Input[_builtins.int] retention_window_in_days: The retention window for the instance. This is the time window in days
               for which the historical data is retained. The default value is 7 days.
               Valid values are 2 to 35 days
        :param pulumi.Input[_builtins.bool] stopped: Whether the instance is stopped
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatabaseInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Lakebase Database Instances are managed Postgres instances, composed of a primary Postgres compute instance and 0 or more read replica instances.

        ## Example Usage

        ### Basic Example

        This example creates a simple Database Instance with the specified name and capacity.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseInstance("this",
            name="my-database-instance",
            capacity="CU_2")
        ```

        ### Example with Readable Secondaries

        This example creates a Database Instance with readable secondaries (and HA) enabled.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.DatabaseInstance("this",
            name="my-database-instance",
            capacity="CU_2",
            node_count=2,
            enable_readable_secondaries=True)
        ```

        ### Example Child Instance Created From Parent

        This example creates a child Database Instance from a specified parent Database Instance at the current point in time.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        child = databricks.DatabaseInstance("child",
            name="my-database-instance",
            capacity="CU_2",
            parent_instance_ref={
                "name": "my-parent-instance",
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_database_instance.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseInstance:DatabaseInstance databricks_database_instance name
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_instance_ref: Optional[pulumi.Input[Union['DatabaseInstanceParentInstanceRefArgs', 'DatabaseInstanceParentInstanceRefArgsDict']]] = None,
                 purge_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 stopped: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInstanceArgs.__new__(DatabaseInstanceArgs)

            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["enable_readable_secondaries"] = enable_readable_secondaries
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["parent_instance_ref"] = parent_instance_ref
            __props__.__dict__["purge_on_delete"] = purge_on_delete
            __props__.__dict__["retention_window_in_days"] = retention_window_in_days
            __props__.__dict__["stopped"] = stopped
            __props__.__dict__["child_instance_refs"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["effective_enable_readable_secondaries"] = None
            __props__.__dict__["effective_node_count"] = None
            __props__.__dict__["effective_retention_window_in_days"] = None
            __props__.__dict__["effective_stopped"] = None
            __props__.__dict__["pg_version"] = None
            __props__.__dict__["read_only_dns"] = None
            __props__.__dict__["read_write_dns"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
        super(DatabaseInstance, __self__).__init__(
            'databricks:index/databaseInstance:DatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[_builtins.str]] = None,
            child_instance_refs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseInstanceChildInstanceRefArgs', 'DatabaseInstanceChildInstanceRefArgsDict']]]]] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            effective_enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_node_count: Optional[pulumi.Input[_builtins.int]] = None,
            effective_retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            effective_stopped: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_readable_secondaries: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            parent_instance_ref: Optional[pulumi.Input[Union['DatabaseInstanceParentInstanceRefArgs', 'DatabaseInstanceParentInstanceRefArgsDict']]] = None,
            pg_version: Optional[pulumi.Input[_builtins.str]] = None,
            purge_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            read_only_dns: Optional[pulumi.Input[_builtins.str]] = None,
            read_write_dns: Optional[pulumi.Input[_builtins.str]] = None,
            retention_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            stopped: Optional[pulumi.Input[_builtins.bool]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseInstance':
        """
        Get an existing DatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capacity: The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseInstanceChildInstanceRefArgs', 'DatabaseInstanceChildInstanceRefArgsDict']]]] child_instance_refs: (list of DatabaseInstanceRef) - The refs of the child instances. This is only available if the instance is
               parent instance
        :param pulumi.Input[_builtins.str] creation_time: (string) - The timestamp when the instance was created
        :param pulumi.Input[_builtins.str] creator: (string) - The email of the creator of the instance
        :param pulumi.Input[_builtins.bool] effective_enable_readable_secondaries: (boolean) - xref AIP-129. `enable_readable_secondaries` is owned by the client, while `effective_enable_readable_secondaries` is owned by the server.
               `enable_readable_secondaries` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_enable_readable_secondaries` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.int] effective_node_count: (integer) - xref AIP-129. `node_count` is owned by the client, while `effective_node_count` is owned by the server.
               `node_count` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_node_count` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.int] effective_retention_window_in_days: (integer) - xref AIP-129. `retention_window_in_days` is owned by the client, while `effective_retention_window_in_days` is owned by the server.
               `retention_window_in_days` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_retention_window_in_days` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.bool] effective_stopped: (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
               `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
               `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        :param pulumi.Input[_builtins.bool] enable_readable_secondaries: Whether to enable secondaries to serve read-only traffic. Defaults to false
        :param pulumi.Input[_builtins.str] name: The name of the instance. This is the unique identifier for the instance
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
               1 primary and 0 secondaries
        :param pulumi.Input[Union['DatabaseInstanceParentInstanceRefArgs', 'DatabaseInstanceParentInstanceRefArgsDict']] parent_instance_ref: The ref of the parent instance. This is only available if the instance is
               child instance.
               Input: For specifying the parent instance to create a child instance. Optional.
               Output: Only populated if provided as input to create a child instance
        :param pulumi.Input[_builtins.str] pg_version: (string) - The version of Postgres running on the instance
        :param pulumi.Input[_builtins.bool] purge_on_delete: Purge the resource on delete
        :param pulumi.Input[_builtins.str] read_only_dns: (string) - The DNS endpoint to connect to the instance for read only access. This is only available if
               enable_readable_secondaries is true
        :param pulumi.Input[_builtins.str] read_write_dns: (string) - The DNS endpoint to connect to the instance for read+write access
        :param pulumi.Input[_builtins.int] retention_window_in_days: The retention window for the instance. This is the time window in days
               for which the historical data is retained. The default value is 7 days.
               Valid values are 2 to 35 days
        :param pulumi.Input[_builtins.str] state: (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        :param pulumi.Input[_builtins.bool] stopped: Whether the instance is stopped
        :param pulumi.Input[_builtins.str] uid: (string) - Id of the ref database instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInstanceState.__new__(_DatabaseInstanceState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["child_instance_refs"] = child_instance_refs
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["effective_enable_readable_secondaries"] = effective_enable_readable_secondaries
        __props__.__dict__["effective_node_count"] = effective_node_count
        __props__.__dict__["effective_retention_window_in_days"] = effective_retention_window_in_days
        __props__.__dict__["effective_stopped"] = effective_stopped
        __props__.__dict__["enable_readable_secondaries"] = enable_readable_secondaries
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["parent_instance_ref"] = parent_instance_ref
        __props__.__dict__["pg_version"] = pg_version
        __props__.__dict__["purge_on_delete"] = purge_on_delete
        __props__.__dict__["read_only_dns"] = read_only_dns
        __props__.__dict__["read_write_dns"] = read_write_dns
        __props__.__dict__["retention_window_in_days"] = retention_window_in_days
        __props__.__dict__["state"] = state
        __props__.__dict__["stopped"] = stopped
        __props__.__dict__["uid"] = uid
        return DatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The sku of the instance. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="childInstanceRefs")
    def child_instance_refs(self) -> pulumi.Output[Sequence['outputs.DatabaseInstanceChildInstanceRef']]:
        """
        (list of DatabaseInstanceRef) - The refs of the child instances. This is only available if the instance is
        parent instance
        """
        return pulumi.get(self, "child_instance_refs")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The timestamp when the instance was created
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The email of the creator of the instance
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="effectiveEnableReadableSecondaries")
    def effective_enable_readable_secondaries(self) -> pulumi.Output[_builtins.bool]:
        """
        (boolean) - xref AIP-129. `enable_readable_secondaries` is owned by the client, while `effective_enable_readable_secondaries` is owned by the server.
        `enable_readable_secondaries` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_enable_readable_secondaries` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_enable_readable_secondaries")

    @_builtins.property
    @pulumi.getter(name="effectiveNodeCount")
    def effective_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - xref AIP-129. `node_count` is owned by the client, while `effective_node_count` is owned by the server.
        `node_count` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_node_count` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_node_count")

    @_builtins.property
    @pulumi.getter(name="effectiveRetentionWindowInDays")
    def effective_retention_window_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - xref AIP-129. `retention_window_in_days` is owned by the client, while `effective_retention_window_in_days` is owned by the server.
        `retention_window_in_days` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_retention_window_in_days` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_retention_window_in_days")

    @_builtins.property
    @pulumi.getter(name="effectiveStopped")
    def effective_stopped(self) -> pulumi.Output[_builtins.bool]:
        """
        (boolean) - xref AIP-129. `stopped` is owned by the client, while `effective_stopped` is owned by the server.
        `stopped` will only be set in Create/Update response messages if and only if the user provides the field via the request.
        `effective_stopped` on the other hand will always bet set in all response messages (Create/Update/Get/List)
        """
        return pulumi.get(self, "effective_stopped")

    @_builtins.property
    @pulumi.getter(name="enableReadableSecondaries")
    def enable_readable_secondaries(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable secondaries to serve read-only traffic. Defaults to false
        """
        return pulumi.get(self, "enable_readable_secondaries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance. This is the unique identifier for the instance
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of nodes in the instance, composed of 1 primary and 0 or more secondaries. Defaults to
        1 primary and 0 secondaries
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="parentInstanceRef")
    def parent_instance_ref(self) -> pulumi.Output[Optional['outputs.DatabaseInstanceParentInstanceRef']]:
        """
        The ref of the parent instance. This is only available if the instance is
        child instance.
        Input: For specifying the parent instance to create a child instance. Optional.
        Output: Only populated if provided as input to create a child instance
        """
        return pulumi.get(self, "parent_instance_ref")

    @_builtins.property
    @pulumi.getter(name="pgVersion")
    def pg_version(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The version of Postgres running on the instance
        """
        return pulumi.get(self, "pg_version")

    @_builtins.property
    @pulumi.getter(name="purgeOnDelete")
    def purge_on_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Purge the resource on delete
        """
        return pulumi.get(self, "purge_on_delete")

    @_builtins.property
    @pulumi.getter(name="readOnlyDns")
    def read_only_dns(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The DNS endpoint to connect to the instance for read only access. This is only available if
        enable_readable_secondaries is true
        """
        return pulumi.get(self, "read_only_dns")

    @_builtins.property
    @pulumi.getter(name="readWriteDns")
    def read_write_dns(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The DNS endpoint to connect to the instance for read+write access
        """
        return pulumi.get(self, "read_write_dns")

    @_builtins.property
    @pulumi.getter(name="retentionWindowInDays")
    def retention_window_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The retention window for the instance. This is the time window in days
        for which the historical data is retained. The default value is 7 days.
        Valid values are 2 to 35 days
        """
        return pulumi.get(self, "retention_window_in_days")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The current state of the instance. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def stopped(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the instance is stopped
        """
        return pulumi.get(self, "stopped")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Id of the ref database instance
        """
        return pulumi.get(self, "uid")

