# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPolicyInfoResult',
    'AwaitableGetPolicyInfoResult',
    'get_policy_info',
    'get_policy_info_output',
]

@pulumi.output_type
class GetPolicyInfoResult:
    """
    A collection of values returned by getPolicyInfo.
    """
    def __init__(__self__, column_mask=None, comment=None, created_at=None, created_by=None, except_principals=None, for_securable_type=None, id=None, match_columns=None, name=None, on_securable_fullname=None, on_securable_type=None, policy_type=None, row_filter=None, to_principals=None, updated_at=None, updated_by=None, when_condition=None):
        if column_mask and not isinstance(column_mask, dict):
            raise TypeError("Expected argument 'column_mask' to be a dict")
        pulumi.set(__self__, "column_mask", column_mask)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if created_at and not isinstance(created_at, int):
            raise TypeError("Expected argument 'created_at' to be a int")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if except_principals and not isinstance(except_principals, list):
            raise TypeError("Expected argument 'except_principals' to be a list")
        pulumi.set(__self__, "except_principals", except_principals)
        if for_securable_type and not isinstance(for_securable_type, str):
            raise TypeError("Expected argument 'for_securable_type' to be a str")
        pulumi.set(__self__, "for_securable_type", for_securable_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match_columns and not isinstance(match_columns, list):
            raise TypeError("Expected argument 'match_columns' to be a list")
        pulumi.set(__self__, "match_columns", match_columns)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if on_securable_fullname and not isinstance(on_securable_fullname, str):
            raise TypeError("Expected argument 'on_securable_fullname' to be a str")
        pulumi.set(__self__, "on_securable_fullname", on_securable_fullname)
        if on_securable_type and not isinstance(on_securable_type, str):
            raise TypeError("Expected argument 'on_securable_type' to be a str")
        pulumi.set(__self__, "on_securable_type", on_securable_type)
        if policy_type and not isinstance(policy_type, str):
            raise TypeError("Expected argument 'policy_type' to be a str")
        pulumi.set(__self__, "policy_type", policy_type)
        if row_filter and not isinstance(row_filter, dict):
            raise TypeError("Expected argument 'row_filter' to be a dict")
        pulumi.set(__self__, "row_filter", row_filter)
        if to_principals and not isinstance(to_principals, list):
            raise TypeError("Expected argument 'to_principals' to be a list")
        pulumi.set(__self__, "to_principals", to_principals)
        if updated_at and not isinstance(updated_at, int):
            raise TypeError("Expected argument 'updated_at' to be a int")
        pulumi.set(__self__, "updated_at", updated_at)
        if updated_by and not isinstance(updated_by, str):
            raise TypeError("Expected argument 'updated_by' to be a str")
        pulumi.set(__self__, "updated_by", updated_by)
        if when_condition and not isinstance(when_condition, str):
            raise TypeError("Expected argument 'when_condition' to be a str")
        pulumi.set(__self__, "when_condition", when_condition)

    @_builtins.property
    @pulumi.getter(name="columnMask")
    def column_mask(self) -> Optional['outputs.GetPolicyInfoColumnMaskResult']:
        """
        (ColumnMaskOptions) - Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "column_mask")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        (string) - Optional description of the policy
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.int:
        """
        (integer) - Time at which the policy was created, in epoch milliseconds. Output only
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        (string) - Username of the user who created the policy. Output only
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="exceptPrincipals")
    def except_principals(self) -> Optional[Sequence[_builtins.str]]:
        """
        (list of string) - Optional list of user or group names that should be excluded from the policy
        """
        return pulumi.get(self, "except_principals")

    @_builtins.property
    @pulumi.getter(name="forSecurableType")
    def for_securable_type(self) -> _builtins.str:
        """
        (string) - Type of securables that the policy should take effect on.
        Only `table` is supported at this moment.
        Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "for_securable_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (string) - Unique identifier of the policy. This field is output only and is generated by the system
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="matchColumns")
    def match_columns(self) -> Optional[Sequence['outputs.GetPolicyInfoMatchColumnResult']]:
        """
        (list of MatchColumn) - Optional list of condition expressions used to match table columns.
        Only valid when `for_securable_type` is `table`.
        When specified, the policy only applies to tables whose columns satisfy all match conditions
        """
        return pulumi.get(self, "match_columns")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (string) - Name of the policy. Required on create and ignored on update.
        To update the name, use the `new_name` field
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onSecurableFullname")
    def on_securable_fullname(self) -> Optional[_builtins.str]:
        """
        (string) - Full name of the securable on which the policy is defined.
        Required on create and ignored on update
        """
        return pulumi.get(self, "on_securable_fullname")

    @_builtins.property
    @pulumi.getter(name="onSecurableType")
    def on_securable_type(self) -> Optional[_builtins.str]:
        """
        (string) - Type of the securable on which the policy is defined.
        Only `catalog`, `schema` and `table` are supported at this moment.
        Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
        """
        return pulumi.get(self, "on_securable_type")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        (string) - Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional['outputs.GetPolicyInfoRowFilterResult']:
        """
        (RowFilterOptions) - Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
        Required on create and optional on update. When specified on update,
        the new options will replace the existing options as a whole
        """
        return pulumi.get(self, "row_filter")

    @_builtins.property
    @pulumi.getter(name="toPrincipals")
    def to_principals(self) -> Sequence[_builtins.str]:
        """
        (list of string) - List of user or group names that the policy applies to.
        Required on create and optional on update
        """
        return pulumi.get(self, "to_principals")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.int:
        """
        (integer) - Time at which the policy was last modified, in epoch milliseconds. Output only
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        (string) - Username of the user who last modified the policy. Output only
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="whenCondition")
    def when_condition(self) -> Optional[_builtins.str]:
        """
        (string) - Optional condition when the policy should take effect
        """
        return pulumi.get(self, "when_condition")


class AwaitableGetPolicyInfoResult(GetPolicyInfoResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyInfoResult(
            column_mask=self.column_mask,
            comment=self.comment,
            created_at=self.created_at,
            created_by=self.created_by,
            except_principals=self.except_principals,
            for_securable_type=self.for_securable_type,
            id=self.id,
            match_columns=self.match_columns,
            name=self.name,
            on_securable_fullname=self.on_securable_fullname,
            on_securable_type=self.on_securable_type,
            policy_type=self.policy_type,
            row_filter=self.row_filter,
            to_principals=self.to_principals,
            updated_at=self.updated_at,
            updated_by=self.updated_by,
            when_condition=self.when_condition)


def get_policy_info(column_mask: Optional[Union['GetPolicyInfoColumnMaskArgs', 'GetPolicyInfoColumnMaskArgsDict']] = None,
                    comment: Optional[_builtins.str] = None,
                    except_principals: Optional[Sequence[_builtins.str]] = None,
                    for_securable_type: Optional[_builtins.str] = None,
                    match_columns: Optional[Sequence[Union['GetPolicyInfoMatchColumnArgs', 'GetPolicyInfoMatchColumnArgsDict']]] = None,
                    name: Optional[_builtins.str] = None,
                    on_securable_fullname: Optional[_builtins.str] = None,
                    on_securable_type: Optional[_builtins.str] = None,
                    policy_type: Optional[_builtins.str] = None,
                    row_filter: Optional[Union['GetPolicyInfoRowFilterArgs', 'GetPolicyInfoRowFilterArgsDict']] = None,
                    to_principals: Optional[Sequence[_builtins.str]] = None,
                    when_condition: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyInfoResult:
    """
    Use this data source to access information about an existing resource.

    :param Union['GetPolicyInfoColumnMaskArgs', 'GetPolicyInfoColumnMaskArgsDict'] column_mask: (ColumnMaskOptions) - Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
           Required on create and optional on update. When specified on update,
           the new options will replace the existing options as a whole
    :param _builtins.str comment: (string) - Optional description of the policy
    :param Sequence[_builtins.str] except_principals: (list of string) - Optional list of user or group names that should be excluded from the policy
    :param _builtins.str for_securable_type: (string) - Type of securables that the policy should take effect on.
           Only `table` is supported at this moment.
           Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
    :param Sequence[Union['GetPolicyInfoMatchColumnArgs', 'GetPolicyInfoMatchColumnArgsDict']] match_columns: (list of MatchColumn) - Optional list of condition expressions used to match table columns.
           Only valid when `for_securable_type` is `table`.
           When specified, the policy only applies to tables whose columns satisfy all match conditions
    :param _builtins.str name: Name of the policy. Required on create and ignored on update.
           To update the name, use the `new_name` field
    :param _builtins.str on_securable_fullname: Full name of the securable on which the policy is defined.
           Required on create and ignored on update
    :param _builtins.str on_securable_type: Type of the securable on which the policy is defined.
           Only `catalog`, `schema` and `table` are supported at this moment.
           Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
    :param _builtins.str policy_type: (string) - Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
    :param Union['GetPolicyInfoRowFilterArgs', 'GetPolicyInfoRowFilterArgsDict'] row_filter: (RowFilterOptions) - Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
           Required on create and optional on update. When specified on update,
           the new options will replace the existing options as a whole
    :param Sequence[_builtins.str] to_principals: (list of string) - List of user or group names that the policy applies to.
           Required on create and optional on update
    :param _builtins.str when_condition: (string) - Optional condition when the policy should take effect
    """
    __args__ = dict()
    __args__['columnMask'] = column_mask
    __args__['comment'] = comment
    __args__['exceptPrincipals'] = except_principals
    __args__['forSecurableType'] = for_securable_type
    __args__['matchColumns'] = match_columns
    __args__['name'] = name
    __args__['onSecurableFullname'] = on_securable_fullname
    __args__['onSecurableType'] = on_securable_type
    __args__['policyType'] = policy_type
    __args__['rowFilter'] = row_filter
    __args__['toPrincipals'] = to_principals
    __args__['whenCondition'] = when_condition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getPolicyInfo:getPolicyInfo', __args__, opts=opts, typ=GetPolicyInfoResult).value

    return AwaitableGetPolicyInfoResult(
        column_mask=pulumi.get(__ret__, 'column_mask'),
        comment=pulumi.get(__ret__, 'comment'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        except_principals=pulumi.get(__ret__, 'except_principals'),
        for_securable_type=pulumi.get(__ret__, 'for_securable_type'),
        id=pulumi.get(__ret__, 'id'),
        match_columns=pulumi.get(__ret__, 'match_columns'),
        name=pulumi.get(__ret__, 'name'),
        on_securable_fullname=pulumi.get(__ret__, 'on_securable_fullname'),
        on_securable_type=pulumi.get(__ret__, 'on_securable_type'),
        policy_type=pulumi.get(__ret__, 'policy_type'),
        row_filter=pulumi.get(__ret__, 'row_filter'),
        to_principals=pulumi.get(__ret__, 'to_principals'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        updated_by=pulumi.get(__ret__, 'updated_by'),
        when_condition=pulumi.get(__ret__, 'when_condition'))
def get_policy_info_output(column_mask: Optional[pulumi.Input[Optional[Union['GetPolicyInfoColumnMaskArgs', 'GetPolicyInfoColumnMaskArgsDict']]]] = None,
                           comment: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           except_principals: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           for_securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                           match_columns: Optional[pulumi.Input[Optional[Sequence[Union['GetPolicyInfoMatchColumnArgs', 'GetPolicyInfoMatchColumnArgsDict']]]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           on_securable_fullname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           on_securable_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                           row_filter: Optional[pulumi.Input[Optional[Union['GetPolicyInfoRowFilterArgs', 'GetPolicyInfoRowFilterArgsDict']]]] = None,
                           to_principals: Optional[pulumi.Input[Sequence[_builtins.str]]] = None,
                           when_condition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyInfoResult]:
    """
    Use this data source to access information about an existing resource.

    :param Union['GetPolicyInfoColumnMaskArgs', 'GetPolicyInfoColumnMaskArgsDict'] column_mask: (ColumnMaskOptions) - Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
           Required on create and optional on update. When specified on update,
           the new options will replace the existing options as a whole
    :param _builtins.str comment: (string) - Optional description of the policy
    :param Sequence[_builtins.str] except_principals: (list of string) - Optional list of user or group names that should be excluded from the policy
    :param _builtins.str for_securable_type: (string) - Type of securables that the policy should take effect on.
           Only `table` is supported at this moment.
           Required on create and optional on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
    :param Sequence[Union['GetPolicyInfoMatchColumnArgs', 'GetPolicyInfoMatchColumnArgsDict']] match_columns: (list of MatchColumn) - Optional list of condition expressions used to match table columns.
           Only valid when `for_securable_type` is `table`.
           When specified, the policy only applies to tables whose columns satisfy all match conditions
    :param _builtins.str name: Name of the policy. Required on create and ignored on update.
           To update the name, use the `new_name` field
    :param _builtins.str on_securable_fullname: Full name of the securable on which the policy is defined.
           Required on create and ignored on update
    :param _builtins.str on_securable_type: Type of the securable on which the policy is defined.
           Only `catalog`, `schema` and `table` are supported at this moment.
           Required on create and ignored on update. Possible values are: `CATALOG`, `CLEAN_ROOM`, `CONNECTION`, `CREDENTIAL`, `EXTERNAL_LOCATION`, `EXTERNAL_METADATA`, `FUNCTION`, `METASTORE`, `PIPELINE`, `PROVIDER`, `RECIPIENT`, `SCHEMA`, `SHARE`, `STAGING_TABLE`, `STORAGE_CREDENTIAL`, `TABLE`, `VOLUME`
    :param _builtins.str policy_type: (string) - Type of the policy. Required on create and ignored on update. Possible values are: `POLICY_TYPE_COLUMN_MASK`, `POLICY_TYPE_ROW_FILTER`
    :param Union['GetPolicyInfoRowFilterArgs', 'GetPolicyInfoRowFilterArgsDict'] row_filter: (RowFilterOptions) - Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
           Required on create and optional on update. When specified on update,
           the new options will replace the existing options as a whole
    :param Sequence[_builtins.str] to_principals: (list of string) - List of user or group names that the policy applies to.
           Required on create and optional on update
    :param _builtins.str when_condition: (string) - Optional condition when the policy should take effect
    """
    __args__ = dict()
    __args__['columnMask'] = column_mask
    __args__['comment'] = comment
    __args__['exceptPrincipals'] = except_principals
    __args__['forSecurableType'] = for_securable_type
    __args__['matchColumns'] = match_columns
    __args__['name'] = name
    __args__['onSecurableFullname'] = on_securable_fullname
    __args__['onSecurableType'] = on_securable_type
    __args__['policyType'] = policy_type
    __args__['rowFilter'] = row_filter
    __args__['toPrincipals'] = to_principals
    __args__['whenCondition'] = when_condition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getPolicyInfo:getPolicyInfo', __args__, opts=opts, typ=GetPolicyInfoResult)
    return __ret__.apply(lambda __response__: GetPolicyInfoResult(
        column_mask=pulumi.get(__response__, 'column_mask'),
        comment=pulumi.get(__response__, 'comment'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        except_principals=pulumi.get(__response__, 'except_principals'),
        for_securable_type=pulumi.get(__response__, 'for_securable_type'),
        id=pulumi.get(__response__, 'id'),
        match_columns=pulumi.get(__response__, 'match_columns'),
        name=pulumi.get(__response__, 'name'),
        on_securable_fullname=pulumi.get(__response__, 'on_securable_fullname'),
        on_securable_type=pulumi.get(__response__, 'on_securable_type'),
        policy_type=pulumi.get(__response__, 'policy_type'),
        row_filter=pulumi.get(__response__, 'row_filter'),
        to_principals=pulumi.get(__response__, 'to_principals'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        updated_by=pulumi.get(__response__, 'updated_by'),
        when_condition=pulumi.get(__response__, 'when_condition')))
