# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MwsWorkspacesArgs', 'MwsWorkspaces']

@pulumi.input_type
class MwsWorkspacesArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 workspace_name: pulumi.Input[_builtins.str],
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_resource_container: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']] = None,
                 compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_customer_info: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']] = None,
                 gcp_managed_network_config: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']] = None,
                 gke_config: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input['MwsWorkspacesTokenArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MwsWorkspaces resource.
        :param pulumi.Input[_builtins.str] account_id: Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[_builtins.str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[_builtins.str] aws_region: region of VPC.
        :param pulumi.Input['MwsWorkspacesCloudResourceContainerArgs'] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[_builtins.str] compute_mode: The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.
               
               > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        :param pulumi.Input[_builtins.int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[_builtins.str] credentials_id: `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        :param pulumi.Input[_builtins.str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input[_builtins.str] location: region of the subnet.
        :param pulumi.Input[_builtins.str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[_builtins.str] network_id: `network_id` from networks.
        :param pulumi.Input[_builtins.str] pricing_tier: The pricing tier of the workspace.
        :param pulumi.Input[_builtins.str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[_builtins.str] storage_configuration_id: `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[_builtins.str] storage_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        :param pulumi.Input[_builtins.str] workspace_id: (String) workspace id
        :param pulumi.Input[_builtins.str] workspace_status: (String) workspace status
        :param pulumi.Input[_builtins.str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[_builtins.str] workspace_url: (String) URL of the workspace
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "workspace_name", workspace_name)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_resource_container is not None:
            pulumi.set(__self__, "cloud_resource_container", cloud_resource_container)
        if compute_mode is not None:
            pulumi.set(__self__, "compute_mode", compute_mode)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if customer_managed_key_id is not None:
            warnings.warn("""Use managed_services_customer_managed_key_id instead""", DeprecationWarning)
            pulumi.log.warn("""customer_managed_key_id is deprecated: Use managed_services_customer_managed_key_id instead""")
        if customer_managed_key_id is not None:
            pulumi.set(__self__, "customer_managed_key_id", customer_managed_key_id)
        if deployment_name is not None:
            pulumi.set(__self__, "deployment_name", deployment_name)
        if external_customer_info is not None:
            pulumi.set(__self__, "external_customer_info", external_customer_info)
        if gcp_managed_network_config is not None:
            pulumi.set(__self__, "gcp_managed_network_config", gcp_managed_network_config)
        if gke_config is not None:
            warnings.warn("""gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""", DeprecationWarning)
            pulumi.log.warn("""gke_config is deprecated: gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""")
        if gke_config is not None:
            pulumi.set(__self__, "gke_config", gke_config)
        if is_no_public_ip_enabled is not None:
            pulumi.set(__self__, "is_no_public_ip_enabled", is_no_public_ip_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_services_customer_managed_key_id is not None:
            pulumi.set(__self__, "managed_services_customer_managed_key_id", managed_services_customer_managed_key_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if pricing_tier is not None:
            pulumi.set(__self__, "pricing_tier", pricing_tier)
        if private_access_settings_id is not None:
            pulumi.set(__self__, "private_access_settings_id", private_access_settings_id)
        if storage_configuration_id is not None:
            pulumi.set(__self__, "storage_configuration_id", storage_configuration_id)
        if storage_customer_managed_key_id is not None:
            pulumi.set(__self__, "storage_customer_managed_key_id", storage_customer_managed_key_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_status is not None:
            pulumi.set(__self__, "workspace_status", workspace_status)
        if workspace_status_message is not None:
            pulumi.set(__self__, "workspace_status_message", workspace_status_message)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[_builtins.str]:
        """
        name of the workspace, will appear on UI.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        region of VPC.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="cloudResourceContainer")
    def cloud_resource_container(self) -> Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]:
        """
        A block that specifies GCP workspace configurations, consisting of following blocks:
        """
        return pulumi.get(self, "cloud_resource_container")

    @cloud_resource_container.setter
    def cloud_resource_container(self, value: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]):
        pulumi.set(self, "cloud_resource_container", value)

    @_builtins.property
    @pulumi.getter(name="computeMode")
    def compute_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.

        > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        """
        return pulumi.get(self, "compute_mode")

    @compute_mode.setter
    def compute_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_mode", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) time when workspace was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_id", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyId")
    @_utilities.deprecated("""Use managed_services_customer_managed_key_id instead""")
    def customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "customer_managed_key_id")

    @customer_managed_key_id.setter
    def customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        """
        return pulumi.get(self, "deployment_name")

    @deployment_name.setter
    def deployment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_name", value)

    @_builtins.property
    @pulumi.getter(name="externalCustomerInfo")
    def external_customer_info(self) -> Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]:
        return pulumi.get(self, "external_customer_info")

    @external_customer_info.setter
    def external_customer_info(self, value: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]):
        pulumi.set(self, "external_customer_info", value)

    @_builtins.property
    @pulumi.getter(name="gcpManagedNetworkConfig")
    def gcp_managed_network_config(self) -> Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]:
        return pulumi.get(self, "gcp_managed_network_config")

    @gcp_managed_network_config.setter
    def gcp_managed_network_config(self, value: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]):
        pulumi.set(self, "gcp_managed_network_config", value)

    @_builtins.property
    @pulumi.getter(name="gkeConfig")
    @_utilities.deprecated("""gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""")
    def gke_config(self) -> Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]:
        return pulumi.get(self, "gke_config")

    @gke_config.setter
    def gke_config(self, value: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]):
        pulumi.set(self, "gke_config", value)

    @_builtins.property
    @pulumi.getter(name="isNoPublicIpEnabled")
    def is_no_public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_no_public_ip_enabled")

    @is_no_public_ip_enabled.setter
    def is_no_public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_no_public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        region of the subnet.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedServicesCustomerManagedKeyId")
    def managed_services_customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        """
        return pulumi.get(self, "managed_services_customer_managed_key_id")

    @managed_services_customer_managed_key_id.setter
    def managed_services_customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_services_customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `network_id` from networks.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing tier of the workspace.
        """
        return pulumi.get(self, "pricing_tier")

    @pricing_tier.setter
    def pricing_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_tier", value)

    @_builtins.property
    @pulumi.getter(name="privateAccessSettingsId")
    def private_access_settings_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        """
        return pulumi.get(self, "private_access_settings_id")

    @private_access_settings_id.setter
    def private_access_settings_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_access_settings_id", value)

    @_builtins.property
    @pulumi.getter(name="storageConfigurationId")
    def storage_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        """
        return pulumi.get(self, "storage_configuration_id")

    @storage_configuration_id.setter
    def storage_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="storageCustomerManagedKeyId")
    def storage_customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        """
        return pulumi.get(self, "storage_customer_managed_key_id")

    @storage_customer_managed_key_id.setter
    def storage_customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input['MwsWorkspacesTokenArgs']]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input['MwsWorkspacesTokenArgs']]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) workspace id
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceStatus")
    def workspace_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) workspace status
        """
        return pulumi.get(self, "workspace_status")

    @workspace_status.setter
    def workspace_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_status", value)

    @_builtins.property
    @pulumi.getter(name="workspaceStatusMessage")
    def workspace_status_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) updates on workspace status
        """
        return pulumi.get(self, "workspace_status_message")

    @workspace_status_message.setter
    def workspace_status_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_status_message", value)

    @_builtins.property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) URL of the workspace
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.input_type
class _MwsWorkspacesState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_resource_container: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']] = None,
                 compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 external_customer_info: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']] = None,
                 gcp_managed_network_config: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']] = None,
                 gcp_workspace_sa: Optional[pulumi.Input[_builtins.str]] = None,
                 gke_config: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input['MwsWorkspacesTokenArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MwsWorkspaces resources.
        :param pulumi.Input[_builtins.str] account_id: Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[_builtins.str] aws_region: region of VPC.
        :param pulumi.Input['MwsWorkspacesCloudResourceContainerArgs'] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[_builtins.str] compute_mode: The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.
               
               > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        :param pulumi.Input[_builtins.int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[_builtins.str] credentials_id: `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        :param pulumi.Input[_builtins.str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input[_builtins.str] effective_compute_mode: (String) The effective compute mode for the workspace. This is either `SERVERLESS` for serverless workspaces or `HYBRID` for classic workspaces.
        :param pulumi.Input[_builtins.str] gcp_workspace_sa: (String, GCP only) identifier of a service account created for the workspace in form of `db-<workspace-id>@prod-gcp-<region>.iam.gserviceaccount.com`
        :param pulumi.Input[_builtins.str] location: region of the subnet.
        :param pulumi.Input[_builtins.str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[_builtins.str] network_id: `network_id` from networks.
        :param pulumi.Input[_builtins.str] pricing_tier: The pricing tier of the workspace.
        :param pulumi.Input[_builtins.str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[_builtins.str] storage_configuration_id: `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[_builtins.str] storage_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        :param pulumi.Input[_builtins.str] workspace_id: (String) workspace id
        :param pulumi.Input[_builtins.str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[_builtins.str] workspace_status: (String) workspace status
        :param pulumi.Input[_builtins.str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[_builtins.str] workspace_url: (String) URL of the workspace
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_resource_container is not None:
            pulumi.set(__self__, "cloud_resource_container", cloud_resource_container)
        if compute_mode is not None:
            pulumi.set(__self__, "compute_mode", compute_mode)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if credentials_id is not None:
            pulumi.set(__self__, "credentials_id", credentials_id)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if customer_managed_key_id is not None:
            warnings.warn("""Use managed_services_customer_managed_key_id instead""", DeprecationWarning)
            pulumi.log.warn("""customer_managed_key_id is deprecated: Use managed_services_customer_managed_key_id instead""")
        if customer_managed_key_id is not None:
            pulumi.set(__self__, "customer_managed_key_id", customer_managed_key_id)
        if deployment_name is not None:
            pulumi.set(__self__, "deployment_name", deployment_name)
        if effective_compute_mode is not None:
            pulumi.set(__self__, "effective_compute_mode", effective_compute_mode)
        if external_customer_info is not None:
            pulumi.set(__self__, "external_customer_info", external_customer_info)
        if gcp_managed_network_config is not None:
            pulumi.set(__self__, "gcp_managed_network_config", gcp_managed_network_config)
        if gcp_workspace_sa is not None:
            pulumi.set(__self__, "gcp_workspace_sa", gcp_workspace_sa)
        if gke_config is not None:
            warnings.warn("""gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""", DeprecationWarning)
            pulumi.log.warn("""gke_config is deprecated: gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""")
        if gke_config is not None:
            pulumi.set(__self__, "gke_config", gke_config)
        if is_no_public_ip_enabled is not None:
            pulumi.set(__self__, "is_no_public_ip_enabled", is_no_public_ip_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_services_customer_managed_key_id is not None:
            pulumi.set(__self__, "managed_services_customer_managed_key_id", managed_services_customer_managed_key_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if pricing_tier is not None:
            pulumi.set(__self__, "pricing_tier", pricing_tier)
        if private_access_settings_id is not None:
            pulumi.set(__self__, "private_access_settings_id", private_access_settings_id)
        if storage_configuration_id is not None:
            pulumi.set(__self__, "storage_configuration_id", storage_configuration_id)
        if storage_customer_managed_key_id is not None:
            pulumi.set(__self__, "storage_customer_managed_key_id", storage_customer_managed_key_id)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)
        if workspace_status is not None:
            pulumi.set(__self__, "workspace_status", workspace_status)
        if workspace_status_message is not None:
            pulumi.set(__self__, "workspace_status_message", workspace_status_message)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        region of VPC.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter(name="cloudResourceContainer")
    def cloud_resource_container(self) -> Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]:
        """
        A block that specifies GCP workspace configurations, consisting of following blocks:
        """
        return pulumi.get(self, "cloud_resource_container")

    @cloud_resource_container.setter
    def cloud_resource_container(self, value: Optional[pulumi.Input['MwsWorkspacesCloudResourceContainerArgs']]):
        pulumi.set(self, "cloud_resource_container", value)

    @_builtins.property
    @pulumi.getter(name="computeMode")
    def compute_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.

        > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        """
        return pulumi.get(self, "compute_mode")

    @compute_mode.setter
    def compute_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_mode", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) time when workspace was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        """
        return pulumi.get(self, "credentials_id")

    @credentials_id.setter
    def credentials_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_id", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyId")
    @_utilities.deprecated("""Use managed_services_customer_managed_key_id instead""")
    def customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "customer_managed_key_id")

    @customer_managed_key_id.setter
    def customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        """
        return pulumi.get(self, "deployment_name")

    @deployment_name.setter
    def deployment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveComputeMode")
    def effective_compute_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) The effective compute mode for the workspace. This is either `SERVERLESS` for serverless workspaces or `HYBRID` for classic workspaces.
        """
        return pulumi.get(self, "effective_compute_mode")

    @effective_compute_mode.setter
    def effective_compute_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_compute_mode", value)

    @_builtins.property
    @pulumi.getter(name="externalCustomerInfo")
    def external_customer_info(self) -> Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]:
        return pulumi.get(self, "external_customer_info")

    @external_customer_info.setter
    def external_customer_info(self, value: Optional[pulumi.Input['MwsWorkspacesExternalCustomerInfoArgs']]):
        pulumi.set(self, "external_customer_info", value)

    @_builtins.property
    @pulumi.getter(name="gcpManagedNetworkConfig")
    def gcp_managed_network_config(self) -> Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]:
        return pulumi.get(self, "gcp_managed_network_config")

    @gcp_managed_network_config.setter
    def gcp_managed_network_config(self, value: Optional[pulumi.Input['MwsWorkspacesGcpManagedNetworkConfigArgs']]):
        pulumi.set(self, "gcp_managed_network_config", value)

    @_builtins.property
    @pulumi.getter(name="gcpWorkspaceSa")
    def gcp_workspace_sa(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String, GCP only) identifier of a service account created for the workspace in form of `db-<workspace-id>@prod-gcp-<region>.iam.gserviceaccount.com`
        """
        return pulumi.get(self, "gcp_workspace_sa")

    @gcp_workspace_sa.setter
    def gcp_workspace_sa(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_workspace_sa", value)

    @_builtins.property
    @pulumi.getter(name="gkeConfig")
    @_utilities.deprecated("""gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""")
    def gke_config(self) -> Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]:
        return pulumi.get(self, "gke_config")

    @gke_config.setter
    def gke_config(self, value: Optional[pulumi.Input['MwsWorkspacesGkeConfigArgs']]):
        pulumi.set(self, "gke_config", value)

    @_builtins.property
    @pulumi.getter(name="isNoPublicIpEnabled")
    def is_no_public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_no_public_ip_enabled")

    @is_no_public_ip_enabled.setter
    def is_no_public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_no_public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        region of the subnet.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedServicesCustomerManagedKeyId")
    def managed_services_customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        """
        return pulumi.get(self, "managed_services_customer_managed_key_id")

    @managed_services_customer_managed_key_id.setter
    def managed_services_customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_services_customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `network_id` from networks.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing tier of the workspace.
        """
        return pulumi.get(self, "pricing_tier")

    @pricing_tier.setter
    def pricing_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_tier", value)

    @_builtins.property
    @pulumi.getter(name="privateAccessSettingsId")
    def private_access_settings_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        """
        return pulumi.get(self, "private_access_settings_id")

    @private_access_settings_id.setter
    def private_access_settings_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_access_settings_id", value)

    @_builtins.property
    @pulumi.getter(name="storageConfigurationId")
    def storage_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        """
        return pulumi.get(self, "storage_configuration_id")

    @storage_configuration_id.setter
    def storage_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="storageCustomerManagedKeyId")
    def storage_customer_managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        """
        return pulumi.get(self, "storage_customer_managed_key_id")

    @storage_customer_managed_key_id.setter
    def storage_customer_managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_customer_managed_key_id", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input['MwsWorkspacesTokenArgs']]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input['MwsWorkspacesTokenArgs']]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) workspace id
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        name of the workspace, will appear on UI.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceStatus")
    def workspace_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) workspace status
        """
        return pulumi.get(self, "workspace_status")

    @workspace_status.setter
    def workspace_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_status", value)

    @_builtins.property
    @pulumi.getter(name="workspaceStatusMessage")
    def workspace_status_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) updates on workspace status
        """
        return pulumi.get(self, "workspace_status_message")

    @workspace_status_message.setter
    def workspace_status_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_status_message", value)

    @_builtins.property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) URL of the workspace
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.type_token("databricks:index/mwsWorkspaces:MwsWorkspaces")
class MwsWorkspaces(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_resource_container: Optional[pulumi.Input[Union['MwsWorkspacesCloudResourceContainerArgs', 'MwsWorkspacesCloudResourceContainerArgsDict']]] = None,
                 compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_customer_info: Optional[pulumi.Input[Union['MwsWorkspacesExternalCustomerInfoArgs', 'MwsWorkspacesExternalCustomerInfoArgsDict']]] = None,
                 gcp_managed_network_config: Optional[pulumi.Input[Union['MwsWorkspacesGcpManagedNetworkConfigArgs', 'MwsWorkspacesGcpManagedNetworkConfigArgsDict']]] = None,
                 gke_config: Optional[pulumi.Input[Union['MwsWorkspacesGkeConfigArgs', 'MwsWorkspacesGkeConfigArgsDict']]] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[Union['MwsWorkspacesTokenArgs', 'MwsWorkspacesTokenArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to set up [workspaces on AWS](https://docs.databricks.com/getting-started/overview.html#e2-architecture-1) or [workspaces on GCP](https://docs.gcp.databricks.com/administration-guide/account-settings-gcp/workspaces.html). Please follow this complete runnable example on AWS or GCP with new VPC and new workspace setup.

        > This resource can only be used with an account-level provider!

        > The `gke_config` argument is now deprecated and no longer supported. If you have already created a workspace using these fields, it is safe to remove them from your Pulumi template.

        > On Azure you need to use azurerm_databricks_workspace resource to create Azure Databricks workspaces.

        ## Example Usage

        ### Creating a serverless workspace in AWS

        Creating a serverless workspace does not require any prerequisite resources. Simply specify `compute_mode = "SERVERLESS"` when creating the workspace. Serverless workspaces must not include `credentials_id` or `storage_configuration_id`.

        To use serverless workspaces, you must enroll in the [Default Storage preview](https://docs.databricks.com/aws/en/storage/express-storage).

        ```python
        import pulumi
        import pulumi_databricks as databricks

        serverless_workspace = databricks.MwsWorkspaces("serverless_workspace",
            account_id="",
            workspace_name="serverless-workspace",
            aws_region="us-east-1",
            compute_mode="SERVERLESS")
        ```

        ### Creating a workspace on AWS

        !Simplest multiworkspace

        To get workspace running, you have to configure a couple of things:

        * MwsCredentials - You can share a credentials (cross-account IAM role) configuration ID with multiple workspaces. It is not required to create a new one for each workspace.
        * MwsStorageConfigurations - You can share a root S3 bucket with multiple workspaces in a single account. You do not have to create new ones for each workspace. If you share a root S3 bucket for multiple workspaces in an account, data on the root S3 bucket is partitioned into separate directories by workspace.
        * MwsNetworks - (optional, but recommended) You can share one [customer-managed VPC](https://docs.databricks.com/administration-guide/cloud-configurations/aws/customer-managed-vpc.html) with multiple workspaces in a single account. However, Databricks recommends using unique subnets and security groups for each workspace. If you plan to share one VPC with multiple workspaces, be sure to size your VPC and subnets accordingly. Because a Databricks MwsNetworks encapsulates this information, you cannot reuse it across workspaces.
        * MwsCustomerManagedKeys - You can share a customer-managed key across workspaces.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Account ID that can be found in the dropdown under the email address in the upper-right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        # register cross-account ARN
        this = databricks.MwsCredentials("this",
            account_id=databricks_account_id,
            credentials_name=f"{prefix}-creds",
            role_arn=crossaccount_arn)
        # register root bucket
        this_mws_storage_configurations = databricks.MwsStorageConfigurations("this",
            account_id=databricks_account_id,
            storage_configuration_name=f"{prefix}-storage",
            bucket_name=root_bucket)
        # register VPC
        this_mws_networks = databricks.MwsNetworks("this",
            account_id=databricks_account_id,
            network_name=f"{prefix}-network",
            vpc_id=vpc_id,
            subnet_ids=subnets_private,
            security_group_ids=[security_group])
        # create workspace in given VPC with DBFS on root bucket
        this_mws_workspaces = databricks.MwsWorkspaces("this",
            account_id=databricks_account_id,
            workspace_name=prefix,
            aws_region=region,
            credentials_id=this.credentials_id,
            storage_configuration_id=this_mws_storage_configurations.storage_configuration_id,
            network_id=this_mws_networks.network_id)
        ```

        ### Creating a workspace on AWS with Databricks-Managed VPC

        ![VPCs](https://docs.databricks.com/_images/customer-managed-vpc.png)

        By default, Databricks creates a VPC in your AWS account for each workspace. Databricks uses it for running clusters in the workspace. Optionally, you can use your VPC for the workspace, using the feature customer-managed VPC. Databricks recommends that you provide your VPC with MwsNetworks so that you can configure it according to your organization's enterprise cloud standards while still conforming to Databricks requirements. You cannot migrate an existing workspace to your VPC. Please see the difference described through IAM policy actions [on this page](https://docs.databricks.com/administration-guide/account-api/iam-role.html).

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_databricks as databricks
        import pulumi_random as random

        config = pulumi.Config()
        # Account Id that could be found in the top right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        naming = random.index.String("naming",
            special=False,
            upper=False,
            length=6)
        prefix = f"dltp{naming['result']}"
        this = databricks.get_aws_assume_role_policy(external_id=databricks_account_id)
        cross_account_role = aws.iam.Role("cross_account_role",
            name=f"{prefix}-crossaccount",
            assume_role_policy=this.json,
            tags=tags)
        this_get_aws_cross_account_policy = databricks.get_aws_cross_account_policy()
        this_role_policy = aws.iam.RolePolicy("this",
            name=f"{prefix}-policy",
            role=cross_account_role.id,
            policy=this_get_aws_cross_account_policy.json)
        this_mws_credentials = databricks.MwsCredentials("this",
            account_id=databricks_account_id,
            credentials_name=f"{prefix}-creds",
            role_arn=cross_account_role.arn)
        root_storage_bucket = aws.s3.BucketV2("root_storage_bucket",
            bucket=f"{prefix}-rootbucket",
            acl="private",
            force_destroy=True,
            tags=tags)
        root_versioning = aws.s3.BucketVersioningV2("root_versioning",
            bucket=root_storage_bucket.id,
            versioning_configuration={
                "status": "Disabled",
            })
        root_storage_bucket_bucket_server_side_encryption_configuration_v2 = aws.s3.BucketServerSideEncryptionConfigurationV2("root_storage_bucket",
            bucket=root_storage_bucket.bucket,
            rules=[{
                "apply_server_side_encryption_by_default": {
                    "sse_algorithm": "AES256",
                },
            }])
        root_storage_bucket_bucket_public_access_block = aws.s3.BucketPublicAccessBlock("root_storage_bucket",
            bucket=root_storage_bucket.id,
            block_public_acls=True,
            block_public_policy=True,
            ignore_public_acls=True,
            restrict_public_buckets=True,
            opts = pulumi.ResourceOptions(depends_on=[root_storage_bucket]))
        this_get_aws_bucket_policy = databricks.get_aws_bucket_policy_output(bucket=root_storage_bucket.bucket)
        root_bucket_policy = aws.s3.BucketPolicy("root_bucket_policy",
            bucket=root_storage_bucket.id,
            policy=this_get_aws_bucket_policy.json,
            opts = pulumi.ResourceOptions(depends_on=[root_storage_bucket_bucket_public_access_block]))
        this_mws_storage_configurations = databricks.MwsStorageConfigurations("this",
            account_id=databricks_account_id,
            storage_configuration_name=f"{prefix}-storage",
            bucket_name=root_storage_bucket.bucket)
        this_mws_workspaces = databricks.MwsWorkspaces("this",
            account_id=databricks_account_id,
            workspace_name=prefix,
            aws_region="us-east-1",
            credentials_id=this_mws_credentials.credentials_id,
            storage_configuration_id=this_mws_storage_configurations.storage_configuration_id,
            custom_tags={
                "SoldToCode": "1234",
            })
        ```

        In order to create a [Databricks Workspace that leverages AWS PrivateLink](https://docs.databricks.com/administration-guide/cloud-configurations/aws/privatelink.html) please ensure that you have read and understood the [Enable Private Link](https://docs.databricks.com/administration-guide/cloud-configurations/aws/privatelink.html) documentation and then customise the example above with the relevant examples from mws_vpc_endpoint, mws_private_access_settings and mws_networks.

        ### Creating a workspace on GCP

        To get workspace running, you have to configure a network object:

        * MwsNetworks - (optional, but recommended) You can share one [customer-managed VPC](https://docs.gcp.databricks.com/administration-guide/cloud-configurations/gcp/customer-managed-vpc.html) with multiple workspaces in a single account. You do not have to create a new VPC for each workspace. However, you cannot reuse subnets with other resources, including other workspaces or non-Databricks resources. If you plan to share one VPC with multiple workspaces, be sure to size your VPC and subnets accordingly. Because a Databricks MwsNetworks encapsulates this information, you cannot reuse it across workspaces.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Account Id that could be found in the top right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        databricks_google_service_account = config.require_object("databricksGoogleServiceAccount")
        google_project = config.require_object("googleProject")
        # register VPC
        this = databricks.MwsNetworks("this",
            account_id=databricks_account_id,
            network_name=f"{prefix}-network",
            gcp_network_info={
                "network_project_id": google_project,
                "vpc_id": vpc_id,
                "subnet_id": subnet_id,
                "subnet_region": subnet_region,
                "pod_ip_range_name": "pods",
                "service_ip_range_name": "svc",
            })
        # create workspace in given VPC
        this_mws_workspaces = databricks.MwsWorkspaces("this",
            account_id=databricks_account_id,
            workspace_name=prefix,
            location=subnet_region,
            cloud_resource_container={
                "gcp": {
                    "project_id": google_project,
                },
            },
            network_id=this.network_id)
        ```

        In order to create a [Databricks Workspace that leverages GCP Private Service Connect](https://docs.gcp.databricks.com/administration-guide/cloud-configurations/gcp/private-service-connect.html) please ensure that you have read and understood the [Enable Private Service Connect](https://docs.gcp.databricks.com/administration-guide/cloud-configurations/gcp/private-service-connect.html) documentation and then customise the example above with the relevant examples from mws_vpc_endpoint, mws_private_access_settings and mws_networks.

        ## Import

        This resource can be imported by Databricks account ID and workspace ID.

        hcl

        import {

          to = databricks_mws_workspaces.this

          id = "<account_id>/<workspace_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsWorkspaces:MwsWorkspaces this "<account_id>/<workspace_id>"
        ```

        ~> Not all fields of `databricks_mws_workspaces` can be updated without causing the workspace to be recreated.

           If the configuration for these immutable fields does not match the existing workspace, the workspace will

           be deleted and recreated in the next `pulumi up`. After importing, verify that the configuration

           matches the existing resource by running `pulumi preview`. The only fields that can be updated are

           `credentials_id`, `network_id`, `storage_customer_managed_key_id`, `private_access_settings_id`,

           `managed_services_customer_managed_key_id`, and `custom_tags`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[_builtins.str] aws_region: region of VPC.
        :param pulumi.Input[Union['MwsWorkspacesCloudResourceContainerArgs', 'MwsWorkspacesCloudResourceContainerArgsDict']] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[_builtins.str] compute_mode: The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.
               
               > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        :param pulumi.Input[_builtins.int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[_builtins.str] credentials_id: `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        :param pulumi.Input[_builtins.str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input[_builtins.str] location: region of the subnet.
        :param pulumi.Input[_builtins.str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[_builtins.str] network_id: `network_id` from networks.
        :param pulumi.Input[_builtins.str] pricing_tier: The pricing tier of the workspace.
        :param pulumi.Input[_builtins.str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[_builtins.str] storage_configuration_id: `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[_builtins.str] storage_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        :param pulumi.Input[_builtins.str] workspace_id: (String) workspace id
        :param pulumi.Input[_builtins.str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[_builtins.str] workspace_status: (String) workspace status
        :param pulumi.Input[_builtins.str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[_builtins.str] workspace_url: (String) URL of the workspace
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsWorkspacesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to set up [workspaces on AWS](https://docs.databricks.com/getting-started/overview.html#e2-architecture-1) or [workspaces on GCP](https://docs.gcp.databricks.com/administration-guide/account-settings-gcp/workspaces.html). Please follow this complete runnable example on AWS or GCP with new VPC and new workspace setup.

        > This resource can only be used with an account-level provider!

        > The `gke_config` argument is now deprecated and no longer supported. If you have already created a workspace using these fields, it is safe to remove them from your Pulumi template.

        > On Azure you need to use azurerm_databricks_workspace resource to create Azure Databricks workspaces.

        ## Example Usage

        ### Creating a serverless workspace in AWS

        Creating a serverless workspace does not require any prerequisite resources. Simply specify `compute_mode = "SERVERLESS"` when creating the workspace. Serverless workspaces must not include `credentials_id` or `storage_configuration_id`.

        To use serverless workspaces, you must enroll in the [Default Storage preview](https://docs.databricks.com/aws/en/storage/express-storage).

        ```python
        import pulumi
        import pulumi_databricks as databricks

        serverless_workspace = databricks.MwsWorkspaces("serverless_workspace",
            account_id="",
            workspace_name="serverless-workspace",
            aws_region="us-east-1",
            compute_mode="SERVERLESS")
        ```

        ### Creating a workspace on AWS

        !Simplest multiworkspace

        To get workspace running, you have to configure a couple of things:

        * MwsCredentials - You can share a credentials (cross-account IAM role) configuration ID with multiple workspaces. It is not required to create a new one for each workspace.
        * MwsStorageConfigurations - You can share a root S3 bucket with multiple workspaces in a single account. You do not have to create new ones for each workspace. If you share a root S3 bucket for multiple workspaces in an account, data on the root S3 bucket is partitioned into separate directories by workspace.
        * MwsNetworks - (optional, but recommended) You can share one [customer-managed VPC](https://docs.databricks.com/administration-guide/cloud-configurations/aws/customer-managed-vpc.html) with multiple workspaces in a single account. However, Databricks recommends using unique subnets and security groups for each workspace. If you plan to share one VPC with multiple workspaces, be sure to size your VPC and subnets accordingly. Because a Databricks MwsNetworks encapsulates this information, you cannot reuse it across workspaces.
        * MwsCustomerManagedKeys - You can share a customer-managed key across workspaces.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Account ID that can be found in the dropdown under the email address in the upper-right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        # register cross-account ARN
        this = databricks.MwsCredentials("this",
            account_id=databricks_account_id,
            credentials_name=f"{prefix}-creds",
            role_arn=crossaccount_arn)
        # register root bucket
        this_mws_storage_configurations = databricks.MwsStorageConfigurations("this",
            account_id=databricks_account_id,
            storage_configuration_name=f"{prefix}-storage",
            bucket_name=root_bucket)
        # register VPC
        this_mws_networks = databricks.MwsNetworks("this",
            account_id=databricks_account_id,
            network_name=f"{prefix}-network",
            vpc_id=vpc_id,
            subnet_ids=subnets_private,
            security_group_ids=[security_group])
        # create workspace in given VPC with DBFS on root bucket
        this_mws_workspaces = databricks.MwsWorkspaces("this",
            account_id=databricks_account_id,
            workspace_name=prefix,
            aws_region=region,
            credentials_id=this.credentials_id,
            storage_configuration_id=this_mws_storage_configurations.storage_configuration_id,
            network_id=this_mws_networks.network_id)
        ```

        ### Creating a workspace on AWS with Databricks-Managed VPC

        ![VPCs](https://docs.databricks.com/_images/customer-managed-vpc.png)

        By default, Databricks creates a VPC in your AWS account for each workspace. Databricks uses it for running clusters in the workspace. Optionally, you can use your VPC for the workspace, using the feature customer-managed VPC. Databricks recommends that you provide your VPC with MwsNetworks so that you can configure it according to your organization's enterprise cloud standards while still conforming to Databricks requirements. You cannot migrate an existing workspace to your VPC. Please see the difference described through IAM policy actions [on this page](https://docs.databricks.com/administration-guide/account-api/iam-role.html).

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_databricks as databricks
        import pulumi_random as random

        config = pulumi.Config()
        # Account Id that could be found in the top right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        naming = random.index.String("naming",
            special=False,
            upper=False,
            length=6)
        prefix = f"dltp{naming['result']}"
        this = databricks.get_aws_assume_role_policy(external_id=databricks_account_id)
        cross_account_role = aws.iam.Role("cross_account_role",
            name=f"{prefix}-crossaccount",
            assume_role_policy=this.json,
            tags=tags)
        this_get_aws_cross_account_policy = databricks.get_aws_cross_account_policy()
        this_role_policy = aws.iam.RolePolicy("this",
            name=f"{prefix}-policy",
            role=cross_account_role.id,
            policy=this_get_aws_cross_account_policy.json)
        this_mws_credentials = databricks.MwsCredentials("this",
            account_id=databricks_account_id,
            credentials_name=f"{prefix}-creds",
            role_arn=cross_account_role.arn)
        root_storage_bucket = aws.s3.BucketV2("root_storage_bucket",
            bucket=f"{prefix}-rootbucket",
            acl="private",
            force_destroy=True,
            tags=tags)
        root_versioning = aws.s3.BucketVersioningV2("root_versioning",
            bucket=root_storage_bucket.id,
            versioning_configuration={
                "status": "Disabled",
            })
        root_storage_bucket_bucket_server_side_encryption_configuration_v2 = aws.s3.BucketServerSideEncryptionConfigurationV2("root_storage_bucket",
            bucket=root_storage_bucket.bucket,
            rules=[{
                "apply_server_side_encryption_by_default": {
                    "sse_algorithm": "AES256",
                },
            }])
        root_storage_bucket_bucket_public_access_block = aws.s3.BucketPublicAccessBlock("root_storage_bucket",
            bucket=root_storage_bucket.id,
            block_public_acls=True,
            block_public_policy=True,
            ignore_public_acls=True,
            restrict_public_buckets=True,
            opts = pulumi.ResourceOptions(depends_on=[root_storage_bucket]))
        this_get_aws_bucket_policy = databricks.get_aws_bucket_policy_output(bucket=root_storage_bucket.bucket)
        root_bucket_policy = aws.s3.BucketPolicy("root_bucket_policy",
            bucket=root_storage_bucket.id,
            policy=this_get_aws_bucket_policy.json,
            opts = pulumi.ResourceOptions(depends_on=[root_storage_bucket_bucket_public_access_block]))
        this_mws_storage_configurations = databricks.MwsStorageConfigurations("this",
            account_id=databricks_account_id,
            storage_configuration_name=f"{prefix}-storage",
            bucket_name=root_storage_bucket.bucket)
        this_mws_workspaces = databricks.MwsWorkspaces("this",
            account_id=databricks_account_id,
            workspace_name=prefix,
            aws_region="us-east-1",
            credentials_id=this_mws_credentials.credentials_id,
            storage_configuration_id=this_mws_storage_configurations.storage_configuration_id,
            custom_tags={
                "SoldToCode": "1234",
            })
        ```

        In order to create a [Databricks Workspace that leverages AWS PrivateLink](https://docs.databricks.com/administration-guide/cloud-configurations/aws/privatelink.html) please ensure that you have read and understood the [Enable Private Link](https://docs.databricks.com/administration-guide/cloud-configurations/aws/privatelink.html) documentation and then customise the example above with the relevant examples from mws_vpc_endpoint, mws_private_access_settings and mws_networks.

        ### Creating a workspace on GCP

        To get workspace running, you have to configure a network object:

        * MwsNetworks - (optional, but recommended) You can share one [customer-managed VPC](https://docs.gcp.databricks.com/administration-guide/cloud-configurations/gcp/customer-managed-vpc.html) with multiple workspaces in a single account. You do not have to create a new VPC for each workspace. However, you cannot reuse subnets with other resources, including other workspaces or non-Databricks resources. If you plan to share one VPC with multiple workspaces, be sure to size your VPC and subnets accordingly. Because a Databricks MwsNetworks encapsulates this information, you cannot reuse it across workspaces.

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Account Id that could be found in the top right corner of https://accounts.cloud.databricks.com/
        databricks_account_id = config.require_object("databricksAccountId")
        databricks_google_service_account = config.require_object("databricksGoogleServiceAccount")
        google_project = config.require_object("googleProject")
        # register VPC
        this = databricks.MwsNetworks("this",
            account_id=databricks_account_id,
            network_name=f"{prefix}-network",
            gcp_network_info={
                "network_project_id": google_project,
                "vpc_id": vpc_id,
                "subnet_id": subnet_id,
                "subnet_region": subnet_region,
                "pod_ip_range_name": "pods",
                "service_ip_range_name": "svc",
            })
        # create workspace in given VPC
        this_mws_workspaces = databricks.MwsWorkspaces("this",
            account_id=databricks_account_id,
            workspace_name=prefix,
            location=subnet_region,
            cloud_resource_container={
                "gcp": {
                    "project_id": google_project,
                },
            },
            network_id=this.network_id)
        ```

        In order to create a [Databricks Workspace that leverages GCP Private Service Connect](https://docs.gcp.databricks.com/administration-guide/cloud-configurations/gcp/private-service-connect.html) please ensure that you have read and understood the [Enable Private Service Connect](https://docs.gcp.databricks.com/administration-guide/cloud-configurations/gcp/private-service-connect.html) documentation and then customise the example above with the relevant examples from mws_vpc_endpoint, mws_private_access_settings and mws_networks.

        ## Import

        This resource can be imported by Databricks account ID and workspace ID.

        hcl

        import {

          to = databricks_mws_workspaces.this

          id = "<account_id>/<workspace_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/mwsWorkspaces:MwsWorkspaces this "<account_id>/<workspace_id>"
        ```

        ~> Not all fields of `databricks_mws_workspaces` can be updated without causing the workspace to be recreated.

           If the configuration for these immutable fields does not match the existing workspace, the workspace will

           be deleted and recreated in the next `pulumi up`. After importing, verify that the configuration

           matches the existing resource by running `pulumi preview`. The only fields that can be updated are

           `credentials_id`, `network_id`, `storage_customer_managed_key_id`, `private_access_settings_id`,

           `managed_services_customer_managed_key_id`, and `custom_tags`.

        :param str resource_name: The name of the resource.
        :param MwsWorkspacesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsWorkspacesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_resource_container: Optional[pulumi.Input[Union['MwsWorkspacesCloudResourceContainerArgs', 'MwsWorkspacesCloudResourceContainerArgsDict']]] = None,
                 compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 credentials_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_customer_info: Optional[pulumi.Input[Union['MwsWorkspacesExternalCustomerInfoArgs', 'MwsWorkspacesExternalCustomerInfoArgsDict']]] = None,
                 gcp_managed_network_config: Optional[pulumi.Input[Union['MwsWorkspacesGcpManagedNetworkConfigArgs', 'MwsWorkspacesGcpManagedNetworkConfigArgsDict']]] = None,
                 gke_config: Optional[pulumi.Input[Union['MwsWorkspacesGkeConfigArgs', 'MwsWorkspacesGkeConfigArgsDict']]] = None,
                 is_no_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 private_access_settings_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[Union['MwsWorkspacesTokenArgs', 'MwsWorkspacesTokenArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsWorkspacesArgs.__new__(MwsWorkspacesArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = None if account_id is None else pulumi.Output.secret(account_id)
            __props__.__dict__["aws_region"] = aws_region
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["cloud_resource_container"] = cloud_resource_container
            __props__.__dict__["compute_mode"] = compute_mode
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["credentials_id"] = credentials_id
            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["customer_managed_key_id"] = customer_managed_key_id
            __props__.__dict__["deployment_name"] = deployment_name
            __props__.__dict__["external_customer_info"] = external_customer_info
            __props__.__dict__["gcp_managed_network_config"] = gcp_managed_network_config
            __props__.__dict__["gke_config"] = gke_config
            __props__.__dict__["is_no_public_ip_enabled"] = is_no_public_ip_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_services_customer_managed_key_id"] = managed_services_customer_managed_key_id
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["pricing_tier"] = pricing_tier
            __props__.__dict__["private_access_settings_id"] = private_access_settings_id
            __props__.__dict__["storage_configuration_id"] = storage_configuration_id
            __props__.__dict__["storage_customer_managed_key_id"] = storage_customer_managed_key_id
            __props__.__dict__["token"] = token
            __props__.__dict__["workspace_id"] = workspace_id
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            __props__.__dict__["workspace_status"] = workspace_status
            __props__.__dict__["workspace_status_message"] = workspace_status_message
            __props__.__dict__["workspace_url"] = workspace_url
            __props__.__dict__["effective_compute_mode"] = None
            __props__.__dict__["gcp_workspace_sa"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MwsWorkspaces, __self__).__init__(
            'databricks:index/mwsWorkspaces:MwsWorkspaces',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            aws_region: Optional[pulumi.Input[_builtins.str]] = None,
            cloud: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_resource_container: Optional[pulumi.Input[Union['MwsWorkspacesCloudResourceContainerArgs', 'MwsWorkspacesCloudResourceContainerArgsDict']]] = None,
            compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.int]] = None,
            credentials_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_compute_mode: Optional[pulumi.Input[_builtins.str]] = None,
            external_customer_info: Optional[pulumi.Input[Union['MwsWorkspacesExternalCustomerInfoArgs', 'MwsWorkspacesExternalCustomerInfoArgsDict']]] = None,
            gcp_managed_network_config: Optional[pulumi.Input[Union['MwsWorkspacesGcpManagedNetworkConfigArgs', 'MwsWorkspacesGcpManagedNetworkConfigArgsDict']]] = None,
            gcp_workspace_sa: Optional[pulumi.Input[_builtins.str]] = None,
            gke_config: Optional[pulumi.Input[Union['MwsWorkspacesGkeConfigArgs', 'MwsWorkspacesGkeConfigArgsDict']]] = None,
            is_no_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_services_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
            private_access_settings_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_customer_managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[Union['MwsWorkspacesTokenArgs', 'MwsWorkspacesTokenArgsDict']]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_status: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_status_message: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'MwsWorkspaces':
        """
        Get an existing MwsWorkspaces resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        :param pulumi.Input[_builtins.str] aws_region: region of VPC.
        :param pulumi.Input[Union['MwsWorkspacesCloudResourceContainerArgs', 'MwsWorkspacesCloudResourceContainerArgsDict']] cloud_resource_container: A block that specifies GCP workspace configurations, consisting of following blocks:
        :param pulumi.Input[_builtins.str] compute_mode: The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.
               
               > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        :param pulumi.Input[_builtins.int] creation_time: (Integer) time when workspace was created
        :param pulumi.Input[_builtins.str] credentials_id: `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_tags: The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        :param pulumi.Input[_builtins.str] deployment_name: part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        :param pulumi.Input[_builtins.str] effective_compute_mode: (String) The effective compute mode for the workspace. This is either `SERVERLESS` for serverless workspaces or `HYBRID` for classic workspaces.
        :param pulumi.Input[_builtins.str] gcp_workspace_sa: (String, GCP only) identifier of a service account created for the workspace in form of `db-<workspace-id>@prod-gcp-<region>.iam.gserviceaccount.com`
        :param pulumi.Input[_builtins.str] location: region of the subnet.
        :param pulumi.Input[_builtins.str] managed_services_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        :param pulumi.Input[_builtins.str] network_id: `network_id` from networks.
        :param pulumi.Input[_builtins.str] pricing_tier: The pricing tier of the workspace.
        :param pulumi.Input[_builtins.str] private_access_settings_id: Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        :param pulumi.Input[_builtins.str] storage_configuration_id: `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        :param pulumi.Input[_builtins.str] storage_customer_managed_key_id: `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        :param pulumi.Input[_builtins.str] workspace_id: (String) workspace id
        :param pulumi.Input[_builtins.str] workspace_name: name of the workspace, will appear on UI.
        :param pulumi.Input[_builtins.str] workspace_status: (String) workspace status
        :param pulumi.Input[_builtins.str] workspace_status_message: (String) updates on workspace status
        :param pulumi.Input[_builtins.str] workspace_url: (String) URL of the workspace
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsWorkspacesState.__new__(_MwsWorkspacesState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["cloud_resource_container"] = cloud_resource_container
        __props__.__dict__["compute_mode"] = compute_mode
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["credentials_id"] = credentials_id
        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["customer_managed_key_id"] = customer_managed_key_id
        __props__.__dict__["deployment_name"] = deployment_name
        __props__.__dict__["effective_compute_mode"] = effective_compute_mode
        __props__.__dict__["external_customer_info"] = external_customer_info
        __props__.__dict__["gcp_managed_network_config"] = gcp_managed_network_config
        __props__.__dict__["gcp_workspace_sa"] = gcp_workspace_sa
        __props__.__dict__["gke_config"] = gke_config
        __props__.__dict__["is_no_public_ip_enabled"] = is_no_public_ip_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_services_customer_managed_key_id"] = managed_services_customer_managed_key_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["pricing_tier"] = pricing_tier
        __props__.__dict__["private_access_settings_id"] = private_access_settings_id
        __props__.__dict__["storage_configuration_id"] = storage_configuration_id
        __props__.__dict__["storage_customer_managed_key_id"] = storage_customer_managed_key_id
        __props__.__dict__["token"] = token
        __props__.__dict__["workspace_id"] = workspace_id
        __props__.__dict__["workspace_name"] = workspace_name
        __props__.__dict__["workspace_status"] = workspace_status
        __props__.__dict__["workspace_status_message"] = workspace_status_message
        __props__.__dict__["workspace_url"] = workspace_url
        return MwsWorkspaces(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account Id that could be found in the top right corner of [Accounts Console](https://accounts.cloud.databricks.com/).
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        region of VPC.
        """
        return pulumi.get(self, "aws_region")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter(name="cloudResourceContainer")
    def cloud_resource_container(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesCloudResourceContainer']]:
        """
        A block that specifies GCP workspace configurations, consisting of following blocks:
        """
        return pulumi.get(self, "cloud_resource_container")

    @_builtins.property
    @pulumi.getter(name="computeMode")
    def compute_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The compute mode for the workspace. When unset, a classic workspace is created, and both `credentials_id` and `storage_configuration_id` must be specified. When set to `SERVERLESS`, the resulting workspace is a serverless workspace, and `credentials_id` and `storage_configuration_id` must not be set. The only allowed value for this is `SERVERLESS`. Changing this field requires recreation of the workspace.

        > Databricks strongly recommends using OAuth instead of PATs for user account client authentication and authorization due to the improved security
        """
        return pulumi.get(self, "compute_mode")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.int]:
        """
        (Integer) time when workspace was created
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `credentials_id` from credentials. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        """
        return pulumi.get(self, "credentials_id")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The custom tags key-value pairing that is attached to this workspace. These tags will be applied to clusters automatically in addition to any `default_tags` or `custom_tags` on a cluster level. Please note it can take up to an hour for custom_tags to be set due to scheduling on Control Plane. After custom tags are applied, they can be modified however they can never be completely removed.
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyId")
    @_utilities.deprecated("""Use managed_services_customer_managed_key_id instead""")
    def customer_managed_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "customer_managed_key_id")

    @_builtins.property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        part of URL as in `https://<prefix>-<deployment-name>.cloud.databricks.com`. Deployment name cannot be used until a deployment name prefix is defined. Please contact your Databricks representative. Once a new deployment prefix is added/updated, it only will affect the new workspaces created.
        """
        return pulumi.get(self, "deployment_name")

    @_builtins.property
    @pulumi.getter(name="effectiveComputeMode")
    def effective_compute_mode(self) -> pulumi.Output[_builtins.str]:
        """
        (String) The effective compute mode for the workspace. This is either `SERVERLESS` for serverless workspaces or `HYBRID` for classic workspaces.
        """
        return pulumi.get(self, "effective_compute_mode")

    @_builtins.property
    @pulumi.getter(name="externalCustomerInfo")
    def external_customer_info(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesExternalCustomerInfo']]:
        return pulumi.get(self, "external_customer_info")

    @_builtins.property
    @pulumi.getter(name="gcpManagedNetworkConfig")
    def gcp_managed_network_config(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesGcpManagedNetworkConfig']]:
        return pulumi.get(self, "gcp_managed_network_config")

    @_builtins.property
    @pulumi.getter(name="gcpWorkspaceSa")
    def gcp_workspace_sa(self) -> pulumi.Output[_builtins.str]:
        """
        (String, GCP only) identifier of a service account created for the workspace in form of `db-<workspace-id>@prod-gcp-<region>.iam.gserviceaccount.com`
        """
        return pulumi.get(self, "gcp_workspace_sa")

    @_builtins.property
    @pulumi.getter(name="gkeConfig")
    @_utilities.deprecated("""gke_config is deprecated and will be removed in a future release. For more information, review the documentation at https://registry.terraform.io/providers/databricks/databricks/1.87.1/docs/guides/gcp-workspace#creating-a-databricks-workspace""")
    def gke_config(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesGkeConfig']]:
        return pulumi.get(self, "gke_config")

    @_builtins.property
    @pulumi.getter(name="isNoPublicIpEnabled")
    def is_no_public_ip_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "is_no_public_ip_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        region of the subnet.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedServicesCustomerManagedKeyId")
    def managed_services_customer_managed_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `MANAGED_SERVICES`. This is used to encrypt the workspace's notebook and secret data in the control plane.
        """
        return pulumi.get(self, "managed_services_customer_managed_key_id")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `network_id` from networks.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> pulumi.Output[_builtins.str]:
        """
        The pricing tier of the workspace.
        """
        return pulumi.get(self, "pricing_tier")

    @_builtins.property
    @pulumi.getter(name="privateAccessSettingsId")
    def private_access_settings_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Canonical unique identifier of MwsPrivateAccessSettings in Databricks Account.
        """
        return pulumi.get(self, "private_access_settings_id")

    @_builtins.property
    @pulumi.getter(name="storageConfigurationId")
    def storage_configuration_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `storage_configuration_id` from storage configuration. This must not be specified when `compute_mode` is set to `SERVERLESS`.
        """
        return pulumi.get(self, "storage_configuration_id")

    @_builtins.property
    @pulumi.getter(name="storageCustomerManagedKeyId")
    def storage_customer_managed_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `customer_managed_key_id` from customer managed keys with `use_cases` set to `STORAGE`. This is used to encrypt the DBFS Storage & Cluster Volumes.
        """
        return pulumi.get(self, "storage_customer_managed_key_id")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional['outputs.MwsWorkspacesToken']]:
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        (String) workspace id
        """
        return pulumi.get(self, "workspace_id")

    @_builtins.property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Output[_builtins.str]:
        """
        name of the workspace, will appear on UI.
        """
        return pulumi.get(self, "workspace_name")

    @_builtins.property
    @pulumi.getter(name="workspaceStatus")
    def workspace_status(self) -> pulumi.Output[_builtins.str]:
        """
        (String) workspace status
        """
        return pulumi.get(self, "workspace_status")

    @_builtins.property
    @pulumi.getter(name="workspaceStatusMessage")
    def workspace_status_message(self) -> pulumi.Output[_builtins.str]:
        """
        (String) updates on workspace status
        """
        return pulumi.get(self, "workspace_status_message")

    @_builtins.property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> pulumi.Output[_builtins.str]:
        """
        (String) URL of the workspace
        """
        return pulumi.get(self, "workspace_url")

