# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OnlineStoreArgs', 'OnlineStore']

@pulumi.input_type
class OnlineStoreArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a OnlineStore resource.
        :param pulumi.Input[_builtins.str] capacity: The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[_builtins.str] name: The name of the online store. This is the unique identifier for the online store
        :param pulumi.Input[_builtins.int] read_replica_count: The number of read replicas for the online store. Defaults to 0
        """
        pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_replica_count is not None:
            pulumi.set(__self__, "read_replica_count", read_replica_count)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[_builtins.str]:
        """
        The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the online store. This is the unique identifier for the online store
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read replicas for the online store. Defaults to 0
        """
        return pulumi.get(self, "read_replica_count")

    @read_replica_count.setter
    def read_replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_replica_count", value)


@pulumi.input_type
class _OnlineStoreState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OnlineStore resources.
        :param pulumi.Input[_builtins.str] capacity: The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[_builtins.str] creation_time: (string) - The timestamp when the online store was created
        :param pulumi.Input[_builtins.str] creator: (string) - The email of the creator of the online store
        :param pulumi.Input[_builtins.str] name: The name of the online store. This is the unique identifier for the online store
        :param pulumi.Input[_builtins.int] read_replica_count: The number of read replicas for the online store. Defaults to 0
        :param pulumi.Input[_builtins.str] state: (string) - The current state of the online store. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_replica_count is not None:
            pulumi.set(__self__, "read_replica_count", read_replica_count)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The timestamp when the online store was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The email of the creator of the online store
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the online store. This is the unique identifier for the online store
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read replicas for the online store. Defaults to 0
        """
        return pulumi.get(self, "read_replica_count")

    @read_replica_count.setter
    def read_replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_replica_count", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The current state of the online store. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("databricks:index/onlineStore:OnlineStore")
class OnlineStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_online_store.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/onlineStore:OnlineStore databricks_online_store name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capacity: The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[_builtins.str] name: The name of the online store. This is the unique identifier for the online store
        :param pulumi.Input[_builtins.int] read_replica_count: The number of read replicas for the online store. Defaults to 0
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnlineStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = name

          to = databricks_online_store.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/onlineStore:OnlineStore databricks_online_store name
        ```

        :param str resource_name: The name of the resource.
        :param OnlineStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnlineStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnlineStoreArgs.__new__(OnlineStoreArgs)

            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["read_replica_count"] = read_replica_count
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["state"] = None
        super(OnlineStore, __self__).__init__(
            'databricks:index/onlineStore:OnlineStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'OnlineStore':
        """
        Get an existing OnlineStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capacity: The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        :param pulumi.Input[_builtins.str] creation_time: (string) - The timestamp when the online store was created
        :param pulumi.Input[_builtins.str] creator: (string) - The email of the creator of the online store
        :param pulumi.Input[_builtins.str] name: The name of the online store. This is the unique identifier for the online store
        :param pulumi.Input[_builtins.int] read_replica_count: The number of read replicas for the online store. Defaults to 0
        :param pulumi.Input[_builtins.str] state: (string) - The current state of the online store. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnlineStoreState.__new__(_OnlineStoreState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["name"] = name
        __props__.__dict__["read_replica_count"] = read_replica_count
        __props__.__dict__["state"] = state
        return OnlineStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.str]:
        """
        The capacity of the online store. Valid values are "CU_1", "CU_2", "CU_4", "CU_8"
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The timestamp when the online store was created
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The email of the creator of the online store
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the online store. This is the unique identifier for the online store
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of read replicas for the online store. Defaults to 0
        """
        return pulumi.get(self, "read_replica_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The current state of the online store. Possible values are: `AVAILABLE`, `DELETING`, `FAILING_OVER`, `STARTING`, `STOPPED`, `UPDATING`
        """
        return pulumi.get(self, "state")

