# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServicePrincipalSecretArgs', 'ServicePrincipalSecret']

@pulumi.input_type
class ServicePrincipalSecretArgs:
    def __init__(__self__, *,
                 service_principal_id: pulumi.Input[_builtins.str],
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_rotating: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServicePrincipalSecret resource.
        :param pulumi.Input[_builtins.str] service_principal_id: SCIM ID of the ServicePrincipal (not application ID).
        :param pulumi.Input[_builtins.str] create_time: UTC time when the secret was created.
        :param pulumi.Input[_builtins.str] expire_time: UTC time when the secret will expire. If the field is not present, the secret does not expire.
        :param pulumi.Input[_builtins.str] lifetime: The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        :param pulumi.Input[_builtins.str] secret: **Sensitive** Generated secret for the service principal.
        :param pulumi.Input[_builtins.str] secret_hash: Secret Hash.
        :param pulumi.Input[_builtins.str] status: Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        :param pulumi.Input[_builtins.str] time_rotating: Changing this argument forces recreation of the secret.
        :param pulumi.Input[_builtins.str] update_time: UTC time when the secret was updated.
        """
        pulumi.set(__self__, "service_principal_id", service_principal_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if secret_hash is not None:
            pulumi.set(__self__, "secret_hash", secret_hash)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_rotating is not None:
            pulumi.set(__self__, "time_rotating", time_rotating)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        SCIM ID of the ServicePrincipal (not application ID).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC time when the secret was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC time when the secret will expire. If the field is not present, the secret does not expire.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Sensitive** Generated secret for the service principal.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter(name="secretHash")
    def secret_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret Hash.
        """
        return pulumi.get(self, "secret_hash")

    @secret_hash.setter
    def secret_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_hash", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeRotating")
    def time_rotating(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Changing this argument forces recreation of the secret.
        """
        return pulumi.get(self, "time_rotating")

    @time_rotating.setter
    def time_rotating(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_rotating", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC time when the secret was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.input_type
class _ServicePrincipalSecretState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_rotating: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipalSecret resources.
        :param pulumi.Input[_builtins.str] create_time: UTC time when the secret was created.
        :param pulumi.Input[_builtins.str] expire_time: UTC time when the secret will expire. If the field is not present, the secret does not expire.
        :param pulumi.Input[_builtins.str] lifetime: The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        :param pulumi.Input[_builtins.str] secret: **Sensitive** Generated secret for the service principal.
        :param pulumi.Input[_builtins.str] secret_hash: Secret Hash.
        :param pulumi.Input[_builtins.str] service_principal_id: SCIM ID of the ServicePrincipal (not application ID).
        :param pulumi.Input[_builtins.str] status: Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        :param pulumi.Input[_builtins.str] time_rotating: Changing this argument forces recreation of the secret.
        :param pulumi.Input[_builtins.str] update_time: UTC time when the secret was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if secret_hash is not None:
            pulumi.set(__self__, "secret_hash", secret_hash)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_rotating is not None:
            pulumi.set(__self__, "time_rotating", time_rotating)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC time when the secret was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC time when the secret will expire. If the field is not present, the secret does not expire.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Sensitive** Generated secret for the service principal.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter(name="secretHash")
    def secret_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret Hash.
        """
        return pulumi.get(self, "secret_hash")

    @secret_hash.setter
    def secret_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_hash", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SCIM ID of the ServicePrincipal (not application ID).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeRotating")
    def time_rotating(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Changing this argument forces recreation of the secret.
        """
        return pulumi.get(self, "time_rotating")

    @time_rotating.setter
    def time_rotating(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_rotating", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC time when the secret was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("databricks:index/servicePrincipalSecret:ServicePrincipalSecret")
class ServicePrincipalSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_rotating: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With this resource you can create a secret for a given [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html).

        > This resource can only be used with an account-level or workspace-level provider!

        This secret can be used to configure the Databricks Pulumi Provider to authenticate with the service principal. See Authenticating with service principal.

        Additionally, the secret can be used to request OAuth tokens for the service principal, which can be used to authenticate to Databricks REST APIs. See [Authentication using OAuth tokens for service principals](https://docs.databricks.com/dev-tools/authentication-oauth.html).

        ## Example Usage

        Create service principal secret

        ```python
        import pulumi
        import pulumi_databricks as databricks

        terraform_sp = databricks.ServicePrincipalSecret("terraform_sp", service_principal_id=this["id"])
        ```

        A secret can be automatically rotated by taking a dependency on the `time_rotating` resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumiverse_time as time

        this = time.Rotating("this", rotation_days=30)
        terraform_sp = databricks.ServicePrincipalSecret("terraform_sp",
            service_principal_id=this_databricks_service_principal["id"],
            time_rotating=this.rfc3339.apply(lambda rfc3339: f"Pulumi (created: {rfc3339})"))
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * ServicePrincipal to manage [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html) in Databricks

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: UTC time when the secret was created.
        :param pulumi.Input[_builtins.str] expire_time: UTC time when the secret will expire. If the field is not present, the secret does not expire.
        :param pulumi.Input[_builtins.str] lifetime: The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        :param pulumi.Input[_builtins.str] secret: **Sensitive** Generated secret for the service principal.
        :param pulumi.Input[_builtins.str] secret_hash: Secret Hash.
        :param pulumi.Input[_builtins.str] service_principal_id: SCIM ID of the ServicePrincipal (not application ID).
        :param pulumi.Input[_builtins.str] status: Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        :param pulumi.Input[_builtins.str] time_rotating: Changing this argument forces recreation of the secret.
        :param pulumi.Input[_builtins.str] update_time: UTC time when the secret was updated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePrincipalSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource you can create a secret for a given [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html).

        > This resource can only be used with an account-level or workspace-level provider!

        This secret can be used to configure the Databricks Pulumi Provider to authenticate with the service principal. See Authenticating with service principal.

        Additionally, the secret can be used to request OAuth tokens for the service principal, which can be used to authenticate to Databricks REST APIs. See [Authentication using OAuth tokens for service principals](https://docs.databricks.com/dev-tools/authentication-oauth.html).

        ## Example Usage

        Create service principal secret

        ```python
        import pulumi
        import pulumi_databricks as databricks

        terraform_sp = databricks.ServicePrincipalSecret("terraform_sp", service_principal_id=this["id"])
        ```

        A secret can be automatically rotated by taking a dependency on the `time_rotating` resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumiverse_time as time

        this = time.Rotating("this", rotation_days=30)
        terraform_sp = databricks.ServicePrincipalSecret("terraform_sp",
            service_principal_id=this_databricks_service_principal["id"],
            time_rotating=this.rfc3339.apply(lambda rfc3339: f"Pulumi (created: {rfc3339})"))
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * ServicePrincipal to manage [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html) in Databricks

        :param str resource_name: The name of the resource.
        :param ServicePrincipalSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_rotating: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalSecretArgs.__new__(ServicePrincipalSecretArgs)

            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
            __props__.__dict__["secret_hash"] = secret_hash
            if service_principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_principal_id'")
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["status"] = status
            __props__.__dict__["time_rotating"] = time_rotating
            __props__.__dict__["update_time"] = update_time
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServicePrincipalSecret, __self__).__init__(
            'databricks:index/servicePrincipalSecret:ServicePrincipalSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            lifetime: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None,
            secret_hash: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            time_rotating: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServicePrincipalSecret':
        """
        Get an existing ServicePrincipalSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: UTC time when the secret was created.
        :param pulumi.Input[_builtins.str] expire_time: UTC time when the secret will expire. If the field is not present, the secret does not expire.
        :param pulumi.Input[_builtins.str] lifetime: The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        :param pulumi.Input[_builtins.str] secret: **Sensitive** Generated secret for the service principal.
        :param pulumi.Input[_builtins.str] secret_hash: Secret Hash.
        :param pulumi.Input[_builtins.str] service_principal_id: SCIM ID of the ServicePrincipal (not application ID).
        :param pulumi.Input[_builtins.str] status: Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        :param pulumi.Input[_builtins.str] time_rotating: Changing this argument forces recreation of the secret.
        :param pulumi.Input[_builtins.str] update_time: UTC time when the secret was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalSecretState.__new__(_ServicePrincipalSecretState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["secret"] = secret
        __props__.__dict__["secret_hash"] = secret_hash
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["status"] = status
        __props__.__dict__["time_rotating"] = time_rotating
        __props__.__dict__["update_time"] = update_time
        return ServicePrincipalSecret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        UTC time when the secret was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        UTC time when the secret will expire. If the field is not present, the secret does not expire.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[_builtins.str]:
        """
        The lifetime of the secret in seconds formatted as `NNNNs`. If this parameter is not provided, the secret will have a default lifetime of 730 days (`63072000s`).  Expiration of secret will lead to generation of new secret.
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        """
        **Sensitive** Generated secret for the service principal.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="secretHash")
    def secret_hash(self) -> pulumi.Output[_builtins.str]:
        """
        Secret Hash.
        """
        return pulumi.get(self, "secret_hash")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        SCIM ID of the ServicePrincipal (not application ID).
        """
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the secret (i.e., `ACTIVE` - see [REST API docs for full list](https://docs.databricks.com/api/account/serviceprincipalsecrets/list#secrets-status)).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeRotating")
    def time_rotating(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Changing this argument forces recreation of the secret.
        """
        return pulumi.get(self, "time_rotating")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        UTC time when the secret was updated.
        """
        return pulumi.get(self, "update_time")

