# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TokenArgs', 'Token']

@pulumi.input_type
class TokenArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lifetime_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Token resource.
        :param pulumi.Input[_builtins.str] comment: (String) Comment that will appear on the user’s settings page for this token.
        :param pulumi.Input[_builtins.int] lifetime_seconds: (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if lifetime_seconds is not None:
            pulumi.set(__self__, "lifetime_seconds", lifetime_seconds)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) Comment that will appear on the user’s settings page for this token.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="lifetimeSeconds")
    def lifetime_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        """
        return pulumi.get(self, "lifetime_seconds")

    @lifetime_seconds.setter
    def lifetime_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lifetime_seconds", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_id", value)


@pulumi.input_type
class _TokenState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lifetime_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 token_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Token resources.
        :param pulumi.Input[_builtins.str] comment: (String) Comment that will appear on the user’s settings page for this token.
        :param pulumi.Input[_builtins.int] lifetime_seconds: (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        :param pulumi.Input[_builtins.str] token_value: **Sensitive** value of the newly-created token.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if lifetime_seconds is not None:
            pulumi.set(__self__, "lifetime_seconds", lifetime_seconds)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)
        if token_value is not None:
            pulumi.set(__self__, "token_value", token_value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) Comment that will appear on the user’s settings page for this token.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiry_time", value)

    @_builtins.property
    @pulumi.getter(name="lifetimeSeconds")
    def lifetime_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        """
        return pulumi.get(self, "lifetime_seconds")

    @lifetime_seconds.setter
    def lifetime_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lifetime_seconds", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_id", value)

    @_builtins.property
    @pulumi.getter(name="tokenValue")
    def token_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **Sensitive** value of the newly-created token.
        """
        return pulumi.get(self, "token_value")

    @token_value.setter
    def token_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_value", value)


@pulumi.type_token("databricks:index/token:Token")
class Token(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lifetime_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource creates [Personal Access Tokens](https://docs.databricks.com/sql/user/security/personal-access-tokens.html) for the same user that is authenticated with the provider. Most likely you should use OboToken to create [On-Behalf-Of tokens](https://docs.databricks.com/administration-guide/users-groups/service-principals.html#manage-personal-access-tokens-for-a-service-principal) for a ServicePrincipal in Databricks workspaces on AWS. Databricks workspaces on other clouds use their own native OAuth token flows.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # create PAT token to provision entities within workspace
        pat = databricks.Token("pat",
            comment="Pulumi Provisioning",
            lifetime_seconds=8640000)
        pulumi.export("databricksToken", pat.token_value)
        ```

        A token can be automatically rotated by taking a dependency on the `time_rotating` resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumiverse_time as time

        this = time.Rotating("this", rotation_days=30)
        pat = databricks.Token("pat",
            comment=this.rfc3339.apply(lambda rfc3339: f"Pulumi (created: {rfc3339})"),
            lifetime_seconds=60 * 24 * 60 * 60)
        ```

        ## Import

        !> Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: (String) Comment that will appear on the user’s settings page for this token.
        :param pulumi.Input[_builtins.int] lifetime_seconds: (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource creates [Personal Access Tokens](https://docs.databricks.com/sql/user/security/personal-access-tokens.html) for the same user that is authenticated with the provider. Most likely you should use OboToken to create [On-Behalf-Of tokens](https://docs.databricks.com/administration-guide/users-groups/service-principals.html#manage-personal-access-tokens-for-a-service-principal) for a ServicePrincipal in Databricks workspaces on AWS. Databricks workspaces on other clouds use their own native OAuth token flows.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # create PAT token to provision entities within workspace
        pat = databricks.Token("pat",
            comment="Pulumi Provisioning",
            lifetime_seconds=8640000)
        pulumi.export("databricksToken", pat.token_value)
        ```

        A token can be automatically rotated by taking a dependency on the `time_rotating` resource:

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumiverse_time as time

        this = time.Rotating("this", rotation_days=30)
        pat = databricks.Token("pat",
            comment=this.rfc3339.apply(lambda rfc3339: f"Pulumi (created: {rfc3339})"),
            lifetime_seconds=60 * 24 * 60 * 60)
        ```

        ## Import

        !> Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param TokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 expiry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lifetime_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TokenArgs.__new__(TokenArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["expiry_time"] = expiry_time
            __props__.__dict__["lifetime_seconds"] = lifetime_seconds
            __props__.__dict__["token_id"] = token_id
            __props__.__dict__["token_value"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["tokenValue"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Token, __self__).__init__(
            'databricks:index/token:Token',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.int]] = None,
            expiry_time: Optional[pulumi.Input[_builtins.int]] = None,
            lifetime_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            token_id: Optional[pulumi.Input[_builtins.str]] = None,
            token_value: Optional[pulumi.Input[_builtins.str]] = None) -> 'Token':
        """
        Get an existing Token resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: (String) Comment that will appear on the user’s settings page for this token.
        :param pulumi.Input[_builtins.int] lifetime_seconds: (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        :param pulumi.Input[_builtins.str] token_value: **Sensitive** value of the newly-created token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TokenState.__new__(_TokenState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["expiry_time"] = expiry_time
        __props__.__dict__["lifetime_seconds"] = lifetime_seconds
        __props__.__dict__["token_id"] = token_id
        __props__.__dict__["token_value"] = token_value
        return Token(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (String) Comment that will appear on the user’s settings page for this token.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "expiry_time")

    @_builtins.property
    @pulumi.getter(name="lifetimeSeconds")
    def lifetime_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Integer) The lifetime of the token, in seconds. If no lifetime is specified, then expire time will be set to maximum allowed by the workspace configuration or platform.
        """
        return pulumi.get(self, "lifetime_seconds")

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "token_id")

    @_builtins.property
    @pulumi.getter(name="tokenValue")
    def token_value(self) -> pulumi.Output[_builtins.str]:
        """
        **Sensitive** value of the newly-created token.
        """
        return pulumi.get(self, "token_value")

