"""
Deployer Plugin

CERT/CC Deployer Decision Model
Generated from YAML configuration.

DO NOT EDIT THIS FILE DIRECTLY
This file is auto-generated. To make changes:
1. Edit the source YAML file: methodologies/deployer.yaml
2. Run: uv run python scripts/generate_plugins.py

@generated true
@source methodologies/deployer.yaml
@generator scripts/generate_plugins.py
@lastGenerated 2025-08-30T00:13:44.122917
"""

from enum import Enum
from datetime import datetime
import re


class ExploitationStatus(Enum):
    none = "none"
    public_poc = "public_poc"
    active = "active"


class SystemExposureLevel(Enum):
    small = "small"
    controlled = "controlled"
    open = "open"


class UtilityLevel(Enum):
    laborious = "laborious"
    efficient = "efficient"
    super_effective = "super_effective"


class HumanImpactLevel(Enum):
    low = "low"
    medium = "medium"
    high = "high"
    very_high = "very_high"


class ActionType(Enum):
    DEFER = "defer"
    SCHEDULED = "scheduled"
    OUT_OF_CYCLE = "out_of_cycle"
    IMMEDIATE = "immediate"


class DecisionPriorityLevel(Enum):
    LOW = "low"
    IMMEDIATE = "immediate"
    HIGH = "high"
    MEDIUM = "medium"


priority_map = {
    ActionType.DEFER: DecisionPriorityLevel.LOW,
    ActionType.SCHEDULED: DecisionPriorityLevel.MEDIUM,
    ActionType.OUT_OF_CYCLE: DecisionPriorityLevel.HIGH,
    ActionType.IMMEDIATE: DecisionPriorityLevel.IMMEDIATE,
}


class OutcomeDeployer:
    def __init__(self, action):
        self.priority = priority_map[action]
        self.action = action


class DecisionDeployer:
    def __init__(
        self,
        exploitation: ExploitationStatus | str = None,
        system_exposure: SystemExposureLevel | str = None,
        utility: UtilityLevel | str = None,
        human_impact: HumanImpactLevel | str = None,
    ):
        if isinstance(exploitation, str):
            exploitation = ExploitationStatus(exploitation.upper())
        if isinstance(system_exposure, str):
            system_exposure = SystemExposureLevel(system_exposure.upper())
        if isinstance(utility, str):
            utility = UtilityLevel(utility.upper())
        if isinstance(human_impact, str):
            human_impact = HumanImpactLevel(human_impact.upper())

        self.exploitation = exploitation
        self.system_exposure = system_exposure
        self.utility = utility
        self.human_impact = human_impact

        # Always try to evaluate if we have the minimum required parameters
        if all(
            [
                self.exploitation is not None,
                self.system_exposure is not None,
                self.utility is not None,
                self.human_impact is not None,
            ]
        ):
            self.outcome = self.evaluate()

    def evaluate(self) -> OutcomeDeployer:
        action = self._traverse_tree()
        self.outcome = OutcomeDeployer(action)
        return self.outcome

    def _traverse_tree(self):
        """Traverse the decision tree to determine the outcome."""
        if self.exploitation == ExploitationStatus.none:
            if self.system_exposure == SystemExposureLevel.small:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.scheduled
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.scheduled
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
            elif self.system_exposure == SystemExposureLevel.controlled:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.scheduled
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
            elif self.system_exposure == SystemExposureLevel.open:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
        elif self.exploitation == ExploitationStatus.public_poc:
            if self.system_exposure == SystemExposureLevel.small:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.defer
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
            elif self.system_exposure == SystemExposureLevel.controlled:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.out_of_cycle
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
            elif self.system_exposure == SystemExposureLevel.open:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
        elif self.exploitation == ExploitationStatus.active:
            if self.system_exposure == SystemExposureLevel.small:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
            elif self.system_exposure == SystemExposureLevel.controlled:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.scheduled
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
            elif self.system_exposure == SystemExposureLevel.open:
                if self.utility == UtilityLevel.laborious:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.efficient:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.out_of_cycle
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate
                elif self.utility == UtilityLevel.super_effective:
                    if self.human_impact == HumanImpactLevel.low:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.medium:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.high:
                        return ActionType.immediate
                    elif self.human_impact == HumanImpactLevel.very_high:
                        return ActionType.immediate

        # Default action for unmapped paths
        return ActionType.defer

    def to_vector(self) -> str:
        """Generate SSVC vector string representation."""
        if not hasattr(self, "outcome") or not self.outcome:
            self.evaluate()

        exploitation_vector = {"NONE": "N", "PUBLIC_POC": "P", "ACTIVE": "A"}.get(
            str(self.exploitation).split(".")[-1] if self.exploitation else "", ""
        )
        system_exposure_vector = {"SMALL": "S", "CONTROLLED": "C", "OPEN": "O"}.get(
            str(self.system_exposure).split(".")[-1] if self.system_exposure else "", ""
        )
        utility_vector = {
            "LABORIOUS": "L",
            "EFFICIENT": "E",
            "SUPER_EFFECTIVE": "S",
        }.get(str(self.utility).split(".")[-1] if self.utility else "", "")
        human_impact_vector = {
            "LOW": "L",
            "MEDIUM": "M",
            "HIGH": "H",
            "VERY_HIGH": "V",
        }.get(str(self.human_impact).split(".")[-1] if self.human_impact else "", "")
        timestamp = datetime.now().isoformat()
        return f"DEPLOYERv1/E:{exploitation_vector}/SE:{system_exposure_vector}/U:{utility_vector}/HI:{human_impact_vector}/{timestamp}/"

    @classmethod
    def from_vector(cls, vector_string: str) -> "DecisionDeployer":
        """Parse SSVC vector string to create decision instance."""
        pattern = r"^DEPLOYERv1/(.+)/([0-9T:\-\.Z]+)/?$"
        match = re.match(pattern, vector_string)

        if not match:
            raise ValueError(
                f"Invalid vector string format for Deployer: {vector_string}"
            )

        params_string = match.group(1)
        params = {}

        param_pairs = params_string.split("/")
        for pair in param_pairs:
            if ":" in pair:
                key, value = pair.split(":", 1)
                params[key] = value

        exploitation_match = params.get("E")
        system_exposure_match = params.get("SE")
        utility_match = params.get("U")
        human_impact_match = params.get("HI")

        return cls(
            exploitation={"N": "none", "P": "public_poc", "A": "active"}.get(
                exploitation_match, exploitation_match
            )
            if exploitation_match
            else None,
            system_exposure={"S": "small", "C": "controlled", "O": "open"}.get(
                system_exposure_match, system_exposure_match
            )
            if system_exposure_match
            else None,
            utility={"L": "laborious", "E": "efficient", "S": "super_effective"}.get(
                utility_match, utility_match
            )
            if utility_match
            else None,
            human_impact={"L": "low", "M": "medium", "H": "high", "V": "very_high"}.get(
                human_impact_match, human_impact_match
            )
            if human_impact_match
            else None,
        )
