# MD006 - Consider starting lists at the beginning of the line

## What this rule does

Ensures top-level list items start at the beginning of the line (no indentation).

## Why this matters

- **Clarity**: Indented top-level lists can be confused with nested lists
- **Consistency**: All documents should start lists the same way
- **Readability**: Clear distinction between top-level and nested items
- **Standards**: Most Markdown style guides require lists to start at column 0

## Examples

### ✅ Correct

```markdown
* Item 1
* Item 2
  * Nested item
  * Another nested item
* Item 3

- First item
- Second item
  - Nested under second
- Third item
```

### ❌ Incorrect

```markdown
  * Item 1      (indented 2 spaces)
  * Item 2      (indented 2 spaces)
    * Nested item
  * Item 3      (indented 2 spaces)
```

### 🔧 Fixed

```markdown
* Item 1
* Item 2
  * Nested item
* Item 3
```

## Configuration

This rule has no configuration options. Top-level lists must start at the beginning of the line.

## Automatic fixes

This rule automatically removes indentation from top-level list items.

## Special notes

- Only applies to unordered lists (*, -, +)
- Ordered lists (1., 2., etc.) are not affected
- Each list in a document is evaluated separately

## Learn more

- [CommonMark lists](https://spec.commonmark.org/0.31.2/#lists) - Technical specification
- [Markdown Guide - Lists](https://www.markdownguide.org/basic-syntax/#lists) - List best practices

## Related rules

- [MD004](md004.md) - Unordered list style should be consistent
- [MD005](md005.md) - List indentation should be consistent
- [MD007](md007.md) - Unordered list indentation
