# MD024 - Avoid duplicate heading text

## What this rule does

Checks that headings don't have identical text, preventing confusion and navigation issues.

## Why this matters

- **Better navigation**: Unique headings make it easier to find specific sections
- **Clear table of contents**: Automated TOCs need unique headings to create proper links
- **Improved accessibility**: Screen readers rely on unique headings for navigation
- **Avoid confusion**: Readers won't wonder which "Introduction" section they're in

## Examples

<!-- rumdl-disable MD024 -->

### ✅ Correct

```markdown
# Project Setup

## Installing Dependencies

Details about npm install...

## Configuring the Environment

Details about environment setup...

## Running Tests

How to run the test suite...
```

### ❌ Incorrect

```markdown
# Project Setup

## Setup

Details about npm install...

## Setup

Details about environment setup...

## Setup

How to run the test suite...
```

### 🔧 Fixed

```markdown
# Project Setup

## Installing Dependencies

Details about npm install...

## Environment Configuration

Details about environment setup...

## Test Setup

How to run the test suite...
```

<!-- rumdl-enable MD024 -->

## Configuration

```yaml
MD024:
  allow_different_nesting: false  # Allow duplicates at different levels (default: false)
  siblings_only: false           # Only check siblings at same level (default: false)
```

## Automatic fixes

This rule cannot be automatically fixed because changing heading text requires understanding the content's meaning. You'll need to manually update duplicate headings to be more descriptive.

## Learn more

- [Writing better headings](https://www.nngroup.com/articles/headings-pickup-lines/)
- [Accessible heading structure](https://www.w3.org/WAI/tutorials/page-structure/headings/)

## Related rules

- [MD001](md001.md): Use consistent heading levels
- [MD025](md025.md): Use only one top-level heading
- [MD026](md026.md): Remove trailing punctuation in headings
- [MD043](md043.md): Require specific heading structure
