# MD031 - Code blocks need blank lines around them

## What this rule does

Ensures code blocks (```) have blank lines before and after them for proper spacing.

## Why this matters

- **Readability**: Blank lines visually separate code from surrounding text
- **Rendering**: Some Markdown processors require blank lines for proper code block display
- **Consistency**: Uniform spacing makes documents look professional

## Examples

### ✅ Correct

````markdown
Here's some text explaining the code.

```python
def hello():
    print("Hello, world!")
```

And here's more text after the code.
````

### ❌ Incorrect

<!-- rumdl-disable MD031 MD040 MD022 -->

````markdown
Here's some text explaining the code.
```python
def hello():
    print("Hello, world!")
```
And here's more text after the code.
````

<!-- rumdl-enable MD031 MD040 MD022 -->

### 🔧 Fixed

````markdown
Here's some text explaining the code.

```python
def hello():
    print("Hello, world!")
```

And here's more text after the code.
````

## Configuration

```yaml
MD031:
  list_items: true  # Also require blank lines in lists (default: true)
```

### Example with list_items

When `list_items` is true (default):

```markdown
1. First item

   ```python
   code_in_list()
   ```

2. Second item

```

When `list_items` is false:

```markdown
1. First item
   ```python
   code_in_list()
   ```

2. Second item

```

## Automatic fixes

This rule automatically adds blank lines:
- Before code blocks that don't have one
- After code blocks that don't have one

## Learn more

- [CommonMark code blocks](https://spec.commonmark.org/0.31.2/#fenced-code-blocks) - Technical specification
- [Markdown Guide - Code](https://www.markdownguide.org/extended-syntax/#fenced-code-blocks) - Code block best practices

## Related rules

- [MD032](md032.md) - Lists should be surrounded by blank lines
- [MD040](md040.md) - Code blocks should have a language specified
- [MD046](md046.md) - Code block style should be consistent
