# MD032 - Separate lists with blank lines

## What this rule does

Ensures lists have blank lines before and after them, making them visually distinct from surrounding content.

## Why this matters

- **Reliable parsing**: Many Markdown parsers require blank lines to properly recognize lists
- **Visual clarity**: Blank lines make lists stand out from paragraphs
- **Better readability**: Clear separation helps readers scan documents quickly
- **Consistent rendering**: Prevents lists from merging with adjacent content

## Examples

### ✅ Correct

```markdown
Text before the list.

* Item 1
* Item 2
* Item 3

Text after the list.
```

### ❌ Incorrect

<!-- rumdl-disable MD032 -->

```markdown
Text before the list.
* Item 1
* Item 2
* Item 3
Text after the list.
```

<!-- rumdl-enable MD032 -->

### 🔧 Fixed

```markdown
Text before the list.

* Item 1
* Item 2
* Item 3

Text after the list.
```

## Configuration

This rule has no configuration options. Lists should always be surrounded by blank lines.

## Automatic fixes

This rule will:
- Add a blank line before lists that follow other content
- Add a blank line after lists that precede other content
- Handle nested lists correctly (only the outermost list needs surrounding blank lines)

## Learn more

- [CommonMark Spec: Lists](https://spec.commonmark.org/0.31.2/#lists)
- [CommonMark Spec: Blank lines](https://spec.commonmark.org/0.31.2/#blank-lines)

## Related rules

- [MD022 - Separate headings with blank lines](md022.md)
- [MD031 - Separate code blocks with blank lines](md031.md)
- [MD004 - Use consistent list markers](md004.md)
- [MD058 - Separate tables with blank lines](md058.md)
