# MD036 - Use real headings, not just bold text

> **Note:** This rule does not provide automatic fixes because it cannot reliably determine user intent. Bold text on its own line has many legitimate uses (image captions, labels, warnings, etc.).

## What this rule does

Detects when bold or italic text is used as a standalone heading.

## Why this matters

- **Better document structure**: Real headings create a proper outline that tools can understand
- **Improved accessibility**: Screen readers rely on heading tags to navigate documents
- **Enables navigation**: Proper headings allow table of contents generation and quick jumping
- **Cleaner formatting**: Headings have consistent styling across different viewers

## Examples

<!-- rumdl-disable MD036 -->

### ✅ Correct

Using proper heading syntax:

```markdown
# Main Title

## Section Heading

This paragraph contains **bold text** and *italic text* inline.

**Table of Contents**  <!-- Allowed exception -->
```

### ❌ Incorrect

Using emphasis as headings:

```markdown
**This looks like a heading**

*Another section title*

***Important Section***

**Configuration:**
```

### 🔧 Manual Fix Required

These should be manually converted to proper headings:

```markdown
## This looks like a heading

# Another section title

### Important Section

## Configuration
```

**Note:** rumdl will detect these issues but won't automatically fix them. You need to manually decide if the emphasized text should be a heading.

<!-- rumdl-enable MD036 -->

## Configuration

```toml
# .rumdl.toml
[MD036]
punctuation = ".,;:!?"  # Configure punctuation checking
```

### Options

- `punctuation`: String of punctuation marks that, when found at the end of emphasized text, prevent it from being flagged (default: `".,;:!?"`)
  - Set to `""` to flag all emphasized lines regardless of punctuation
  - Customize to remove only specific marks

## Automatic fixes

This rule does **not** provide automatic fixes. Converting bold or italic text to headings is too risky as it can corrupt documents.
For example, bold text is often used for image captions, labels, or other legitimate emphasis that should not be converted to headings.

Users should manually review each warning and decide whether the emphasized text should be converted to a heading.

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Web Content Accessibility Guidelines (WCAG) on headings](https://www.w3.org/WAI/WCAG21/Understanding/info-and-relationships.html)

## Related rules

- [MD001 - Heading increment](md001.md) - Ensure heading levels increase properly
- [MD003 - Heading style](md003.md) - Keep heading formats consistent
- [MD018 - No missing space in ATX heading](md018.md) - Ensure proper heading spacing
