# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAggregateV2Result',
    'AwaitableGetAggregateV2Result',
    'get_aggregate_v2',
    'get_aggregate_v2_output',
]

@pulumi.output_type
class GetAggregateV2Result:
    """
    A collection of values returned by getAggregateV2.
    """
    def __init__(__self__, hosts=None, id=None, metadata=None, name=None, region=None, zone=None):
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence[_builtins.str]:
        """
        List of Hypervisors contained in the Host Aggregate
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Metadata of the Host Aggregate
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        Availability zone of the Host Aggregate
        """
        return pulumi.get(self, "zone")


class AwaitableGetAggregateV2Result(GetAggregateV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAggregateV2Result(
            hosts=self.hosts,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            region=self.region,
            zone=self.zone)


def get_aggregate_v2(hosts: Optional[Sequence[_builtins.str]] = None,
                     metadata: Optional[Mapping[str, _builtins.str]] = None,
                     name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAggregateV2Result:
    """
    Use this data source to get information about host aggregates
    by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    test = openstack.compute.get_aggregate_v2(name="test")
    ```


    :param Sequence[_builtins.str] hosts: List of Hypervisors contained in the Host Aggregate
    :param Mapping[str, _builtins.str] metadata: Metadata of the Host Aggregate
    :param _builtins.str name: The name of the host aggregate.
    :param _builtins.str region: The region in which to obtain the V2 Compute client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['hosts'] = hosts
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:compute/getAggregateV2:getAggregateV2', __args__, opts=opts, typ=GetAggregateV2Result).value

    return AwaitableGetAggregateV2Result(
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        zone=pulumi.get(__ret__, 'zone'))
def get_aggregate_v2_output(hosts: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            metadata: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAggregateV2Result]:
    """
    Use this data source to get information about host aggregates
    by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    test = openstack.compute.get_aggregate_v2(name="test")
    ```


    :param Sequence[_builtins.str] hosts: List of Hypervisors contained in the Host Aggregate
    :param Mapping[str, _builtins.str] metadata: Metadata of the Host Aggregate
    :param _builtins.str name: The name of the host aggregate.
    :param _builtins.str region: The region in which to obtain the V2 Compute client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['hosts'] = hosts
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:compute/getAggregateV2:getAggregateV2', __args__, opts=opts, typ=GetAggregateV2Result)
    return __ret__.apply(lambda __response__: GetAggregateV2Result(
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        zone=pulumi.get(__response__, 'zone')))
