# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlavorV2Args', 'FlavorV2']

@pulumi.input_type
class FlavorV2Args:
    def __init__(__self__, *,
                 flavor_profile_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlavorV2 resource.
        :param pulumi.Input[_builtins.str] flavor_profile_id: The flavor_profile_id that the flavor
               will use. Changing this creates a new flavor.
        :param pulumi.Input[_builtins.str] description: The description of the flavor. Changing this
               updates the existing flavor.
        :param pulumi.Input[_builtins.bool] enabled: Whether the flavor is enabled or not. Defaults to `true`.
               Changing this updates the existing flavor.
        :param pulumi.Input[_builtins.str] name: Name of the flavor. Changing this updates the existing
               flavor.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB flavor.
        """
        pulumi.set(__self__, "flavor_profile_id", flavor_profile_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="flavorProfileId")
    def flavor_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The flavor_profile_id that the flavor
        will use. Changing this creates a new flavor.
        """
        return pulumi.get(self, "flavor_profile_id")

    @flavor_profile_id.setter
    def flavor_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the flavor. Changing this
        updates the existing flavor.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the flavor is enabled or not. Defaults to `true`.
        Changing this updates the existing flavor.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the flavor. Changing this updates the existing
        flavor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an LB member. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        LB flavor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FlavorV2State:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 flavor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlavorV2 resources.
        :param pulumi.Input[_builtins.str] description: The description of the flavor. Changing this
               updates the existing flavor.
        :param pulumi.Input[_builtins.bool] enabled: Whether the flavor is enabled or not. Defaults to `true`.
               Changing this updates the existing flavor.
        :param pulumi.Input[_builtins.str] flavor_profile_id: The flavor_profile_id that the flavor
               will use. Changing this creates a new flavor.
        :param pulumi.Input[_builtins.str] name: Name of the flavor. Changing this updates the existing
               flavor.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB flavor.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if flavor_profile_id is not None:
            pulumi.set(__self__, "flavor_profile_id", flavor_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the flavor. Changing this
        updates the existing flavor.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the flavor is enabled or not. Defaults to `true`.
        Changing this updates the existing flavor.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="flavorProfileId")
    def flavor_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor_profile_id that the flavor
        will use. Changing this creates a new flavor.
        """
        return pulumi.get(self, "flavor_profile_id")

    @flavor_profile_id.setter
    def flavor_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the flavor. Changing this updates the existing
        flavor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an LB member. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        LB flavor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("openstack:loadbalancer/flavorV2:FlavorV2")
class FlavorV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 flavor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 load balancer flavor resource within OpenStack.

        > **Note:** This usually requires admin privileges.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_openstack as openstack

        fp1 = openstack.loadbalancer.FlavorprofileV2("fp_1",
            name="test",
            provider_name="amphora",
            flavor_data=json.dumps({
                "loadbalancer_topology": "ACTIVE_STANDBY",
            }))
        flavor1 = openstack.loadbalancer.FlavorV2("flavor_1",
            name="test",
            description="This is a test flavor",
            flavor_profile_id=fp1.id)
        ```

        ## Import

        flavors can be imported using their `id`. Example:

        ```sh
        $ pulumi import openstack:loadbalancer/flavorV2:FlavorV2 flavor_1 2a0f2240-c5e6-41de-896d-e80d97428d6b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the flavor. Changing this
               updates the existing flavor.
        :param pulumi.Input[_builtins.bool] enabled: Whether the flavor is enabled or not. Defaults to `true`.
               Changing this updates the existing flavor.
        :param pulumi.Input[_builtins.str] flavor_profile_id: The flavor_profile_id that the flavor
               will use. Changing this creates a new flavor.
        :param pulumi.Input[_builtins.str] name: Name of the flavor. Changing this updates the existing
               flavor.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB flavor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlavorV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 load balancer flavor resource within OpenStack.

        > **Note:** This usually requires admin privileges.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_openstack as openstack

        fp1 = openstack.loadbalancer.FlavorprofileV2("fp_1",
            name="test",
            provider_name="amphora",
            flavor_data=json.dumps({
                "loadbalancer_topology": "ACTIVE_STANDBY",
            }))
        flavor1 = openstack.loadbalancer.FlavorV2("flavor_1",
            name="test",
            description="This is a test flavor",
            flavor_profile_id=fp1.id)
        ```

        ## Import

        flavors can be imported using their `id`. Example:

        ```sh
        $ pulumi import openstack:loadbalancer/flavorV2:FlavorV2 flavor_1 2a0f2240-c5e6-41de-896d-e80d97428d6b
        ```

        :param str resource_name: The name of the resource.
        :param FlavorV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlavorV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 flavor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlavorV2Args.__new__(FlavorV2Args)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if flavor_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_profile_id'")
            __props__.__dict__["flavor_profile_id"] = flavor_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(FlavorV2, __self__).__init__(
            'openstack:loadbalancer/flavorV2:FlavorV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            flavor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlavorV2':
        """
        Get an existing FlavorV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the flavor. Changing this
               updates the existing flavor.
        :param pulumi.Input[_builtins.bool] enabled: Whether the flavor is enabled or not. Defaults to `true`.
               Changing this updates the existing flavor.
        :param pulumi.Input[_builtins.str] flavor_profile_id: The flavor_profile_id that the flavor
               will use. Changing this creates a new flavor.
        :param pulumi.Input[_builtins.str] name: Name of the flavor. Changing this updates the existing
               flavor.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB flavor.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlavorV2State.__new__(_FlavorV2State)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["flavor_profile_id"] = flavor_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return FlavorV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the flavor. Changing this
        updates the existing flavor.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the flavor is enabled or not. Defaults to `true`.
        Changing this updates the existing flavor.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="flavorProfileId")
    def flavor_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The flavor_profile_id that the flavor
        will use. Changing this creates a new flavor.
        """
        return pulumi.get(self, "flavor_profile_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the flavor. Changing this updates the existing
        flavor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an LB member. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        LB flavor.
        """
        return pulumi.get(self, "region")

