# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLbFlavorDeprecatedResult',
    'AwaitableGetLbFlavorDeprecatedResult',
    'get_lb_flavor_deprecated',
    'get_lb_flavor_deprecated_output',
]

@pulumi.output_type
class GetLbFlavorDeprecatedResult:
    """
    A collection of values returned by getLbFlavorDeprecated.
    """
    def __init__(__self__, description=None, enabled=None, flavor_id=None, flavor_profile_id=None, id=None, name=None, region=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_profile_id and not isinstance(flavor_profile_id, str):
            raise TypeError("Expected argument 'flavor_profile_id' to be a str")
        pulumi.set(__self__, "flavor_profile_id", flavor_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the flavor.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the flavor enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The ID of the flavor.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorProfileId")
    def flavor_profile_id(self) -> _builtins.str:
        """
        The ID of the flavor profile.
        """
        return pulumi.get(self, "flavor_profile_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the flavor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetLbFlavorDeprecatedResult(GetLbFlavorDeprecatedResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbFlavorDeprecatedResult(
            description=self.description,
            enabled=self.enabled,
            flavor_id=self.flavor_id,
            flavor_profile_id=self.flavor_profile_id,
            id=self.id,
            name=self.name,
            region=self.region)


def get_lb_flavor_deprecated(flavor_id: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             region: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbFlavorDeprecatedResult:
    """
    Use this data source to get the ID of an OpenStack Load Balancer flavor.

    > **Note:** This data source is deprecated, please use `loadbalancer.FlavorV2` instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    flavor1 = openstack.loadbalancer.get_lb_flavor_deprecated(name="flavor_1")
    ```


    :param _builtins.str flavor_id: The ID of the flavor. Exactly one of `name`, `flavor_id` is required to be set.
    :param _builtins.str name: The name of the flavor. Exactly one of `name`, `flavor_id` is required to be set.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['flavorId'] = flavor_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:loadbalancer/getLbFlavorDeprecated:getLbFlavorDeprecated', __args__, opts=opts, typ=GetLbFlavorDeprecatedResult).value

    return AwaitableGetLbFlavorDeprecatedResult(
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        flavor_profile_id=pulumi.get(__ret__, 'flavor_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_lb_flavor_deprecated_output(flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLbFlavorDeprecatedResult]:
    """
    Use this data source to get the ID of an OpenStack Load Balancer flavor.

    > **Note:** This data source is deprecated, please use `loadbalancer.FlavorV2` instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    flavor1 = openstack.loadbalancer.get_lb_flavor_deprecated(name="flavor_1")
    ```


    :param _builtins.str flavor_id: The ID of the flavor. Exactly one of `name`, `flavor_id` is required to be set.
    :param _builtins.str name: The name of the flavor. Exactly one of `name`, `flavor_id` is required to be set.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['flavorId'] = flavor_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:loadbalancer/getLbFlavorDeprecated:getLbFlavorDeprecated', __args__, opts=opts, typ=GetLbFlavorDeprecatedResult)
    return __ret__.apply(lambda __response__: GetLbFlavorDeprecatedResult(
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        flavor_profile_id=pulumi.get(__response__, 'flavor_profile_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
