# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 protocol_port: pulumi.Input[_builtins.int],
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_client_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_connect: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_tcp_inspect: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this
               Listener. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] protocol: The protocol can be either `TCP`, `HTTP`, `HTTPS`,
               `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
               \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
               2.25**). Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic.
               * Changing this creates a new Listener.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the Listener. A
               valid value is true (UP) or false (DOWN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_cidrs: A list of CIDR blocks that are permitted to
               connect to this listener, denying all other source addresses. If not present,
               defaults to allow all.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alpn_protocols: A list of ALPN protocols. Available protocols:
               `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
               2.20**.
        :param pulumi.Input[_builtins.str] client_authentication: The TLS client authentication mode.
               Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
               `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
               Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.str] client_ca_tls_container_ref: The ref of the key manager service
               secret containing a PEM format client CA certificate bundle for
               `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
               `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
               2.8**.
        :param pulumi.Input[_builtins.str] client_crl_container_ref: The URI of the key manager service
               secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
               listeners. Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for
               the Listener.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the
               Listener is associated.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: A reference to a Barbican Secrets
               container which stores TLS information. This is required if the protocol is
               `TERMINATED_HTTPS`. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the Listener.
        :param pulumi.Input[_builtins.bool] hsts_include_subdomains: Defines whether the
               **includeSubDomains** directive should be added to the
               Strict-Transport-Security HTTP response header. This requires setting the
               `hsts_max_age` option as well in order to become effective. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.int] hsts_max_age: The value of the **max_age** directive for the
               Strict-Transport-Security HTTP response header. Setting this enables HTTP
               Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.bool] hsts_preload: Defines whether the **preload** directive should
               be added to the Strict-Transport-Security HTTP response header. This requires
               setting the `hsts_max_age` option as well in order to become effective.
               Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
               minor version >= 2.27**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] insert_headers: The list of key value pairs representing
               headers to insert into the request before it is sent to the backend members.
               Changing this updates the headers of the existing listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Listener. Does not have to be
               unique.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a listener. If omitted, the `region`
               argument of the provider is used. Changing this creates a new Listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: A list of references to Barbican Secrets
               containers which store SNI information. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of simple strings assigned to the pool. Available
               for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Listener.  Only administrative users can specify a tenant UUID other than
               their own. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] timeout_client_data: The client inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_connect: The member connection timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_data: The member inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_tcp_inspect: The time in milliseconds, to wait for
               additional TCP packets for content inspection.
        :param pulumi.Input[_builtins.str] tls_ciphers: List of ciphers in OpenSSL format
               (colon-separated). See
               https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
               Supported only in **Octavia minor version >= 2.15**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: A list of TLS protocol versions. Available
               versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
               **Octavia minor version >= 2.17**.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if allowed_cidrs is not None:
            pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        if alpn_protocols is not None:
            pulumi.set(__self__, "alpn_protocols", alpn_protocols)
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)
        if client_ca_tls_container_ref is not None:
            pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        if client_crl_container_ref is not None:
            pulumi.set(__self__, "client_crl_container_ref", client_crl_container_ref)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref is not None:
            pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hsts_include_subdomains is not None:
            pulumi.set(__self__, "hsts_include_subdomains", hsts_include_subdomains)
        if hsts_max_age is not None:
            pulumi.set(__self__, "hsts_max_age", hsts_max_age)
        if hsts_preload is not None:
            pulumi.set(__self__, "hsts_preload", hsts_preload)
        if insert_headers is not None:
            pulumi.set(__self__, "insert_headers", insert_headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sni_container_refs is not None:
            pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout_client_data is not None:
            pulumi.set(__self__, "timeout_client_data", timeout_client_data)
        if timeout_member_connect is not None:
            pulumi.set(__self__, "timeout_member_connect", timeout_member_connect)
        if timeout_member_data is not None:
            pulumi.set(__self__, "timeout_member_data", timeout_member_data)
        if timeout_tcp_inspect is not None:
            pulumi.set(__self__, "timeout_tcp_inspect", timeout_tcp_inspect)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_versions is not None:
            pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The load balancer on which to provision this
        Listener. Changing this creates a new Listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol can be either `TCP`, `HTTP`, `HTTPS`,
        `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
        \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
        2.25**). Changing this creates a new Listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Input[_builtins.int]:
        """
        The port on which to listen for client traffic.
        * Changing this creates a new Listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the Listener. A
        valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of CIDR blocks that are permitted to
        connect to this listener, denying all other source addresses. If not present,
        defaults to allow all.
        """
        return pulumi.get(self, "allowed_cidrs")

    @allowed_cidrs.setter
    def allowed_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="alpnProtocols")
    def alpn_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of ALPN protocols. Available protocols:
        `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
        2.20**.
        """
        return pulumi.get(self, "alpn_protocols")

    @alpn_protocols.setter
    def alpn_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alpn_protocols", value)

    @_builtins.property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS client authentication mode.
        Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
        `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
        Supported only in **Octavia minor version >= 2.8**.
        """
        return pulumi.get(self, "client_authentication")

    @client_authentication.setter
    def client_authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_authentication", value)

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ref of the key manager service
        secret containing a PEM format client CA certificate bundle for
        `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
        `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
        2.8**.
        """
        return pulumi.get(self, "client_ca_tls_container_ref")

    @client_ca_tls_container_ref.setter
    def client_ca_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter(name="clientCrlContainerRef")
    def client_crl_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the key manager service
        secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
        listeners. Supported only in **Octavia minor version >= 2.8**.
        """
        return pulumi.get(self, "client_crl_container_ref")

    @client_crl_container_ref.setter
    def client_crl_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_crl_container_ref", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections allowed for
        the Listener.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default pool with which the
        Listener is associated.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to a Barbican Secrets
        container which stores TLS information. This is required if the protocol is
        `TERMINATED_HTTPS`. See
        [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
        for more information.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @default_tls_container_ref.setter
    def default_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the Listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the
        **includeSubDomains** directive should be added to the
        Strict-Transport-Security HTTP response header. This requires setting the
        `hsts_max_age` option as well in order to become effective. Requires
        `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
        version >= 2.27**.
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @hsts_include_subdomains.setter
    def hsts_include_subdomains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hsts_include_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of the **max_age** directive for the
        Strict-Transport-Security HTTP response header. Setting this enables HTTP
        Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
        `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
        version >= 2.27**.
        """
        return pulumi.get(self, "hsts_max_age")

    @hsts_max_age.setter
    def hsts_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hsts_max_age", value)

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the **preload** directive should
        be added to the Strict-Transport-Security HTTP response header. This requires
        setting the `hsts_max_age` option as well in order to become effective.
        Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
        minor version >= 2.27**.
        """
        return pulumi.get(self, "hsts_preload")

    @hsts_preload.setter
    def hsts_preload(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hsts_preload", value)

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of key value pairs representing
        headers to insert into the request before it is sent to the backend members.
        Changing this updates the headers of the existing listener.
        """
        return pulumi.get(self, "insert_headers")

    @insert_headers.setter
    def insert_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "insert_headers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the Listener. Does not have to be
        unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a listener. If omitted, the `region`
        argument of the provider is used. Changing this creates a new Listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of references to Barbican Secrets
        containers which store SNI information. See
        [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
        for more information.
        """
        return pulumi.get(self, "sni_container_refs")

    @sni_container_refs.setter
    def sni_container_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sni_container_refs", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of simple strings assigned to the pool. Available
        for Octavia **minor version 2.5 or later**.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for admins. The UUID of the tenant who owns
        the Listener.  Only administrative users can specify a tenant UUID other than
        their own. Changing this creates a new Listener.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeoutClientData")
    def timeout_client_data(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client inactivity timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_client_data")

    @timeout_client_data.setter
    def timeout_client_data(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_client_data", value)

    @_builtins.property
    @pulumi.getter(name="timeoutMemberConnect")
    def timeout_member_connect(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The member connection timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_member_connect")

    @timeout_member_connect.setter
    def timeout_member_connect(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_member_connect", value)

    @_builtins.property
    @pulumi.getter(name="timeoutMemberData")
    def timeout_member_data(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The member inactivity timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_member_data")

    @timeout_member_data.setter
    def timeout_member_data(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_member_data", value)

    @_builtins.property
    @pulumi.getter(name="timeoutTcpInspect")
    def timeout_tcp_inspect(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in milliseconds, to wait for
        additional TCP packets for content inspection.
        """
        return pulumi.get(self, "timeout_tcp_inspect")

    @timeout_tcp_inspect.setter
    def timeout_tcp_inspect(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_tcp_inspect", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of ciphers in OpenSSL format
        (colon-separated). See
        https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
        Supported only in **Octavia minor version >= 2.15**.
        """
        return pulumi.get(self, "tls_ciphers")

    @tls_ciphers.setter
    def tls_ciphers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of TLS protocol versions. Available
        versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
        **Octavia minor version >= 2.17**.
        """
        return pulumi.get(self, "tls_versions")

    @tls_versions.setter
    def tls_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_versions", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_client_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_connect: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_tcp_inspect: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the Listener. A
               valid value is true (UP) or false (DOWN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_cidrs: A list of CIDR blocks that are permitted to
               connect to this listener, denying all other source addresses. If not present,
               defaults to allow all.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alpn_protocols: A list of ALPN protocols. Available protocols:
               `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
               2.20**.
        :param pulumi.Input[_builtins.str] client_authentication: The TLS client authentication mode.
               Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
               `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
               Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.str] client_ca_tls_container_ref: The ref of the key manager service
               secret containing a PEM format client CA certificate bundle for
               `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
               `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
               2.8**.
        :param pulumi.Input[_builtins.str] client_crl_container_ref: The URI of the key manager service
               secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
               listeners. Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for
               the Listener.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the
               Listener is associated.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: A reference to a Barbican Secrets
               container which stores TLS information. This is required if the protocol is
               `TERMINATED_HTTPS`. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the Listener.
        :param pulumi.Input[_builtins.bool] hsts_include_subdomains: Defines whether the
               **includeSubDomains** directive should be added to the
               Strict-Transport-Security HTTP response header. This requires setting the
               `hsts_max_age` option as well in order to become effective. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.int] hsts_max_age: The value of the **max_age** directive for the
               Strict-Transport-Security HTTP response header. Setting this enables HTTP
               Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.bool] hsts_preload: Defines whether the **preload** directive should
               be added to the Strict-Transport-Security HTTP response header. This requires
               setting the `hsts_max_age` option as well in order to become effective.
               Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
               minor version >= 2.27**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] insert_headers: The list of key value pairs representing
               headers to insert into the request before it is sent to the backend members.
               Changing this updates the headers of the existing listener.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this
               Listener. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Listener. Does not have to be
               unique.
        :param pulumi.Input[_builtins.str] protocol: The protocol can be either `TCP`, `HTTP`, `HTTPS`,
               `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
               \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
               2.25**). Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic.
               * Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a listener. If omitted, the `region`
               argument of the provider is used. Changing this creates a new Listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: A list of references to Barbican Secrets
               containers which store SNI information. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of simple strings assigned to the pool. Available
               for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Listener.  Only administrative users can specify a tenant UUID other than
               their own. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] timeout_client_data: The client inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_connect: The member connection timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_data: The member inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_tcp_inspect: The time in milliseconds, to wait for
               additional TCP packets for content inspection.
        :param pulumi.Input[_builtins.str] tls_ciphers: List of ciphers in OpenSSL format
               (colon-separated). See
               https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
               Supported only in **Octavia minor version >= 2.15**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: A list of TLS protocol versions. Available
               versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
               **Octavia minor version >= 2.17**.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if allowed_cidrs is not None:
            pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        if alpn_protocols is not None:
            pulumi.set(__self__, "alpn_protocols", alpn_protocols)
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)
        if client_ca_tls_container_ref is not None:
            pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        if client_crl_container_ref is not None:
            pulumi.set(__self__, "client_crl_container_ref", client_crl_container_ref)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref is not None:
            pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hsts_include_subdomains is not None:
            pulumi.set(__self__, "hsts_include_subdomains", hsts_include_subdomains)
        if hsts_max_age is not None:
            pulumi.set(__self__, "hsts_max_age", hsts_max_age)
        if hsts_preload is not None:
            pulumi.set(__self__, "hsts_preload", hsts_preload)
        if insert_headers is not None:
            pulumi.set(__self__, "insert_headers", insert_headers)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sni_container_refs is not None:
            pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout_client_data is not None:
            pulumi.set(__self__, "timeout_client_data", timeout_client_data)
        if timeout_member_connect is not None:
            pulumi.set(__self__, "timeout_member_connect", timeout_member_connect)
        if timeout_member_data is not None:
            pulumi.set(__self__, "timeout_member_data", timeout_member_data)
        if timeout_tcp_inspect is not None:
            pulumi.set(__self__, "timeout_tcp_inspect", timeout_tcp_inspect)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_versions is not None:
            pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the Listener. A
        valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of CIDR blocks that are permitted to
        connect to this listener, denying all other source addresses. If not present,
        defaults to allow all.
        """
        return pulumi.get(self, "allowed_cidrs")

    @allowed_cidrs.setter
    def allowed_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="alpnProtocols")
    def alpn_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of ALPN protocols. Available protocols:
        `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
        2.20**.
        """
        return pulumi.get(self, "alpn_protocols")

    @alpn_protocols.setter
    def alpn_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alpn_protocols", value)

    @_builtins.property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS client authentication mode.
        Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
        `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
        Supported only in **Octavia minor version >= 2.8**.
        """
        return pulumi.get(self, "client_authentication")

    @client_authentication.setter
    def client_authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_authentication", value)

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ref of the key manager service
        secret containing a PEM format client CA certificate bundle for
        `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
        `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
        2.8**.
        """
        return pulumi.get(self, "client_ca_tls_container_ref")

    @client_ca_tls_container_ref.setter
    def client_ca_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter(name="clientCrlContainerRef")
    def client_crl_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the key manager service
        secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
        listeners. Supported only in **Octavia minor version >= 2.8**.
        """
        return pulumi.get(self, "client_crl_container_ref")

    @client_crl_container_ref.setter
    def client_crl_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_crl_container_ref", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections allowed for
        the Listener.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_limit", value)

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default pool with which the
        Listener is associated.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to a Barbican Secrets
        container which stores TLS information. This is required if the protocol is
        `TERMINATED_HTTPS`. See
        [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
        for more information.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @default_tls_container_ref.setter
    def default_tls_container_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_tls_container_ref", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description for the Listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the
        **includeSubDomains** directive should be added to the
        Strict-Transport-Security HTTP response header. This requires setting the
        `hsts_max_age` option as well in order to become effective. Requires
        `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
        version >= 2.27**.
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @hsts_include_subdomains.setter
    def hsts_include_subdomains(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hsts_include_subdomains", value)

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of the **max_age** directive for the
        Strict-Transport-Security HTTP response header. Setting this enables HTTP
        Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
        `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
        version >= 2.27**.
        """
        return pulumi.get(self, "hsts_max_age")

    @hsts_max_age.setter
    def hsts_max_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hsts_max_age", value)

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines whether the **preload** directive should
        be added to the Strict-Transport-Security HTTP response header. This requires
        setting the `hsts_max_age` option as well in order to become effective.
        Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
        minor version >= 2.27**.
        """
        return pulumi.get(self, "hsts_preload")

    @hsts_preload.setter
    def hsts_preload(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hsts_preload", value)

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of key value pairs representing
        headers to insert into the request before it is sent to the backend members.
        Changing this updates the headers of the existing listener.
        """
        return pulumi.get(self, "insert_headers")

    @insert_headers.setter
    def insert_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "insert_headers", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancer on which to provision this
        Listener. Changing this creates a new Listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name for the Listener. Does not have to be
        unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol can be either `TCP`, `HTTP`, `HTTPS`,
        `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
        \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
        2.25**). Changing this creates a new Listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port on which to listen for client traffic.
        * Changing this creates a new Listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol_port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a listener. If omitted, the `region`
        argument of the provider is used. Changing this creates a new Listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of references to Barbican Secrets
        containers which store SNI information. See
        [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
        for more information.
        """
        return pulumi.get(self, "sni_container_refs")

    @sni_container_refs.setter
    def sni_container_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sni_container_refs", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of simple strings assigned to the pool. Available
        for Octavia **minor version 2.5 or later**.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for admins. The UUID of the tenant who owns
        the Listener.  Only administrative users can specify a tenant UUID other than
        their own. Changing this creates a new Listener.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeoutClientData")
    def timeout_client_data(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client inactivity timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_client_data")

    @timeout_client_data.setter
    def timeout_client_data(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_client_data", value)

    @_builtins.property
    @pulumi.getter(name="timeoutMemberConnect")
    def timeout_member_connect(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The member connection timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_member_connect")

    @timeout_member_connect.setter
    def timeout_member_connect(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_member_connect", value)

    @_builtins.property
    @pulumi.getter(name="timeoutMemberData")
    def timeout_member_data(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The member inactivity timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_member_data")

    @timeout_member_data.setter
    def timeout_member_data(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_member_data", value)

    @_builtins.property
    @pulumi.getter(name="timeoutTcpInspect")
    def timeout_tcp_inspect(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in milliseconds, to wait for
        additional TCP packets for content inspection.
        """
        return pulumi.get(self, "timeout_tcp_inspect")

    @timeout_tcp_inspect.setter
    def timeout_tcp_inspect(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_tcp_inspect", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of ciphers in OpenSSL format
        (colon-separated). See
        https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
        Supported only in **Octavia minor version >= 2.15**.
        """
        return pulumi.get(self, "tls_ciphers")

    @tls_ciphers.setter
    def tls_ciphers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of TLS protocol versions. Available
        versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
        **Octavia minor version >= 2.17**.
        """
        return pulumi.get(self, "tls_versions")

    @tls_versions.setter
    def tls_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_versions", value)


@pulumi.type_token("openstack:loadbalancer/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_client_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_connect: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_tcp_inspect: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a V2 listener resource within OpenStack.

        > **Note:** This resource has attributes that depend on octavia minor versions.
        Please ensure your Openstack cloud supports the required minor version.

        ## Example Usage

        ### Simple listener

        ```python
        import pulumi
        import pulumi_openstack as openstack

        listener1 = openstack.loadbalancer.Listener("listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id="d9415786-5f1a-428b-b35f-2f1523e146d2",
            insert_headers={
                "X-Forwarded-For": "true",
            })
        ```

        ### Listener with TLS and client certificate authentication

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        certificate1 = openstack.keymanager.SecretV1("certificate_1",
            name="certificate",
            payload=std.filebase64(input="snakeoil.p12").result,
            payload_content_encoding="base64",
            payload_content_type="application/octet-stream")
        ca_certificate1 = openstack.keymanager.SecretV1("ca_certificate_1",
            name="certificate",
            payload=std.file(input="CA.pem").result,
            secret_type="certificate",
            payload_content_type="text/plain")
        subnet1 = openstack.networking.get_subnet(name="my-subnet")
        lb1 = openstack.loadbalancer.LoadBalancer("lb_1",
            name="loadbalancer",
            vip_subnet_id=subnet1.id)
        listener1 = openstack.loadbalancer.Listener("listener_1",
            name="https",
            protocol="TERMINATED_HTTPS",
            protocol_port=443,
            loadbalancer_id=lb1.id,
            default_tls_container_ref=certificate1,
            client_authentication="OPTIONAL",
            client_ca_tls_container_ref=ca_certificate2["secretRef"])
        ```

        ## Import

        Load Balancer Listener can be imported using the Listener ID, e.g.:

        ```sh
        $ pulumi import openstack:loadbalancer/listener:Listener listener_1 b67ce64e-8b26-405d-afeb-4a078901f15a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the Listener. A
               valid value is true (UP) or false (DOWN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_cidrs: A list of CIDR blocks that are permitted to
               connect to this listener, denying all other source addresses. If not present,
               defaults to allow all.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alpn_protocols: A list of ALPN protocols. Available protocols:
               `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
               2.20**.
        :param pulumi.Input[_builtins.str] client_authentication: The TLS client authentication mode.
               Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
               `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
               Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.str] client_ca_tls_container_ref: The ref of the key manager service
               secret containing a PEM format client CA certificate bundle for
               `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
               `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
               2.8**.
        :param pulumi.Input[_builtins.str] client_crl_container_ref: The URI of the key manager service
               secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
               listeners. Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for
               the Listener.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the
               Listener is associated.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: A reference to a Barbican Secrets
               container which stores TLS information. This is required if the protocol is
               `TERMINATED_HTTPS`. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the Listener.
        :param pulumi.Input[_builtins.bool] hsts_include_subdomains: Defines whether the
               **includeSubDomains** directive should be added to the
               Strict-Transport-Security HTTP response header. This requires setting the
               `hsts_max_age` option as well in order to become effective. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.int] hsts_max_age: The value of the **max_age** directive for the
               Strict-Transport-Security HTTP response header. Setting this enables HTTP
               Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.bool] hsts_preload: Defines whether the **preload** directive should
               be added to the Strict-Transport-Security HTTP response header. This requires
               setting the `hsts_max_age` option as well in order to become effective.
               Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
               minor version >= 2.27**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] insert_headers: The list of key value pairs representing
               headers to insert into the request before it is sent to the backend members.
               Changing this updates the headers of the existing listener.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this
               Listener. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Listener. Does not have to be
               unique.
        :param pulumi.Input[_builtins.str] protocol: The protocol can be either `TCP`, `HTTP`, `HTTPS`,
               `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
               \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
               2.25**). Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic.
               * Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a listener. If omitted, the `region`
               argument of the provider is used. Changing this creates a new Listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: A list of references to Barbican Secrets
               containers which store SNI information. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of simple strings assigned to the pool. Available
               for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Listener.  Only administrative users can specify a tenant UUID other than
               their own. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] timeout_client_data: The client inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_connect: The member connection timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_data: The member inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_tcp_inspect: The time in milliseconds, to wait for
               additional TCP packets for content inspection.
        :param pulumi.Input[_builtins.str] tls_ciphers: List of ciphers in OpenSSL format
               (colon-separated). See
               https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
               Supported only in **Octavia minor version >= 2.15**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: A list of TLS protocol versions. Available
               versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
               **Octavia minor version >= 2.17**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 listener resource within OpenStack.

        > **Note:** This resource has attributes that depend on octavia minor versions.
        Please ensure your Openstack cloud supports the required minor version.

        ## Example Usage

        ### Simple listener

        ```python
        import pulumi
        import pulumi_openstack as openstack

        listener1 = openstack.loadbalancer.Listener("listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id="d9415786-5f1a-428b-b35f-2f1523e146d2",
            insert_headers={
                "X-Forwarded-For": "true",
            })
        ```

        ### Listener with TLS and client certificate authentication

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        certificate1 = openstack.keymanager.SecretV1("certificate_1",
            name="certificate",
            payload=std.filebase64(input="snakeoil.p12").result,
            payload_content_encoding="base64",
            payload_content_type="application/octet-stream")
        ca_certificate1 = openstack.keymanager.SecretV1("ca_certificate_1",
            name="certificate",
            payload=std.file(input="CA.pem").result,
            secret_type="certificate",
            payload_content_type="text/plain")
        subnet1 = openstack.networking.get_subnet(name="my-subnet")
        lb1 = openstack.loadbalancer.LoadBalancer("lb_1",
            name="loadbalancer",
            vip_subnet_id=subnet1.id)
        listener1 = openstack.loadbalancer.Listener("listener_1",
            name="https",
            protocol="TERMINATED_HTTPS",
            protocol_port=443,
            loadbalancer_id=lb1.id,
            default_tls_container_ref=certificate1,
            client_authentication="OPTIONAL",
            client_ca_tls_container_ref=ca_certificate2["secretRef"])
        ```

        ## Import

        Load Balancer Listener can be imported using the Listener ID, e.g.:

        ```sh
        $ pulumi import openstack:loadbalancer/listener:Listener listener_1 b67ce64e-8b26-405d-afeb-4a078901f15a
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 hsts_include_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
                 hsts_max_age: Optional[pulumi.Input[_builtins.int]] = None,
                 hsts_preload: Optional[pulumi.Input[_builtins.bool]] = None,
                 insert_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_client_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_connect: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_member_data: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout_tcp_inspect: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["allowed_cidrs"] = allowed_cidrs
            __props__.__dict__["alpn_protocols"] = alpn_protocols
            __props__.__dict__["client_authentication"] = client_authentication
            __props__.__dict__["client_ca_tls_container_ref"] = client_ca_tls_container_ref
            __props__.__dict__["client_crl_container_ref"] = client_crl_container_ref
            __props__.__dict__["connection_limit"] = connection_limit
            __props__.__dict__["default_pool_id"] = default_pool_id
            __props__.__dict__["default_tls_container_ref"] = default_tls_container_ref
            __props__.__dict__["description"] = description
            __props__.__dict__["hsts_include_subdomains"] = hsts_include_subdomains
            __props__.__dict__["hsts_max_age"] = hsts_max_age
            __props__.__dict__["hsts_preload"] = hsts_preload
            __props__.__dict__["insert_headers"] = insert_headers
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if protocol_port is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_port'")
            __props__.__dict__["protocol_port"] = protocol_port
            __props__.__dict__["region"] = region
            __props__.__dict__["sni_container_refs"] = sni_container_refs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timeout_client_data"] = timeout_client_data
            __props__.__dict__["timeout_member_connect"] = timeout_member_connect
            __props__.__dict__["timeout_member_data"] = timeout_member_data
            __props__.__dict__["timeout_tcp_inspect"] = timeout_tcp_inspect
            __props__.__dict__["tls_ciphers"] = tls_ciphers
            __props__.__dict__["tls_versions"] = tls_versions
        super(Listener, __self__).__init__(
            'openstack:loadbalancer/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            alpn_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            client_authentication: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
            client_crl_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
            connection_limit: Optional[pulumi.Input[_builtins.int]] = None,
            default_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_tls_container_ref: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            hsts_include_subdomains: Optional[pulumi.Input[_builtins.bool]] = None,
            hsts_max_age: Optional[pulumi.Input[_builtins.int]] = None,
            hsts_preload: Optional[pulumi.Input[_builtins.bool]] = None,
            insert_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            protocol_port: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_client_data: Optional[pulumi.Input[_builtins.int]] = None,
            timeout_member_connect: Optional[pulumi.Input[_builtins.int]] = None,
            timeout_member_data: Optional[pulumi.Input[_builtins.int]] = None,
            timeout_tcp_inspect: Optional[pulumi.Input[_builtins.int]] = None,
            tls_ciphers: Optional[pulumi.Input[_builtins.str]] = None,
            tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the Listener. A
               valid value is true (UP) or false (DOWN).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_cidrs: A list of CIDR blocks that are permitted to
               connect to this listener, denying all other source addresses. If not present,
               defaults to allow all.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alpn_protocols: A list of ALPN protocols. Available protocols:
               `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
               2.20**.
        :param pulumi.Input[_builtins.str] client_authentication: The TLS client authentication mode.
               Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
               `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
               Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.str] client_ca_tls_container_ref: The ref of the key manager service
               secret containing a PEM format client CA certificate bundle for
               `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
               `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
               2.8**.
        :param pulumi.Input[_builtins.str] client_crl_container_ref: The URI of the key manager service
               secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
               listeners. Supported only in **Octavia minor version >= 2.8**.
        :param pulumi.Input[_builtins.int] connection_limit: The maximum number of connections allowed for
               the Listener.
        :param pulumi.Input[_builtins.str] default_pool_id: The ID of the default pool with which the
               Listener is associated.
        :param pulumi.Input[_builtins.str] default_tls_container_ref: A reference to a Barbican Secrets
               container which stores TLS information. This is required if the protocol is
               `TERMINATED_HTTPS`. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[_builtins.str] description: Human-readable description for the Listener.
        :param pulumi.Input[_builtins.bool] hsts_include_subdomains: Defines whether the
               **includeSubDomains** directive should be added to the
               Strict-Transport-Security HTTP response header. This requires setting the
               `hsts_max_age` option as well in order to become effective. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.int] hsts_max_age: The value of the **max_age** directive for the
               Strict-Transport-Security HTTP response header. Setting this enables HTTP
               Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
               `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
               version >= 2.27**.
        :param pulumi.Input[_builtins.bool] hsts_preload: Defines whether the **preload** directive should
               be added to the Strict-Transport-Security HTTP response header. This requires
               setting the `hsts_max_age` option as well in order to become effective.
               Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
               minor version >= 2.27**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] insert_headers: The list of key value pairs representing
               headers to insert into the request before it is sent to the backend members.
               Changing this updates the headers of the existing listener.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The load balancer on which to provision this
               Listener. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] name: Human-readable name for the Listener. Does not have to be
               unique.
        :param pulumi.Input[_builtins.str] protocol: The protocol can be either `TCP`, `HTTP`, `HTTPS`,
               `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
               \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
               2.25**). Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] protocol_port: The port on which to listen for client traffic.
               * Changing this creates a new Listener.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a listener. If omitted, the `region`
               argument of the provider is used. Changing this creates a new Listener.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sni_container_refs: A list of references to Barbican Secrets
               containers which store SNI information. See
               [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
               for more information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of simple strings assigned to the pool. Available
               for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Listener.  Only administrative users can specify a tenant UUID other than
               their own. Changing this creates a new Listener.
        :param pulumi.Input[_builtins.int] timeout_client_data: The client inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_connect: The member connection timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_member_data: The member inactivity timeout in
               milliseconds.
        :param pulumi.Input[_builtins.int] timeout_tcp_inspect: The time in milliseconds, to wait for
               additional TCP packets for content inspection.
        :param pulumi.Input[_builtins.str] tls_ciphers: List of ciphers in OpenSSL format
               (colon-separated). See
               https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
               Supported only in **Octavia minor version >= 2.15**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_versions: A list of TLS protocol versions. Available
               versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
               **Octavia minor version >= 2.17**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["allowed_cidrs"] = allowed_cidrs
        __props__.__dict__["alpn_protocols"] = alpn_protocols
        __props__.__dict__["client_authentication"] = client_authentication
        __props__.__dict__["client_ca_tls_container_ref"] = client_ca_tls_container_ref
        __props__.__dict__["client_crl_container_ref"] = client_crl_container_ref
        __props__.__dict__["connection_limit"] = connection_limit
        __props__.__dict__["default_pool_id"] = default_pool_id
        __props__.__dict__["default_tls_container_ref"] = default_tls_container_ref
        __props__.__dict__["description"] = description
        __props__.__dict__["hsts_include_subdomains"] = hsts_include_subdomains
        __props__.__dict__["hsts_max_age"] = hsts_max_age
        __props__.__dict__["hsts_preload"] = hsts_preload
        __props__.__dict__["insert_headers"] = insert_headers
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_port"] = protocol_port
        __props__.__dict__["region"] = region
        __props__.__dict__["sni_container_refs"] = sni_container_refs
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeout_client_data"] = timeout_client_data
        __props__.__dict__["timeout_member_connect"] = timeout_member_connect
        __props__.__dict__["timeout_member_data"] = timeout_member_data
        __props__.__dict__["timeout_tcp_inspect"] = timeout_tcp_inspect
        __props__.__dict__["tls_ciphers"] = tls_ciphers
        __props__.__dict__["tls_versions"] = tls_versions
        return Listener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The administrative state of the Listener. A
        valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of CIDR blocks that are permitted to
        connect to this listener, denying all other source addresses. If not present,
        defaults to allow all.
        """
        return pulumi.get(self, "allowed_cidrs")

    @_builtins.property
    @pulumi.getter(name="alpnProtocols")
    def alpn_protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of ALPN protocols. Available protocols:
        `http/1.0`, `http/1.1`, `h2`. Supported only in **Octavia minor version >=
        2.20**.
        """
        return pulumi.get(self, "alpn_protocols")

    @_builtins.property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TLS client authentication mode.
        Available options: `NONE`, `OPTIONAL` or `MANDATORY`. Requires
        `TERMINATED_HTTPS` listener protocol and the `client_ca_tls_container_ref`.
        Supported only in **Octavia minor version >= 2.8**.
        """
        return pulumi.get(self, "client_authentication")

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ref of the key manager service
        secret containing a PEM format client CA certificate bundle for
        `TERMINATED_HTTPS` listeners. Required if `client_authentication` is
        `OPTIONAL` or `MANDATORY`. Supported only in **Octavia minor version >=
        2.8**.
        """
        return pulumi.get(self, "client_ca_tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="clientCrlContainerRef")
    def client_crl_container_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI of the key manager service
        secret containing a PEM format CA revocation list file for `TERMINATED_HTTPS`
        listeners. Supported only in **Octavia minor version >= 2.8**.
        """
        return pulumi.get(self, "client_crl_container_ref")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of connections allowed for
        the Listener.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the default pool with which the
        Listener is associated.
        """
        return pulumi.get(self, "default_pool_id")

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A reference to a Barbican Secrets
        container which stores TLS information. This is required if the protocol is
        `TERMINATED_HTTPS`. See
        [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
        for more information.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description for the Listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether the
        **includeSubDomains** directive should be added to the
        Strict-Transport-Security HTTP response header. This requires setting the
        `hsts_max_age` option as well in order to become effective. Requires
        `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
        version >= 2.27**.
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The value of the **max_age** directive for the
        Strict-Transport-Security HTTP response header. Setting this enables HTTP
        Strict Transport Security (HSTS) for the TLS-terminated listener. Requires
        `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia minor
        version >= 2.27**.
        """
        return pulumi.get(self, "hsts_max_age")

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines whether the **preload** directive should
        be added to the Strict-Transport-Security HTTP response header. This requires
        setting the `hsts_max_age` option as well in order to become effective.
        Requires `TERMINATED_HTTPS` listener protocol. Supported only in **Octavia
        minor version >= 2.27**.
        """
        return pulumi.get(self, "hsts_preload")

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The list of key value pairs representing
        headers to insert into the request before it is sent to the backend members.
        Changing this updates the headers of the existing listener.
        """
        return pulumi.get(self, "insert_headers")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The load balancer on which to provision this
        Listener. Changing this creates a new Listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name for the Listener. Does not have to be
        unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol can be either `TCP`, `HTTP`, `HTTPS`,
        `TERMINATED_HTTPS`, `UDP`, `SCTP` (supported only in **Octavia minor version
        \\>= 2.23**), or `PROMETHEUS` (supported only in **Octavia minor version >=
        2.25**). Changing this creates a new Listener.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[_builtins.int]:
        """
        The port on which to listen for client traffic.
        * Changing this creates a new Listener.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a listener. If omitted, the `region`
        argument of the provider is used. Changing this creates a new Listener.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of references to Barbican Secrets
        containers which store SNI information. See
        [here](https://docs.openstack.org/octavia/latest/user/guides/basic-cookbook.html#deploy-a-tls-terminated-https-load-balancer)
        for more information.
        """
        return pulumi.get(self, "sni_container_refs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of simple strings assigned to the pool. Available
        for Octavia **minor version 2.5 or later**.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required for admins. The UUID of the tenant who owns
        the Listener.  Only administrative users can specify a tenant UUID other than
        their own. Changing this creates a new Listener.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="timeoutClientData")
    def timeout_client_data(self) -> pulumi.Output[_builtins.int]:
        """
        The client inactivity timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_client_data")

    @_builtins.property
    @pulumi.getter(name="timeoutMemberConnect")
    def timeout_member_connect(self) -> pulumi.Output[_builtins.int]:
        """
        The member connection timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_member_connect")

    @_builtins.property
    @pulumi.getter(name="timeoutMemberData")
    def timeout_member_data(self) -> pulumi.Output[_builtins.int]:
        """
        The member inactivity timeout in
        milliseconds.
        """
        return pulumi.get(self, "timeout_member_data")

    @_builtins.property
    @pulumi.getter(name="timeoutTcpInspect")
    def timeout_tcp_inspect(self) -> pulumi.Output[_builtins.int]:
        """
        The time in milliseconds, to wait for
        additional TCP packets for content inspection.
        """
        return pulumi.get(self, "timeout_tcp_inspect")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> pulumi.Output[_builtins.str]:
        """
        List of ciphers in OpenSSL format
        (colon-separated). See
        https://www.openssl.org/docs/man1.1.1/man1/ciphers.html for more information.
        Supported only in **Octavia minor version >= 2.15**.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of TLS protocol versions. Available
        versions: `TLSv1`, `TLSv1.1`, `TLSv1.2`, `TLSv1.3`. Supported only in
        **Octavia minor version >= 2.17**.
        """
        return pulumi.get(self, "tls_versions")

