# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BgpPeerV2Args', 'BgpPeerV2']

@pulumi.input_type
class BgpPeerV2Args:
    def __init__(__self__, *,
                 peer_ip: pulumi.Input[_builtins.str],
                 remote_as: pulumi.Input[_builtins.int],
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BgpPeerV2 resource.
        :param pulumi.Input[_builtins.str] peer_ip: The IP address of the BGP peer. Must be a valid IP
               address. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.int] remote_as: The AS number of the BGP peer. Changing this
               creates a new BGP peer.
        :param pulumi.Input[_builtins.str] auth_type: The authentication type to use. Can be one of `none`
               or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
               must also be provided. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] name: A name for the BGP peer.
        :param pulumi.Input[_builtins.str] password: The password used for MD5 authentication. Must be set
               only when `auth_type` is not `none`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               peer.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP peer.
        """
        pulumi.set(__self__, "peer_ip", peer_ip)
        pulumi.set(__self__, "remote_as", remote_as)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address of the BGP peer. Must be a valid IP
        address. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_ip", value)

    @_builtins.property
    @pulumi.getter(name="remoteAs")
    def remote_as(self) -> pulumi.Input[_builtins.int]:
        """
        The AS number of the BGP peer. Changing this
        creates a new BGP peer.
        """
        return pulumi.get(self, "remote_as")

    @remote_as.setter
    def remote_as(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "remote_as", value)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication type to use. Can be one of `none`
        or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
        must also be provided. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the BGP peer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password used for MD5 authentication. Must be set
        only when `auth_type` is not `none`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new BGP
        peer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant/project ID. Required if admin privileges
        are used. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _BgpPeerV2State:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_as: Optional[pulumi.Input[_builtins.int]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BgpPeerV2 resources.
        :param pulumi.Input[_builtins.str] auth_type: The authentication type to use. Can be one of `none`
               or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
               must also be provided. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] name: A name for the BGP peer.
        :param pulumi.Input[_builtins.str] password: The password used for MD5 authentication. Must be set
               only when `auth_type` is not `none`.
        :param pulumi.Input[_builtins.str] peer_ip: The IP address of the BGP peer. Must be a valid IP
               address. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               peer.
        :param pulumi.Input[_builtins.int] remote_as: The AS number of the BGP peer. Changing this
               creates a new BGP peer.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP peer.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if peer_ip is not None:
            pulumi.set(__self__, "peer_ip", peer_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_as is not None:
            pulumi.set(__self__, "remote_as", remote_as)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication type to use. Can be one of `none`
        or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
        must also be provided. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the BGP peer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password used for MD5 authentication. Must be set
        only when `auth_type` is not `none`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the BGP peer. Must be a valid IP
        address. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new BGP
        peer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remoteAs")
    def remote_as(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The AS number of the BGP peer. Changing this
        creates a new BGP peer.
        """
        return pulumi.get(self, "remote_as")

    @remote_as.setter
    def remote_as(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "remote_as", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant/project ID. Required if admin privileges
        are used. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("openstack:networking/bgpPeerV2:BgpPeerV2")
class BgpPeerV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_as: Optional[pulumi.Input[_builtins.int]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 Neutron BGP Peer resource within OpenStack.

        This resource allows you to configure a BGP peer that can be associated with a
        BGP speaker to exchange routing information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        peer1 = openstack.networking.BgpPeerV2("peer_1",
            name="bgp_peer_1",
            peer_ip="192.0.2.10",
            remote_as=65001,
            auth_type="md5",
            password="supersecret")
        ```

        ## Import

        BGP peers can be imported using their ID:

        ```sh
        $ pulumi import openstack:networking/bgpPeerV2:BgpPeerV2 peer1 a1b2c3d4-e5f6-7890-abcd-1234567890ef
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_type: The authentication type to use. Can be one of `none`
               or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
               must also be provided. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] name: A name for the BGP peer.
        :param pulumi.Input[_builtins.str] password: The password used for MD5 authentication. Must be set
               only when `auth_type` is not `none`.
        :param pulumi.Input[_builtins.str] peer_ip: The IP address of the BGP peer. Must be a valid IP
               address. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               peer.
        :param pulumi.Input[_builtins.int] remote_as: The AS number of the BGP peer. Changing this
               creates a new BGP peer.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP peer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BgpPeerV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 Neutron BGP Peer resource within OpenStack.

        This resource allows you to configure a BGP peer that can be associated with a
        BGP speaker to exchange routing information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        peer1 = openstack.networking.BgpPeerV2("peer_1",
            name="bgp_peer_1",
            peer_ip="192.0.2.10",
            remote_as=65001,
            auth_type="md5",
            password="supersecret")
        ```

        ## Import

        BGP peers can be imported using their ID:

        ```sh
        $ pulumi import openstack:networking/bgpPeerV2:BgpPeerV2 peer1 a1b2c3d4-e5f6-7890-abcd-1234567890ef
        ```

        :param str resource_name: The name of the resource.
        :param BgpPeerV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BgpPeerV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_as: Optional[pulumi.Input[_builtins.int]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BgpPeerV2Args.__new__(BgpPeerV2Args)

            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if peer_ip is None and not opts.urn:
                raise TypeError("Missing required property 'peer_ip'")
            __props__.__dict__["peer_ip"] = peer_ip
            __props__.__dict__["region"] = region
            if remote_as is None and not opts.urn:
                raise TypeError("Missing required property 'remote_as'")
            __props__.__dict__["remote_as"] = remote_as
            __props__.__dict__["tenant_id"] = tenant_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BgpPeerV2, __self__).__init__(
            'openstack:networking/bgpPeerV2:BgpPeerV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remote_as: Optional[pulumi.Input[_builtins.int]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BgpPeerV2':
        """
        Get an existing BgpPeerV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_type: The authentication type to use. Can be one of `none`
               or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
               must also be provided. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] name: A name for the BGP peer.
        :param pulumi.Input[_builtins.str] password: The password used for MD5 authentication. Must be set
               only when `auth_type` is not `none`.
        :param pulumi.Input[_builtins.str] peer_ip: The IP address of the BGP peer. Must be a valid IP
               address. Changing this creates a new BGP peer.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new BGP
               peer.
        :param pulumi.Input[_builtins.int] remote_as: The AS number of the BGP peer. Changing this
               creates a new BGP peer.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant/project ID. Required if admin privileges
               are used. Changing this creates a new BGP peer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BgpPeerV2State.__new__(_BgpPeerV2State)

        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["peer_ip"] = peer_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_as"] = remote_as
        __props__.__dict__["tenant_id"] = tenant_id
        return BgpPeerV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authentication type to use. Can be one of `none`
        or `md5`. Defaults to `none`. If set to not `none`, the `password` argument
        must also be provided. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the BGP peer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password used for MD5 authentication. Must be set
        only when `auth_type` is not `none`.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the BGP peer. Must be a valid IP
        address. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "peer_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new BGP
        peer.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remoteAs")
    def remote_as(self) -> pulumi.Output[_builtins.int]:
        """
        The AS number of the BGP peer. Changing this
        creates a new BGP peer.
        """
        return pulumi.get(self, "remote_as")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant/project ID. Required if admin privileges
        are used. Changing this creates a new BGP peer.
        """
        return pulumi.get(self, "tenant_id")

