# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecGroupResult',
    'AwaitableGetSecGroupResult',
    'get_sec_group',
    'get_sec_group_output',
]

@pulumi.output_type
class GetSecGroupResult:
    """
    A collection of values returned by getSecGroup.
    """
    def __init__(__self__, all_tags=None, description=None, id=None, name=None, region=None, secgroup_id=None, stateful=None, tags=None, tenant_id=None):
        if all_tags and not isinstance(all_tags, list):
            raise TypeError("Expected argument 'all_tags' to be a list")
        pulumi.set(__self__, "all_tags", all_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secgroup_id and not isinstance(secgroup_id, str):
            raise TypeError("Expected argument 'secgroup_id' to be a str")
        pulumi.set(__self__, "secgroup_id", secgroup_id)
        if stateful and not isinstance(stateful, bool):
            raise TypeError("Expected argument 'stateful' to be a bool")
        pulumi.set(__self__, "stateful", stateful)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Sequence[_builtins.str]:
        """
        The set of string tags applied on the security group.
        """
        return pulumi.get(self, "all_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secgroupId")
    def secgroup_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "secgroup_id")

    @_builtins.property
    @pulumi.getter
    def stateful(self) -> _builtins.bool:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "stateful")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        return pulumi.get(self, "tenant_id")


class AwaitableGetSecGroupResult(GetSecGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecGroupResult(
            all_tags=self.all_tags,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            secgroup_id=self.secgroup_id,
            stateful=self.stateful,
            tags=self.tags,
            tenant_id=self.tenant_id)


def get_sec_group(description: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  secgroup_id: Optional[_builtins.str] = None,
                  stateful: Optional[_builtins.bool] = None,
                  tags: Optional[Sequence[_builtins.str]] = None,
                  tenant_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecGroupResult:
    """
    Use this data source to get the ID of an available OpenStack security group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    secgroup = openstack.networking.get_sec_group(name="tf_test_secgroup")
    ```


    :param _builtins.str description: Human-readable description the the subnet.
    :param _builtins.str name: The name of the security group.
    :param _builtins.str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve security groups ids. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.str secgroup_id: The ID of the security group.
    :param _builtins.bool stateful: Whether the security group is stateful or not.
    :param Sequence[_builtins.str] tags: The list of security group tags to filter.
    :param _builtins.str tenant_id: The owner of the security group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['region'] = region
    __args__['secgroupId'] = secgroup_id
    __args__['stateful'] = stateful
    __args__['tags'] = tags
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:networking/getSecGroup:getSecGroup', __args__, opts=opts, typ=GetSecGroupResult).value

    return AwaitableGetSecGroupResult(
        all_tags=pulumi.get(__ret__, 'all_tags'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        secgroup_id=pulumi.get(__ret__, 'secgroup_id'),
        stateful=pulumi.get(__ret__, 'stateful'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_sec_group_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         secgroup_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         stateful: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         tenant_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecGroupResult]:
    """
    Use this data source to get the ID of an available OpenStack security group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    secgroup = openstack.networking.get_sec_group(name="tf_test_secgroup")
    ```


    :param _builtins.str description: Human-readable description the the subnet.
    :param _builtins.str name: The name of the security group.
    :param _builtins.str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve security groups ids. If omitted, the
           `region` argument of the provider is used.
    :param _builtins.str secgroup_id: The ID of the security group.
    :param _builtins.bool stateful: Whether the security group is stateful or not.
    :param Sequence[_builtins.str] tags: The list of security group tags to filter.
    :param _builtins.str tenant_id: The owner of the security group.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['region'] = region
    __args__['secgroupId'] = secgroup_id
    __args__['stateful'] = stateful
    __args__['tags'] = tags
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:networking/getSecGroup:getSecGroup', __args__, opts=opts, typ=GetSecGroupResult)
    return __ret__.apply(lambda __response__: GetSecGroupResult(
        all_tags=pulumi.get(__response__, 'all_tags'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        secgroup_id=pulumi.get(__response__, 'secgroup_id'),
        stateful=pulumi.get(__response__, 'stateful'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
