# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------
#pylint: skip-file
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ErrorDetails(Model):
    """The properties related to the details of an error.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param code: The error code.
    :type code: str
    :ivar http_status_code: The http status code.
    :vartype http_status_code: str
    :param message: The error message.
    :type message: str
    :param details: The error details.
    :type details: str
    """ 

    _validation = {
        'http_status_code': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'http_status_code': {'key': 'HttpStatusCode', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
        'details': {'key': 'Details', 'type': 'str'},
    }

    def __init__(self, code=None, message=None, details=None):
        self.code = code
        self.http_status_code = None
        self.message = message
        self.details = details


class ErrorDetailsException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorDetails'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorDetailsException, self).__init__(deserialize, response, 'ErrorDetails', *args)
