import { ILayoutRestorer, IRouter, JupyterFrontEnd, JupyterFrontEndPlugin } from "@jupyterlab/application";
import { ContentsManager } from "@jupyterlab/services";
import { DocumentRegistry } from "@jupyterlab/docregistry";
import { IDocumentManager } from "@jupyterlab/docmanager";
import { IWindowResolver, Toolbar } from "@jupyterlab/apputils";
import { Widget } from "@phosphor/widgets";
import * as JSZip from "jszip";
import "../style/index.css";
export declare class FileTreeWidget extends Widget {
    cm: ContentsManager;
    dr: DocumentRegistry;
    commands: any;
    toolbar: Toolbar;
    table: HTMLTableElement;
    tree: HTMLElement;
    controller: any;
    selected: string;
    basepath: string;
    constructor(lab: JupyterFrontEnd, basepath?: string, id?: string);
    buildTable(headers: any, data: any): HTMLTableElement;
    reload(): void;
    restore(): void;
    refresh(): void;
    updateController(oldPath: string, newPath: string): void;
    buildTableContents(data: any, level: number, parent: any): void;
    sortContents(data: any): any[][];
    createTreeElement(object: any, level: number): HTMLTableRowElement;
    download(path: string, folder: boolean): Promise<any>;
    wrapFolder(zip: JSZip, path: string): Promise<void>;
}
export declare function constructFileTreeWidget(app: JupyterFrontEnd, basepath: string, id: string, side: string, paths: JupyterFrontEnd.IPaths, resolver: IWindowResolver, restorer: ILayoutRestorer, manager: IDocumentManager, router: IRouter): void;
declare const extension: JupyterFrontEndPlugin<void>;
export default extension;
