"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const application_1 = require("@jupyterlab/application");
const apputils_1 = require("@jupyterlab/apputils");
const coreutils_1 = require("@jupyterlab/coreutils");
const docmanager_1 = require("@jupyterlab/docmanager");
const filetree_1 = require("./filetree");
require("../style/index.css");
// tslint:disable: variable-name
const extension = {
    activate,
    autoStart: true,
    id: "multicontentsmanager",
    requires: [application_1.JupyterFrontEnd.IPaths, apputils_1.IWindowResolver, application_1.ILayoutRestorer, docmanager_1.IDocumentManager, application_1.IRouter],
};
function activate(app, paths, resolver, restorer, manager, router) {
    // grab templates from serverextension
    fetch(new Request(coreutils_1.PageConfig.getBaseUrl() + "multicontents/get", { method: "get" })).then((value) => __awaiter(this, void 0, void 0, function* () {
        if (value.ok) {
            const keys = yield value.json();
            // tslint:disable-next-line:no-console
            console.log("JupyterLab extension multicontentsmanager is activated!");
            for (const s of keys) {
                filetree_1.constructFileTreeWidget(app, s, s, "left", paths, resolver, restorer, manager, router);
                // tslint:disable-next-line:no-console
                console.log("Adding contents manager for " + s);
            }
        }
        else {
            // tslint:disable-next-line:no-console
            console.warn("MultiContentsManager failed to activate");
        }
    }));
}
exports._activate = activate;
exports.default = extension;
