import { ToolbarButton } from "@jupyterlab/apputils";
import { Contents } from "@jupyterlab/services";
/**
 * The maximum upload size (in bytes) for notebook version < 5.1.0
 */
export declare const LARGE_FILE_SIZE: number;
export declare const CHUNK_SIZE: number;
export interface IUploadModel {
    path: string;
    /**
     * % uploaded [0, 1)
     */
    progress: number;
}
export declare class Uploader extends ToolbarButton {
    private _input;
    private _uploads;
    private _uploadChanged;
    private manager;
    private widget;
    private context;
    private basepath;
    constructor(options: any);
    contextClick(path: string): void;
    /**
     * Upload a `File` object.
     *
     * @param file - The `File` object to upload.
     *
     * @returns A promise containing the new file contents model.
     *
     * #### Notes
     * On Notebook version < 5.1.0, this will fail to upload files that are too
     * big to be sent in one request to the server. On newer versions, it will
     * ask for confirmation then upload the file in 1 MB chunks.
     */
    upload(file: File, path: string): Promise<Contents.IModel>;
    private _onInputChanged;
    private _onInputClicked;
    private _uploadCheckDisposed;
    private _shouldUploadLarge;
    /**
     * Perform the actual upload.
     */
    private _upload;
}
