# ななこ (Nanako) - 教育用プログラミング言語

ななこは生成AI時代の教育用プログラミング言語です。限られた機能でチューリング完全性を学び、プログラミングの本質を理解することを目的としています。

## 特徴

- **限定された演算**: インクリメント、デクリメント、絶対値、符号反転のみ
- **0との比較のみ**: 条件文は0との比較のみ可能
- **定回数ループ**: N回繰り返しまたは配列の長さ分繰り返し
- **関数定義**: 再帰も可能な関数定義
- **チューリング完全**: これらの機能だけで理論上あらゆる計算が可能

## インストール

```bash
git clone <このリポジトリ>
cd nanako
```

## 使い方

### ファイル実行
```bash
python run_nanako.py examples/basic.nanako
```

### インタラクティブモード
```bash
python run_nanako.py --interactive
```

### テスト実行
```bash
python simple_test.py
python sample_programs.py
python japanese_samples.py
```

## 言語仕様

### 基本構文

#### 変数代入
```
x = 42
xを10とする
```

#### インクリメント・デクリメント
```
xを増やす
xを減らす
```

#### 条件分岐
```
もし、xが0以上ならば、{
    yを10とする
}
そうでなければ {
    yを20とする
}
```

比較演算子:
- `以上`: >= 0
- `以下`: <= 0  
- `より大きい`: > 0
- `より小さい`: < 0
- `以外`: != 0
- `未満`: < 0
- 空文字: == 0

#### ループ
```
5回、くり返す{
    xを増やす
}
```

配列の長さ分ループ:
```
[1, 2, 3]回、くり返す{
    counterを増やす
}
```

#### 関数定義と呼び出し
```
入力 x, y に対し {
    y回、くり返す{
        xを増やす
    }
    xが答え
}
```

#### 配列操作
```
arr = [1, 2, 3]
arr[0] = 99      # 要素の更新
x = arr[1]       # 要素の参照
arr[?] = 4       # 末尾に要素を追加（新機能！）
```

#### 文字列リテラル（新機能！）
```
message = "Hello"     # 文字コードの配列 [72, 101, 108, 108, 111]
greeting = "こんにちは"  # 日本語も対応
text = "Line1\nLine2" # エスケープシーケンス対応
```

#### 特殊演算
```
x = |y|    # 絶対値または配列の長さ
x = -y     # 符号反転
x = ?      # null値
```

## サンプルプログラム

### 足し算関数
```
たし算 = 入力 X, Y に対し {
    Y回、くり返す{
        Xを増やす
    }
    Xが答え
}
```

### 引き算関数  
```
ひき算 = 入力 X, Y に対し {
    Y回、くり返す{
        Xを減らす
    }
    Xが答え
}
```

### 絶対値関数
```
絶対値 = 入力 X に対し {
    もし Xが0より小さいならば {
        ひき算(0, X)が答え
    }
    そうでなければ {
        Xが答え
    }
}
```

## ファイル構成

- `nanako.py`: メインのインタープリター実装
- `run_nanako.py`: 実行可能ファイル
- `test_nanako.py`: 完全なテストスイート
- `simple_test.py`: 基本機能のテスト
- `sample_programs.py`: サンプルプログラムとデモ
- `japanese_samples.py`: 日本語構文のサンプル
- `examples/`: サンプルファイル
- `memo.txt`: 言語仕様とサンプルコード

## 教育的価値

1. **計算の本質**: 複雑な演算を基本操作の組み合わせで実現
2. **アルゴリズム思考**: 制約の中で問題解決する思考力
3. **チューリング完全性**: 最小限の機能で万能性を理解
4. **プログラミング概念**: 変数、関数、制御構造の基礎

## 実装について

このインタープリターはPythonで実装されており、以下の機能を含みます:

- 抽象構文木(AST)による構文表現
- 再帰下降パーサーによる構文解析
- 環境(環境辞書)による変数管理
- 例外による制御フローの実装

## ライセンス

MIT License

## 貢献

プルリクエストや改善提案を歓迎します。教育目的に適した機能追加や、より良い日本語構文の提案などお待ちしています。