# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['businessready']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2==2.11.2',
 'MarkupSafe==2.0.1',
 'requests>=2.27.1,<3.0.0',
 'urllib3>=1.26.8,<2.0.0',
 'xmltodict>=0.12.0,<0.13.0']

entry_points = \
{'console_scripts': ['wikimd = brd.script:run']}

setup_kwargs = {
    'name': 'businessready',
    'version': '0.9.60',
    'description': 'Transform Cisco CLIs and APIs into Business Ready Documents',
    'long_description': '[![published](https://static.production.devnetcloud.com/codeexchange/assets/images/devnet-published.svg)](https://developer.cisco.com/codeexchange/github/repo/automateyournetwork/business_ready)\n\n# business_ready\n## A Python CLI that transforms Cisco CLIs and REST APIs into "Business Ready" Documents\n\n## Getting Started\n### Business Ready has two modes of operation:\n\n#### Cisco Command Line Interface (CLI) output transformation using pyATS (Linux required)\n\n#### Cisco REST API output transformation using Python Requests (Windows or Linux friendly)\n\n### Each Business Ready Function provides the user with 5 output files:\n\n#### Comma-separated values (CSV) - Spreadsheets!\n#### HyperText Markup Language (HTML) - Webpages!\n#### Markdown (tabular) - GitHub Ready Tables!\n#### Markdown (markmap) - Mind Maps! \n#### JavaScript Object Notation (JSON) - The Raw payload\n\n### The VS Code Terminal can be used, either with Windows (REST APIs) or WSL Ubuntu (pyATS), to create a Python virtual environment and run Business Ready.\n\n### The following extensions can be used to maximize the user experience:\n\n#### Markmap (MD files)\n#### Markdown Preview (MD files)\n#### Excel Preview (CSV files)\n#### Open in Default Browser (HTML files)\n\n## Installation Guides\n\n### Cisco IOS / NXOS CLI \n#### Linux and pyATS Required\n#### The following instructions are based on Windows WSL2 and Ubuntu however any flavour of Linux will work with possibly slightly different commands.\n\n##### Confirm Python 3.9 is installed \n\n#####\n```console\n\n$ python3 -V\nPython 3.9.10\n\n```\n\n##### Create and activate a virtual environment\n\n#####\n```console\n\n$ sudo apt install python3-venv\n$ python3 -m venv demo\n$ source demo/bin/activate\n(demo)$\n\n```\n\n##### Install pyATS[full]\n\n######\n```console\n\n(demo)$ pip install pyats[full]\n\n```\n\n##### Install businessready\n\n######\n```console\n\n(demo)$ pip install businessready\n\n```\n\n### Cisco REST APIs - Windows or Linux Compatible\n\n#### Confirm Python 3.9 is installed\n##### [Download Python](https://python.org)\n\n#### Create and activate a virtual environment\n\n#####\n```console\n\nC:\\>python3 -m venv demo\nC:\\>demo\\Scripts\\activate\n(demo) C:\\>\n\n```\n\n#### Install businessready\n\n#####\n``` console\n\n(demo) C:\\>pip install buisnessready\n\n```\n\n## Usage\n### Once businessready is installed it can be used from the Python command-line\n\n### Python CLI\n#### Linux\n#####\n```console\n\n(demo)$ python3 \n>>> import businessready\n\n```\n#### Windows\n#####\n```console\n\n(demo) C:\\>python3 \n>>> import businessready\n\n```\n### Cisco CLI\n\n#### Connecting - Business Ready functions that extend pyATS require 4 parameters \n##### hostname\n##### username\n##### password\n##### IP / DNS Address\n\n#### Cisco IOS-XE\n##### All - You can run all IOS-XE Learn And Show functions to fully document a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.IOS_all("hostname","username","password","IP / DNS Address")\n\n```\n##### Learn All - You can run all IOS-XE Learn functions to fully learn a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.IOS_learn_all("hostname","username","password","IP / DNS Address")\n\n```\n\n##### Show All - You can run all IOS-XE Show functions to fully parse a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.IOS_show_all("hostname","username","password","IP / DNS Address")\n\n```\n##### Individual Learn / Show Functions - You can run individual learn or show commands as well if you are looking for something specific \n###### \n``` console\n\n>>> import businessready \n>>> businessready.IOS_learn_{{ function }}("hostname","username","password","IP / DNS Address")\n>>> businessready.IOS_show_{{ show command }}("hostname","username","password","IP / DNS Address")\n\n```\n\n#### Cisco NXOS\n##### All - You can run all NXOS Learn And Show functions to fully document a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.NXOS_all("hostname","username","password","IP / DNS Address")\n\n```\n##### Learn All - You can run all NXOS Learn functions to fully learn a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.NXOS_learn_all("hostname","username","password","IP / DNS Address")\n\n```\n\n##### Show All - You can run all NXOS-XE Show functions to fully parse a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.NXOS_show_all("hostname","username","password","IP / DNS Address")\n\n```\n##### Individual Learn / Show Functions - You can run individual learn or show commands as well if you are looking for something specific \n###### \n``` console\n\n>>> import businessready \n>>> businessready.NXOS_learn_{{ function }}("hostname","username","password","IP / DNS Address")\n>>> businessready.NXOS_show_{{ show command }}("hostname","username","password","IP / DNS Address")\n\n```\n\n### Cisco Digital Network Architecture Center (DNAC)\n#### Connecting - Business Ready functions that extend DNAC REST APIs require 3 parameters \n##### DNAC URL\n##### username\n##### password\n##### IP / DNS Address\n#### All - You can run all DNAC REST API functions to fully document a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.DNAC_all("url","username","password")\n\n```\n#### Individual REST APIs - You can run individual REST API as well if you are looking for something specific \n##### \n``` console\n\n>>> import businessready \n>>> businessready.DNAC_{{ REST API }}("url","username","password")\n\n```\n### Meraki Dashboard\n#### Connecting - Business Ready functions that extend Meraki Dashboard REST APIs require 3 parameters \n##### Meraki URL\n##### Dashboard Token\n#### All - You can run all Meraki REST API functions to fully document a device with one command\n###### \n``` console\n\n>>> import businessready \n>>> businessready.Meraki_all("url","Dashboard Token")\n\n```\n#### Individual REST APIs - You can run individual REST API as well if you are looking for something specific \n##### \n``` console\n\n>>> import businessready \n>>> businessready.Meraki_{{ REST API }}("url","Dashboard Token")\n\n```\n\n* In Development\n### Cisco Identity Services Engine (ISE)\n* In Development\n\n## Topology Examples\n\n### If you have more than one device you want to transform Business Ready can handle multiple devices in a variety of ways\n\n### Python Array Source\n\n#### The included python_for_loop_example.py file\n\n#### \n```python\n\nimport businessready\n\ndevice01_info = ["dist-rtr01", "cisco", "cisco", "10.10.20.175"]\ndevice02_info = ["dist-rtr02", "cisco", "cisco", "10.10.20.176"]\n\ndevice_list = [device01_info, device02_info]\n\nfor device in device_list:\n    businessready.NXOS_learn_all(*device)\n\n```\n\n### pyATS YAML Testbed Source\n\n#### The included from_testbed_example.py\n\n####\n\n```python\n\nimport businessready\nimport yaml\n\nwith open(\'testbed.yml\') as info:\n    info_dict = yaml.safe_load(info)\n\nfor device in info_dict[\'devices\']:\n    if info_dict[\'devices\'][device][\'os\'] == "iosxe":\n        businessready.IOS_learn_all(device,info_dict[\'devices\'][device][\'credentials\'][\'default\'][\'username\'],info_dict[\'devices\'][device][\'credentials\'][\'default\'][\'password\'],info_dict[\'devices\'][device][\'connections\'][\'cli\'][\'ip\'])\n    elif info_dict[\'devices\'][device][\'os\'] == "nxos":\n        businessready.NXOS_learn_all(device,info_dict[\'devices\'][device][\'credentials\'][\'default\'][\'username\'],info_dict[\'devices\'][device][\'credentials\'][\'default\'][\'password\'],info_dict[\'devices\'][device][\'connections\'][\'cli\'][\'ip\'])\n\n```\n\n### CSV Source\n\n#### The included from_csv_example.py\n\n####\n\n```python\n\nimport businessready\nimport csv\n\nwith open(\'spreadsheet.csv\') as info:\n    for line in csv.DictReader(info):\n\t    info_dict = line\n        print(info_dict)\n\t    if info_dict[\'os\'] == "iosxe":\n            businessready.IOS_all(info_dict[\'hostname\'],info_dict[\'username\'],info_dict[\'password\'],info_dict[\'ip\'])\n\t    elif info_dict[\'os\'] == "nxos":\n            businessready.NXOS_all(info_dict[\'hostname\'],info_dict[\'username\'],info_dict[\'password\'],info_dict[\'ip\'])\n\n```\n\n## Function Libary\n### IOS-XE\n#### All\n##### businessready.IOS_all()\n##### businessready.IOS_learn_all()\n##### businessready.IOS_show_all()\n#### Learn\n##### businessready.IOS_learn_all()\n##### businessready.IOS_learn_acl()\n##### businessready.IOS_learn_arp()\n##### businessready.IOS_learn_bgp()\n##### businessready.IOS_learn_dot1x()\n##### businessready.IOS_learn_hsrp()\n##### businessready.IOS_learn_interface()\n##### businessready.IOS_learn_lldp()\n##### businessready.IOS_learn_ntp()\n##### businessready.IOS_learn_ospf(ho \n##### businessready.IOS_learn_routing()\n##### businessready.IOS_learn_stp()\n##### businessready.IOS_learn_vlan()\n##### businessready.IOS_learn_vrf()\n#### Show\n##### businessready.IOS_show_all()\n##### businessready.IOS_show_access_lists()\n##### businessready.IOS_show_cdp_neighbors()\n##### businessready.IOS_show_cdp_neighbors_detail()\n##### businessready.IOS_show_environment_all()\n##### businessready.IOS_show_etherchannel_summary()\n##### businessready.IOS_show_interfaces()\n##### businessready.IOS_show_interfaces_status()\n##### businessready.IOS_show_interfaces_trunk()\n##### businessready.IOS_show_inventory_9000()\n##### businessready.IOS_show_ip_arp()\n##### businessready.IOS_show_ip_interface_brief()\n##### businessready.IOS_show_ip_ospf()\n##### businessready.IOS_show_ip_ospf_database()\n##### businessready.IOS_show_ip_ospf_interface()\n##### businessready.IOS_show_ip_ospf_neighbor()\n##### businessready.IOS_show_ip_ospf_neighbor_detail()\n##### businessready.IOS_show_ip_route()\n##### businessready.IOS_show_license_summary()\n##### businessready.IOS_show_mac_address_table()\n##### businessready.IOS_show_ntp_associations()\n##### businessready.IOS_show_wlan_all()\n##### businessready.IOS_show_wlan_client_stats()\n##### businessready.IOS_show_wlan_summary()\n##### businessready.IOS_show_wireless_profile_summary()\n##### businessready.IOS_show_wireless_profile_detailed()\n##### businessready.IOS_show_version()\n##### businessready.IOS_show_vlan()\n##### businessready.IOS_show_vrf()\n### NXOS\n#### All\n##### businessready.NXOS_all()\n##### businessready.NXOS_learn_all()\n##### businessready.NXOS_show_all()\n#### Learn\n##### businessready.NXOS_learn_all()\n##### businessready.NXOS_learn_acl()\n##### businessready.NXOS_learn_arp()\n##### businessready.NXOS_learn_bgp()\n##### businessready.NXOS_learn_hsrp()\n##### businessready.NXOS_learn_interface()\n##### businessready.NXOS_learn_ospf()\n##### businessready.NXOS_learn_platform()\n##### businessready.NXOS_learn_routing()\n##### businessready.NXOS_learn_vlan()\n##### businessready.NXOS_learn_vrf()\n#### Show\n##### businessready.NXOS_show_access_lists()\n##### businessready.NXOS_show_bgp_process_vrf_all()\n##### businessready.NXOS_show_bgp_sessions()\n##### businessready.NXOS_show_cdp_neighbors()\n##### businessready.NXOS_show_cdp_neighbors_detail()\n##### businessready.NXOS_show_environment()\n##### businessready.NXOS_show_interface()\n##### businessready.NXOS_show_interface_status()\n##### businessready.NXOS_show_interface_transceiver()\n##### businessready.NXOS_show_inventory()\n##### businessready.NXOS_show_ip_arp_vrf()\n##### businessready.NXOS_show_ip_interface_brief()\n##### businessready.NXOS_show_ip_ospf()\n##### businessready.NXOS_show_ip_ospf_interface()\n##### businessready.NXOS_show_ip_ospf_neighbors_deta)\n##### businessready.NXOS_show_ip_ospf_neighbors_detail_vrf()\n##### businessready.NXOS_show_ip_ospf_vrf()\n##### businessready.NXOS_show_ip_ospf_interface_vrf()\n##### businessready.NXOS_show_ip_route()\n##### businessready.NXOS_show_ip_route_vrf()\n##### businessready.NXOS_show_mac_address_table()\n##### businessready.NXOS_show_port_channel_summary()\n##### businessready.NXOS_show_version()\n##### businessready.NXOS_show_vlan()\n##### businessready.NXOS_show_vrf()\n##### businessready.NXOS_show_vrf_all_detail()\n##### businessready.NXOS_show_vrf_all_interface()\n##### businessready.NXOS_show_vrf_detail()\n### DNAC\n#### businessready.DNAC_sites()\n#### businessready.DNAC_sites()\n#### businessready.DNAC_site_health()\n#### businessready.DNAC_site_member()\n#### businessready.DNAC_vlan()\n#### businessready.DNAC_vlan_topology()\n#### businessready.DNAC_physical_topology()\n#### businessready.DNAC_routing_topology()\n#### businessready.DNAC_network_health()\n#### businessready.DNAC_device()\n#### businessready.DNAC_swim()\n#### businessready.DNAC_projects()\n#### businessready.DNAC_templates()\n#### businessready.DNAC_rf_profiles()\n#### businessready.DNAC_assurance_tests()\n#### businessready.DNAC_flow_analysis()\n### Meraki\n#### businessready.Meraki_all()\n#### businessready.Meraki_organizations()\n#### businessready.Meraki_organization_devices()\n#### businessready.Meraki_organization_licenses()\n#### businessready.Meraki_organization_adaptive_policies()\n#### businessready.Meraki_organization_admins()\n#### businessready.Meraki_organization_alert_profiles()\n#### businessready.Meraki_organization_branding_policy()\n#### businessready.Meraki_organization_clients()\n',
    'author': 'John Capobianco',
    'author_email': 'ptcapo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/automateyournetwork/business_ready',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
