from dlubal.api.rfem import object_id_pb2 as _object_id_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class CalculationDiagram(_message.Message):
    __slots__ = ("no", "user_defined_name_enabled", "name", "diagram_type", "analysis_type", "case", "horizontal_axis_result_type", "horizontal_axis_value", "horizontal_axis_object", "horizontal_axis_node", "vertical_axis_result_type", "vertical_axis_value", "vertical_axis_object", "vertical_axis_node", "table", "comment", "id_for_export_import", "metadata_for_export_import")
    class DiagramType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DIAGRAM_TYPE_UNKNOWN: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_BASIC: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_CHAINED: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_CONVERGENCE: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_GROUP: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_HINGE: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_PUSHOVER_ADRS: _ClassVar[CalculationDiagram.DiagramType]
        DIAGRAM_TYPE_2D_STORY: _ClassVar[CalculationDiagram.DiagramType]
    DIAGRAM_TYPE_UNKNOWN: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_BASIC: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_CHAINED: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_CONVERGENCE: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_GROUP: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_HINGE: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_PUSHOVER_ADRS: CalculationDiagram.DiagramType
    DIAGRAM_TYPE_2D_STORY: CalculationDiagram.DiagramType
    class AnalysisType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ANALYSIS_TYPE_STATIC: _ClassVar[CalculationDiagram.AnalysisType]
        ANALYSIS_TYPE_PUSHOVER: _ClassVar[CalculationDiagram.AnalysisType]
        ANALYSIS_TYPE_SPECTRAL: _ClassVar[CalculationDiagram.AnalysisType]
        ANALYSIS_TYPE_STABILITY_INCREMENTAL: _ClassVar[CalculationDiagram.AnalysisType]
        ANALYSIS_TYPE_TIME_HISTORY: _ClassVar[CalculationDiagram.AnalysisType]
    ANALYSIS_TYPE_STATIC: CalculationDiagram.AnalysisType
    ANALYSIS_TYPE_PUSHOVER: CalculationDiagram.AnalysisType
    ANALYSIS_TYPE_SPECTRAL: CalculationDiagram.AnalysisType
    ANALYSIS_TYPE_STABILITY_INCREMENTAL: CalculationDiagram.AnalysisType
    ANALYSIS_TYPE_TIME_HISTORY: CalculationDiagram.AnalysisType
    class HorizontalAxisResultType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        HORIZONTAL_AXIS_RESULT_TYPE_NODE_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_INCREMENT_ITERATION: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_MAXIMUM_DEFORMATION: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_INCREMENT: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_LINE_SUM_OF_SUPPORT_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_LOAD_FACTOR: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MAXIMUM_DEFORMATION: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_CONTACT_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS_FORCES_ABSOLUTE: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_HINGE_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_INTERNAL_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_LOCAL_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_NODE_ACCELERATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_NODE_VELOCITIES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM_BILINEAR: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_BILINEAR_SPECTRUMS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_SPECTRUMS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_SPECTRUM: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DISPLACEMENT: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_BASIC_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_BASIC_STRESSES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_BASIC_TOTAL_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_STRESSES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_TOTAL_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_GAS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_STRESSES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_TOTAL_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_STORY_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_STORY_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_STORY_GLOBAL_Z_BUILDING_DIRECTION: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_STORY_RELATIVE_POSITION: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_STORY_SENSITIVITY_COEFFICIENTS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SUM_OF_SUPPORT_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_LINE_SUPPORTS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_NODAL_SUPPORTS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_INTERNAL_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_STRESSES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_TOTAL_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_CONTACT_STRESSES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_DESIGN_INTERNAL_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_LOCAL_DEFORMATIONS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_TOTAL_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_BACH_P: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_MISES_P: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_RANKINE_P: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_TRESCA_P: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_INTERNAL_FORCES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_STRESSES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_TOTAL_STRAINS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_BACH: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_MISES: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESS_COMPONENTS: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
        HORIZONTAL_AXIS_RESULT_TYPE_TIME: _ClassVar[CalculationDiagram.HorizontalAxisResultType]
    HORIZONTAL_AXIS_RESULT_TYPE_NODE_GLOBAL_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_INCREMENT_ITERATION: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_MAXIMUM_DEFORMATION: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_INCREMENT: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_LINE_SUM_OF_SUPPORT_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_LOAD_FACTOR: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MAXIMUM_DEFORMATION: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_CONTACT_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_GLOBAL_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS_FORCES_ABSOLUTE: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_HINGE_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_INTERNAL_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_LOCAL_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_MEMBER_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_NODE_ACCELERATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_NODE_VELOCITIES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM_BILINEAR: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_BILINEAR_SPECTRUMS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_SPECTRUMS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_SPECTRUM: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DISPLACEMENT: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_BASIC_PLASTIC_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_BASIC_STRESSES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_BASIC_TOTAL_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_PLASTIC_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_STRESSES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_TOTAL_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_GAS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_GLOBAL_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_PLASTIC_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_STRESSES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_TOTAL_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_STORY_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_STORY_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_STORY_GLOBAL_Z_BUILDING_DIRECTION: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_STORY_RELATIVE_POSITION: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_STORY_SENSITIVITY_COEFFICIENTS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SUM_OF_SUPPORT_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_LINE_SUPPORTS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_NODAL_SUPPORTS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_INTERNAL_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_PLASTIC_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_STRESSES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_BASIC_TOTAL_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_CONTACT_STRESSES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_DESIGN_INTERNAL_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_GLOBAL_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_LOCAL_DEFORMATIONS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_PLASTIC_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_TOTAL_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_BACH_P: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_MISES_P: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_RANKINE_P: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_TRESCA_P: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_INTERNAL_FORCES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_PLASTIC_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_STRESSES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_TOTAL_STRAINS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_BACH: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_MISES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_RANKINE: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_TRESCA: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_BACH: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_MISES: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_RANKINE: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_TRESCA: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_SURFACE_STRESS_COMPONENTS: CalculationDiagram.HorizontalAxisResultType
    HORIZONTAL_AXIS_RESULT_TYPE_TIME: CalculationDiagram.HorizontalAxisResultType
    class HorizontalAxisValue(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_FORCE_FX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_FORCE_FY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_FORCE_FZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_PHI: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_M_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_PRI: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_SEC: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_M_OMEGA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_N: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_P: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_WARPING: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_MEMBER_HINGES_DEFORMATIONS_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_EPS_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XU: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XV: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_V: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MOMENT_MX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MOMENT_MY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_MOMENT_MZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_EQUIVALENT_PLASTIC_STRAINS_END: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_INITIAL_PRESSURE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_OVERPRESSURE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_TEMPERATURE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_VOLUME: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_1: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_123: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_2: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_3: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_YZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_1: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_123: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_2: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_3: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_YZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_1: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_123: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_2: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_3: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_MAX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_YZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MXY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NXY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VY: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_SIGMA_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_XZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_YZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NC_D: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NX_D: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NY_D: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_BETA_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M1: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M2: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_MT_MAX_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N1: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N2: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_BACH: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_MISES: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_RANKINE: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_TRESCA: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_MAX: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_B: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_M: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_MINUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_PLUS: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
        HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_YZ: _ClassVar[CalculationDiagram.HorizontalAxisValue]
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_FORCE_FX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_FORCE_FY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_FORCE_FZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_PHI: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_M_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_PRI: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_SEC: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_M_OMEGA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_N: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_P: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_WARPING: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_MEMBER_HINGES_DEFORMATIONS_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_EPS_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XU: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XV: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_V: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MOMENT_MX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MOMENT_MY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_MOMENT_MZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_EQUIVALENT_PLASTIC_STRAINS_END: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_INITIAL_PRESSURE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_OVERPRESSURE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_TEMPERATURE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_GAS_VOLUME: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_1: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_123: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_2: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_3: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_YZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_1: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_123: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_2: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_3: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_YZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_1: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_123: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_2: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_3: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_MAX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_YZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MXY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NXY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VY: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_SIGMA_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_XZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_YZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NC_D: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NX_D: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NY_D: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_X: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Y: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Z: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_BETA_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M1: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M2: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_MT_MAX_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N1: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N2: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_BACH: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_MISES: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_RANKINE: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_TRESCA: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_MAX: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_B: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_M: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_MINUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_PLUS: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XZ: CalculationDiagram.HorizontalAxisValue
    HORIZONTAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_YZ: CalculationDiagram.HorizontalAxisValue
    class VerticalAxisResultType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        VERTICAL_AXIS_RESULT_TYPE_NODE_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_INCREMENT_ITERATION: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_MAXIMUM_DEFORMATION: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_INCREMENT: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_LINE_SUM_OF_SUPPORT_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_LOAD_FACTOR: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MAXIMUM_DEFORMATION: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_CONTACT_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS_FORCES_ABSOLUTE: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_HINGE_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_INTERNAL_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_LOCAL_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_MEMBER_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_NODE_ACCELERATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_NODE_VELOCITIES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM_BILINEAR: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_BILINEAR_SPECTRUMS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_SPECTRUMS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_SPECTRUM: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DISPLACEMENT: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_BASIC_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_BASIC_STRESSES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_BASIC_TOTAL_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_STRESSES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_TOTAL_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_GAS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_STRESSES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_TOTAL_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_STORY_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_STORY_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_STORY_GLOBAL_Z_BUILDING_DIRECTION: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_STORY_RELATIVE_POSITION: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_STORY_SENSITIVITY_COEFFICIENTS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SUM_OF_SUPPORT_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_LINE_SUPPORTS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_NODAL_SUPPORTS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_INTERNAL_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_STRESSES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_TOTAL_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_CONTACT_STRESSES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_DESIGN_INTERNAL_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_GLOBAL_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_LOCAL_DEFORMATIONS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_TOTAL_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_BACH_P: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_MISES_P: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_RANKINE_P: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_TRESCA_P: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_INTERNAL_FORCES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_PLASTIC_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_STRESSES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_TOTAL_STRAINS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_BACH: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_MISES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_BACH: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_MISES: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESS_COMPONENTS: _ClassVar[CalculationDiagram.VerticalAxisResultType]
        VERTICAL_AXIS_RESULT_TYPE_TIME: _ClassVar[CalculationDiagram.VerticalAxisResultType]
    VERTICAL_AXIS_RESULT_TYPE_NODE_GLOBAL_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_INCREMENT_ITERATION: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_CONVERGENCE_DIAGRAM_MAXIMUM_DEFORMATION: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_INCREMENT: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_LINE_SUM_OF_SUPPORT_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_LOAD_FACTOR: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MAXIMUM_DEFORMATION: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_CONTACT_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_GLOBAL_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_HINGE_DEFORMATIONS_FORCES_ABSOLUTE: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_HINGE_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_INTERNAL_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_LOCAL_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_MEMBER_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_NODE_ACCELERATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_NODE_VELOCITIES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_CAPACITY_SPECTRUM_BILINEAR: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_BILINEAR_SPECTRUMS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_AND_CAPACITY_SPECTRUMS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DEMAND_SPECTRUM: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_PUSHOVER_ADRS_DIAGRAM_DISPLACEMENT: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_BASIC_PLASTIC_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_BASIC_STRESSES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_BASIC_TOTAL_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_PLASTIC_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_STRESSES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_EQUIVALENT_TOTAL_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_GAS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_GLOBAL_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_PLASTIC_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_STRESSES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SOLID_PRINCIPAL_TOTAL_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_STORY_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_STORY_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_STORY_GLOBAL_Z_BUILDING_DIRECTION: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_STORY_RELATIVE_POSITION: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_STORY_SENSITIVITY_COEFFICIENTS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SUM_OF_SUPPORT_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_LINE_SUPPORTS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SUPPORT_REACTIONS_NODAL_SUPPORTS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_INTERNAL_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_PLASTIC_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_STRESSES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_BASIC_TOTAL_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_CONTACT_STRESSES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_DESIGN_INTERNAL_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_GLOBAL_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_LOCAL_DEFORMATIONS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_PLASTIC_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_MAXIMUM_TOTAL_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_BACH_P: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_MISES_P: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_RANKINE_P: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PLASTIC_STRAINS_TRESCA_P: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_INTERNAL_FORCES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_PLASTIC_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_STRESSES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_PRINCIPAL_TOTAL_STRAINS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_BACH: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_MISES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_RANKINE: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRAINS_TRESCA: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_BACH: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_MISES: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_RANKINE: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESSES_SIGMA_EQV_TRESCA: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_SURFACE_STRESS_COMPONENTS: CalculationDiagram.VerticalAxisResultType
    VERTICAL_AXIS_RESULT_TYPE_TIME: CalculationDiagram.VerticalAxisResultType
    class VerticalAxisValue(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_FORCE_FX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_FORCE_FY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_FORCE_FZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_PHI: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_M_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_PRI: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_SEC: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_M_OMEGA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_N: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_P: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_WARPING: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_MEMBER_HINGES_DEFORMATIONS_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_EPS_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XU: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XV: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_V: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MOMENT_MX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MOMENT_MY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_MOMENT_MZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_EQUIVALENT_PLASTIC_STRAINS_END: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_INITIAL_PRESSURE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_OVERPRESSURE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_TEMPERATURE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_VOLUME: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_1: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_123: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_2: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_3: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_YZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_1: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_123: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_2: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_3: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_YZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_1: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_123: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_2: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_3: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_MAX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_YZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MXY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NXY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VY: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_SIGMA_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_XZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_YZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NC_D: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NX_D: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NY_D: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_X: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Y: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Z: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_BETA_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M1: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M2: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_MT_MAX_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N1: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N2: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_BACH: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_MISES: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_RANKINE: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_TRESCA: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_MAX: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_B: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_M: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_MINUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_PLUS: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
        VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_YZ: _ClassVar[CalculationDiagram.VerticalAxisValue]
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_BUILDING_STORIES_SENSITIVITY_COEFFICIENT_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_FORCE_FX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_FORCE_FY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_FORCE_FZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_GLOBAL_DEFORMATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_PHI: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MAXIMUM_DEFORMATIONS_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_M_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_PRINCIPAL_AXES_P_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_CONTACT_FORCES_P_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_DEFORMATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_FORCE_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_GLOBAL_MEMBER_HINGES_FORCES_MOMENT_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_PRI: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MT_SEC: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_MZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_M_OMEGA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_N: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_P: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_M_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_PRINCIPAL_AXES_V_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_INTERNAL_FORCES_VZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_PHI_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_PRINCIPAL_AXES_U_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_DEFORMATIONS_WARPING: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_DEFORMATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_FORCE_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_LOCAL_MEMBER_HINGES_FORCES_MOMENT_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_MEMBER_HINGES_DEFORMATIONS_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_EPS_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_GAMMA_XZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_KAPPA_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XU: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_GAMMA_XV: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_STRAINS_PRINCIPAL_AXES_KAPPA_V: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_DEFORMATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_FORCE_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MEMBER_RESULTS_USER_MEMBER_HINGES_FORCES_MOMENT_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MOMENT_MX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MOMENT_MY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_MOMENT_MZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_EQUIVALENT_PLASTIC_STRAINS_END: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_INITIAL_PRESSURE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_OVERPRESSURE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_TEMPERATURE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_GAS_VOLUME: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_1: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_123: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_2: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_3: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_P_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_EPSILON_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_XZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_PLASTIC_STRAINS_GAMMA_P_YZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_1: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_123: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_2: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_3: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_EPSILON_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_XZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRAINS_GAMMA_YZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_1: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_123: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_2: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_3: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_EQV_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_SIGMA_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_MAX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_XZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SOLID_RESULTS_STRESSES_TAU_YZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_ACCELERATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SPECTRAL_ANALYSIS_VELOCITIES_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_GLOBAL_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUM_OF_SUPPORT_FORCES_LOCAL_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_M_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_GLOBAL_P_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_M_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_LINE_SUPPORTS_LOCAL_P_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_M_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_GLOBAL_P_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_M_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SUPPORT_REACTIONS_NODAL_SUPPORTS_LOCAL_P_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MXY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_MY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NXY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_NY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_BASIC_INTERNAL_FORCES_VY: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_SIGMA_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_XZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_CONTACT_STRESSES_TAU_YZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MC_D_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MX_D_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_MY_D_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NC_D: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NX_D: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_DESIGN_INTERNAL_FORCES_NY_D: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_PHI_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_X: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Y: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_LOCAL_DEFORMATIONS_U_Z: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ABS_EPSILON_P_MAX_PLUS_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_ALPHA_P_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_1_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_2_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_PLUS_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MAX_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MINUS_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_MIN_PLUS_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_PLUS_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_X_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_EPSILON_P_Y_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PLASTIC_STRAINS_GAMMA_P_XY_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_ALFA_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_BETA_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M1: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_M2: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_MT_MAX_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N1: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_N2: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_PRINCIPAL_INTERNAL_FORCES_V_MAX_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ABS_EPSILON_MAX_PLUS_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_ALPHA_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_1_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_2_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_PLUS_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MAX_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MINUS_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_MIN_PLUS_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_PLUS_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_X_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_EPSILON_Y_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRAINS_GAMMA_XY_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_ALFA_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_1_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_2_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MAX_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_MINUS_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_M_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_BACH: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_MISES: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_RANKINE: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_EQV_PLUS_TRESCA: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_X_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_SIGMA_Y_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_MAX: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_B: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_M: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_MINUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XY_PLUS: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_XZ: CalculationDiagram.VerticalAxisValue
    VERTICAL_AXIS_VALUE_SURFACE_RESULTS_STRESSES_TAU_YZ: CalculationDiagram.VerticalAxisValue
    class Table(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[CalculationDiagram.TableRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[CalculationDiagram.TableRow, _Mapping]]] = ...) -> None: ...
    class TableRow(_message.Message):
        __slots__ = ("no", "description", "iteration_no", "load_factor", "horizontal_axis_value", "vertical_axis_value")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ITERATION_NO_FIELD_NUMBER: _ClassVar[int]
        LOAD_FACTOR_FIELD_NUMBER: _ClassVar[int]
        HORIZONTAL_AXIS_VALUE_FIELD_NUMBER: _ClassVar[int]
        VERTICAL_AXIS_VALUE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        iteration_no: int
        load_factor: float
        horizontal_axis_value: float
        vertical_axis_value: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., iteration_no: _Optional[int] = ..., load_factor: _Optional[float] = ..., horizontal_axis_value: _Optional[float] = ..., vertical_axis_value: _Optional[float] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_NAME_ENABLED_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DIAGRAM_TYPE_FIELD_NUMBER: _ClassVar[int]
    ANALYSIS_TYPE_FIELD_NUMBER: _ClassVar[int]
    CASE_FIELD_NUMBER: _ClassVar[int]
    HORIZONTAL_AXIS_RESULT_TYPE_FIELD_NUMBER: _ClassVar[int]
    HORIZONTAL_AXIS_VALUE_FIELD_NUMBER: _ClassVar[int]
    HORIZONTAL_AXIS_OBJECT_FIELD_NUMBER: _ClassVar[int]
    HORIZONTAL_AXIS_NODE_FIELD_NUMBER: _ClassVar[int]
    VERTICAL_AXIS_RESULT_TYPE_FIELD_NUMBER: _ClassVar[int]
    VERTICAL_AXIS_VALUE_FIELD_NUMBER: _ClassVar[int]
    VERTICAL_AXIS_OBJECT_FIELD_NUMBER: _ClassVar[int]
    VERTICAL_AXIS_NODE_FIELD_NUMBER: _ClassVar[int]
    TABLE_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    user_defined_name_enabled: bool
    name: str
    diagram_type: CalculationDiagram.DiagramType
    analysis_type: CalculationDiagram.AnalysisType
    case: _object_id_pb2.ObjectId
    horizontal_axis_result_type: CalculationDiagram.HorizontalAxisResultType
    horizontal_axis_value: CalculationDiagram.HorizontalAxisValue
    horizontal_axis_object: _object_id_pb2.ObjectId
    horizontal_axis_node: int
    vertical_axis_result_type: CalculationDiagram.VerticalAxisResultType
    vertical_axis_value: CalculationDiagram.VerticalAxisValue
    vertical_axis_object: _object_id_pb2.ObjectId
    vertical_axis_node: int
    table: CalculationDiagram.Table
    comment: str
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., user_defined_name_enabled: bool = ..., name: _Optional[str] = ..., diagram_type: _Optional[_Union[CalculationDiagram.DiagramType, str]] = ..., analysis_type: _Optional[_Union[CalculationDiagram.AnalysisType, str]] = ..., case: _Optional[_Union[_object_id_pb2.ObjectId, _Mapping]] = ..., horizontal_axis_result_type: _Optional[_Union[CalculationDiagram.HorizontalAxisResultType, str]] = ..., horizontal_axis_value: _Optional[_Union[CalculationDiagram.HorizontalAxisValue, str]] = ..., horizontal_axis_object: _Optional[_Union[_object_id_pb2.ObjectId, _Mapping]] = ..., horizontal_axis_node: _Optional[int] = ..., vertical_axis_result_type: _Optional[_Union[CalculationDiagram.VerticalAxisResultType, str]] = ..., vertical_axis_value: _Optional[_Union[CalculationDiagram.VerticalAxisValue, str]] = ..., vertical_axis_object: _Optional[_Union[_object_id_pb2.ObjectId, _Mapping]] = ..., vertical_axis_node: _Optional[int] = ..., table: _Optional[_Union[CalculationDiagram.Table, _Mapping]] = ..., comment: _Optional[str] = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
