from dlubal.api.common import common_pb2 as _common_pb2
from dlubal.api.rfem import object_id_pb2 as _object_id_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class LoadCase(_message.Message):
    __slots__ = ("no", "analysis_type", "name", "calculate_critical_load", "static_analysis_settings", "stability_analysis_settings", "modal_analysis_settings", "spectral_analysis_settings", "consider_imperfection", "imperfection_case", "consider_initial_state", "initial_state_case", "initial_state_definition_type", "individual_factors_of_selected_objects_table", "consider_construction_stage", "construction_stage_case", "to_solve", "action_category", "self_weight_active", "self_weight_factors", "self_weight_factor_x", "self_weight_factor_y", "self_weight_factor_z", "factor_phi", "load_duration", "loading_start", "time_being_investigated", "import_masses_from", "import_modal_analysis_from", "selection_of_modes_mode_activation_table", "selection_of_modes_deselect_modes_according_to_criterion_is_enabled", "selection_of_modes_deselect_modes_modes_according_to_criterion_value", "selection_of_modes_total_effective_modal_mass_factor_f_mex", "selection_of_modes_total_effective_modal_mass_factor_f_mey", "selection_of_modes_total_effective_modal_mass_factor_f_mez", "comment", "is_generated", "generating_object_info", "structure_modification_enabled", "structure_modification", "possibility_of_crowds", "specification_for_load_case_gr1a", "specification_for_load_case_gr2", "specification_for_load_case_gr5", "specification_for_load_case_gr6", "liveload_less_equal_100", "liveload_consider_design_situation_effective_seismic_weight_check", "liveload_consider_design_situation_effective_seismic_weight_combo", "liveload_consider_design_situation_effective_seismic_weight_CYTHYE_check", "liveload_consider_design_situation_effective_seismic_weight_CYTHYE_combo", "liveload_consider_design_situation_seismic_weight_check", "liveload_consider_design_situation_seismic_weight_combo", "liveload_consider_design_situation_seismic_mass_check", "liveload_consider_design_situation_seismic_mass_combo", "consider_design_situation_effective_seismic_weight", "liveload_less_equal_48", "liveload_consider_design_situation_effective_seismic_weight_aci_check", "liveload_consider_design_situation_effective_seismic_weight_aci_combo", "liveload_less_equal_100_ibc", "liveload_consider_design_situation_effective_seismic_weight_ibc_check", "liveload_consider_design_situation_effective_seismic_weight_ibc_combo", "cranehookload_nocombined_roofliveload", "roof_configurations_that_do_not_shed_snow", "flat_roof_snow_load", "flat_roof_snow_load_category", "deadload_factor_shall_be_increased", "deadload_factor_shall_be_increased1", "deadload_factor_shall_be_increased2", "dead_no_effective_seismic_weight_NBC05", "dead_no_effective_seismic_weight_NBC15", "liveload_principal_factor_may_be_reduced1", "liveload_companion_factor_may_be_increased1", "liveload_principal_factor_may_be_reduced2", "liveload_companion_factor_may_be_increased2", "consider_design_situation_effective_seismic_weight_NBC05", "consider_design_situation_effective_seismic_weight_NBC15", "dead_no_effective_seismic_weight", "longtermload_tp_considered_in_limit_state_of_serviceability", "greater_intensity_than_4", "distinguish_different_overstrength_factor_in_direction_xy_check", "distinguish_different_overstrength_factor_in_direction_xy_combo", "load_duration_sp", "ground_water_elevation", "direction_x_check", "direction_y_check", "consider_inclusive_load_case", "inclusive_load_case", "consider_design_situation_seismic_mass_combination", "type_of_imposed_actions", "wind_simulation_wind_direction_angle", "wind_simulation_wind_tunnel_depth_minus_coefficient", "wind_simulation_wind_tunnel_depth_plus_coefficient", "wind_simulation_wind_tunnel_width_minus_coefficient", "wind_simulation_wind_tunnel_width_plus_coefficient", "wind_simulation_wind_tunnel_height_plus_coefficient", "wind_simulation_construction_bounding_box_depth_coefficient", "wind_simulation_construction_bounding_box_height_coefficient", "wind_simulation_construction_bounding_box_width_coefficient", "wind_simulation_wind_tunnel_depth_coefficient", "wind_simulation_wind_tunnel_width_coefficient", "wind_simulation_wind_tunnel_height_coefficient", "wind_simulation_wind_profile", "wind_simulation_analysis_settings", "wind_simulation_wind_tunnel_depth_minus_length", "wind_simulation_wind_tunnel_depth_plus_length", "wind_simulation_wind_tunnel_width_minus_length", "wind_simulation_wind_tunnel_width_plus_length", "wind_simulation_wind_tunnel_height_plus_length", "wind_simulation_construction_bounding_box_depth", "wind_simulation_construction_bounding_box_height", "wind_simulation_construction_bounding_box_width", "wind_simulation_wind_tunnel_depth", "wind_simulation_wind_tunnel_width", "wind_simulation_wind_tunnel_height", "geotechnical_analysis_reset_small_strain_history", "id_for_export_import", "metadata_for_export_import")
    class AnalysisType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ANALYSIS_TYPE_UNKNOWN: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_CUTTING_PATTERN_ANALYSIS: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_EQUIVALENT_LOAD_ANALYSIS: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_MODAL_ANALYSIS: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_RESPONSE_SPECTRUM_ANALYSIS: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_STATIC_ANALYSIS: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_STATIC_CREEP_AND_SHRINKAGE: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_STATIC_TIME_DEPENDENCE: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_TIME_HISTORY: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_TIME_HISTORY_TIME_DIAGRAM: _ClassVar[LoadCase.AnalysisType]
        ANALYSIS_TYPE_WIND_SIMULATION: _ClassVar[LoadCase.AnalysisType]
    ANALYSIS_TYPE_UNKNOWN: LoadCase.AnalysisType
    ANALYSIS_TYPE_CUTTING_PATTERN_ANALYSIS: LoadCase.AnalysisType
    ANALYSIS_TYPE_EQUIVALENT_LOAD_ANALYSIS: LoadCase.AnalysisType
    ANALYSIS_TYPE_MODAL_ANALYSIS: LoadCase.AnalysisType
    ANALYSIS_TYPE_RESPONSE_SPECTRUM_ANALYSIS: LoadCase.AnalysisType
    ANALYSIS_TYPE_STATIC_ANALYSIS: LoadCase.AnalysisType
    ANALYSIS_TYPE_STATIC_CREEP_AND_SHRINKAGE: LoadCase.AnalysisType
    ANALYSIS_TYPE_STATIC_TIME_DEPENDENCE: LoadCase.AnalysisType
    ANALYSIS_TYPE_TIME_HISTORY: LoadCase.AnalysisType
    ANALYSIS_TYPE_TIME_HISTORY_TIME_DIAGRAM: LoadCase.AnalysisType
    ANALYSIS_TYPE_WIND_SIMULATION: LoadCase.AnalysisType
    class InitialStateDefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        INITIAL_STATE_DEFINITION_TYPE_FINAL_STATE: _ClassVar[LoadCase.InitialStateDefinitionType]
        INITIAL_STATE_DEFINITION_TYPE_STIFFNESS: _ClassVar[LoadCase.InitialStateDefinitionType]
        INITIAL_STATE_DEFINITION_TYPE_STRAINS: _ClassVar[LoadCase.InitialStateDefinitionType]
        INITIAL_STATE_DEFINITION_TYPE_STRAINS_WITH_USER_DEFINED_FACTORS: _ClassVar[LoadCase.InitialStateDefinitionType]
    INITIAL_STATE_DEFINITION_TYPE_FINAL_STATE: LoadCase.InitialStateDefinitionType
    INITIAL_STATE_DEFINITION_TYPE_STIFFNESS: LoadCase.InitialStateDefinitionType
    INITIAL_STATE_DEFINITION_TYPE_STRAINS: LoadCase.InitialStateDefinitionType
    INITIAL_STATE_DEFINITION_TYPE_STRAINS_WITH_USER_DEFINED_FACTORS: LoadCase.InitialStateDefinitionType
    class ActionCategory(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ACTION_CATEGORY_UNKNOWN: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACCIDENTAL_ACTION_A: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACCIDENTAL_LOAD_AL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTIONS_DUE_TO_CLIMATE_CHANGES_IN_TEMPERATURE_AND_AIR_PRESSURE_QC: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTIONS_DUE_TO_CRANES_HORIZONTAL_AND_VERTICAL_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTIONS_DURING_EXECUTION_Q_EX: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTIONS_WITH_LIMITED_MAXIMUM_VALUES_Q_LI: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_LOADS_GS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_PRESSURE_GS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_WATER_PRESSURE_GS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_EARTH_PRESSURE_GS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_WATER_PRESSURE_GS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_ADJACENT_TO_BLAST_FURNACE_TABLE_5_4_1_2_Q_AS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_TABLE_5_4_1_1_Q_AS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ASSEMBLY_CONSTRAINTS_QA: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_ASSEMBLY_HALL_THEATER_CINEMA_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_BUS_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_ROOF_BUS_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_OTHER_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_POPULATION_MAY_BE_CONCENTRATED_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_BUILDINGS_IN_ITEM_NO_1_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_FOR_OTHER_BUILDINGS_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_CANTEEN_DINING_HALL_ORDINARY_ARCHIVES_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_CLASSROOM_LABORATORY_READING_ROOM_MEETING_ROOM_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_DANCE_HALL_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_DWELLING_HOSTEL_HOTEL_OFFICE_HOSPITAL_WARD_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_GYMNASIUM_ARENA_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_FOR_DINING_HALL_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_OTHER_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_LAUNDRY_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_HOSTEL_HOTEL_NURSERY_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_OFFICE_CLASSROOM_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_THICK_STREAM_OF_PEOPLE_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_APARTMENT_HOUSE_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_BLOCK_OF_FLATS_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_OTHER_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_STANDS_WITHOUT_FIXED_SEAT_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_STOREHOUSE_FOR_COLLECTING_BOOKS_ARCHIVES_STOREROOMS_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_STORES_AND_SHOPS_EXHIBITION_HALLS_STATION_PORT_AIRPORT_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_VENTILATOR_MOTOR_ROOM_ELEVATOR_MOTOR_ROOM_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CIVIL_BUILDINGS_WAREHOUSE_WITH_A_DENSE_CONCENTRATION_OF_SHELVING_Q_CB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CONCENTRATED_AND_RAILING_LOADS_Q_CO: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CONCRETE_PRESSURE_Q4_2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CONSTRUCTION_AND_MAINTENANCE_LOADS_AND_HORIZONTAL_LOAD_ON_RAILINGS_ACC_TO_5_5_3_Q_CM: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CONSTRUCTION_LOADS_DUE_TO_WORKING_PERSONNEL_Q_CP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CONSTRUCTION_OPERATIONS_LOADING_Q2_3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CRANE_LOADS_LIFTING_HOOK_CRANES_OF_WORKING_GRADE_A8_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A1_A3_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A4_A5_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A6_A7_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_CRANE_LOAD_CL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEAD_LOAD_D: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEAD_LOAD_DL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEAD_LOAD_GK: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEAD_LOAD_SOIL_DLS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEAD_LOAD_SOIL_DS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEAD_LOAD_SOIL_GKS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_DEBRIS_EFFECT_Q6_2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EARTHQUAKE_LOAD_E: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EARTHQUAKE_LOAD_EL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EARTHQUAKE_LOAD_HORIZONTAL_EH: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EARTH_PRESSURE_FE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LIQUID_Q_E3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LOOSE_Q_E4: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EQUIPMENT_FORKLIFTS_AND_ELECTRIC_TRUCKS_Q_E5: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EQUIPMENT_ISOLATION_OF_EQUIPMENT_Q_E2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EQUIPMENT_PERMANENT_EQUIPMENT_Q_E1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EQUIPMENT_STORED_MATERIALS_AND_PRODUCTS_Q_M: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ERECTION_LOAD_ER: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_EXCEPTIONAL_EXC: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_FATIGUE_ACTION_QFAT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_FATIGUE_LM3_QFAT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_FLOOD_LOAD_FA: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GENERAL_CONSTRUCTION_ELEMENTS_AND_EQUIPMENT_G_GE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GENERAL_VARIABLE_ACTIONS_Q_GE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GEOTECHNICAL_LOADS_PERMANENT_GEP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GEOTECHNICAL_LOADS_VARIABLE_GEV: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR1A_LM1_PEDESTRIAN_CYCLE_TRACK_GR1A: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR1B_SINGLE_AXLE_GR1B: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR2_HORIZONTAL_FORCES_LM1_GR2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR3_PEDESTRIAN_LOAD_GR3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR4_CROWD_LOADING_PEDESTRIAN_LOAD_GR4: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR5_SPECIAL_VEHICLES_LM1_GR5: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GR6_LOADS_FOR_BEARINGS_EXCHANGE_GR6: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_GROUND_WATER_FGW: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_HEIGHT_DIFFERENCE_GH: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_HORIZONTAL_EARTHQUAKE_ACTION_EH: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ICE_ACTION_FICE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ICE_LOADINGS_Q_I: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ICE_QI: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_ACTION_Q: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_DEFORMATIONS_DUE_TO_PRE_STRESSING_P: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_EXCLUDING_CATEGORIES_A_TO_D_Q_J: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_A_Q_KA: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_B_Q_KB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_C_Q_KC: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_D_Q_KD: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_AREAS_WHERE_PEOPLE_CAN_CONGREGATE_Q_C: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_E: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_ROOFS_ACCESSIBLE_ONLY_PRIVATELY_QI_F: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G1_ROOFS_SLOPE_LESS_THAN_20_Q_G1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G2_ROOFS_SLOPE_MORE_THAN_40_Q_G2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_INACCESSIBLE_ROOFS_QI_H: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_ACCESSIBLE_ONLY_FOR_MAINTENANCE_QI_H: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_ACCESSIBLE_QI_I: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_HELICOPTER_QI_I: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_J_ROOFS_HELIPORT_EQUIPMENT_QI_J: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_HELICOPTER_QI_K: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_OTHER_QI_K: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_ROOFS_FOR_SPECIAL_USES_HELIPORTS_QI_K: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_DOMESTIC_AND_RESIDENTIAL_AREAS_Q_A: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_FORK_LIFTS_Q_FL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_11_12_13_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_1_7_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_8_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_9_10_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_SUPPORT_FORCES_Q_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_HELICOPTER_LOAD_Q_HC: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_INACCESSIBLE_ROOFS_Q_H: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_INDUSTRIAL_USE_Q_E2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_LIGHT_INDUSTRIAL_USE_Q_E1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_LIVE_LOADS_LL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_PUBLIC_AREAS_NOT_SUSCEPTIBLE_TO_CROWDING_Q_B: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_SHOPPING_AREAS_Q_D: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_STORAGE_AREAS_Q_E3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_Q_F: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_TO_160_KN_Q_G: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IMPOSED_LOAD_QK: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_G_IN: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_WITH_ADDITION_ON_SITE_G_IS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_COTTON_MILLING_WORKSHOP_TABLE_D_0_1_4_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_GRAIN_PROCESSING_WORKSHOP_TABLE_D_0_1_6_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_1_2_4_6_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_3_5_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_7_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_METAL_WORKING_WORKSHOP_TABLE_D_0_1_1_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_PREPARATORY_WORKSHOP_FOR_TIRE_PLANT_TABLE_D_0_1_5_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_SEMICONDUCTOR_PRODUCTION_WORKSHOP_TABLE_D_0_1_3_Q_IB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_INFLUENCES_RESULTING_FROM_TEMPERATURE_CHANGES_SHRINKAGE_OR_CREEP_ETC_T: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_IN_SITU_CONCRETE_LOADING_ALLOWANCE_Q4_1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LATERAL_EARTH_PRESSURE_H: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIQUID_PRESSURE_FLP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_HELICOPTER_ON_THE_ROOF_ACC_TO_5_3_2_Q_LR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_MANNED_ROOF_Q_LR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_GARDEN_Q_LR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_SPORTS_GROUND_Q_LR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_UNMANNED_ROOF_Q_LR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOAD_DUE_TO_EARTHQUAKE_E: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOAD_DUE_TO_WIND_W: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOAD_L: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LIVE_LOAD_Q: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_6K_Q_C4: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_7K_Q_C3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_ELASTIC_Q_C2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_RIGID_Q_C1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_CRANES_IN_GENERAL_Q_C1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_CRANES_OTHER_GROUPS_Q_C5: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_FROM_VEHICLES_Q_V: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOADS_PRODUCED_BY_FLOWING_WATER_Q6_1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOAD_DUE_TO_GROUND_WATER_PRESSURE_HW: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_OR_PRESSURE_OF_BULK_MATERIALS_HEB: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_MAXIMUM_WIND_Q5_1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_NONE_NONE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_NOTIONAL_HORIZONTAL_FORCES_ACCORDING_TO_BS_5950_NK: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_OTHER_ACTIONS_QO: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_OTHER_CONSTRUCTION_LOADS_Q_CO: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_OTHER_IMPOSED_PERMANENT_DEFORMATIONS_FOR_EXAMPLE_SETTLEMENT_G_OT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_OTHER_LIVE_LOADS_QO: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_OTHER_LOADS_Q9: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_OTHER_TYPES_OF_VARIABLE_LOADS_Q_OT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_EARTH_PRESSURE_G_E: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_FROM_CRANES_G_CR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_G: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_G1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_G_GF: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_G_GU: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_IMPOSED_GQ: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_IMPOSED_NON_STRUCTURAL_GQ: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_LOADS_FROM_FLUIDS_G_FL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_NON_STRUCTURAL_G2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_SELF_WEIGHT_SELF_WEIGHT_OF_SOIL_G: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_SOIL_GS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERMANENT_WATER_PRESSURE_G_W: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PERSONNEL_LOADS_QP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PLACEMENT_LOADS_QP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_2_KN_M2_AND_MORE_Q_U2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_LESS_THAN_2_KN_M2_Q_U1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PRESTRESSING_Q8_3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_PRESTRESS_P: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_RAINWATER_PONDING_FPND: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_RAIN_LOAD_QR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_RAIN_LOAD_R: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ROOF_LIVE_LOAD_LR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ROOF_LIVE_LOAD_QR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SEISMIC_ACTIONS_AE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SEISMIC_AE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SEISMIC_EFFECTS_Q7: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_STRAINING_FORCE_PERMANENT_TP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_STRAINING_FORCE_VARIABLE_TV: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_ON_BUILDING_SITE_G_C3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_PREFABRICATED_G_C2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_MORE_THAN_1600_KG_M3_STONE_TIMBER_G_C1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_G: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_OF_GENERAL_WOODEN_STRUCTURES_G_WG: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_OF_INDUSTRIALIZED_WOODEN_STRUCTURES_G_WI: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_OF_METAL_STRUCTURES_G_ME: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_OF_PREFABRICATED_STRUCTURES_G_PR: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_OF_STRUCTURES_BUILT_ON_SITE_G_SI: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_Q1_1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_SOIL_MODIFIED_G_SM: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_SOIL_NATURAL_G_SN: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_G_S1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_OVER_50_OF_TOTAL_LOAD_G_S2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SERVICEABILITY_EARTHQUAKE_ACTION_ES: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SERVICEABILITY_WIND_ACTION_WS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SETTLEMENTS_OF_SUPPORTS_SHRINKAGE_SETT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SETTLEMENT_Q8_2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ACTION_FSN: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_AND_ICE_Q2_4: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_AND_RAIN_S: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_GREATER_THAN_2_75_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_THAN_2_75_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_ICE_LOADS_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_LOADINGS_Q_S: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_LOAD_S: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_LOAD_ZONE_III_S: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_LOAD_ZONE_II_S: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_LOAD_ZONE_I_S: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SNOW_REGION_SAINT_PIERRE_AND_MIQUELON_QS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SOIL_Q1_2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SPECIAL_LOADINGS_PS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_STORAGE_AREAS_Q2_2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_SUPPORTED_CONSTRUCTION_Q2_1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_TEMPERATURE_CLIMATIC_INFLUENCES_Q_T: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_TEMPERATURE_FIRE_TS: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_TEMPERATURE_Q8_1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_THERMAL_ACTIONS_ARISING_FROM_THE_FIRE_T: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_THERMAL_ACTIONS_QT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_THERMAL_ACTION_ACCORDING_TO_9_1_3_T: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_TORNADO_LOAD_WT: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ULTIMATE_EARTHQUAKE_ACTION_EU: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_ULTIMATE_WIND_ACTION_WU: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_UNEVEN_SETTLEMENTS_G_US: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_UNIT_LOADS_QU: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUNDWATER_GEF1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUND_WATER_FLUIDS_GEF2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_OTHER_ACTIONS_GEF3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUNDWATER_GEU1: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUND_WATER_FLUIDS_GEU2: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_OTHER_ACTIONS_GEU3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_LOADS_FROM_FLUIDS_Q_FL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_PERSISTENT_HORIZONTAL_IMPOSED_ACTIONS_Q3: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VARIABLE_Q: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_VERTICAL_EARTHQUAKE_ACTION_EV: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WEIGHT_OF_ICE_DI: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOADINGS_Q_W: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOADS_FWK_EXECUTION_QWE: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOADS_FWK_PERSISTENT_DESIGN_SITUATIONS_QWP: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOADS_FW_QW: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOAD_ACCORDING_TO_8_1_4_W: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOAD_W: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOAD_WK: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_LOAD_WL: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WIND_QW: _ClassVar[LoadCase.ActionCategory]
        ACTION_CATEGORY_WORKING_WIND_Q5_2: _ClassVar[LoadCase.ActionCategory]
    ACTION_CATEGORY_UNKNOWN: LoadCase.ActionCategory
    ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A: LoadCase.ActionCategory
    ACTION_CATEGORY_ACCIDENTAL_ACTION_A: LoadCase.ActionCategory
    ACTION_CATEGORY_ACCIDENTAL_LOAD_AL: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTIONS_DUE_TO_CLIMATE_CHANGES_IN_TEMPERATURE_AND_AIR_PRESSURE_QC: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTIONS_DUE_TO_CRANES_HORIZONTAL_AND_VERTICAL_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTIONS_DURING_EXECUTION_Q_EX: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTIONS_WITH_LIMITED_MAXIMUM_VALUES_Q_LI: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_LOADS_GS: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_PRESSURE_GS: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_WATER_PRESSURE_GS: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_EARTH_PRESSURE_GS: LoadCase.ActionCategory
    ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_WATER_PRESSURE_GS: LoadCase.ActionCategory
    ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_ADJACENT_TO_BLAST_FURNACE_TABLE_5_4_1_2_Q_AS: LoadCase.ActionCategory
    ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_TABLE_5_4_1_1_Q_AS: LoadCase.ActionCategory
    ACTION_CATEGORY_ASSEMBLY_CONSTRAINTS_QA: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_ASSEMBLY_HALL_THEATER_CINEMA_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_BUS_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_ROOF_BUS_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_OTHER_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_POPULATION_MAY_BE_CONCENTRATED_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_BUILDINGS_IN_ITEM_NO_1_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_FOR_OTHER_BUILDINGS_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_CANTEEN_DINING_HALL_ORDINARY_ARCHIVES_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_CLASSROOM_LABORATORY_READING_ROOM_MEETING_ROOM_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_DANCE_HALL_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_DWELLING_HOSTEL_HOTEL_OFFICE_HOSPITAL_WARD_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_GYMNASIUM_ARENA_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_FOR_DINING_HALL_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_OTHER_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_LAUNDRY_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_HOSTEL_HOTEL_NURSERY_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_OFFICE_CLASSROOM_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_THICK_STREAM_OF_PEOPLE_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_APARTMENT_HOUSE_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_BLOCK_OF_FLATS_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_OTHER_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_STANDS_WITHOUT_FIXED_SEAT_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_STOREHOUSE_FOR_COLLECTING_BOOKS_ARCHIVES_STOREROOMS_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_STORES_AND_SHOPS_EXHIBITION_HALLS_STATION_PORT_AIRPORT_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_VENTILATOR_MOTOR_ROOM_ELEVATOR_MOTOR_ROOM_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CIVIL_BUILDINGS_WAREHOUSE_WITH_A_DENSE_CONCENTRATION_OF_SHELVING_Q_CB: LoadCase.ActionCategory
    ACTION_CATEGORY_CONCENTRATED_AND_RAILING_LOADS_Q_CO: LoadCase.ActionCategory
    ACTION_CATEGORY_CONCRETE_PRESSURE_Q4_2: LoadCase.ActionCategory
    ACTION_CATEGORY_CONSTRUCTION_AND_MAINTENANCE_LOADS_AND_HORIZONTAL_LOAD_ON_RAILINGS_ACC_TO_5_5_3_Q_CM: LoadCase.ActionCategory
    ACTION_CATEGORY_CONSTRUCTION_LOADS_DUE_TO_WORKING_PERSONNEL_Q_CP: LoadCase.ActionCategory
    ACTION_CATEGORY_CONSTRUCTION_OPERATIONS_LOADING_Q2_3: LoadCase.ActionCategory
    ACTION_CATEGORY_CRANE_LOADS_LIFTING_HOOK_CRANES_OF_WORKING_GRADE_A8_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A1_A3_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A4_A5_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A6_A7_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_CRANE_LOAD_CL: LoadCase.ActionCategory
    ACTION_CATEGORY_DEAD_LOAD_D: LoadCase.ActionCategory
    ACTION_CATEGORY_DEAD_LOAD_DL: LoadCase.ActionCategory
    ACTION_CATEGORY_DEAD_LOAD_GK: LoadCase.ActionCategory
    ACTION_CATEGORY_DEAD_LOAD_SOIL_DLS: LoadCase.ActionCategory
    ACTION_CATEGORY_DEAD_LOAD_SOIL_DS: LoadCase.ActionCategory
    ACTION_CATEGORY_DEAD_LOAD_SOIL_GKS: LoadCase.ActionCategory
    ACTION_CATEGORY_DEBRIS_EFFECT_Q6_2: LoadCase.ActionCategory
    ACTION_CATEGORY_EARTHQUAKE_LOAD_E: LoadCase.ActionCategory
    ACTION_CATEGORY_EARTHQUAKE_LOAD_EL: LoadCase.ActionCategory
    ACTION_CATEGORY_EARTHQUAKE_LOAD_HORIZONTAL_EH: LoadCase.ActionCategory
    ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV: LoadCase.ActionCategory
    ACTION_CATEGORY_EARTH_PRESSURE_FE: LoadCase.ActionCategory
    ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE: LoadCase.ActionCategory
    ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LIQUID_Q_E3: LoadCase.ActionCategory
    ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LOOSE_Q_E4: LoadCase.ActionCategory
    ACTION_CATEGORY_EQUIPMENT_FORKLIFTS_AND_ELECTRIC_TRUCKS_Q_E5: LoadCase.ActionCategory
    ACTION_CATEGORY_EQUIPMENT_ISOLATION_OF_EQUIPMENT_Q_E2: LoadCase.ActionCategory
    ACTION_CATEGORY_EQUIPMENT_PERMANENT_EQUIPMENT_Q_E1: LoadCase.ActionCategory
    ACTION_CATEGORY_EQUIPMENT_STORED_MATERIALS_AND_PRODUCTS_Q_M: LoadCase.ActionCategory
    ACTION_CATEGORY_ERECTION_LOAD_ER: LoadCase.ActionCategory
    ACTION_CATEGORY_EXCEPTIONAL_EXC: LoadCase.ActionCategory
    ACTION_CATEGORY_FATIGUE_ACTION_QFAT: LoadCase.ActionCategory
    ACTION_CATEGORY_FATIGUE_LM3_QFAT: LoadCase.ActionCategory
    ACTION_CATEGORY_FLOOD_LOAD_FA: LoadCase.ActionCategory
    ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF: LoadCase.ActionCategory
    ACTION_CATEGORY_GENERAL_CONSTRUCTION_ELEMENTS_AND_EQUIPMENT_G_GE: LoadCase.ActionCategory
    ACTION_CATEGORY_GENERAL_VARIABLE_ACTIONS_Q_GE: LoadCase.ActionCategory
    ACTION_CATEGORY_GEOTECHNICAL_LOADS_PERMANENT_GEP: LoadCase.ActionCategory
    ACTION_CATEGORY_GEOTECHNICAL_LOADS_VARIABLE_GEV: LoadCase.ActionCategory
    ACTION_CATEGORY_GR1A_LM1_PEDESTRIAN_CYCLE_TRACK_GR1A: LoadCase.ActionCategory
    ACTION_CATEGORY_GR1B_SINGLE_AXLE_GR1B: LoadCase.ActionCategory
    ACTION_CATEGORY_GR2_HORIZONTAL_FORCES_LM1_GR2: LoadCase.ActionCategory
    ACTION_CATEGORY_GR3_PEDESTRIAN_LOAD_GR3: LoadCase.ActionCategory
    ACTION_CATEGORY_GR4_CROWD_LOADING_PEDESTRIAN_LOAD_GR4: LoadCase.ActionCategory
    ACTION_CATEGORY_GR5_SPECIAL_VEHICLES_LM1_GR5: LoadCase.ActionCategory
    ACTION_CATEGORY_GR6_LOADS_FOR_BEARINGS_EXCHANGE_GR6: LoadCase.ActionCategory
    ACTION_CATEGORY_GROUND_WATER_FGW: LoadCase.ActionCategory
    ACTION_CATEGORY_HEIGHT_DIFFERENCE_GH: LoadCase.ActionCategory
    ACTION_CATEGORY_HORIZONTAL_EARTHQUAKE_ACTION_EH: LoadCase.ActionCategory
    ACTION_CATEGORY_ICE_ACTION_FICE: LoadCase.ActionCategory
    ACTION_CATEGORY_ICE_LOADINGS_Q_I: LoadCase.ActionCategory
    ACTION_CATEGORY_ICE_QI: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_ACTION_Q: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_DEFORMATIONS_DUE_TO_PRE_STRESSING_P: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_EXCLUDING_CATEGORIES_A_TO_D_Q_J: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_A_Q_KA: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_B_Q_KB: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_C_Q_KC: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_D_Q_KD: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_AREAS_WHERE_PEOPLE_CAN_CONGREGATE_Q_C: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_E: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_ROOFS_ACCESSIBLE_ONLY_PRIVATELY_QI_F: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G1_ROOFS_SLOPE_LESS_THAN_20_Q_G1: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G2_ROOFS_SLOPE_MORE_THAN_40_Q_G2: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_INACCESSIBLE_ROOFS_QI_H: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_ACCESSIBLE_ONLY_FOR_MAINTENANCE_QI_H: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_ACCESSIBLE_QI_I: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_HELICOPTER_QI_I: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_J_ROOFS_HELIPORT_EQUIPMENT_QI_J: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_HELICOPTER_QI_K: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_OTHER_QI_K: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_ROOFS_FOR_SPECIAL_USES_HELIPORTS_QI_K: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_DOMESTIC_AND_RESIDENTIAL_AREAS_Q_A: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_FORK_LIFTS_Q_FL: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_11_12_13_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_1_7_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_8_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_9_10_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_SUPPORT_FORCES_Q_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_HELICOPTER_LOAD_Q_HC: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_INACCESSIBLE_ROOFS_Q_H: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_INDUSTRIAL_USE_Q_E2: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_LIGHT_INDUSTRIAL_USE_Q_E1: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_LIVE_LOADS_LL: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_PUBLIC_AREAS_NOT_SUSCEPTIBLE_TO_CROWDING_Q_B: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_SHOPPING_AREAS_Q_D: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_STORAGE_AREAS_Q_E3: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_Q_F: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_TO_160_KN_Q_G: LoadCase.ActionCategory
    ACTION_CATEGORY_IMPOSED_LOAD_QK: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_G_IN: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_WITH_ADDITION_ON_SITE_G_IS: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_COTTON_MILLING_WORKSHOP_TABLE_D_0_1_4_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_GRAIN_PROCESSING_WORKSHOP_TABLE_D_0_1_6_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_1_2_4_6_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_3_5_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_7_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_METAL_WORKING_WORKSHOP_TABLE_D_0_1_1_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_PREPARATORY_WORKSHOP_FOR_TIRE_PLANT_TABLE_D_0_1_5_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_SEMICONDUCTOR_PRODUCTION_WORKSHOP_TABLE_D_0_1_3_Q_IB: LoadCase.ActionCategory
    ACTION_CATEGORY_INFLUENCES_RESULTING_FROM_TEMPERATURE_CHANGES_SHRINKAGE_OR_CREEP_ETC_T: LoadCase.ActionCategory
    ACTION_CATEGORY_IN_SITU_CONCRETE_LOADING_ALLOWANCE_Q4_1: LoadCase.ActionCategory
    ACTION_CATEGORY_LATERAL_EARTH_PRESSURE_H: LoadCase.ActionCategory
    ACTION_CATEGORY_LIQUID_PRESSURE_FLP: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_HELICOPTER_ON_THE_ROOF_ACC_TO_5_3_2_Q_LR: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_MANNED_ROOF_Q_LR: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_GARDEN_Q_LR: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_SPORTS_GROUND_Q_LR: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_UNMANNED_ROOF_Q_LR: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOAD_DUE_TO_EARTHQUAKE_E: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOAD_DUE_TO_WIND_W: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOAD_L: LoadCase.ActionCategory
    ACTION_CATEGORY_LIVE_LOAD_Q: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_6K_Q_C4: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_7K_Q_C3: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_ELASTIC_Q_C2: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_RIGID_Q_C1: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_CRANES_IN_GENERAL_Q_C1: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_CRANES_OTHER_GROUPS_Q_C5: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_FROM_VEHICLES_Q_V: LoadCase.ActionCategory
    ACTION_CATEGORY_LOADS_PRODUCED_BY_FLOWING_WATER_Q6_1: LoadCase.ActionCategory
    ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK: LoadCase.ActionCategory
    ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F: LoadCase.ActionCategory
    ACTION_CATEGORY_LOAD_DUE_TO_GROUND_WATER_PRESSURE_HW: LoadCase.ActionCategory
    ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H: LoadCase.ActionCategory
    ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_OR_PRESSURE_OF_BULK_MATERIALS_HEB: LoadCase.ActionCategory
    ACTION_CATEGORY_MAXIMUM_WIND_Q5_1: LoadCase.ActionCategory
    ACTION_CATEGORY_NONE_NONE: LoadCase.ActionCategory
    ACTION_CATEGORY_NOTIONAL_HORIZONTAL_FORCES_ACCORDING_TO_BS_5950_NK: LoadCase.ActionCategory
    ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N: LoadCase.ActionCategory
    ACTION_CATEGORY_OTHER_ACTIONS_QO: LoadCase.ActionCategory
    ACTION_CATEGORY_OTHER_CONSTRUCTION_LOADS_Q_CO: LoadCase.ActionCategory
    ACTION_CATEGORY_OTHER_IMPOSED_PERMANENT_DEFORMATIONS_FOR_EXAMPLE_SETTLEMENT_G_OT: LoadCase.ActionCategory
    ACTION_CATEGORY_OTHER_LIVE_LOADS_QO: LoadCase.ActionCategory
    ACTION_CATEGORY_OTHER_LOADS_Q9: LoadCase.ActionCategory
    ACTION_CATEGORY_OTHER_TYPES_OF_VARIABLE_LOADS_Q_OT: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_EARTH_PRESSURE_G_E: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_FROM_CRANES_G_CR: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_G: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_G1: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_G_GF: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_G_GU: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_IMPOSED_GQ: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_IMPOSED_NON_STRUCTURAL_GQ: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_LOADS_FROM_FLUIDS_G_FL: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_NON_STRUCTURAL_G2: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_SELF_WEIGHT_SELF_WEIGHT_OF_SOIL_G: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_SOIL_GS: LoadCase.ActionCategory
    ACTION_CATEGORY_PERMANENT_WATER_PRESSURE_G_W: LoadCase.ActionCategory
    ACTION_CATEGORY_PERSONNEL_LOADS_QP: LoadCase.ActionCategory
    ACTION_CATEGORY_PLACEMENT_LOADS_QP: LoadCase.ActionCategory
    ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_2_KN_M2_AND_MORE_Q_U2: LoadCase.ActionCategory
    ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_LESS_THAN_2_KN_M2_Q_U1: LoadCase.ActionCategory
    ACTION_CATEGORY_PRESTRESSING_Q8_3: LoadCase.ActionCategory
    ACTION_CATEGORY_PRESTRESS_P: LoadCase.ActionCategory
    ACTION_CATEGORY_RAINWATER_PONDING_FPND: LoadCase.ActionCategory
    ACTION_CATEGORY_RAIN_LOAD_QR: LoadCase.ActionCategory
    ACTION_CATEGORY_RAIN_LOAD_R: LoadCase.ActionCategory
    ACTION_CATEGORY_ROOF_LIVE_LOAD_LR: LoadCase.ActionCategory
    ACTION_CATEGORY_ROOF_LIVE_LOAD_QR: LoadCase.ActionCategory
    ACTION_CATEGORY_SEISMIC_ACTIONS_AE: LoadCase.ActionCategory
    ACTION_CATEGORY_SEISMIC_AE: LoadCase.ActionCategory
    ACTION_CATEGORY_SEISMIC_EFFECTS_Q7: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_STRAINING_FORCE_PERMANENT_TP: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_STRAINING_FORCE_VARIABLE_TV: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_ON_BUILDING_SITE_G_C3: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_PREFABRICATED_G_C2: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_MORE_THAN_1600_KG_M3_STONE_TIMBER_G_C1: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_G: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_OF_GENERAL_WOODEN_STRUCTURES_G_WG: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_OF_INDUSTRIALIZED_WOODEN_STRUCTURES_G_WI: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_OF_METAL_STRUCTURES_G_ME: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_OF_PREFABRICATED_STRUCTURES_G_PR: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_OF_STRUCTURES_BUILT_ON_SITE_G_SI: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_Q1_1: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_SOIL_MODIFIED_G_SM: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_SOIL_NATURAL_G_SN: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_G_S1: LoadCase.ActionCategory
    ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_OVER_50_OF_TOTAL_LOAD_G_S2: LoadCase.ActionCategory
    ACTION_CATEGORY_SERVICEABILITY_EARTHQUAKE_ACTION_ES: LoadCase.ActionCategory
    ACTION_CATEGORY_SERVICEABILITY_WIND_ACTION_WS: LoadCase.ActionCategory
    ACTION_CATEGORY_SETTLEMENTS_OF_SUPPORTS_SHRINKAGE_SETT: LoadCase.ActionCategory
    ACTION_CATEGORY_SETTLEMENT_Q8_2: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ACTION_FSN: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_AND_ICE_Q2_4: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_AND_RAIN_S: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_GREATER_THAN_2_75_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_THAN_2_75_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_ICE_LOADS_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_LOADINGS_Q_S: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_LOAD_S: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_LOAD_ZONE_III_S: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_LOAD_ZONE_II_S: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_LOAD_ZONE_I_S: LoadCase.ActionCategory
    ACTION_CATEGORY_SNOW_REGION_SAINT_PIERRE_AND_MIQUELON_QS: LoadCase.ActionCategory
    ACTION_CATEGORY_SOIL_Q1_2: LoadCase.ActionCategory
    ACTION_CATEGORY_SPECIAL_LOADINGS_PS: LoadCase.ActionCategory
    ACTION_CATEGORY_STORAGE_AREAS_Q2_2: LoadCase.ActionCategory
    ACTION_CATEGORY_SUPPORTED_CONSTRUCTION_Q2_1: LoadCase.ActionCategory
    ACTION_CATEGORY_TEMPERATURE_CLIMATIC_INFLUENCES_Q_T: LoadCase.ActionCategory
    ACTION_CATEGORY_TEMPERATURE_FIRE_TS: LoadCase.ActionCategory
    ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT: LoadCase.ActionCategory
    ACTION_CATEGORY_TEMPERATURE_Q8_1: LoadCase.ActionCategory
    ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T: LoadCase.ActionCategory
    ACTION_CATEGORY_THERMAL_ACTIONS_ARISING_FROM_THE_FIRE_T: LoadCase.ActionCategory
    ACTION_CATEGORY_THERMAL_ACTIONS_QT: LoadCase.ActionCategory
    ACTION_CATEGORY_THERMAL_ACTION_ACCORDING_TO_9_1_3_T: LoadCase.ActionCategory
    ACTION_CATEGORY_TORNADO_LOAD_WT: LoadCase.ActionCategory
    ACTION_CATEGORY_ULTIMATE_EARTHQUAKE_ACTION_EU: LoadCase.ActionCategory
    ACTION_CATEGORY_ULTIMATE_WIND_ACTION_WU: LoadCase.ActionCategory
    ACTION_CATEGORY_UNEVEN_SETTLEMENTS_G_US: LoadCase.ActionCategory
    ACTION_CATEGORY_UNIT_LOADS_QU: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUNDWATER_GEF1: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUND_WATER_FLUIDS_GEF2: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_OTHER_ACTIONS_GEF3: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUNDWATER_GEU1: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUND_WATER_FLUIDS_GEU2: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_OTHER_ACTIONS_GEU3: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_LOADS_FROM_FLUIDS_Q_FL: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_PERSISTENT_HORIZONTAL_IMPOSED_ACTIONS_Q3: LoadCase.ActionCategory
    ACTION_CATEGORY_VARIABLE_Q: LoadCase.ActionCategory
    ACTION_CATEGORY_VERTICAL_EARTHQUAKE_ACTION_EV: LoadCase.ActionCategory
    ACTION_CATEGORY_WEIGHT_OF_ICE_DI: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOADINGS_Q_W: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOADS_FWK_EXECUTION_QWE: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOADS_FWK_PERSISTENT_DESIGN_SITUATIONS_QWP: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOADS_FW_QW: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOAD_ACCORDING_TO_8_1_4_W: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOAD_W: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOAD_WK: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_LOAD_WL: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI: LoadCase.ActionCategory
    ACTION_CATEGORY_WIND_QW: LoadCase.ActionCategory
    ACTION_CATEGORY_WORKING_WIND_Q5_2: LoadCase.ActionCategory
    class FactorPhi(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        FACTOR_PHI_1: _ClassVar[LoadCase.FactorPhi]
        FACTOR_PHI_2: _ClassVar[LoadCase.FactorPhi]
        FACTOR_PHI_3: _ClassVar[LoadCase.FactorPhi]
    FACTOR_PHI_1: LoadCase.FactorPhi
    FACTOR_PHI_2: LoadCase.FactorPhi
    FACTOR_PHI_3: LoadCase.FactorPhi
    class LoadDuration(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LOAD_DURATION_UNKNOWN: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_10_MINUTES: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_10_SECONDS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_12_HOURS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_1_DAY: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_1_HOUR: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_1_MINUTE: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_1_MONTH: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_1_WEEK: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_1_YEAR: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_3_MONTHS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_3_SECONDS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_50_YEARS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_5_DAYS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_5_HOURS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_5_MINUTES: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_5_MONTHS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_5_SECONDS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_ASD_IMPACT_LRFD_EQUAL_TO_1_25: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_ASD_PERMANENT_LRFD_EQUAL_TO_0_6: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_ASD_SEVEN_DAYS_LRFD_EQUAL_TO_0_9: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_ASD_TEN_MINUTES_LRFD_EQUAL_TO_1_0: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_ASD_TEN_YEARS_LRFD_EQUAL_TO_0_7: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_ASD_TWO_MONTHS_LRFD_EQUAL_TO_0_8: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_BEYOND_1_YEAR: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_IMPACT: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_INSTANTANEOUS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_LONG_TERM: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_MEDIUM_TERM: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_PERMANENT: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_SEVEN_DAYS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_SHORT_TERM: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_SHORT_TERM_INSTANTANEOUS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_STANDARD_TERM: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_TEN_MINUTES: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_TEN_YEARS: _ClassVar[LoadCase.LoadDuration]
        LOAD_DURATION_TWO_MONTHS: _ClassVar[LoadCase.LoadDuration]
    LOAD_DURATION_UNKNOWN: LoadCase.LoadDuration
    LOAD_DURATION_10_MINUTES: LoadCase.LoadDuration
    LOAD_DURATION_10_SECONDS: LoadCase.LoadDuration
    LOAD_DURATION_12_HOURS: LoadCase.LoadDuration
    LOAD_DURATION_1_DAY: LoadCase.LoadDuration
    LOAD_DURATION_1_HOUR: LoadCase.LoadDuration
    LOAD_DURATION_1_MINUTE: LoadCase.LoadDuration
    LOAD_DURATION_1_MONTH: LoadCase.LoadDuration
    LOAD_DURATION_1_WEEK: LoadCase.LoadDuration
    LOAD_DURATION_1_YEAR: LoadCase.LoadDuration
    LOAD_DURATION_3_MONTHS: LoadCase.LoadDuration
    LOAD_DURATION_3_SECONDS: LoadCase.LoadDuration
    LOAD_DURATION_50_YEARS: LoadCase.LoadDuration
    LOAD_DURATION_5_DAYS: LoadCase.LoadDuration
    LOAD_DURATION_5_HOURS: LoadCase.LoadDuration
    LOAD_DURATION_5_MINUTES: LoadCase.LoadDuration
    LOAD_DURATION_5_MONTHS: LoadCase.LoadDuration
    LOAD_DURATION_5_SECONDS: LoadCase.LoadDuration
    LOAD_DURATION_ASD_IMPACT_LRFD_EQUAL_TO_1_25: LoadCase.LoadDuration
    LOAD_DURATION_ASD_PERMANENT_LRFD_EQUAL_TO_0_6: LoadCase.LoadDuration
    LOAD_DURATION_ASD_SEVEN_DAYS_LRFD_EQUAL_TO_0_9: LoadCase.LoadDuration
    LOAD_DURATION_ASD_TEN_MINUTES_LRFD_EQUAL_TO_1_0: LoadCase.LoadDuration
    LOAD_DURATION_ASD_TEN_YEARS_LRFD_EQUAL_TO_0_7: LoadCase.LoadDuration
    LOAD_DURATION_ASD_TWO_MONTHS_LRFD_EQUAL_TO_0_8: LoadCase.LoadDuration
    LOAD_DURATION_BEYOND_1_YEAR: LoadCase.LoadDuration
    LOAD_DURATION_IMPACT: LoadCase.LoadDuration
    LOAD_DURATION_INSTANTANEOUS: LoadCase.LoadDuration
    LOAD_DURATION_LONG_TERM: LoadCase.LoadDuration
    LOAD_DURATION_MEDIUM_TERM: LoadCase.LoadDuration
    LOAD_DURATION_PERMANENT: LoadCase.LoadDuration
    LOAD_DURATION_SEVEN_DAYS: LoadCase.LoadDuration
    LOAD_DURATION_SHORT_TERM: LoadCase.LoadDuration
    LOAD_DURATION_SHORT_TERM_INSTANTANEOUS: LoadCase.LoadDuration
    LOAD_DURATION_STANDARD_TERM: LoadCase.LoadDuration
    LOAD_DURATION_TEN_MINUTES: LoadCase.LoadDuration
    LOAD_DURATION_TEN_YEARS: LoadCase.LoadDuration
    LOAD_DURATION_TWO_MONTHS: LoadCase.LoadDuration
    class SpecificationForLoadCaseGr1a(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SPECIFICATION_FOR_LOAD_CASE_GR1A_TS1: _ClassVar[LoadCase.SpecificationForLoadCaseGr1a]
        SPECIFICATION_FOR_LOAD_CASE_GR1A_PEDESTRIAN_AND_CYCLE_TRACK: _ClassVar[LoadCase.SpecificationForLoadCaseGr1a]
        SPECIFICATION_FOR_LOAD_CASE_GR1A_UDL: _ClassVar[LoadCase.SpecificationForLoadCaseGr1a]
    SPECIFICATION_FOR_LOAD_CASE_GR1A_TS1: LoadCase.SpecificationForLoadCaseGr1a
    SPECIFICATION_FOR_LOAD_CASE_GR1A_PEDESTRIAN_AND_CYCLE_TRACK: LoadCase.SpecificationForLoadCaseGr1a
    SPECIFICATION_FOR_LOAD_CASE_GR1A_UDL: LoadCase.SpecificationForLoadCaseGr1a
    class SpecificationForLoadCaseGr2(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SPECIFICATION_FOR_LOAD_CASE_GR2_HORIZONTAL_FORCES_BRAKING_AND_ACCELERATION: _ClassVar[LoadCase.SpecificationForLoadCaseGr2]
        SPECIFICATION_FOR_LOAD_CASE_GR2_HORIZONTAL_FORCES_CENTRIFUGAL_FORCES: _ClassVar[LoadCase.SpecificationForLoadCaseGr2]
    SPECIFICATION_FOR_LOAD_CASE_GR2_HORIZONTAL_FORCES_BRAKING_AND_ACCELERATION: LoadCase.SpecificationForLoadCaseGr2
    SPECIFICATION_FOR_LOAD_CASE_GR2_HORIZONTAL_FORCES_CENTRIFUGAL_FORCES: LoadCase.SpecificationForLoadCaseGr2
    class SpecificationForLoadCaseGr5(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SPECIFICATION_FOR_LOAD_CASE_GR5_SPECIAL_VEHICLE: _ClassVar[LoadCase.SpecificationForLoadCaseGr5]
        SPECIFICATION_FOR_LOAD_CASE_GR5_TS: _ClassVar[LoadCase.SpecificationForLoadCaseGr5]
        SPECIFICATION_FOR_LOAD_CASE_GR5_UDL: _ClassVar[LoadCase.SpecificationForLoadCaseGr5]
    SPECIFICATION_FOR_LOAD_CASE_GR5_SPECIAL_VEHICLE: LoadCase.SpecificationForLoadCaseGr5
    SPECIFICATION_FOR_LOAD_CASE_GR5_TS: LoadCase.SpecificationForLoadCaseGr5
    SPECIFICATION_FOR_LOAD_CASE_GR5_UDL: LoadCase.SpecificationForLoadCaseGr5
    class SpecificationForLoadCaseGr6(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SPECIFICATION_FOR_LOAD_CASE_GR6_TS: _ClassVar[LoadCase.SpecificationForLoadCaseGr6]
        SPECIFICATION_FOR_LOAD_CASE_GR6_HORIZONTAL_FORCES_BRAKING_AND_ACCELERATION: _ClassVar[LoadCase.SpecificationForLoadCaseGr6]
        SPECIFICATION_FOR_LOAD_CASE_GR6_HORIZONTAL_FORCES_CENTRIFUGAL_FORCES: _ClassVar[LoadCase.SpecificationForLoadCaseGr6]
        SPECIFICATION_FOR_LOAD_CASE_GR6_PEDESTRIAN_AND_CYCLE_TRACK: _ClassVar[LoadCase.SpecificationForLoadCaseGr6]
        SPECIFICATION_FOR_LOAD_CASE_GR6_UDL: _ClassVar[LoadCase.SpecificationForLoadCaseGr6]
    SPECIFICATION_FOR_LOAD_CASE_GR6_TS: LoadCase.SpecificationForLoadCaseGr6
    SPECIFICATION_FOR_LOAD_CASE_GR6_HORIZONTAL_FORCES_BRAKING_AND_ACCELERATION: LoadCase.SpecificationForLoadCaseGr6
    SPECIFICATION_FOR_LOAD_CASE_GR6_HORIZONTAL_FORCES_CENTRIFUGAL_FORCES: LoadCase.SpecificationForLoadCaseGr6
    SPECIFICATION_FOR_LOAD_CASE_GR6_PEDESTRIAN_AND_CYCLE_TRACK: LoadCase.SpecificationForLoadCaseGr6
    SPECIFICATION_FOR_LOAD_CASE_GR6_UDL: LoadCase.SpecificationForLoadCaseGr6
    class LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_FLOOR_LIVE_LOAD: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_PARTITIONS: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_FLOOR_LIVE_LOAD: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_PARTITIONS: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo
    class LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_FLOOR_LIVE_LOAD: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_PARTITIONS: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_FLOOR_LIVE_LOAD: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_PARTITIONS: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo
    class LiveloadConsiderDesignSituationSeismicWeightCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_WEIGHT_COMBO_FLOOR_LOADS_UP_TO_3: _ClassVar[LoadCase.LiveloadConsiderDesignSituationSeismicWeightCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_WEIGHT_COMBO_FLOOR_LOADS_ABOVE_3: _ClassVar[LoadCase.LiveloadConsiderDesignSituationSeismicWeightCombo]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_WEIGHT_COMBO_FLOOR_LOADS_UP_TO_3: LoadCase.LiveloadConsiderDesignSituationSeismicWeightCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_WEIGHT_COMBO_FLOOR_LOADS_ABOVE_3: LoadCase.LiveloadConsiderDesignSituationSeismicWeightCombo
    class LiveloadConsiderDesignSituationSeismicMassCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_LOAD_CALCULATED_ACCORDING_ACTUAL_CONDITIONS: _ClassVar[LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_LOAD_CALCULATED_ACCORDING_EQUIVALENT_UNIFORM_LIBRARY_ARCHIVES: _ClassVar[LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_LOAD_CALCULATED_ACCORDING_EQUIVALENT_UNIFORM_OTHER_CIVIL_BUILDINGS: _ClassVar[LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_LOAD_CALCULATED_ACCORDING_ACTUAL_CONDITIONS: LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_LOAD_CALCULATED_ACCORDING_EQUIVALENT_UNIFORM_LIBRARY_ARCHIVES: LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_LOAD_CALCULATED_ACCORDING_EQUIVALENT_UNIFORM_OTHER_CIVIL_BUILDINGS: LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo
    class LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_FLOOR_LIVE_LOAD: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_PARTITIONS: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_FLOOR_LIVE_LOAD: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_PARTITIONS: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo
    class LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_FLOOR_LIVE_LOAD: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo]
        LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_PARTITIONS: _ClassVar[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_FLOOR_LIVE_LOAD: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_OPERATING_WEIGHT_OF_PERMANENT_EQUIPMENT: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_PARTITIONS: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo
    class FlatRoofSnowLoadCategory(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        FLAT_ROOF_SNOW_LOAD_CATEGORY_SNOW_LOADS_OF_30PSF_OR_LESS: _ClassVar[LoadCase.FlatRoofSnowLoadCategory]
        FLAT_ROOF_SNOW_LOAD_CATEGORY_SNOW_LOADS_EXCEEDING_30PSF: _ClassVar[LoadCase.FlatRoofSnowLoadCategory]
    FLAT_ROOF_SNOW_LOAD_CATEGORY_SNOW_LOADS_OF_30PSF_OR_LESS: LoadCase.FlatRoofSnowLoadCategory
    FLAT_ROOF_SNOW_LOAD_CATEGORY_SNOW_LOADS_EXCEEDING_30PSF: LoadCase.FlatRoofSnowLoadCategory
    class DistinguishDifferentOverstrengthFactorInDirectionXyCombo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DISTINGUISH_DIFFERENT_OVERSTRENGTH_FACTOR_IN_DIRECTION_XY_COMBO_X: _ClassVar[LoadCase.DistinguishDifferentOverstrengthFactorInDirectionXyCombo]
        DISTINGUISH_DIFFERENT_OVERSTRENGTH_FACTOR_IN_DIRECTION_XY_COMBO_Y: _ClassVar[LoadCase.DistinguishDifferentOverstrengthFactorInDirectionXyCombo]
    DISTINGUISH_DIFFERENT_OVERSTRENGTH_FACTOR_IN_DIRECTION_XY_COMBO_X: LoadCase.DistinguishDifferentOverstrengthFactorInDirectionXyCombo
    DISTINGUISH_DIFFERENT_OVERSTRENGTH_FACTOR_IN_DIRECTION_XY_COMBO_Y: LoadCase.DistinguishDifferentOverstrengthFactorInDirectionXyCombo
    class LoadDurationSp(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LOAD_DURATION_SP_LONG: _ClassVar[LoadCase.LoadDurationSp]
        LOAD_DURATION_SP_SHORT: _ClassVar[LoadCase.LoadDurationSp]
    LOAD_DURATION_SP_LONG: LoadCase.LoadDurationSp
    LOAD_DURATION_SP_SHORT: LoadCase.LoadDurationSp
    class GroundWaterElevation(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        GROUND_WATER_ELEVATION_MAXIMUM: _ClassVar[LoadCase.GroundWaterElevation]
        GROUND_WATER_ELEVATION_MINIMUM: _ClassVar[LoadCase.GroundWaterElevation]
    GROUND_WATER_ELEVATION_MAXIMUM: LoadCase.GroundWaterElevation
    GROUND_WATER_ELEVATION_MINIMUM: LoadCase.GroundWaterElevation
    class TypeOfImposedActions(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_RESIDENTIAL: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_BALUSTRADES: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_DOMESTIC_HOUSING: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_FLOORS_OFFICES: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_MACHINERY: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_OTHER_ROOFS: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_ROOFS: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_STORAGE: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_OFFICES: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_OTHER: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_PARKING: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_RETAIL: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_STORAGE: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_OTHER_ROOFS: _ClassVar[LoadCase.TypeOfImposedActions]
        TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_ROOFS: _ClassVar[LoadCase.TypeOfImposedActions]
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_RESIDENTIAL: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_BALUSTRADES: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_DOMESTIC_HOUSING: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_FLOORS_OFFICES: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_MACHINERY: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_OTHER_ROOFS: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_ROOFS: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_CONCENTRACED_STORAGE: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_OFFICES: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_OTHER: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_PARKING: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_RETAIL: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_FLOORS_STORAGE: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_OTHER_ROOFS: LoadCase.TypeOfImposedActions
    TYPE_OF_IMPOSED_ACTIONS_DISTRIBUTED_ROOFS: LoadCase.TypeOfImposedActions
    class IndividualFactorsOfSelectedObjectsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[LoadCase.IndividualFactorsOfSelectedObjectsTableRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[LoadCase.IndividualFactorsOfSelectedObjectsTableRow, _Mapping]]] = ...) -> None: ...
    class IndividualFactorsOfSelectedObjectsTableRow(_message.Message):
        __slots__ = ("no", "description", "object_type", "object_list", "strain", "factor", "comment")
        class ObjectType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            OBJECT_TYPE_UNKNOWN: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_LINE_HINGE: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_LINE_WITH_SUPPORT: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_MEMBER: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_MEMBER_HINGE: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_NODE_WITH_SUPPORT: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_SOLID: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
            OBJECT_TYPE_SURFACE: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType]
        OBJECT_TYPE_UNKNOWN: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_LINE_HINGE: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_LINE_WITH_SUPPORT: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_MEMBER: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_MEMBER_HINGE: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_NODE_WITH_SUPPORT: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_SOLID: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        OBJECT_TYPE_SURFACE: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        class Strain(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STRAIN_ALL: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
            STRAIN_ALONG_X: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
            STRAIN_ALONG_Y: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
            STRAIN_ALONG_Z: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
            STRAIN_AROUND_X: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
            STRAIN_AROUND_Y: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
            STRAIN_AROUND_Z: _ClassVar[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain]
        STRAIN_ALL: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        STRAIN_ALONG_X: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        STRAIN_ALONG_Y: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        STRAIN_ALONG_Z: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        STRAIN_AROUND_X: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        STRAIN_AROUND_Y: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        STRAIN_AROUND_Z: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        OBJECT_TYPE_FIELD_NUMBER: _ClassVar[int]
        OBJECT_LIST_FIELD_NUMBER: _ClassVar[int]
        STRAIN_FIELD_NUMBER: _ClassVar[int]
        FACTOR_FIELD_NUMBER: _ClassVar[int]
        COMMENT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        object_type: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType
        object_list: _containers.RepeatedScalarFieldContainer[int]
        strain: LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain
        factor: float
        comment: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., object_type: _Optional[_Union[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.ObjectType, str]] = ..., object_list: _Optional[_Iterable[int]] = ..., strain: _Optional[_Union[LoadCase.IndividualFactorsOfSelectedObjectsTableRow.Strain, str]] = ..., factor: _Optional[float] = ..., comment: _Optional[str] = ...) -> None: ...
    class SelectionOfModesModeActivationTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[LoadCase.SelectionOfModesModeActivationTableRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[LoadCase.SelectionOfModesModeActivationTableRow, _Mapping]]] = ...) -> None: ...
    class SelectionOfModesModeActivationTableRow(_message.Message):
        __slots__ = ("no", "description", "mode_no", "to_generate", "natural_period_t", "natural_frequency_f", "acceleration_s_ax", "acceleration_s_ay", "acceleration_s_az", "effective_modal_mass_factor_f_mex", "effective_modal_mass_factor_f_mey", "effective_modal_mass_factor_f_mez", "damping")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        MODE_NO_FIELD_NUMBER: _ClassVar[int]
        TO_GENERATE_FIELD_NUMBER: _ClassVar[int]
        NATURAL_PERIOD_T_FIELD_NUMBER: _ClassVar[int]
        NATURAL_FREQUENCY_F_FIELD_NUMBER: _ClassVar[int]
        ACCELERATION_S_AX_FIELD_NUMBER: _ClassVar[int]
        ACCELERATION_S_AY_FIELD_NUMBER: _ClassVar[int]
        ACCELERATION_S_AZ_FIELD_NUMBER: _ClassVar[int]
        EFFECTIVE_MODAL_MASS_FACTOR_F_MEX_FIELD_NUMBER: _ClassVar[int]
        EFFECTIVE_MODAL_MASS_FACTOR_F_MEY_FIELD_NUMBER: _ClassVar[int]
        EFFECTIVE_MODAL_MASS_FACTOR_F_MEZ_FIELD_NUMBER: _ClassVar[int]
        DAMPING_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        mode_no: int
        to_generate: bool
        natural_period_t: float
        natural_frequency_f: float
        acceleration_s_ax: float
        acceleration_s_ay: float
        acceleration_s_az: float
        effective_modal_mass_factor_f_mex: float
        effective_modal_mass_factor_f_mey: float
        effective_modal_mass_factor_f_mez: float
        damping: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., mode_no: _Optional[int] = ..., to_generate: bool = ..., natural_period_t: _Optional[float] = ..., natural_frequency_f: _Optional[float] = ..., acceleration_s_ax: _Optional[float] = ..., acceleration_s_ay: _Optional[float] = ..., acceleration_s_az: _Optional[float] = ..., effective_modal_mass_factor_f_mex: _Optional[float] = ..., effective_modal_mass_factor_f_mey: _Optional[float] = ..., effective_modal_mass_factor_f_mez: _Optional[float] = ..., damping: _Optional[float] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    ANALYSIS_TYPE_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    CALCULATE_CRITICAL_LOAD_FIELD_NUMBER: _ClassVar[int]
    STATIC_ANALYSIS_SETTINGS_FIELD_NUMBER: _ClassVar[int]
    STABILITY_ANALYSIS_SETTINGS_FIELD_NUMBER: _ClassVar[int]
    MODAL_ANALYSIS_SETTINGS_FIELD_NUMBER: _ClassVar[int]
    SPECTRAL_ANALYSIS_SETTINGS_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_IMPERFECTION_FIELD_NUMBER: _ClassVar[int]
    IMPERFECTION_CASE_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_INITIAL_STATE_FIELD_NUMBER: _ClassVar[int]
    INITIAL_STATE_CASE_FIELD_NUMBER: _ClassVar[int]
    INITIAL_STATE_DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
    INDIVIDUAL_FACTORS_OF_SELECTED_OBJECTS_TABLE_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_CONSTRUCTION_STAGE_FIELD_NUMBER: _ClassVar[int]
    CONSTRUCTION_STAGE_CASE_FIELD_NUMBER: _ClassVar[int]
    TO_SOLVE_FIELD_NUMBER: _ClassVar[int]
    ACTION_CATEGORY_FIELD_NUMBER: _ClassVar[int]
    SELF_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SELF_WEIGHT_FACTORS_FIELD_NUMBER: _ClassVar[int]
    SELF_WEIGHT_FACTOR_X_FIELD_NUMBER: _ClassVar[int]
    SELF_WEIGHT_FACTOR_Y_FIELD_NUMBER: _ClassVar[int]
    SELF_WEIGHT_FACTOR_Z_FIELD_NUMBER: _ClassVar[int]
    FACTOR_PHI_FIELD_NUMBER: _ClassVar[int]
    LOAD_DURATION_FIELD_NUMBER: _ClassVar[int]
    LOADING_START_FIELD_NUMBER: _ClassVar[int]
    TIME_BEING_INVESTIGATED_FIELD_NUMBER: _ClassVar[int]
    IMPORT_MASSES_FROM_FIELD_NUMBER: _ClassVar[int]
    IMPORT_MODAL_ANALYSIS_FROM_FIELD_NUMBER: _ClassVar[int]
    SELECTION_OF_MODES_MODE_ACTIVATION_TABLE_FIELD_NUMBER: _ClassVar[int]
    SELECTION_OF_MODES_DESELECT_MODES_ACCORDING_TO_CRITERION_IS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    SELECTION_OF_MODES_DESELECT_MODES_MODES_ACCORDING_TO_CRITERION_VALUE_FIELD_NUMBER: _ClassVar[int]
    SELECTION_OF_MODES_TOTAL_EFFECTIVE_MODAL_MASS_FACTOR_F_MEX_FIELD_NUMBER: _ClassVar[int]
    SELECTION_OF_MODES_TOTAL_EFFECTIVE_MODAL_MASS_FACTOR_F_MEY_FIELD_NUMBER: _ClassVar[int]
    SELECTION_OF_MODES_TOTAL_EFFECTIVE_MODAL_MASS_FACTOR_F_MEZ_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    IS_GENERATED_FIELD_NUMBER: _ClassVar[int]
    GENERATING_OBJECT_INFO_FIELD_NUMBER: _ClassVar[int]
    STRUCTURE_MODIFICATION_ENABLED_FIELD_NUMBER: _ClassVar[int]
    STRUCTURE_MODIFICATION_FIELD_NUMBER: _ClassVar[int]
    POSSIBILITY_OF_CROWDS_FIELD_NUMBER: _ClassVar[int]
    SPECIFICATION_FOR_LOAD_CASE_GR1A_FIELD_NUMBER: _ClassVar[int]
    SPECIFICATION_FOR_LOAD_CASE_GR2_FIELD_NUMBER: _ClassVar[int]
    SPECIFICATION_FOR_LOAD_CASE_GR5_FIELD_NUMBER: _ClassVar[int]
    SPECIFICATION_FOR_LOAD_CASE_GR6_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_LESS_EQUAL_100_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CHECK_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_COMBO_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_CHECK_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_CYTHYE_COMBO_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_WEIGHT_CHECK_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_WEIGHT_COMBO_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_CHECK_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBO_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_LESS_EQUAL_48_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_CHECK_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_ACI_COMBO_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_LESS_EQUAL_100_IBC_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_CHECK_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_IBC_COMBO_FIELD_NUMBER: _ClassVar[int]
    CRANEHOOKLOAD_NOCOMBINED_ROOFLIVELOAD_FIELD_NUMBER: _ClassVar[int]
    ROOF_CONFIGURATIONS_THAT_DO_NOT_SHED_SNOW_FIELD_NUMBER: _ClassVar[int]
    FLAT_ROOF_SNOW_LOAD_FIELD_NUMBER: _ClassVar[int]
    FLAT_ROOF_SNOW_LOAD_CATEGORY_FIELD_NUMBER: _ClassVar[int]
    DEADLOAD_FACTOR_SHALL_BE_INCREASED_FIELD_NUMBER: _ClassVar[int]
    DEADLOAD_FACTOR_SHALL_BE_INCREASED1_FIELD_NUMBER: _ClassVar[int]
    DEADLOAD_FACTOR_SHALL_BE_INCREASED2_FIELD_NUMBER: _ClassVar[int]
    DEAD_NO_EFFECTIVE_SEISMIC_WEIGHT_NBC05_FIELD_NUMBER: _ClassVar[int]
    DEAD_NO_EFFECTIVE_SEISMIC_WEIGHT_NBC15_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_PRINCIPAL_FACTOR_MAY_BE_REDUCED1_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_COMPANION_FACTOR_MAY_BE_INCREASED1_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_PRINCIPAL_FACTOR_MAY_BE_REDUCED2_FIELD_NUMBER: _ClassVar[int]
    LIVELOAD_COMPANION_FACTOR_MAY_BE_INCREASED2_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_NBC05_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_DESIGN_SITUATION_EFFECTIVE_SEISMIC_WEIGHT_NBC15_FIELD_NUMBER: _ClassVar[int]
    DEAD_NO_EFFECTIVE_SEISMIC_WEIGHT_FIELD_NUMBER: _ClassVar[int]
    LONGTERMLOAD_TP_CONSIDERED_IN_LIMIT_STATE_OF_SERVICEABILITY_FIELD_NUMBER: _ClassVar[int]
    GREATER_INTENSITY_THAN_4_FIELD_NUMBER: _ClassVar[int]
    DISTINGUISH_DIFFERENT_OVERSTRENGTH_FACTOR_IN_DIRECTION_XY_CHECK_FIELD_NUMBER: _ClassVar[int]
    DISTINGUISH_DIFFERENT_OVERSTRENGTH_FACTOR_IN_DIRECTION_XY_COMBO_FIELD_NUMBER: _ClassVar[int]
    LOAD_DURATION_SP_FIELD_NUMBER: _ClassVar[int]
    GROUND_WATER_ELEVATION_FIELD_NUMBER: _ClassVar[int]
    DIRECTION_X_CHECK_FIELD_NUMBER: _ClassVar[int]
    DIRECTION_Y_CHECK_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_INCLUSIVE_LOAD_CASE_FIELD_NUMBER: _ClassVar[int]
    INCLUSIVE_LOAD_CASE_FIELD_NUMBER: _ClassVar[int]
    CONSIDER_DESIGN_SITUATION_SEISMIC_MASS_COMBINATION_FIELD_NUMBER: _ClassVar[int]
    TYPE_OF_IMPOSED_ACTIONS_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_DIRECTION_ANGLE_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_DEPTH_MINUS_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_DEPTH_PLUS_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_WIDTH_MINUS_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_WIDTH_PLUS_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_HEIGHT_PLUS_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_CONSTRUCTION_BOUNDING_BOX_DEPTH_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_CONSTRUCTION_BOUNDING_BOX_HEIGHT_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_CONSTRUCTION_BOUNDING_BOX_WIDTH_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_DEPTH_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_WIDTH_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_HEIGHT_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_PROFILE_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_ANALYSIS_SETTINGS_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_DEPTH_MINUS_LENGTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_DEPTH_PLUS_LENGTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_WIDTH_MINUS_LENGTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_WIDTH_PLUS_LENGTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_HEIGHT_PLUS_LENGTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_CONSTRUCTION_BOUNDING_BOX_DEPTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_CONSTRUCTION_BOUNDING_BOX_HEIGHT_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_CONSTRUCTION_BOUNDING_BOX_WIDTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_DEPTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_WIDTH_FIELD_NUMBER: _ClassVar[int]
    WIND_SIMULATION_WIND_TUNNEL_HEIGHT_FIELD_NUMBER: _ClassVar[int]
    GEOTECHNICAL_ANALYSIS_RESET_SMALL_STRAIN_HISTORY_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    analysis_type: LoadCase.AnalysisType
    name: str
    calculate_critical_load: bool
    static_analysis_settings: int
    stability_analysis_settings: int
    modal_analysis_settings: int
    spectral_analysis_settings: int
    consider_imperfection: bool
    imperfection_case: int
    consider_initial_state: bool
    initial_state_case: _object_id_pb2.ObjectId
    initial_state_definition_type: LoadCase.InitialStateDefinitionType
    individual_factors_of_selected_objects_table: LoadCase.IndividualFactorsOfSelectedObjectsTable
    consider_construction_stage: bool
    construction_stage_case: int
    to_solve: bool
    action_category: LoadCase.ActionCategory
    self_weight_active: bool
    self_weight_factors: _common_pb2.Vector3d
    self_weight_factor_x: float
    self_weight_factor_y: float
    self_weight_factor_z: float
    factor_phi: LoadCase.FactorPhi
    load_duration: LoadCase.LoadDuration
    loading_start: float
    time_being_investigated: float
    import_masses_from: _object_id_pb2.ObjectId
    import_modal_analysis_from: int
    selection_of_modes_mode_activation_table: LoadCase.SelectionOfModesModeActivationTable
    selection_of_modes_deselect_modes_according_to_criterion_is_enabled: bool
    selection_of_modes_deselect_modes_modes_according_to_criterion_value: float
    selection_of_modes_total_effective_modal_mass_factor_f_mex: float
    selection_of_modes_total_effective_modal_mass_factor_f_mey: float
    selection_of_modes_total_effective_modal_mass_factor_f_mez: float
    comment: str
    is_generated: bool
    generating_object_info: str
    structure_modification_enabled: bool
    structure_modification: int
    possibility_of_crowds: bool
    specification_for_load_case_gr1a: LoadCase.SpecificationForLoadCaseGr1a
    specification_for_load_case_gr2: LoadCase.SpecificationForLoadCaseGr2
    specification_for_load_case_gr5: LoadCase.SpecificationForLoadCaseGr5
    specification_for_load_case_gr6: LoadCase.SpecificationForLoadCaseGr6
    liveload_less_equal_100: bool
    liveload_consider_design_situation_effective_seismic_weight_check: bool
    liveload_consider_design_situation_effective_seismic_weight_combo: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo
    liveload_consider_design_situation_effective_seismic_weight_CYTHYE_check: bool
    liveload_consider_design_situation_effective_seismic_weight_CYTHYE_combo: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo
    liveload_consider_design_situation_seismic_weight_check: bool
    liveload_consider_design_situation_seismic_weight_combo: LoadCase.LiveloadConsiderDesignSituationSeismicWeightCombo
    liveload_consider_design_situation_seismic_mass_check: bool
    liveload_consider_design_situation_seismic_mass_combo: LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo
    consider_design_situation_effective_seismic_weight: bool
    liveload_less_equal_48: bool
    liveload_consider_design_situation_effective_seismic_weight_aci_check: bool
    liveload_consider_design_situation_effective_seismic_weight_aci_combo: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo
    liveload_less_equal_100_ibc: bool
    liveload_consider_design_situation_effective_seismic_weight_ibc_check: bool
    liveload_consider_design_situation_effective_seismic_weight_ibc_combo: LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo
    cranehookload_nocombined_roofliveload: bool
    roof_configurations_that_do_not_shed_snow: bool
    flat_roof_snow_load: bool
    flat_roof_snow_load_category: LoadCase.FlatRoofSnowLoadCategory
    deadload_factor_shall_be_increased: bool
    deadload_factor_shall_be_increased1: bool
    deadload_factor_shall_be_increased2: bool
    dead_no_effective_seismic_weight_NBC05: bool
    dead_no_effective_seismic_weight_NBC15: bool
    liveload_principal_factor_may_be_reduced1: bool
    liveload_companion_factor_may_be_increased1: bool
    liveload_principal_factor_may_be_reduced2: bool
    liveload_companion_factor_may_be_increased2: bool
    consider_design_situation_effective_seismic_weight_NBC05: bool
    consider_design_situation_effective_seismic_weight_NBC15: bool
    dead_no_effective_seismic_weight: bool
    longtermload_tp_considered_in_limit_state_of_serviceability: bool
    greater_intensity_than_4: bool
    distinguish_different_overstrength_factor_in_direction_xy_check: bool
    distinguish_different_overstrength_factor_in_direction_xy_combo: LoadCase.DistinguishDifferentOverstrengthFactorInDirectionXyCombo
    load_duration_sp: LoadCase.LoadDurationSp
    ground_water_elevation: LoadCase.GroundWaterElevation
    direction_x_check: bool
    direction_y_check: bool
    consider_inclusive_load_case: bool
    inclusive_load_case: int
    consider_design_situation_seismic_mass_combination: bool
    type_of_imposed_actions: LoadCase.TypeOfImposedActions
    wind_simulation_wind_direction_angle: float
    wind_simulation_wind_tunnel_depth_minus_coefficient: float
    wind_simulation_wind_tunnel_depth_plus_coefficient: float
    wind_simulation_wind_tunnel_width_minus_coefficient: float
    wind_simulation_wind_tunnel_width_plus_coefficient: float
    wind_simulation_wind_tunnel_height_plus_coefficient: float
    wind_simulation_construction_bounding_box_depth_coefficient: float
    wind_simulation_construction_bounding_box_height_coefficient: float
    wind_simulation_construction_bounding_box_width_coefficient: float
    wind_simulation_wind_tunnel_depth_coefficient: float
    wind_simulation_wind_tunnel_width_coefficient: float
    wind_simulation_wind_tunnel_height_coefficient: float
    wind_simulation_wind_profile: int
    wind_simulation_analysis_settings: int
    wind_simulation_wind_tunnel_depth_minus_length: float
    wind_simulation_wind_tunnel_depth_plus_length: float
    wind_simulation_wind_tunnel_width_minus_length: float
    wind_simulation_wind_tunnel_width_plus_length: float
    wind_simulation_wind_tunnel_height_plus_length: float
    wind_simulation_construction_bounding_box_depth: float
    wind_simulation_construction_bounding_box_height: float
    wind_simulation_construction_bounding_box_width: float
    wind_simulation_wind_tunnel_depth: float
    wind_simulation_wind_tunnel_width: float
    wind_simulation_wind_tunnel_height: float
    geotechnical_analysis_reset_small_strain_history: bool
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., analysis_type: _Optional[_Union[LoadCase.AnalysisType, str]] = ..., name: _Optional[str] = ..., calculate_critical_load: bool = ..., static_analysis_settings: _Optional[int] = ..., stability_analysis_settings: _Optional[int] = ..., modal_analysis_settings: _Optional[int] = ..., spectral_analysis_settings: _Optional[int] = ..., consider_imperfection: bool = ..., imperfection_case: _Optional[int] = ..., consider_initial_state: bool = ..., initial_state_case: _Optional[_Union[_object_id_pb2.ObjectId, _Mapping]] = ..., initial_state_definition_type: _Optional[_Union[LoadCase.InitialStateDefinitionType, str]] = ..., individual_factors_of_selected_objects_table: _Optional[_Union[LoadCase.IndividualFactorsOfSelectedObjectsTable, _Mapping]] = ..., consider_construction_stage: bool = ..., construction_stage_case: _Optional[int] = ..., to_solve: bool = ..., action_category: _Optional[_Union[LoadCase.ActionCategory, str]] = ..., self_weight_active: bool = ..., self_weight_factors: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., self_weight_factor_x: _Optional[float] = ..., self_weight_factor_y: _Optional[float] = ..., self_weight_factor_z: _Optional[float] = ..., factor_phi: _Optional[_Union[LoadCase.FactorPhi, str]] = ..., load_duration: _Optional[_Union[LoadCase.LoadDuration, str]] = ..., loading_start: _Optional[float] = ..., time_being_investigated: _Optional[float] = ..., import_masses_from: _Optional[_Union[_object_id_pb2.ObjectId, _Mapping]] = ..., import_modal_analysis_from: _Optional[int] = ..., selection_of_modes_mode_activation_table: _Optional[_Union[LoadCase.SelectionOfModesModeActivationTable, _Mapping]] = ..., selection_of_modes_deselect_modes_according_to_criterion_is_enabled: bool = ..., selection_of_modes_deselect_modes_modes_according_to_criterion_value: _Optional[float] = ..., selection_of_modes_total_effective_modal_mass_factor_f_mex: _Optional[float] = ..., selection_of_modes_total_effective_modal_mass_factor_f_mey: _Optional[float] = ..., selection_of_modes_total_effective_modal_mass_factor_f_mez: _Optional[float] = ..., comment: _Optional[str] = ..., is_generated: bool = ..., generating_object_info: _Optional[str] = ..., structure_modification_enabled: bool = ..., structure_modification: _Optional[int] = ..., possibility_of_crowds: bool = ..., specification_for_load_case_gr1a: _Optional[_Union[LoadCase.SpecificationForLoadCaseGr1a, str]] = ..., specification_for_load_case_gr2: _Optional[_Union[LoadCase.SpecificationForLoadCaseGr2, str]] = ..., specification_for_load_case_gr5: _Optional[_Union[LoadCase.SpecificationForLoadCaseGr5, str]] = ..., specification_for_load_case_gr6: _Optional[_Union[LoadCase.SpecificationForLoadCaseGr6, str]] = ..., liveload_less_equal_100: bool = ..., liveload_consider_design_situation_effective_seismic_weight_check: bool = ..., liveload_consider_design_situation_effective_seismic_weight_combo: _Optional[_Union[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCombo, str]] = ..., liveload_consider_design_situation_effective_seismic_weight_CYTHYE_check: bool = ..., liveload_consider_design_situation_effective_seismic_weight_CYTHYE_combo: _Optional[_Union[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightCythyeCombo, str]] = ..., liveload_consider_design_situation_seismic_weight_check: bool = ..., liveload_consider_design_situation_seismic_weight_combo: _Optional[_Union[LoadCase.LiveloadConsiderDesignSituationSeismicWeightCombo, str]] = ..., liveload_consider_design_situation_seismic_mass_check: bool = ..., liveload_consider_design_situation_seismic_mass_combo: _Optional[_Union[LoadCase.LiveloadConsiderDesignSituationSeismicMassCombo, str]] = ..., consider_design_situation_effective_seismic_weight: bool = ..., liveload_less_equal_48: bool = ..., liveload_consider_design_situation_effective_seismic_weight_aci_check: bool = ..., liveload_consider_design_situation_effective_seismic_weight_aci_combo: _Optional[_Union[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightAciCombo, str]] = ..., liveload_less_equal_100_ibc: bool = ..., liveload_consider_design_situation_effective_seismic_weight_ibc_check: bool = ..., liveload_consider_design_situation_effective_seismic_weight_ibc_combo: _Optional[_Union[LoadCase.LiveloadConsiderDesignSituationEffectiveSeismicWeightIbcCombo, str]] = ..., cranehookload_nocombined_roofliveload: bool = ..., roof_configurations_that_do_not_shed_snow: bool = ..., flat_roof_snow_load: bool = ..., flat_roof_snow_load_category: _Optional[_Union[LoadCase.FlatRoofSnowLoadCategory, str]] = ..., deadload_factor_shall_be_increased: bool = ..., deadload_factor_shall_be_increased1: bool = ..., deadload_factor_shall_be_increased2: bool = ..., dead_no_effective_seismic_weight_NBC05: bool = ..., dead_no_effective_seismic_weight_NBC15: bool = ..., liveload_principal_factor_may_be_reduced1: bool = ..., liveload_companion_factor_may_be_increased1: bool = ..., liveload_principal_factor_may_be_reduced2: bool = ..., liveload_companion_factor_may_be_increased2: bool = ..., consider_design_situation_effective_seismic_weight_NBC05: bool = ..., consider_design_situation_effective_seismic_weight_NBC15: bool = ..., dead_no_effective_seismic_weight: bool = ..., longtermload_tp_considered_in_limit_state_of_serviceability: bool = ..., greater_intensity_than_4: bool = ..., distinguish_different_overstrength_factor_in_direction_xy_check: bool = ..., distinguish_different_overstrength_factor_in_direction_xy_combo: _Optional[_Union[LoadCase.DistinguishDifferentOverstrengthFactorInDirectionXyCombo, str]] = ..., load_duration_sp: _Optional[_Union[LoadCase.LoadDurationSp, str]] = ..., ground_water_elevation: _Optional[_Union[LoadCase.GroundWaterElevation, str]] = ..., direction_x_check: bool = ..., direction_y_check: bool = ..., consider_inclusive_load_case: bool = ..., inclusive_load_case: _Optional[int] = ..., consider_design_situation_seismic_mass_combination: bool = ..., type_of_imposed_actions: _Optional[_Union[LoadCase.TypeOfImposedActions, str]] = ..., wind_simulation_wind_direction_angle: _Optional[float] = ..., wind_simulation_wind_tunnel_depth_minus_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_depth_plus_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_width_minus_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_width_plus_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_height_plus_coefficient: _Optional[float] = ..., wind_simulation_construction_bounding_box_depth_coefficient: _Optional[float] = ..., wind_simulation_construction_bounding_box_height_coefficient: _Optional[float] = ..., wind_simulation_construction_bounding_box_width_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_depth_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_width_coefficient: _Optional[float] = ..., wind_simulation_wind_tunnel_height_coefficient: _Optional[float] = ..., wind_simulation_wind_profile: _Optional[int] = ..., wind_simulation_analysis_settings: _Optional[int] = ..., wind_simulation_wind_tunnel_depth_minus_length: _Optional[float] = ..., wind_simulation_wind_tunnel_depth_plus_length: _Optional[float] = ..., wind_simulation_wind_tunnel_width_minus_length: _Optional[float] = ..., wind_simulation_wind_tunnel_width_plus_length: _Optional[float] = ..., wind_simulation_wind_tunnel_height_plus_length: _Optional[float] = ..., wind_simulation_construction_bounding_box_depth: _Optional[float] = ..., wind_simulation_construction_bounding_box_height: _Optional[float] = ..., wind_simulation_construction_bounding_box_width: _Optional[float] = ..., wind_simulation_wind_tunnel_depth: _Optional[float] = ..., wind_simulation_wind_tunnel_width: _Optional[float] = ..., wind_simulation_wind_tunnel_height: _Optional[float] = ..., geotechnical_analysis_reset_small_strain_history: bool = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
