from dlubal.api.common import common_pb2 as _common_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class Member(_message.Message):
    __slots__ = ("no", "type", "is_deactivated_for_calculation", "line", "section_distribution_type", "reference_type", "nodes", "node_start", "node_end", "analytical_length", "analytical_volume", "analytical_surface_of_coating", "analytical_mass", "surface_of_coating", "analytical_center_of_gravity", "analytical_center_of_gravity_x", "analytical_center_of_gravity_y", "analytical_center_of_gravity_z", "length", "volume", "mass", "center_of_gravity", "center_of_gravity_x", "center_of_gravity_y", "center_of_gravity_z", "member_representative", "design_properties_via_member", "design_properties_via_parent_member_set", "design_properties_parent_member_set", "comment", "member_type_rib_alignment", "member_rib_first_surface", "member_rib_second_surface", "member_rib_surface_assignment_autodetect", "align_local_z_axis_to_local_z_axis_of_surface", "member_rib_shear_joint_between_web_and_flange", "member_rib_surface_roughness_classification", "member_rib_reduction_of_joint_width", "flange_dimensions", "synchronize_width_mode", "relative_ordinates_mode", "member_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled", "member_type_definable_stiffness", "result_beam_integrate_stresses_and_forces", "result_beam_y_z", "result_beam_y_plus", "result_beam_z_plus", "result_beam_y_minus", "result_beam_z_minus", "result_beam_radius", "result_beam_include_all_surfaces", "result_beam_include_surfaces", "result_beam_include_all_solids", "result_beam_include_solids", "result_beam_include_all_members", "result_beam_include_members", "result_beam_exclude_surfaces", "result_beam_exclude_solids", "result_beam_exclude_members", "projected_length", "section_distance_from_start_is_defined_as_relative", "section_distance_from_start_absolute", "section_distance_from_start_relative", "section_distance_from_end_is_defined_as_relative", "section_distance_from_end_absolute", "section_distance_from_end_relative", "section_alignment", "section_start", "section_end", "section_internal", "section_material", "grain_alignment", "is_curved", "curved_member_is_asymmetric_layout", "curved_member_is_cantilevers", "curved_member_cantilevers_type", "curved_member_is_capped_with_loose_ridge_wedge", "curved_member_parameters", "rotation_specification_type", "rotation_angle", "rotation_help_node", "rotation_plane_type", "rotation_surface", "rotation_surface_plane_type", "is_rotated", "member_hinge_start", "member_hinge_end", "member_eccentricity_start", "member_eccentricity_end", "support", "member_transverse_stiffener", "member_openings", "member_nonlinearity", "member_result_intermediate_point", "stress_analysis_configuration", "aluminum_effective_lengths", "aluminum_boundary_conditions", "aluminum_member_local_section_reduction", "aluminum_member_transverse_weld", "member_aluminum_design_uls_configuration", "member_aluminum_design_sls_configuration", "concrete_effective_lengths", "concrete_cover_user_defined_enabled", "concrete_cover", "concrete_cover_top", "concrete_cover_left", "concrete_cover_right", "concrete_cover_bottom", "concrete_cover_min", "concrete_cover_min_top", "concrete_cover_min_left", "concrete_cover_min_right", "concrete_cover_min_bottom", "concrete_cover_different_at_section_sides_enabled", "concrete_durability", "concrete_durability_top", "concrete_durability_left", "concrete_durability_right", "concrete_durability_bottom", "concrete_shear_reinforcement_spans", "concrete_longitudinal_reinforcement_items", "member_concrete_design_uls_configuration", "member_concrete_design_sls_configuration", "member_concrete_design_fr_configuration", "member_concrete_design_seismic_configuration", "steel_effective_lengths", "steel_boundary_conditions", "steel_member_local_section_reduction", "steel_member_transverse_weld", "member_steel_design_uls_configuration", "member_steel_design_sls_configuration", "member_steel_design_fr_configuration", "timber_effective_lengths", "timber_service_class", "timber_moisture_class", "timber_service_conditions", "timber_member_local_section_reduction", "member_timber_design_uls_configuration", "member_timber_design_sls_configuration", "member_timber_design_fr_configuration", "end_modifications_member_start_extension", "end_modifications_member_start_slope_y", "end_modifications_member_start_slope_z", "end_modifications_member_end_extension", "end_modifications_member_end_slope_y", "end_modifications_member_end_slope_z", "has_any_end_modifications", "deflection_check_direction", "deflection_check_displacement_reference", "deflection_segments_z_axis", "deflection_segments_y_axis", "design_support_on_member_start", "design_support_on_member_end", "design_supports_on_internal_nodes", "deflection_segments_defined_length_z_axis_enabled", "deflection_segments_defined_length_y_axis_enabled", "member_type_spring", "member_type_damper_spring", "member_type_damper_damping_coefficient", "generating_object_info", "is_generated", "id_for_export_import", "metadata_for_export_import")
    class Type(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        TYPE_UNKNOWN: _ClassVar[Member.Type]
        TYPE_ANCHOR: _ClassVar[Member.Type]
        TYPE_BEAM: _ClassVar[Member.Type]
        TYPE_BUCKLING: _ClassVar[Member.Type]
        TYPE_CABLE: _ClassVar[Member.Type]
        TYPE_CABLE_ON_PULLEYS: _ClassVar[Member.Type]
        TYPE_COMPRESSION: _ClassVar[Member.Type]
        TYPE_COUPLING_HINGE_HINGE: _ClassVar[Member.Type]
        TYPE_COUPLING_HINGE_RIGID: _ClassVar[Member.Type]
        TYPE_COUPLING_RIGID_HINGE: _ClassVar[Member.Type]
        TYPE_COUPLING_RIGID_RIGID: _ClassVar[Member.Type]
        TYPE_DAMPER: _ClassVar[Member.Type]
        TYPE_DEEP_BEAM: _ClassVar[Member.Type]
        TYPE_DEFINABLE_STIFFNESS: _ClassVar[Member.Type]
        TYPE_DESIGN_STRIP: _ClassVar[Member.Type]
        TYPE_JOIST: _ClassVar[Member.Type]
        TYPE_PILE: _ClassVar[Member.Type]
        TYPE_RESULT_BEAM: _ClassVar[Member.Type]
        TYPE_RESULT_LINE: _ClassVar[Member.Type]
        TYPE_RIB: _ClassVar[Member.Type]
        TYPE_RIGID: _ClassVar[Member.Type]
        TYPE_SHEAR_WALL: _ClassVar[Member.Type]
        TYPE_SPRING: _ClassVar[Member.Type]
        TYPE_SURFACE_MODEL: _ClassVar[Member.Type]
        TYPE_TENDON: _ClassVar[Member.Type]
        TYPE_TENSION: _ClassVar[Member.Type]
        TYPE_TRUSS: _ClassVar[Member.Type]
        TYPE_TRUSS_ONLY_N: _ClassVar[Member.Type]
    TYPE_UNKNOWN: Member.Type
    TYPE_ANCHOR: Member.Type
    TYPE_BEAM: Member.Type
    TYPE_BUCKLING: Member.Type
    TYPE_CABLE: Member.Type
    TYPE_CABLE_ON_PULLEYS: Member.Type
    TYPE_COMPRESSION: Member.Type
    TYPE_COUPLING_HINGE_HINGE: Member.Type
    TYPE_COUPLING_HINGE_RIGID: Member.Type
    TYPE_COUPLING_RIGID_HINGE: Member.Type
    TYPE_COUPLING_RIGID_RIGID: Member.Type
    TYPE_DAMPER: Member.Type
    TYPE_DEEP_BEAM: Member.Type
    TYPE_DEFINABLE_STIFFNESS: Member.Type
    TYPE_DESIGN_STRIP: Member.Type
    TYPE_JOIST: Member.Type
    TYPE_PILE: Member.Type
    TYPE_RESULT_BEAM: Member.Type
    TYPE_RESULT_LINE: Member.Type
    TYPE_RIB: Member.Type
    TYPE_RIGID: Member.Type
    TYPE_SHEAR_WALL: Member.Type
    TYPE_SPRING: Member.Type
    TYPE_SURFACE_MODEL: Member.Type
    TYPE_TENDON: Member.Type
    TYPE_TENSION: Member.Type
    TYPE_TRUSS: Member.Type
    TYPE_TRUSS_ONLY_N: Member.Type
    class SectionDistributionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SECTION_DISTRIBUTION_TYPE_UNIFORM: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_CURVED: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_FISH_BEAM_LINEAR: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_FISH_BEAM_PARABOLIC: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_LINEAR: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_NONE: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_OFFSET_AT_BOTH_SIDES: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_OFFSET_AT_END_OF_MEMBER: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_OFFSET_AT_START_OF_MEMBER: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_CONSTANT_HEIGHT: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_VARIABLE_HEIGHT: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_SADDLE: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AT_BOTH_SIDES: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AT_END_OF_MEMBER: _ClassVar[Member.SectionDistributionType]
        SECTION_DISTRIBUTION_TYPE_TAPERED_AT_START_OF_MEMBER: _ClassVar[Member.SectionDistributionType]
    SECTION_DISTRIBUTION_TYPE_UNIFORM: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_CURVED: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_FISH_BEAM_LINEAR: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_FISH_BEAM_PARABOLIC: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_LINEAR: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_NONE: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_BOTH_SIDES: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_END_OF_MEMBER: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_OFFSET_AT_START_OF_MEMBER: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_CONSTANT_HEIGHT: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_PITCHED_CAMBERED_BEAM_WITH_VARIABLE_HEIGHT: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_SADDLE: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_BOTH_SIDES: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_END_OF_MEMBER: Member.SectionDistributionType
    SECTION_DISTRIBUTION_TYPE_TAPERED_AT_START_OF_MEMBER: Member.SectionDistributionType
    class ReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REFERENCE_TYPE_L: _ClassVar[Member.ReferenceType]
        REFERENCE_TYPE_XY: _ClassVar[Member.ReferenceType]
        REFERENCE_TYPE_XZ: _ClassVar[Member.ReferenceType]
        REFERENCE_TYPE_YZ: _ClassVar[Member.ReferenceType]
    REFERENCE_TYPE_L: Member.ReferenceType
    REFERENCE_TYPE_XY: Member.ReferenceType
    REFERENCE_TYPE_XZ: Member.ReferenceType
    REFERENCE_TYPE_YZ: Member.ReferenceType
    class MemberTypeRibAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_NEGATIVE: _ClassVar[Member.MemberTypeRibAlignment]
        MEMBER_TYPE_RIB_ALIGNMENT_CENTRIC: _ClassVar[Member.MemberTypeRibAlignment]
        MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_POSITIVE: _ClassVar[Member.MemberTypeRibAlignment]
        MEMBER_TYPE_RIB_ALIGNMENT_USER_DEFINED_VIA_MEMBER_ECCENTRICITY: _ClassVar[Member.MemberTypeRibAlignment]
    MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_NEGATIVE: Member.MemberTypeRibAlignment
    MEMBER_TYPE_RIB_ALIGNMENT_CENTRIC: Member.MemberTypeRibAlignment
    MEMBER_TYPE_RIB_ALIGNMENT_ON_Z_SIDE_POSITIVE: Member.MemberTypeRibAlignment
    MEMBER_TYPE_RIB_ALIGNMENT_USER_DEFINED_VIA_MEMBER_ECCENTRICITY: Member.MemberTypeRibAlignment
    class MemberRibSurfaceRoughnessClassification(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_INDENTED: _ClassVar[Member.MemberRibSurfaceRoughnessClassification]
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_ROUGH: _ClassVar[Member.MemberRibSurfaceRoughnessClassification]
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_SMOOTH: _ClassVar[Member.MemberRibSurfaceRoughnessClassification]
        MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_VERY_SMOOTH: _ClassVar[Member.MemberRibSurfaceRoughnessClassification]
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_INDENTED: Member.MemberRibSurfaceRoughnessClassification
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_ROUGH: Member.MemberRibSurfaceRoughnessClassification
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_SMOOTH: Member.MemberRibSurfaceRoughnessClassification
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_VERY_SMOOTH: Member.MemberRibSurfaceRoughnessClassification
    class ResultBeamIntegrateStressesAndForces(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_QUADRATIC: _ClassVar[Member.ResultBeamIntegrateStressesAndForces]
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_FROM_LISTED_INCLUDE_OBJECTS: _ClassVar[Member.ResultBeamIntegrateStressesAndForces]
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_GENERAL: _ClassVar[Member.ResultBeamIntegrateStressesAndForces]
        RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CYLINDER: _ClassVar[Member.ResultBeamIntegrateStressesAndForces]
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_QUADRATIC: Member.ResultBeamIntegrateStressesAndForces
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_FROM_LISTED_INCLUDE_OBJECTS: Member.ResultBeamIntegrateStressesAndForces
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CUBOID_GENERAL: Member.ResultBeamIntegrateStressesAndForces
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_WITHIN_CYLINDER: Member.ResultBeamIntegrateStressesAndForces
    class SectionAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SECTION_ALIGNMENT_TOP: _ClassVar[Member.SectionAlignment]
        SECTION_ALIGNMENT_BOTTOM: _ClassVar[Member.SectionAlignment]
        SECTION_ALIGNMENT_CENTRIC: _ClassVar[Member.SectionAlignment]
    SECTION_ALIGNMENT_TOP: Member.SectionAlignment
    SECTION_ALIGNMENT_BOTTOM: Member.SectionAlignment
    SECTION_ALIGNMENT_CENTRIC: Member.SectionAlignment
    class GrainAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        GRAIN_ALIGNMENT_TOP: _ClassVar[Member.GrainAlignment]
        GRAIN_ALIGNMENT_BOTTOM: _ClassVar[Member.GrainAlignment]
        GRAIN_ALIGNMENT_CENTRIC: _ClassVar[Member.GrainAlignment]
    GRAIN_ALIGNMENT_TOP: Member.GrainAlignment
    GRAIN_ALIGNMENT_BOTTOM: Member.GrainAlignment
    GRAIN_ALIGNMENT_CENTRIC: Member.GrainAlignment
    class CurvedMemberCantileversType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        CURVED_MEMBER_CANTILEVERS_TYPE_HORIZONTAL: _ClassVar[Member.CurvedMemberCantileversType]
        CURVED_MEMBER_CANTILEVERS_TYPE_OFFSET: _ClassVar[Member.CurvedMemberCantileversType]
        CURVED_MEMBER_CANTILEVERS_TYPE_PARALLEL: _ClassVar[Member.CurvedMemberCantileversType]
        CURVED_MEMBER_CANTILEVERS_TYPE_TAPER: _ClassVar[Member.CurvedMemberCantileversType]
    CURVED_MEMBER_CANTILEVERS_TYPE_HORIZONTAL: Member.CurvedMemberCantileversType
    CURVED_MEMBER_CANTILEVERS_TYPE_OFFSET: Member.CurvedMemberCantileversType
    CURVED_MEMBER_CANTILEVERS_TYPE_PARALLEL: Member.CurvedMemberCantileversType
    CURVED_MEMBER_CANTILEVERS_TYPE_TAPER: Member.CurvedMemberCantileversType
    class RotationSpecificationType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROTATION_SPECIFICATION_TYPE_BY_ANGLE: _ClassVar[Member.RotationSpecificationType]
        ROTATION_SPECIFICATION_TYPE_INSIDE: _ClassVar[Member.RotationSpecificationType]
        ROTATION_SPECIFICATION_TYPE_SURFACE: _ClassVar[Member.RotationSpecificationType]
        ROTATION_SPECIFICATION_TYPE_TO_NODE: _ClassVar[Member.RotationSpecificationType]
    ROTATION_SPECIFICATION_TYPE_BY_ANGLE: Member.RotationSpecificationType
    ROTATION_SPECIFICATION_TYPE_INSIDE: Member.RotationSpecificationType
    ROTATION_SPECIFICATION_TYPE_SURFACE: Member.RotationSpecificationType
    ROTATION_SPECIFICATION_TYPE_TO_NODE: Member.RotationSpecificationType
    class RotationPlaneType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROTATION_PLANE_TYPE_ROTATION_PLANE_XY: _ClassVar[Member.RotationPlaneType]
        ROTATION_PLANE_TYPE_ROTATION_PLANE_XZ: _ClassVar[Member.RotationPlaneType]
    ROTATION_PLANE_TYPE_ROTATION_PLANE_XY: Member.RotationPlaneType
    ROTATION_PLANE_TYPE_ROTATION_PLANE_XZ: Member.RotationPlaneType
    class RotationSurfacePlaneType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XY: _ClassVar[Member.RotationSurfacePlaneType]
        ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XZ: _ClassVar[Member.RotationSurfacePlaneType]
    ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XY: Member.RotationSurfacePlaneType
    ROTATION_SURFACE_PLANE_TYPE_ROTATION_PLANE_XZ: Member.RotationSurfacePlaneType
    class DeflectionCheckDirection(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z: _ClassVar[Member.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Y: _ClassVar[Member.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z: _ClassVar[Member.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z_AND_Y: _ClassVar[Member.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Y: _ClassVar[Member.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z_AND_Y: _ClassVar[Member.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_RESULTING_AXIS: _ClassVar[Member.DeflectionCheckDirection]
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z: Member.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Y: Member.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z: Member.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z_AND_Y: Member.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Y: Member.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z_AND_Y: Member.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_RESULTING_AXIS: Member.DeflectionCheckDirection
    class DeflectionCheckDisplacementReference(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_SEGMENT_ENDS: _ClassVar[Member.DeflectionCheckDisplacementReference]
        DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_UNDEFORMED_SYSTEM: _ClassVar[Member.DeflectionCheckDisplacementReference]
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_SEGMENT_ENDS: Member.DeflectionCheckDisplacementReference
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_UNDEFORMED_SYSTEM: Member.DeflectionCheckDisplacementReference
    class FlangeDimensionsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.FlangeDimensionsRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.FlangeDimensionsRow, _Mapping]]] = ...) -> None: ...
    class FlangeDimensionsRow(_message.Message):
        __slots__ = ("no", "description", "end_ordinate", "length", "reference_length_definition_type", "reference_length", "reference_length_width", "width_minus_y_integrative", "width_minus_y_effictive", "width_minus_y_maximal", "width_plus_y_integrative", "width_plus_y_effictive", "width_plus_y_maximal", "distribution_linearity")
        class ReferenceLengthDefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_SEGMENT_LENGTH: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthDefinitionType]
            REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_MEMBER_LENGTH: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthDefinitionType]
            REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_USER_DEFINED: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthDefinitionType]
        REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_SEGMENT_LENGTH: Member.FlangeDimensionsRow.ReferenceLengthDefinitionType
        REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_MEMBER_LENGTH: Member.FlangeDimensionsRow.ReferenceLengthDefinitionType
        REFERENCE_LENGTH_DEFINITION_TYPE_REFERENCE_LENGTH_TYPE_USER_DEFINED: Member.FlangeDimensionsRow.ReferenceLengthDefinitionType
        class ReferenceLengthWidth(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REFERENCE_LENGTH_WIDTH_NONE: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthWidth]
            REFERENCE_LENGTH_WIDTH_EC2: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthWidth]
            REFERENCE_LENGTH_WIDTH_EIGHTH: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthWidth]
            REFERENCE_LENGTH_WIDTH_SIXTH: _ClassVar[Member.FlangeDimensionsRow.ReferenceLengthWidth]
        REFERENCE_LENGTH_WIDTH_NONE: Member.FlangeDimensionsRow.ReferenceLengthWidth
        REFERENCE_LENGTH_WIDTH_EC2: Member.FlangeDimensionsRow.ReferenceLengthWidth
        REFERENCE_LENGTH_WIDTH_EIGHTH: Member.FlangeDimensionsRow.ReferenceLengthWidth
        REFERENCE_LENGTH_WIDTH_SIXTH: Member.FlangeDimensionsRow.ReferenceLengthWidth
        class DistributionLinearity(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_NONE: _ClassVar[Member.FlangeDimensionsRow.DistributionLinearity]
            DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_FROM_START: _ClassVar[Member.FlangeDimensionsRow.DistributionLinearity]
            DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_TO_END: _ClassVar[Member.FlangeDimensionsRow.DistributionLinearity]
        DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_NONE: Member.FlangeDimensionsRow.DistributionLinearity
        DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_FROM_START: Member.FlangeDimensionsRow.DistributionLinearity
        DISTRIBUTION_LINEARITY_SEGMENT_LINEARITY_TO_END: Member.FlangeDimensionsRow.DistributionLinearity
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        END_ORDINATE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_LENGTH_DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_LENGTH_WIDTH_FIELD_NUMBER: _ClassVar[int]
        WIDTH_MINUS_Y_INTEGRATIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_MINUS_Y_EFFICTIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_MINUS_Y_MAXIMAL_FIELD_NUMBER: _ClassVar[int]
        WIDTH_PLUS_Y_INTEGRATIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_PLUS_Y_EFFICTIVE_FIELD_NUMBER: _ClassVar[int]
        WIDTH_PLUS_Y_MAXIMAL_FIELD_NUMBER: _ClassVar[int]
        DISTRIBUTION_LINEARITY_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        end_ordinate: float
        length: float
        reference_length_definition_type: Member.FlangeDimensionsRow.ReferenceLengthDefinitionType
        reference_length: float
        reference_length_width: Member.FlangeDimensionsRow.ReferenceLengthWidth
        width_minus_y_integrative: float
        width_minus_y_effictive: float
        width_minus_y_maximal: float
        width_plus_y_integrative: float
        width_plus_y_effictive: float
        width_plus_y_maximal: float
        distribution_linearity: Member.FlangeDimensionsRow.DistributionLinearity
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., end_ordinate: _Optional[float] = ..., length: _Optional[float] = ..., reference_length_definition_type: _Optional[_Union[Member.FlangeDimensionsRow.ReferenceLengthDefinitionType, str]] = ..., reference_length: _Optional[float] = ..., reference_length_width: _Optional[_Union[Member.FlangeDimensionsRow.ReferenceLengthWidth, str]] = ..., width_minus_y_integrative: _Optional[float] = ..., width_minus_y_effictive: _Optional[float] = ..., width_minus_y_maximal: _Optional[float] = ..., width_plus_y_integrative: _Optional[float] = ..., width_plus_y_effictive: _Optional[float] = ..., width_plus_y_maximal: _Optional[float] = ..., distribution_linearity: _Optional[_Union[Member.FlangeDimensionsRow.DistributionLinearity, str]] = ...) -> None: ...
    class CurvedMemberParametersTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.CurvedMemberParametersTableRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.CurvedMemberParametersTableRow, _Mapping]]] = ...) -> None: ...
    class CurvedMemberParametersTableRow(_message.Message):
        __slots__ = ("key", "caption", "symbol", "value", "unit", "note", "children")
        KEY_FIELD_NUMBER: _ClassVar[int]
        CAPTION_FIELD_NUMBER: _ClassVar[int]
        SYMBOL_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        UNIT_FIELD_NUMBER: _ClassVar[int]
        NOTE_FIELD_NUMBER: _ClassVar[int]
        CHILDREN_FIELD_NUMBER: _ClassVar[int]
        key: str
        caption: str
        symbol: str
        value: float
        unit: str
        note: str
        children: _containers.RepeatedCompositeFieldContainer[Member.CurvedMemberParametersTableRow]
        def __init__(self, key: _Optional[str] = ..., caption: _Optional[str] = ..., symbol: _Optional[str] = ..., value: _Optional[float] = ..., unit: _Optional[str] = ..., note: _Optional[str] = ..., children: _Optional[_Iterable[_Union[Member.CurvedMemberParametersTableRow, _Mapping]]] = ...) -> None: ...
    class ConcreteShearReinforcementSpansTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.ConcreteShearReinforcementSpansRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.ConcreteShearReinforcementSpansRow, _Mapping]]] = ...) -> None: ...
    class ConcreteShearReinforcementSpansRow(_message.Message):
        __slots__ = ("no", "description", "name", "stirrup_type", "material", "stirrup_count", "stirrup_bar_size", "stirrup_bar_size_calculated", "stirrup_diameter", "stirrup_diameter_calculated", "stirrup_diameter_auto_enabled", "stirrup_bar_size_auto_minimum", "stirrup_diameter_auto_minimum", "stirrup_bar_size_auto_maximum", "stirrup_diameter_auto_maximum", "stirrup_diameter_auto_diameters_enabled", "stirrup_diameter_auto_diameters", "stirrup_diameter_auto_priority", "stirrup_distances", "stirrup_distances_calculated", "stirrup_distances_auto_enabled", "stirrup_distances_auto_minimum", "stirrup_distances_auto_maximum", "stirrup_distances_auto_increment", "stirrup_distances_auto_priority", "crossties_active", "crossties_diameter", "reinforcement_area", "horizontal_crosstie_reinforcement_area", "minimal_maximal_horizontal_crosstie_reinforcement_area", "vertical_crosstie_reinforcement_area", "minimal_maximal_vertical_crosstie_reinforcement_area", "total_horizontal_reinforcement_area", "minimal_maximal_total_horizontal_reinforcement_area", "total_vertical_reinforcement_area", "minimal_maximal_total_vertical_reinforcement_area", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "stirrup_layout_rule", "stirrup_start_offset", "stirrup_end_offset", "one_stirrup_length", "minimal_and_maximal_stirrup_length", "all_stirrups_length", "one_stirrup_weight", "minimal_and_maximal_stirrup_weight", "all_stirrups_weight", "one_crosstie_length", "minimal_and_maximal_crosstie_length", "all_crossties_lenght", "one_crosstie_weight", "minimal_and_maximal_crosstie_weight", "all_crossties_weight")
        class StirrupType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OPEN: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupType]
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OPEN: Member.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: Member.ConcreteShearReinforcementSpansRow.StirrupType
        class StirrupBarSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_10: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_11: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_12: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_14: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_16: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_18: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_3: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_4: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_5: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_6: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_7: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_8: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_9: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_10: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_15: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_20: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_25: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_30: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_35: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_45: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_55: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
        STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_10: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_11: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_12: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_14: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_16: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_18: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_3: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_4: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_5: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_6: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_7: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_8: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_9: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_10: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_15: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_20: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_25: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_30: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_35: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_45: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_55: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        class StirrupBarSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum
        class StirrupBarSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[Member.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[Member.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: Member.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: Member.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        class StirrupLayoutRule(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_LAYOUT_RULE_START_EQUALS_END: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_DEFINED: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_DEFINED: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
        STIRRUP_LAYOUT_RULE_START_EQUALS_END: Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_DEFINED: Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_DEFINED: Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_COUNT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_ACTIVE_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_LAYOUT_RULE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_START_OFFSET_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_END_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_LENGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        stirrup_type: Member.ConcreteShearReinforcementSpansRow.StirrupType
        material: int
        stirrup_count: int
        stirrup_bar_size: float
        stirrup_bar_size_calculated: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        stirrup_diameter: float
        stirrup_diameter_calculated: float
        stirrup_diameter_auto_enabled: bool
        stirrup_bar_size_auto_minimum: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum
        stirrup_diameter_auto_minimum: float
        stirrup_bar_size_auto_maximum: Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum
        stirrup_diameter_auto_maximum: float
        stirrup_diameter_auto_diameters_enabled: bool
        stirrup_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        stirrup_diameter_auto_priority: int
        stirrup_distances: float
        stirrup_distances_calculated: float
        stirrup_distances_auto_enabled: bool
        stirrup_distances_auto_minimum: float
        stirrup_distances_auto_maximum: float
        stirrup_distances_auto_increment: float
        stirrup_distances_auto_priority: int
        crossties_active: bool
        crossties_diameter: float
        reinforcement_area: float
        horizontal_crosstie_reinforcement_area: float
        minimal_maximal_horizontal_crosstie_reinforcement_area: str
        vertical_crosstie_reinforcement_area: float
        minimal_maximal_vertical_crosstie_reinforcement_area: str
        total_horizontal_reinforcement_area: float
        minimal_maximal_total_horizontal_reinforcement_area: str
        total_vertical_reinforcement_area: float
        minimal_maximal_total_vertical_reinforcement_area: str
        span_position_reference_type: Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: Member.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        stirrup_layout_rule: Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        stirrup_start_offset: float
        stirrup_end_offset: float
        one_stirrup_length: float
        minimal_and_maximal_stirrup_length: str
        all_stirrups_length: float
        one_stirrup_weight: float
        minimal_and_maximal_stirrup_weight: str
        all_stirrups_weight: float
        one_crosstie_length: float
        minimal_and_maximal_crosstie_length: str
        all_crossties_lenght: float
        one_crosstie_weight: float
        minimal_and_maximal_crosstie_weight: str
        all_crossties_weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., stirrup_type: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.StirrupType, str]] = ..., material: _Optional[int] = ..., stirrup_count: _Optional[int] = ..., stirrup_bar_size: _Optional[float] = ..., stirrup_bar_size_calculated: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated, str]] = ..., stirrup_diameter: _Optional[float] = ..., stirrup_diameter_calculated: _Optional[float] = ..., stirrup_diameter_auto_enabled: bool = ..., stirrup_bar_size_auto_minimum: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum, str]] = ..., stirrup_diameter_auto_minimum: _Optional[float] = ..., stirrup_bar_size_auto_maximum: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum, str]] = ..., stirrup_diameter_auto_maximum: _Optional[float] = ..., stirrup_diameter_auto_diameters_enabled: bool = ..., stirrup_diameter_auto_diameters: _Optional[_Iterable[int]] = ..., stirrup_diameter_auto_priority: _Optional[int] = ..., stirrup_distances: _Optional[float] = ..., stirrup_distances_calculated: _Optional[float] = ..., stirrup_distances_auto_enabled: bool = ..., stirrup_distances_auto_minimum: _Optional[float] = ..., stirrup_distances_auto_maximum: _Optional[float] = ..., stirrup_distances_auto_increment: _Optional[float] = ..., stirrup_distances_auto_priority: _Optional[int] = ..., crossties_active: bool = ..., crossties_diameter: _Optional[float] = ..., reinforcement_area: _Optional[float] = ..., horizontal_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_horizontal_crosstie_reinforcement_area: _Optional[str] = ..., vertical_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_vertical_crosstie_reinforcement_area: _Optional[str] = ..., total_horizontal_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_horizontal_reinforcement_area: _Optional[str] = ..., total_vertical_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_vertical_reinforcement_area: _Optional[str] = ..., span_position_reference_type: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., stirrup_layout_rule: _Optional[_Union[Member.ConcreteShearReinforcementSpansRow.StirrupLayoutRule, str]] = ..., stirrup_start_offset: _Optional[float] = ..., stirrup_end_offset: _Optional[float] = ..., one_stirrup_length: _Optional[float] = ..., minimal_and_maximal_stirrup_length: _Optional[str] = ..., all_stirrups_length: _Optional[float] = ..., one_stirrup_weight: _Optional[float] = ..., minimal_and_maximal_stirrup_weight: _Optional[str] = ..., all_stirrups_weight: _Optional[float] = ..., one_crosstie_length: _Optional[float] = ..., minimal_and_maximal_crosstie_length: _Optional[str] = ..., all_crossties_lenght: _Optional[float] = ..., one_crosstie_weight: _Optional[float] = ..., minimal_and_maximal_crosstie_weight: _Optional[str] = ..., all_crossties_weight: _Optional[float] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementItemsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.ConcreteLongitudinalReinforcementItemsRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.ConcreteLongitudinalReinforcementItemsRow, _Mapping]]] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementItemsRow(_message.Message):
        __slots__ = ("no", "description", "name", "rebar_type", "material", "reinforcement_placed_in_bending_corner_enabled", "bar_count_symmetrical", "bar_count_symmetrical_calculated", "bar_count_symmetrical_auto_enabled", "bar_count_symmetrical_auto_minimum", "bar_count_symmetrical_auto_maximum", "bar_count_symmetrical_auto_increment", "bar_count_symmetrical_auto_priority", "bar_count_unsymmetrical_at_side", "bar_count_unsymmetrical_top_side", "bar_count_unsymmetrical_top_side_calculated", "bar_count_unsymmetrical_top_side_auto_enabled", "bar_count_unsymmetrical_top_side_auto_minimum", "bar_count_unsymmetrical_top_side_auto_maximum", "bar_count_unsymmetrical_top_side_auto_increment", "bar_count_unsymmetrical_top_side_auto_priority", "bar_count_unsymmetrical_bottom_side", "bar_count_unsymmetrical_bottom_side_calculated", "bar_count_unsymmetrical_bottom_side_auto_enabled", "bar_count_unsymmetrical_bottom_side_auto_minimum", "bar_count_unsymmetrical_bottom_side_auto_maximum", "bar_count_unsymmetrical_bottom_side_auto_increment", "bar_count_unsymmetrical_bottom_side_auto_priority", "bar_count_uniformly_surrounding", "bar_count_uniformly_surrounding_calculated", "bar_count_uniformly_surrounding_auto_enabled", "bar_count_uniformly_surrounding_auto_minimum", "bar_count_uniformly_surrounding_auto_maximum", "bar_count_uniformly_surrounding_auto_increment", "bar_count_uniformly_surrounding_auto_priority", "bar_count_line", "bar_count_line_calculated", "bar_count_line_auto_enabled", "bar_count_line_auto_minimum", "bar_count_line_auto_maximum", "bar_count_line_auto_increment", "bar_count_line_auto_priority", "bar_count_corner", "bar_size_designation_symmetrical", "bar_size_designation_symmetrical_calculated", "bar_diameter_symmetrical", "bar_diameter_symmetrical_calculated", "bar_diameter_symmetrical_auto_enabled", "bar_size_designation_symmetrical_auto_minimum", "bar_diameter_symmetrical_auto_minimum", "bar_size_designation_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_diameters_enabled", "bar_diameter_symmetrical_auto_diameters", "bar_diameter_symmetrical_auto_priority", "bar_size_designation_unsymmetrical_at_side", "bar_diameter_unsymmetrical_at_side", "bar_size_designation_unsymmetrical_top_side", "bar_size_designation_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side", "bar_diameter_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side_auto_enabled", "bar_size_designation_unsymmetrical_top_side_auto_minimum", "bar_diameter_unsymmetrical_top_side_auto_minimum", "bar_size_designation_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_top_side_auto_diameters", "bar_diameter_unsymmetrical_top_side_auto_priority", "bar_size_designation_unsymmetrical_bottom_side", "bar_size_designation_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side", "bar_diameter_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side_auto_enabled", "bar_size_designation_unsymmetrical_bottom_side_auto_minimum", "bar_diameter_unsymmetrical_bottom_side_auto_minimum", "bar_size_designation_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_bottom_side_auto_diameters", "bar_diameter_unsymmetrical_bottom_side_auto_priority", "bar_size_designation_uniformly_surrounding", "bar_size_designation_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding", "bar_diameter_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding_auto_enabled", "bar_size_designation_uniformly_surrounding_auto_minimum", "bar_diameter_uniformly_surrounding_auto_minimum", "bar_size_designation_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_diameters_enabled", "bar_diameter_uniformly_surrounding_auto_diameters", "bar_diameter_uniformly_surrounding_auto_priority", "bar_size_designation_line", "bar_size_designation_line_calculated", "bar_diameter_line", "bar_diameter_line_calculated", "bar_diameter_line_auto_enabled", "bar_size_designation_line_auto_minimum", "bar_diameter_line_auto_minimum", "bar_size_designation_line_auto_maximum", "bar_diameter_line_auto_maximum", "bar_diameter_line_auto_diameters_enabled", "bar_diameter_line_auto_diameters", "bar_diameter_line_auto_priority", "bar_size_designation_single", "bar_size_designation_single_calculated", "bar_diameter_single", "bar_diameter_single_calculated", "bar_diameter_single_auto_enabled", "bar_size_designation_single_auto_minimum", "bar_diameter_single_auto_minimum", "bar_size_designation_single_auto_maximum", "bar_diameter_single_auto_maximum", "bar_diameter_single_auto_diameters_enabled", "bar_diameter_single_auto_diameters", "bar_diameter_single_auto_priority", "bar_size_designation_corner", "bar_diameter_corner", "base_diamter_reduced_multi_edit", "corner_reinforcement_enabled", "reinforcement_area_symmetrical", "reinforcement_area_unsymmetrical_at_side", "reinforcement_area_unsymmetrical_top_side", "reinforcement_area_unsymmetrical_bottom_side", "reinforcement_area_uniformly_surrounding", "reinforcement_area_line", "reinforcement_area_single", "reinforcement_area_corner", "reinforcement_area_total", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "additional_offset_type", "additional_offset_type_single_line", "additional_offset_circle", "additional_offset_top_side", "additional_offset_bottom_side", "additional_offset_left_side", "additional_offset_right_side", "additional_offset_reference_type", "additional_offset_reference_type_at_start", "additional_offset_reference_type_at_end", "additional_horizontal_offset", "additional_horizontal_offset_at_start", "additional_horizontal_offset_at_end", "additional_vertical_offset", "additional_vertical_offset_at_start", "additional_vertical_offset_at_end", "anchorage_start_anchor_type", "anchorage_start_anchor_length", "anchorage_start_bending_diameter", "anchorage_end_anchor_type", "anchorage_end_anchor_length", "anchorage_end_bending_diameter", "one_rebar_length", "one_rebar_minimal_and_maximal_length", "one_rebar_unsymmetrical_at_side_length", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_top_side_length", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_bottom_side_length", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length", "one_rebar_corner_length", "one_rebar_corner_minimal_and_maximal_length", "length", "one_rebar_weight", "one_rebar_minimal_and_maximal_weight", "one_rebar_unsymmetrical_at_side_weight", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_top_side_weight", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_bottom_side_weight", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight", "one_rebar_corner_weight", "one_rebar_corner_minimal_and_maximal_weight", "weight")
        class RebarType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REBAR_TYPE_SYMMETRICAL: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_LINE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_SINGLE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_UNIFORMLY_SURROUNDING: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_UNSYMMETRICAL: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.RebarType]
        REBAR_TYPE_SYMMETRICAL: Member.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_LINE: Member.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_SINGLE: Member.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_UNIFORMLY_SURROUNDING: Member.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_UNSYMMETRICAL: Member.ConcreteLongitudinalReinforcementItemsRow.RebarType
        class BarSizeDesignationSymmetricalCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        class BarSizeDesignationSymmetricalAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum
        class BarSizeDesignationSymmetricalAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum
        class BarSizeDesignationUnsymmetricalAtSide(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide
        class BarSizeDesignationUnsymmetricalTopSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        class BarSizeDesignationUnsymmetricalTopSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        class BarSizeDesignationUnsymmetricalTopSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        class BarSizeDesignationUnsymmetricalBottomSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        class BarSizeDesignationUnsymmetricalBottomSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        class BarSizeDesignationUnsymmetricalBottomSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        class BarSizeDesignationUniformlySurroundingCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        class BarSizeDesignationUniformlySurroundingAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        class BarSizeDesignationUniformlySurroundingAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        class BarSizeDesignationLineCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        class BarSizeDesignationLineAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum
        class BarSizeDesignationLineAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum
        class BarSizeDesignationSingleCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        class BarSizeDesignationSingleAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum
        class BarSizeDesignationSingleAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum
        class BarSizeDesignationCorner(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner]
        BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        class AdditionalOffsetType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_NONE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
        ADDITIONAL_OFFSET_TYPE_NONE: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        class AdditionalOffsetTypeSingleLine(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        class AdditionalOffsetReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        class AdditionalOffsetReferenceTypeAtStart(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        class AdditionalOffsetReferenceTypeAtEnd(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        class AnchorageStartAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_START_ANCHOR_TYPE_NONE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_BEND: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
        ANCHORAGE_START_ANCHOR_TYPE_NONE: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_BEND: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        class AnchorageEndAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_END_ANCHOR_TYPE_NONE: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_BEND: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
        ANCHORAGE_END_ANCHOR_TYPE_NONE: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_BEND: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        REBAR_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_PLACED_IN_BENDING_CORNER_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_CORNER_FIELD_NUMBER: _ClassVar[int]
        BASE_DIAMTER_REDUCED_MULTI_EDIT_FIELD_NUMBER: _ClassVar[int]
        CORNER_REINFORCEMENT_ENABLED_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_LINE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SINGLE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_CORNER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_TOTAL_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_CIRCLE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_LEFT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_RIGHT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        rebar_type: Member.ConcreteLongitudinalReinforcementItemsRow.RebarType
        material: int
        reinforcement_placed_in_bending_corner_enabled: bool
        bar_count_symmetrical: int
        bar_count_symmetrical_calculated: int
        bar_count_symmetrical_auto_enabled: bool
        bar_count_symmetrical_auto_minimum: int
        bar_count_symmetrical_auto_maximum: int
        bar_count_symmetrical_auto_increment: int
        bar_count_symmetrical_auto_priority: int
        bar_count_unsymmetrical_at_side: int
        bar_count_unsymmetrical_top_side: int
        bar_count_unsymmetrical_top_side_calculated: int
        bar_count_unsymmetrical_top_side_auto_enabled: bool
        bar_count_unsymmetrical_top_side_auto_minimum: int
        bar_count_unsymmetrical_top_side_auto_maximum: int
        bar_count_unsymmetrical_top_side_auto_increment: int
        bar_count_unsymmetrical_top_side_auto_priority: int
        bar_count_unsymmetrical_bottom_side: int
        bar_count_unsymmetrical_bottom_side_calculated: int
        bar_count_unsymmetrical_bottom_side_auto_enabled: bool
        bar_count_unsymmetrical_bottom_side_auto_minimum: int
        bar_count_unsymmetrical_bottom_side_auto_maximum: int
        bar_count_unsymmetrical_bottom_side_auto_increment: int
        bar_count_unsymmetrical_bottom_side_auto_priority: int
        bar_count_uniformly_surrounding: int
        bar_count_uniformly_surrounding_calculated: int
        bar_count_uniformly_surrounding_auto_enabled: bool
        bar_count_uniformly_surrounding_auto_minimum: int
        bar_count_uniformly_surrounding_auto_maximum: int
        bar_count_uniformly_surrounding_auto_increment: int
        bar_count_uniformly_surrounding_auto_priority: int
        bar_count_line: int
        bar_count_line_calculated: int
        bar_count_line_auto_enabled: bool
        bar_count_line_auto_minimum: int
        bar_count_line_auto_maximum: int
        bar_count_line_auto_increment: int
        bar_count_line_auto_priority: int
        bar_count_corner: int
        bar_size_designation_symmetrical: float
        bar_size_designation_symmetrical_calculated: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        bar_diameter_symmetrical: float
        bar_diameter_symmetrical_calculated: float
        bar_diameter_symmetrical_auto_enabled: bool
        bar_size_designation_symmetrical_auto_minimum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum
        bar_diameter_symmetrical_auto_minimum: float
        bar_size_designation_symmetrical_auto_maximum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum
        bar_diameter_symmetrical_auto_maximum: float
        bar_diameter_symmetrical_auto_diameters_enabled: bool
        bar_diameter_symmetrical_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_symmetrical_auto_priority: int
        bar_size_designation_unsymmetrical_at_side: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide
        bar_diameter_unsymmetrical_at_side: float
        bar_size_designation_unsymmetrical_top_side: float
        bar_size_designation_unsymmetrical_top_side_calculated: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        bar_diameter_unsymmetrical_top_side: float
        bar_diameter_unsymmetrical_top_side_calculated: float
        bar_diameter_unsymmetrical_top_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_top_side_auto_minimum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        bar_diameter_unsymmetrical_top_side_auto_minimum: float
        bar_size_designation_unsymmetrical_top_side_auto_maximum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        bar_diameter_unsymmetrical_top_side_auto_maximum: float
        bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_top_side_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_unsymmetrical_top_side_auto_priority: int
        bar_size_designation_unsymmetrical_bottom_side: float
        bar_size_designation_unsymmetrical_bottom_side_calculated: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        bar_diameter_unsymmetrical_bottom_side: float
        bar_diameter_unsymmetrical_bottom_side_calculated: float
        bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_bottom_side_auto_minimum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        bar_diameter_unsymmetrical_bottom_side_auto_minimum: float
        bar_size_designation_unsymmetrical_bottom_side_auto_maximum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        bar_diameter_unsymmetrical_bottom_side_auto_maximum: float
        bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_bottom_side_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_unsymmetrical_bottom_side_auto_priority: int
        bar_size_designation_uniformly_surrounding: float
        bar_size_designation_uniformly_surrounding_calculated: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        bar_diameter_uniformly_surrounding: float
        bar_diameter_uniformly_surrounding_calculated: float
        bar_diameter_uniformly_surrounding_auto_enabled: bool
        bar_size_designation_uniformly_surrounding_auto_minimum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        bar_diameter_uniformly_surrounding_auto_minimum: float
        bar_size_designation_uniformly_surrounding_auto_maximum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        bar_diameter_uniformly_surrounding_auto_maximum: float
        bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool
        bar_diameter_uniformly_surrounding_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_uniformly_surrounding_auto_priority: int
        bar_size_designation_line: float
        bar_size_designation_line_calculated: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        bar_diameter_line: float
        bar_diameter_line_calculated: float
        bar_diameter_line_auto_enabled: bool
        bar_size_designation_line_auto_minimum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum
        bar_diameter_line_auto_minimum: float
        bar_size_designation_line_auto_maximum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum
        bar_diameter_line_auto_maximum: float
        bar_diameter_line_auto_diameters_enabled: bool
        bar_diameter_line_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_line_auto_priority: int
        bar_size_designation_single: float
        bar_size_designation_single_calculated: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        bar_diameter_single: float
        bar_diameter_single_calculated: float
        bar_diameter_single_auto_enabled: bool
        bar_size_designation_single_auto_minimum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum
        bar_diameter_single_auto_minimum: float
        bar_size_designation_single_auto_maximum: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum
        bar_diameter_single_auto_maximum: float
        bar_diameter_single_auto_diameters_enabled: bool
        bar_diameter_single_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_single_auto_priority: int
        bar_size_designation_corner: Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner
        bar_diameter_corner: float
        base_diamter_reduced_multi_edit: float
        corner_reinforcement_enabled: bool
        reinforcement_area_symmetrical: float
        reinforcement_area_unsymmetrical_at_side: float
        reinforcement_area_unsymmetrical_top_side: float
        reinforcement_area_unsymmetrical_bottom_side: float
        reinforcement_area_uniformly_surrounding: float
        reinforcement_area_line: float
        reinforcement_area_single: float
        reinforcement_area_corner: float
        reinforcement_area_total: float
        span_position_reference_type: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        additional_offset_type: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        additional_offset_type_single_line: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        additional_offset_circle: float
        additional_offset_top_side: float
        additional_offset_bottom_side: float
        additional_offset_left_side: float
        additional_offset_right_side: float
        additional_offset_reference_type: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        additional_offset_reference_type_at_start: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        additional_offset_reference_type_at_end: Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        additional_horizontal_offset: float
        additional_horizontal_offset_at_start: float
        additional_horizontal_offset_at_end: float
        additional_vertical_offset: float
        additional_vertical_offset_at_start: float
        additional_vertical_offset_at_end: float
        anchorage_start_anchor_type: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        anchorage_start_anchor_length: float
        anchorage_start_bending_diameter: float
        anchorage_end_anchor_type: Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        anchorage_end_anchor_length: float
        anchorage_end_bending_diameter: float
        one_rebar_length: float
        one_rebar_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_at_side_length: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_top_side_length: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_bottom_side_length: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: str
        one_rebar_corner_length: float
        one_rebar_corner_minimal_and_maximal_length: str
        length: float
        one_rebar_weight: float
        one_rebar_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_at_side_weight: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_top_side_weight: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_bottom_side_weight: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: str
        one_rebar_corner_weight: float
        one_rebar_corner_minimal_and_maximal_weight: str
        weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., rebar_type: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.RebarType, str]] = ..., material: _Optional[int] = ..., reinforcement_placed_in_bending_corner_enabled: bool = ..., bar_count_symmetrical: _Optional[int] = ..., bar_count_symmetrical_calculated: _Optional[int] = ..., bar_count_symmetrical_auto_enabled: bool = ..., bar_count_symmetrical_auto_minimum: _Optional[int] = ..., bar_count_symmetrical_auto_maximum: _Optional[int] = ..., bar_count_symmetrical_auto_increment: _Optional[int] = ..., bar_count_symmetrical_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_at_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_enabled: bool = ..., bar_count_unsymmetrical_top_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_count_unsymmetrical_bottom_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_count_uniformly_surrounding: _Optional[int] = ..., bar_count_uniformly_surrounding_calculated: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_enabled: bool = ..., bar_count_uniformly_surrounding_auto_minimum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_maximum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_increment: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_count_line: _Optional[int] = ..., bar_count_line_calculated: _Optional[int] = ..., bar_count_line_auto_enabled: bool = ..., bar_count_line_auto_minimum: _Optional[int] = ..., bar_count_line_auto_maximum: _Optional[int] = ..., bar_count_line_auto_increment: _Optional[int] = ..., bar_count_line_auto_priority: _Optional[int] = ..., bar_count_corner: _Optional[int] = ..., bar_size_designation_symmetrical: _Optional[float] = ..., bar_size_designation_symmetrical_calculated: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated, str]] = ..., bar_diameter_symmetrical: _Optional[float] = ..., bar_diameter_symmetrical_calculated: _Optional[float] = ..., bar_diameter_symmetrical_auto_enabled: bool = ..., bar_size_designation_symmetrical_auto_minimum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum, str]] = ..., bar_diameter_symmetrical_auto_minimum: _Optional[float] = ..., bar_size_designation_symmetrical_auto_maximum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum, str]] = ..., bar_diameter_symmetrical_auto_maximum: _Optional[float] = ..., bar_diameter_symmetrical_auto_diameters_enabled: bool = ..., bar_diameter_symmetrical_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_symmetrical_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_at_side: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide, str]] = ..., bar_diameter_unsymmetrical_at_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_calculated: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated, str]] = ..., bar_diameter_unsymmetrical_top_side: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_top_side_auto_minimum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_auto_maximum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_top_side_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_bottom_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_calculated: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated, str]] = ..., bar_diameter_unsymmetrical_bottom_side: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_bottom_side_auto_minimum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_auto_maximum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_size_designation_uniformly_surrounding: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_calculated: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated, str]] = ..., bar_diameter_uniformly_surrounding: _Optional[float] = ..., bar_diameter_uniformly_surrounding_calculated: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_enabled: bool = ..., bar_size_designation_uniformly_surrounding_auto_minimum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum, str]] = ..., bar_diameter_uniformly_surrounding_auto_minimum: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_auto_maximum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum, str]] = ..., bar_diameter_uniformly_surrounding_auto_maximum: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool = ..., bar_diameter_uniformly_surrounding_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_size_designation_line: _Optional[float] = ..., bar_size_designation_line_calculated: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated, str]] = ..., bar_diameter_line: _Optional[float] = ..., bar_diameter_line_calculated: _Optional[float] = ..., bar_diameter_line_auto_enabled: bool = ..., bar_size_designation_line_auto_minimum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum, str]] = ..., bar_diameter_line_auto_minimum: _Optional[float] = ..., bar_size_designation_line_auto_maximum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum, str]] = ..., bar_diameter_line_auto_maximum: _Optional[float] = ..., bar_diameter_line_auto_diameters_enabled: bool = ..., bar_diameter_line_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_line_auto_priority: _Optional[int] = ..., bar_size_designation_single: _Optional[float] = ..., bar_size_designation_single_calculated: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated, str]] = ..., bar_diameter_single: _Optional[float] = ..., bar_diameter_single_calculated: _Optional[float] = ..., bar_diameter_single_auto_enabled: bool = ..., bar_size_designation_single_auto_minimum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum, str]] = ..., bar_diameter_single_auto_minimum: _Optional[float] = ..., bar_size_designation_single_auto_maximum: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum, str]] = ..., bar_diameter_single_auto_maximum: _Optional[float] = ..., bar_diameter_single_auto_diameters_enabled: bool = ..., bar_diameter_single_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_single_auto_priority: _Optional[int] = ..., bar_size_designation_corner: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner, str]] = ..., bar_diameter_corner: _Optional[float] = ..., base_diamter_reduced_multi_edit: _Optional[float] = ..., corner_reinforcement_enabled: bool = ..., reinforcement_area_symmetrical: _Optional[float] = ..., reinforcement_area_unsymmetrical_at_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_top_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_bottom_side: _Optional[float] = ..., reinforcement_area_uniformly_surrounding: _Optional[float] = ..., reinforcement_area_line: _Optional[float] = ..., reinforcement_area_single: _Optional[float] = ..., reinforcement_area_corner: _Optional[float] = ..., reinforcement_area_total: _Optional[float] = ..., span_position_reference_type: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., additional_offset_type: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType, str]] = ..., additional_offset_type_single_line: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine, str]] = ..., additional_offset_circle: _Optional[float] = ..., additional_offset_top_side: _Optional[float] = ..., additional_offset_bottom_side: _Optional[float] = ..., additional_offset_left_side: _Optional[float] = ..., additional_offset_right_side: _Optional[float] = ..., additional_offset_reference_type: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType, str]] = ..., additional_offset_reference_type_at_start: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart, str]] = ..., additional_offset_reference_type_at_end: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd, str]] = ..., additional_horizontal_offset: _Optional[float] = ..., additional_horizontal_offset_at_start: _Optional[float] = ..., additional_horizontal_offset_at_end: _Optional[float] = ..., additional_vertical_offset: _Optional[float] = ..., additional_vertical_offset_at_start: _Optional[float] = ..., additional_vertical_offset_at_end: _Optional[float] = ..., anchorage_start_anchor_type: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType, str]] = ..., anchorage_start_anchor_length: _Optional[float] = ..., anchorage_start_bending_diameter: _Optional[float] = ..., anchorage_end_anchor_type: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType, str]] = ..., anchorage_end_anchor_length: _Optional[float] = ..., anchorage_end_bending_diameter: _Optional[float] = ..., one_rebar_length: _Optional[float] = ..., one_rebar_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_corner_length: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_length: _Optional[str] = ..., length: _Optional[float] = ..., one_rebar_weight: _Optional[float] = ..., one_rebar_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_corner_weight: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_weight: _Optional[str] = ..., weight: _Optional[float] = ...) -> None: ...
    class DeflectionSegmentsZAxisTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.DeflectionSegmentsZAxisRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.DeflectionSegmentsZAxisRow, _Mapping]]] = ...) -> None: ...
    class DeflectionSegmentsZAxisRow(_message.Message):
        __slots__ = ("no", "description", "active", "length", "precamber", "segment_type")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ACTIVE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        PRECAMBER_FIELD_NUMBER: _ClassVar[int]
        SEGMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        active: bool
        length: float
        precamber: float
        segment_type: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., active: bool = ..., length: _Optional[float] = ..., precamber: _Optional[float] = ..., segment_type: _Optional[str] = ...) -> None: ...
    class DeflectionSegmentsYAxisTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.DeflectionSegmentsYAxisRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.DeflectionSegmentsYAxisRow, _Mapping]]] = ...) -> None: ...
    class DeflectionSegmentsYAxisRow(_message.Message):
        __slots__ = ("no", "description", "active", "length", "precamber", "segment_type")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ACTIVE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        PRECAMBER_FIELD_NUMBER: _ClassVar[int]
        SEGMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        active: bool
        length: float
        precamber: float
        segment_type: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., active: bool = ..., length: _Optional[float] = ..., precamber: _Optional[float] = ..., segment_type: _Optional[str] = ...) -> None: ...
    class DesignSupportsOnInternalNodesTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Member.DesignSupportsOnInternalNodesRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Member.DesignSupportsOnInternalNodesRow, _Mapping]]] = ...) -> None: ...
    class DesignSupportsOnInternalNodesRow(_message.Message):
        __slots__ = ("no", "description", "node", "design_support")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NODE_FIELD_NUMBER: _ClassVar[int]
        DESIGN_SUPPORT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        node: str
        design_support: int
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., node: _Optional[str] = ..., design_support: _Optional[int] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    TYPE_FIELD_NUMBER: _ClassVar[int]
    IS_DEACTIVATED_FOR_CALCULATION_FIELD_NUMBER: _ClassVar[int]
    LINE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTRIBUTION_TYPE_FIELD_NUMBER: _ClassVar[int]
    REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
    NODES_FIELD_NUMBER: _ClassVar[int]
    NODE_START_FIELD_NUMBER: _ClassVar[int]
    NODE_END_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_VOLUME_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_SURFACE_OF_COATING_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_MASS_FIELD_NUMBER: _ClassVar[int]
    SURFACE_OF_COATING_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_X_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_Y_FIELD_NUMBER: _ClassVar[int]
    ANALYTICAL_CENTER_OF_GRAVITY_Z_FIELD_NUMBER: _ClassVar[int]
    LENGTH_FIELD_NUMBER: _ClassVar[int]
    VOLUME_FIELD_NUMBER: _ClassVar[int]
    MASS_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_X_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_Y_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_Z_FIELD_NUMBER: _ClassVar[int]
    MEMBER_REPRESENTATIVE_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_VIA_MEMBER_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_VIA_PARENT_MEMBER_SET_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_PARENT_MEMBER_SET_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_RIB_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_FIRST_SURFACE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SECOND_SURFACE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SURFACE_ASSIGNMENT_AUTODETECT_FIELD_NUMBER: _ClassVar[int]
    ALIGN_LOCAL_Z_AXIS_TO_LOCAL_Z_AXIS_OF_SURFACE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SHEAR_JOINT_BETWEEN_WEB_AND_FLANGE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_SURFACE_ROUGHNESS_CLASSIFICATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_REDUCTION_OF_JOINT_WIDTH_FIELD_NUMBER: _ClassVar[int]
    FLANGE_DIMENSIONS_FIELD_NUMBER: _ClassVar[int]
    SYNCHRONIZE_WIDTH_MODE_FIELD_NUMBER: _ClassVar[int]
    RELATIVE_ORDINATES_MODE_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RIB_GENERATING_LONGITUDINAL_REINFORCEMENT_ITEMS_FROM_SURFACES_ENABLED_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_DEFINABLE_STIFFNESS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INTEGRATE_STRESSES_AND_FORCES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Y_Z_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Y_PLUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Z_PLUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Y_MINUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_Z_MINUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_RADIUS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_ALL_SURFACES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_SURFACES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_ALL_SOLIDS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_SOLIDS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_ALL_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_INCLUDE_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_EXCLUDE_SURFACES_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_EXCLUDE_SOLIDS_FIELD_NUMBER: _ClassVar[int]
    RESULT_BEAM_EXCLUDE_MEMBERS_FIELD_NUMBER: _ClassVar[int]
    PROJECTED_LENGTH_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_START_IS_DEFINED_AS_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_END_IS_DEFINED_AS_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
    SECTION_DISTANCE_FROM_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
    SECTION_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    SECTION_START_FIELD_NUMBER: _ClassVar[int]
    SECTION_END_FIELD_NUMBER: _ClassVar[int]
    SECTION_INTERNAL_FIELD_NUMBER: _ClassVar[int]
    SECTION_MATERIAL_FIELD_NUMBER: _ClassVar[int]
    GRAIN_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    IS_CURVED_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_IS_ASYMMETRIC_LAYOUT_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_IS_CANTILEVERS_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_CANTILEVERS_TYPE_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_IS_CAPPED_WITH_LOOSE_RIDGE_WEDGE_FIELD_NUMBER: _ClassVar[int]
    CURVED_MEMBER_PARAMETERS_FIELD_NUMBER: _ClassVar[int]
    ROTATION_SPECIFICATION_TYPE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_ANGLE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_HELP_NODE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_PLANE_TYPE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_SURFACE_FIELD_NUMBER: _ClassVar[int]
    ROTATION_SURFACE_PLANE_TYPE_FIELD_NUMBER: _ClassVar[int]
    IS_ROTATED_FIELD_NUMBER: _ClassVar[int]
    MEMBER_HINGE_START_FIELD_NUMBER: _ClassVar[int]
    MEMBER_HINGE_END_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ECCENTRICITY_START_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ECCENTRICITY_END_FIELD_NUMBER: _ClassVar[int]
    SUPPORT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TRANSVERSE_STIFFENER_FIELD_NUMBER: _ClassVar[int]
    MEMBER_OPENINGS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_NONLINEARITY_FIELD_NUMBER: _ClassVar[int]
    MEMBER_RESULT_INTERMEDIATE_POINT_FIELD_NUMBER: _ClassVar[int]
    STRESS_ANALYSIS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_BOUNDARY_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_MEMBER_LOCAL_SECTION_REDUCTION_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_MEMBER_TRANSVERSE_WELD_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ALUMINUM_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ALUMINUM_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_USER_DEFINED_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_DIFFERENT_AT_SECTION_SIDES_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_SHEAR_REINFORCEMENT_SPANS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_LONGITUDINAL_REINFORCEMENT_ITEMS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_SEISMIC_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    STEEL_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    STEEL_BOUNDARY_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    STEEL_MEMBER_LOCAL_SECTION_REDUCTION_FIELD_NUMBER: _ClassVar[int]
    STEEL_MEMBER_TRANSVERSE_WELD_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    TIMBER_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_SERVICE_CLASS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_MOISTURE_CLASS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_SERVICE_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    TIMBER_MEMBER_LOCAL_SECTION_REDUCTION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_START_EXTENSION_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_START_SLOPE_Y_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_START_SLOPE_Z_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_END_EXTENSION_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_END_SLOPE_Y_FIELD_NUMBER: _ClassVar[int]
    END_MODIFICATIONS_MEMBER_END_SLOPE_Z_FIELD_NUMBER: _ClassVar[int]
    HAS_ANY_END_MODIFICATIONS_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_CHECK_DIRECTION_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_Z_AXIS_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_Y_AXIS_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORT_ON_MEMBER_START_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORT_ON_MEMBER_END_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORTS_ON_INTERNAL_NODES_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_DEFINED_LENGTH_Z_AXIS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_DEFINED_LENGTH_Y_AXIS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_SPRING_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_DAMPER_SPRING_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TYPE_DAMPER_DAMPING_COEFFICIENT_FIELD_NUMBER: _ClassVar[int]
    GENERATING_OBJECT_INFO_FIELD_NUMBER: _ClassVar[int]
    IS_GENERATED_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    type: Member.Type
    is_deactivated_for_calculation: bool
    line: int
    section_distribution_type: Member.SectionDistributionType
    reference_type: Member.ReferenceType
    nodes: _containers.RepeatedScalarFieldContainer[int]
    node_start: int
    node_end: int
    analytical_length: float
    analytical_volume: float
    analytical_surface_of_coating: float
    analytical_mass: float
    surface_of_coating: float
    analytical_center_of_gravity: _common_pb2.Vector3d
    analytical_center_of_gravity_x: float
    analytical_center_of_gravity_y: float
    analytical_center_of_gravity_z: float
    length: float
    volume: float
    mass: float
    center_of_gravity: _common_pb2.Vector3d
    center_of_gravity_x: float
    center_of_gravity_y: float
    center_of_gravity_z: float
    member_representative: int
    design_properties_via_member: bool
    design_properties_via_parent_member_set: bool
    design_properties_parent_member_set: int
    comment: str
    member_type_rib_alignment: Member.MemberTypeRibAlignment
    member_rib_first_surface: int
    member_rib_second_surface: int
    member_rib_surface_assignment_autodetect: bool
    align_local_z_axis_to_local_z_axis_of_surface: bool
    member_rib_shear_joint_between_web_and_flange: bool
    member_rib_surface_roughness_classification: Member.MemberRibSurfaceRoughnessClassification
    member_rib_reduction_of_joint_width: float
    flange_dimensions: Member.FlangeDimensionsTable
    synchronize_width_mode: bool
    relative_ordinates_mode: bool
    member_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled: bool
    member_type_definable_stiffness: int
    result_beam_integrate_stresses_and_forces: Member.ResultBeamIntegrateStressesAndForces
    result_beam_y_z: float
    result_beam_y_plus: float
    result_beam_z_plus: float
    result_beam_y_minus: float
    result_beam_z_minus: float
    result_beam_radius: float
    result_beam_include_all_surfaces: bool
    result_beam_include_surfaces: _containers.RepeatedScalarFieldContainer[int]
    result_beam_include_all_solids: bool
    result_beam_include_solids: _containers.RepeatedScalarFieldContainer[int]
    result_beam_include_all_members: bool
    result_beam_include_members: _containers.RepeatedScalarFieldContainer[int]
    result_beam_exclude_surfaces: _containers.RepeatedScalarFieldContainer[int]
    result_beam_exclude_solids: _containers.RepeatedScalarFieldContainer[int]
    result_beam_exclude_members: _containers.RepeatedScalarFieldContainer[int]
    projected_length: float
    section_distance_from_start_is_defined_as_relative: bool
    section_distance_from_start_absolute: float
    section_distance_from_start_relative: float
    section_distance_from_end_is_defined_as_relative: bool
    section_distance_from_end_absolute: float
    section_distance_from_end_relative: float
    section_alignment: Member.SectionAlignment
    section_start: int
    section_end: int
    section_internal: int
    section_material: int
    grain_alignment: Member.GrainAlignment
    is_curved: bool
    curved_member_is_asymmetric_layout: bool
    curved_member_is_cantilevers: bool
    curved_member_cantilevers_type: Member.CurvedMemberCantileversType
    curved_member_is_capped_with_loose_ridge_wedge: bool
    curved_member_parameters: Member.CurvedMemberParametersTable
    rotation_specification_type: Member.RotationSpecificationType
    rotation_angle: float
    rotation_help_node: int
    rotation_plane_type: Member.RotationPlaneType
    rotation_surface: int
    rotation_surface_plane_type: Member.RotationSurfacePlaneType
    is_rotated: bool
    member_hinge_start: int
    member_hinge_end: int
    member_eccentricity_start: int
    member_eccentricity_end: int
    support: int
    member_transverse_stiffener: int
    member_openings: int
    member_nonlinearity: int
    member_result_intermediate_point: int
    stress_analysis_configuration: int
    aluminum_effective_lengths: int
    aluminum_boundary_conditions: int
    aluminum_member_local_section_reduction: int
    aluminum_member_transverse_weld: int
    member_aluminum_design_uls_configuration: int
    member_aluminum_design_sls_configuration: int
    concrete_effective_lengths: int
    concrete_cover_user_defined_enabled: bool
    concrete_cover: float
    concrete_cover_top: float
    concrete_cover_left: float
    concrete_cover_right: float
    concrete_cover_bottom: float
    concrete_cover_min: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_top: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_left: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_right: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_bottom: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_different_at_section_sides_enabled: bool
    concrete_durability: int
    concrete_durability_top: int
    concrete_durability_left: int
    concrete_durability_right: int
    concrete_durability_bottom: int
    concrete_shear_reinforcement_spans: Member.ConcreteShearReinforcementSpansTable
    concrete_longitudinal_reinforcement_items: Member.ConcreteLongitudinalReinforcementItemsTable
    member_concrete_design_uls_configuration: int
    member_concrete_design_sls_configuration: int
    member_concrete_design_fr_configuration: int
    member_concrete_design_seismic_configuration: int
    steel_effective_lengths: int
    steel_boundary_conditions: int
    steel_member_local_section_reduction: int
    steel_member_transverse_weld: int
    member_steel_design_uls_configuration: int
    member_steel_design_sls_configuration: int
    member_steel_design_fr_configuration: int
    timber_effective_lengths: int
    timber_service_class: int
    timber_moisture_class: int
    timber_service_conditions: int
    timber_member_local_section_reduction: int
    member_timber_design_uls_configuration: int
    member_timber_design_sls_configuration: int
    member_timber_design_fr_configuration: int
    end_modifications_member_start_extension: float
    end_modifications_member_start_slope_y: float
    end_modifications_member_start_slope_z: float
    end_modifications_member_end_extension: float
    end_modifications_member_end_slope_y: float
    end_modifications_member_end_slope_z: float
    has_any_end_modifications: bool
    deflection_check_direction: Member.DeflectionCheckDirection
    deflection_check_displacement_reference: Member.DeflectionCheckDisplacementReference
    deflection_segments_z_axis: Member.DeflectionSegmentsZAxisTable
    deflection_segments_y_axis: Member.DeflectionSegmentsYAxisTable
    design_support_on_member_start: int
    design_support_on_member_end: int
    design_supports_on_internal_nodes: Member.DesignSupportsOnInternalNodesTable
    deflection_segments_defined_length_z_axis_enabled: bool
    deflection_segments_defined_length_y_axis_enabled: bool
    member_type_spring: int
    member_type_damper_spring: int
    member_type_damper_damping_coefficient: float
    generating_object_info: str
    is_generated: bool
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., type: _Optional[_Union[Member.Type, str]] = ..., is_deactivated_for_calculation: bool = ..., line: _Optional[int] = ..., section_distribution_type: _Optional[_Union[Member.SectionDistributionType, str]] = ..., reference_type: _Optional[_Union[Member.ReferenceType, str]] = ..., nodes: _Optional[_Iterable[int]] = ..., node_start: _Optional[int] = ..., node_end: _Optional[int] = ..., analytical_length: _Optional[float] = ..., analytical_volume: _Optional[float] = ..., analytical_surface_of_coating: _Optional[float] = ..., analytical_mass: _Optional[float] = ..., surface_of_coating: _Optional[float] = ..., analytical_center_of_gravity: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., analytical_center_of_gravity_x: _Optional[float] = ..., analytical_center_of_gravity_y: _Optional[float] = ..., analytical_center_of_gravity_z: _Optional[float] = ..., length: _Optional[float] = ..., volume: _Optional[float] = ..., mass: _Optional[float] = ..., center_of_gravity: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., center_of_gravity_x: _Optional[float] = ..., center_of_gravity_y: _Optional[float] = ..., center_of_gravity_z: _Optional[float] = ..., member_representative: _Optional[int] = ..., design_properties_via_member: bool = ..., design_properties_via_parent_member_set: bool = ..., design_properties_parent_member_set: _Optional[int] = ..., comment: _Optional[str] = ..., member_type_rib_alignment: _Optional[_Union[Member.MemberTypeRibAlignment, str]] = ..., member_rib_first_surface: _Optional[int] = ..., member_rib_second_surface: _Optional[int] = ..., member_rib_surface_assignment_autodetect: bool = ..., align_local_z_axis_to_local_z_axis_of_surface: bool = ..., member_rib_shear_joint_between_web_and_flange: bool = ..., member_rib_surface_roughness_classification: _Optional[_Union[Member.MemberRibSurfaceRoughnessClassification, str]] = ..., member_rib_reduction_of_joint_width: _Optional[float] = ..., flange_dimensions: _Optional[_Union[Member.FlangeDimensionsTable, _Mapping]] = ..., synchronize_width_mode: bool = ..., relative_ordinates_mode: bool = ..., member_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled: bool = ..., member_type_definable_stiffness: _Optional[int] = ..., result_beam_integrate_stresses_and_forces: _Optional[_Union[Member.ResultBeamIntegrateStressesAndForces, str]] = ..., result_beam_y_z: _Optional[float] = ..., result_beam_y_plus: _Optional[float] = ..., result_beam_z_plus: _Optional[float] = ..., result_beam_y_minus: _Optional[float] = ..., result_beam_z_minus: _Optional[float] = ..., result_beam_radius: _Optional[float] = ..., result_beam_include_all_surfaces: bool = ..., result_beam_include_surfaces: _Optional[_Iterable[int]] = ..., result_beam_include_all_solids: bool = ..., result_beam_include_solids: _Optional[_Iterable[int]] = ..., result_beam_include_all_members: bool = ..., result_beam_include_members: _Optional[_Iterable[int]] = ..., result_beam_exclude_surfaces: _Optional[_Iterable[int]] = ..., result_beam_exclude_solids: _Optional[_Iterable[int]] = ..., result_beam_exclude_members: _Optional[_Iterable[int]] = ..., projected_length: _Optional[float] = ..., section_distance_from_start_is_defined_as_relative: bool = ..., section_distance_from_start_absolute: _Optional[float] = ..., section_distance_from_start_relative: _Optional[float] = ..., section_distance_from_end_is_defined_as_relative: bool = ..., section_distance_from_end_absolute: _Optional[float] = ..., section_distance_from_end_relative: _Optional[float] = ..., section_alignment: _Optional[_Union[Member.SectionAlignment, str]] = ..., section_start: _Optional[int] = ..., section_end: _Optional[int] = ..., section_internal: _Optional[int] = ..., section_material: _Optional[int] = ..., grain_alignment: _Optional[_Union[Member.GrainAlignment, str]] = ..., is_curved: bool = ..., curved_member_is_asymmetric_layout: bool = ..., curved_member_is_cantilevers: bool = ..., curved_member_cantilevers_type: _Optional[_Union[Member.CurvedMemberCantileversType, str]] = ..., curved_member_is_capped_with_loose_ridge_wedge: bool = ..., curved_member_parameters: _Optional[_Union[Member.CurvedMemberParametersTable, _Mapping]] = ..., rotation_specification_type: _Optional[_Union[Member.RotationSpecificationType, str]] = ..., rotation_angle: _Optional[float] = ..., rotation_help_node: _Optional[int] = ..., rotation_plane_type: _Optional[_Union[Member.RotationPlaneType, str]] = ..., rotation_surface: _Optional[int] = ..., rotation_surface_plane_type: _Optional[_Union[Member.RotationSurfacePlaneType, str]] = ..., is_rotated: bool = ..., member_hinge_start: _Optional[int] = ..., member_hinge_end: _Optional[int] = ..., member_eccentricity_start: _Optional[int] = ..., member_eccentricity_end: _Optional[int] = ..., support: _Optional[int] = ..., member_transverse_stiffener: _Optional[int] = ..., member_openings: _Optional[int] = ..., member_nonlinearity: _Optional[int] = ..., member_result_intermediate_point: _Optional[int] = ..., stress_analysis_configuration: _Optional[int] = ..., aluminum_effective_lengths: _Optional[int] = ..., aluminum_boundary_conditions: _Optional[int] = ..., aluminum_member_local_section_reduction: _Optional[int] = ..., aluminum_member_transverse_weld: _Optional[int] = ..., member_aluminum_design_uls_configuration: _Optional[int] = ..., member_aluminum_design_sls_configuration: _Optional[int] = ..., concrete_effective_lengths: _Optional[int] = ..., concrete_cover_user_defined_enabled: bool = ..., concrete_cover: _Optional[float] = ..., concrete_cover_top: _Optional[float] = ..., concrete_cover_left: _Optional[float] = ..., concrete_cover_right: _Optional[float] = ..., concrete_cover_bottom: _Optional[float] = ..., concrete_cover_min: _Optional[_Iterable[int]] = ..., concrete_cover_min_top: _Optional[_Iterable[int]] = ..., concrete_cover_min_left: _Optional[_Iterable[int]] = ..., concrete_cover_min_right: _Optional[_Iterable[int]] = ..., concrete_cover_min_bottom: _Optional[_Iterable[int]] = ..., concrete_cover_different_at_section_sides_enabled: bool = ..., concrete_durability: _Optional[int] = ..., concrete_durability_top: _Optional[int] = ..., concrete_durability_left: _Optional[int] = ..., concrete_durability_right: _Optional[int] = ..., concrete_durability_bottom: _Optional[int] = ..., concrete_shear_reinforcement_spans: _Optional[_Union[Member.ConcreteShearReinforcementSpansTable, _Mapping]] = ..., concrete_longitudinal_reinforcement_items: _Optional[_Union[Member.ConcreteLongitudinalReinforcementItemsTable, _Mapping]] = ..., member_concrete_design_uls_configuration: _Optional[int] = ..., member_concrete_design_sls_configuration: _Optional[int] = ..., member_concrete_design_fr_configuration: _Optional[int] = ..., member_concrete_design_seismic_configuration: _Optional[int] = ..., steel_effective_lengths: _Optional[int] = ..., steel_boundary_conditions: _Optional[int] = ..., steel_member_local_section_reduction: _Optional[int] = ..., steel_member_transverse_weld: _Optional[int] = ..., member_steel_design_uls_configuration: _Optional[int] = ..., member_steel_design_sls_configuration: _Optional[int] = ..., member_steel_design_fr_configuration: _Optional[int] = ..., timber_effective_lengths: _Optional[int] = ..., timber_service_class: _Optional[int] = ..., timber_moisture_class: _Optional[int] = ..., timber_service_conditions: _Optional[int] = ..., timber_member_local_section_reduction: _Optional[int] = ..., member_timber_design_uls_configuration: _Optional[int] = ..., member_timber_design_sls_configuration: _Optional[int] = ..., member_timber_design_fr_configuration: _Optional[int] = ..., end_modifications_member_start_extension: _Optional[float] = ..., end_modifications_member_start_slope_y: _Optional[float] = ..., end_modifications_member_start_slope_z: _Optional[float] = ..., end_modifications_member_end_extension: _Optional[float] = ..., end_modifications_member_end_slope_y: _Optional[float] = ..., end_modifications_member_end_slope_z: _Optional[float] = ..., has_any_end_modifications: bool = ..., deflection_check_direction: _Optional[_Union[Member.DeflectionCheckDirection, str]] = ..., deflection_check_displacement_reference: _Optional[_Union[Member.DeflectionCheckDisplacementReference, str]] = ..., deflection_segments_z_axis: _Optional[_Union[Member.DeflectionSegmentsZAxisTable, _Mapping]] = ..., deflection_segments_y_axis: _Optional[_Union[Member.DeflectionSegmentsYAxisTable, _Mapping]] = ..., design_support_on_member_start: _Optional[int] = ..., design_support_on_member_end: _Optional[int] = ..., design_supports_on_internal_nodes: _Optional[_Union[Member.DesignSupportsOnInternalNodesTable, _Mapping]] = ..., deflection_segments_defined_length_z_axis_enabled: bool = ..., deflection_segments_defined_length_y_axis_enabled: bool = ..., member_type_spring: _Optional[int] = ..., member_type_damper_spring: _Optional[int] = ..., member_type_damper_damping_coefficient: _Optional[float] = ..., generating_object_info: _Optional[str] = ..., is_generated: bool = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
