from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class SurfaceReinforcement(_message.Message):
    __slots__ = ("no", "location_type", "user_defined_name_enabled", "name", "surfaces", "material", "reinforcement_type", "rebar_diameter", "rebar_diameter_auto_enabled", "rebar_diameter_auto_minimum", "rebar_diameter_auto_maximum", "rebar_diameter_auto_diameters_enabled", "rebar_diameter_auto_diameters", "rebar_diameter_auto_priority", "rebar_diameter_calculated", "rebar_size", "rebar_spacing", "rebar_spacing_auto_enabled", "rebar_spacing_auto_minimum", "rebar_spacing_auto_maximum", "rebar_spacing_auto_increment", "rebar_spacing_auto_priority", "rebar_spacing_calculated", "stirrup_diameter", "stirrup_diameter_auto_enabled", "stirrup_diameter_auto_minimum", "stirrup_diameter_auto_maximum", "stirrup_diameter_auto_diameters_enabled", "stirrup_diameter_auto_diameters", "stirrup_diameter_auto_priority", "stirrup_diameter_calculated", "stirrup_size", "stirrup_spacing", "stirrup_spacing_auto_enabled", "stirrup_spacing_auto_minimum", "stirrup_spacing_auto_maximum", "stirrup_spacing_auto_increment", "stirrup_spacing_auto_priority", "stirrup_spacing_calculated", "mesh_product_range", "mesh_shape", "mesh_name", "additional_transverse_reinforcement_enabled", "additional_rebar_diameter", "additional_rebar_diameter_auto_enabled", "additional_rebar_diameter_auto_minimum", "additional_rebar_diameter_auto_maximum", "additional_rebar_diameter_auto_diameters_enabled", "additional_rebar_diameter_auto_diameters", "additional_rebar_diameter_auto_priority", "additional_rebar_diameter_calculated", "additional_rebar_size", "additional_rebar_spacing", "additional_rebar_spacing_auto_enabled", "additional_rebar_spacing_auto_minimum", "additional_rebar_spacing_auto_maximum", "additional_rebar_spacing_auto_increment", "additional_rebar_spacing_auto_priority", "additional_rebar_spacing_calculated", "alignment_top_enabled", "alignment_bottom_enabled", "additional_offset_to_concrete_cover_top", "additional_offset_to_concrete_cover_bottom", "reinforcement_direction_type", "design_reinforcement_direction", "first_direction_point_1", "first_direction_point_2", "second_direction_point_1", "second_direction_point_2", "projection_coordinate_system", "projection_plane", "reinforcement_area_as1", "reinforcement_area_as2", "reinforcement_area_as1_top", "reinforcement_area_as2_top", "reinforcement_area_as1_bottom", "reinforcement_area_as2_bottom", "reinforcement_area_as_i", "reinforcement_area_as_i_plus_90", "reinforcement_area_as_i_top", "reinforcement_area_as_i_bottom", "reinforcement_area_as_i_plus_90_top", "reinforcement_area_as_i_plus_90_bottom", "stirrup_reinforcement_area_asw", "acting_region_from", "acting_region_to", "location_rectangle_type", "location_first_x", "location_first_y", "location_second_x", "location_second_y", "location_center_x", "location_center_y", "location_center_side_a", "location_center_side_b", "location_rotation", "location_radius", "polygon_points", "comment", "is_generated", "generating_object_info", "stirrup_size_calculated", "stirrup_size_auto_minimum", "stirrup_size_auto_maximum", "rebar_size_calculated", "rebar_size_auto_minimum", "rebar_size_auto_maximum", "additional_rebar_size_calculated", "additional_rebar_size_auto_minimum", "additional_rebar_size_auto_maximum", "id_for_export_import", "metadata_for_export_import")
    class LocationType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LOCATION_TYPE_UNKNOWN: _ClassVar[SurfaceReinforcement.LocationType]
        LOCATION_TYPE_FREE_CIRCULAR: _ClassVar[SurfaceReinforcement.LocationType]
        LOCATION_TYPE_FREE_POLYGON: _ClassVar[SurfaceReinforcement.LocationType]
        LOCATION_TYPE_FREE_RECTANGULAR: _ClassVar[SurfaceReinforcement.LocationType]
        LOCATION_TYPE_ON_SURFACE: _ClassVar[SurfaceReinforcement.LocationType]
    LOCATION_TYPE_UNKNOWN: SurfaceReinforcement.LocationType
    LOCATION_TYPE_FREE_CIRCULAR: SurfaceReinforcement.LocationType
    LOCATION_TYPE_FREE_POLYGON: SurfaceReinforcement.LocationType
    LOCATION_TYPE_FREE_RECTANGULAR: SurfaceReinforcement.LocationType
    LOCATION_TYPE_ON_SURFACE: SurfaceReinforcement.LocationType
    class ReinforcementType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REINFORCEMENT_TYPE_MESH: _ClassVar[SurfaceReinforcement.ReinforcementType]
        REINFORCEMENT_TYPE_REBAR: _ClassVar[SurfaceReinforcement.ReinforcementType]
        REINFORCEMENT_TYPE_STIRRUPS: _ClassVar[SurfaceReinforcement.ReinforcementType]
    REINFORCEMENT_TYPE_MESH: SurfaceReinforcement.ReinforcementType
    REINFORCEMENT_TYPE_REBAR: SurfaceReinforcement.ReinforcementType
    REINFORCEMENT_TYPE_STIRRUPS: SurfaceReinforcement.ReinforcementType
    class MeshProductRange(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MESH_PRODUCT_RANGE_UNKNOWN: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_AUSTRIA_2002_01_01: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_CZECH_REPUBLIC: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_FRANCE: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_GERMANY_1997_01_01: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_GERMANY_2001_10_01: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_GERMANY_2008_01_01: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_NETHERLANDS: _ClassVar[SurfaceReinforcement.MeshProductRange]
        MESH_PRODUCT_RANGE_MESHSTANDARD_UNITED_STATES: _ClassVar[SurfaceReinforcement.MeshProductRange]
    MESH_PRODUCT_RANGE_UNKNOWN: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_AUSTRIA_2002_01_01: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_CZECH_REPUBLIC: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_FRANCE: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_GERMANY_1997_01_01: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_GERMANY_2001_10_01: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_GERMANY_2008_01_01: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_NETHERLANDS: SurfaceReinforcement.MeshProductRange
    MESH_PRODUCT_RANGE_MESHSTANDARD_UNITED_STATES: SurfaceReinforcement.MeshProductRange
    class MeshShape(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MESH_SHAPE_UNKNOWN: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_AQS_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_AQ_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_AS_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_A_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_B_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_CQS_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_CS_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_E_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_G_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_KA_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_KD_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_KH_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_KY_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_K_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_L_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_PAF: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_P_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_Q_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_ROLLS: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_R_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_SHEETS: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_ST: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_W_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
        MESH_SHAPE_MESHSHAPE_Z_MESH: _ClassVar[SurfaceReinforcement.MeshShape]
    MESH_SHAPE_UNKNOWN: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_AQS_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_AQ_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_AS_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_A_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_B_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_CQS_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_CS_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_E_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_G_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_KA_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_KD_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_KH_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_KY_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_K_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_L_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_PAF: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_P_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_Q_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_ROLLS: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_R_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_SHEETS: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_ST: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_W_MESH: SurfaceReinforcement.MeshShape
    MESH_SHAPE_MESHSHAPE_Z_MESH: SurfaceReinforcement.MeshShape
    class ReinforcementDirectionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REINFORCEMENT_DIRECTION_TYPE_IN_DESIGN_REINFORCEMENT_DIRECTION: _ClassVar[SurfaceReinforcement.ReinforcementDirectionType]
        REINFORCEMENT_DIRECTION_TYPE_PARALLEL_TO_TWO_POINTS: _ClassVar[SurfaceReinforcement.ReinforcementDirectionType]
    REINFORCEMENT_DIRECTION_TYPE_IN_DESIGN_REINFORCEMENT_DIRECTION: SurfaceReinforcement.ReinforcementDirectionType
    REINFORCEMENT_DIRECTION_TYPE_PARALLEL_TO_TWO_POINTS: SurfaceReinforcement.ReinforcementDirectionType
    class DesignReinforcementDirection(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DESIGN_REINFORCEMENT_DIRECTION_A_S_1: _ClassVar[SurfaceReinforcement.DesignReinforcementDirection]
        DESIGN_REINFORCEMENT_DIRECTION_A_S_2: _ClassVar[SurfaceReinforcement.DesignReinforcementDirection]
    DESIGN_REINFORCEMENT_DIRECTION_A_S_1: SurfaceReinforcement.DesignReinforcementDirection
    DESIGN_REINFORCEMENT_DIRECTION_A_S_2: SurfaceReinforcement.DesignReinforcementDirection
    class ProjectionPlane(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        PROJECTION_PLANE_XY_OR_UV: _ClassVar[SurfaceReinforcement.ProjectionPlane]
        PROJECTION_PLANE_XZ_OR_UW: _ClassVar[SurfaceReinforcement.ProjectionPlane]
        PROJECTION_PLANE_YZ_OR_VW: _ClassVar[SurfaceReinforcement.ProjectionPlane]
    PROJECTION_PLANE_XY_OR_UV: SurfaceReinforcement.ProjectionPlane
    PROJECTION_PLANE_XZ_OR_UW: SurfaceReinforcement.ProjectionPlane
    PROJECTION_PLANE_YZ_OR_VW: SurfaceReinforcement.ProjectionPlane
    class LocationRectangleType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        LOCATION_RECTANGLE_TYPE_CORNER_POINTS: _ClassVar[SurfaceReinforcement.LocationRectangleType]
        LOCATION_RECTANGLE_TYPE_CENTER_AND_SIDES: _ClassVar[SurfaceReinforcement.LocationRectangleType]
    LOCATION_RECTANGLE_TYPE_CORNER_POINTS: SurfaceReinforcement.LocationRectangleType
    LOCATION_RECTANGLE_TYPE_CENTER_AND_SIDES: SurfaceReinforcement.LocationRectangleType
    class StirrupSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        STIRRUP_SIZE_CALCULATED_UNKNOWN: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_1: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_10: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_11: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_12: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_14: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_16: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_18: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_1p5: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_2: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_2p5: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_3: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_4: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_5: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_6: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_7: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_8: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_ACI_9: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_10: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_15: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_20: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_25: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_30: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_35: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_45: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
        STIRRUP_SIZE_CALCULATED_CSA_55: _ClassVar[SurfaceReinforcement.StirrupSizeCalculated]
    STIRRUP_SIZE_CALCULATED_UNKNOWN: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_1: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_10: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_11: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_12: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_14: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_16: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_18: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_1p5: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_2: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_2p5: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_3: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_4: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_5: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_6: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_7: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_8: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_ACI_9: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_10: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_15: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_20: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_25: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_30: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_35: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_45: SurfaceReinforcement.StirrupSizeCalculated
    STIRRUP_SIZE_CALCULATED_CSA_55: SurfaceReinforcement.StirrupSizeCalculated
    class StirrupSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        STIRRUP_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[SurfaceReinforcement.StirrupSizeAutoMinimum]
    STIRRUP_SIZE_AUTO_MINIMUM_UNKNOWN: SurfaceReinforcement.StirrupSizeAutoMinimum
    class StirrupSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        STIRRUP_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[SurfaceReinforcement.StirrupSizeAutoMaximum]
    STIRRUP_SIZE_AUTO_MAXIMUM_UNKNOWN: SurfaceReinforcement.StirrupSizeAutoMaximum
    class RebarSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REBAR_SIZE_CALCULATED_UNKNOWN: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_1: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_10: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_11: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_12: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_14: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_16: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_18: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_1p5: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_2: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_2p5: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_3: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_4: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_5: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_6: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_7: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_8: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_ACI_9: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_10: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_15: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_20: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_25: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_30: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_35: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_45: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
        REBAR_SIZE_CALCULATED_CSA_55: _ClassVar[SurfaceReinforcement.RebarSizeCalculated]
    REBAR_SIZE_CALCULATED_UNKNOWN: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_1: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_10: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_11: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_12: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_14: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_16: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_18: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_1p5: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_2: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_2p5: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_3: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_4: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_5: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_6: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_7: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_8: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_ACI_9: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_10: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_15: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_20: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_25: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_30: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_35: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_45: SurfaceReinforcement.RebarSizeCalculated
    REBAR_SIZE_CALCULATED_CSA_55: SurfaceReinforcement.RebarSizeCalculated
    class RebarSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REBAR_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[SurfaceReinforcement.RebarSizeAutoMinimum]
    REBAR_SIZE_AUTO_MINIMUM_UNKNOWN: SurfaceReinforcement.RebarSizeAutoMinimum
    class RebarSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        REBAR_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[SurfaceReinforcement.RebarSizeAutoMaximum]
    REBAR_SIZE_AUTO_MAXIMUM_UNKNOWN: SurfaceReinforcement.RebarSizeAutoMaximum
    class AdditionalRebarSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ADDITIONAL_REBAR_SIZE_CALCULATED_UNKNOWN: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_1: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_10: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_11: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_12: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_14: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_16: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_18: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_1p5: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_2: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_2p5: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_3: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_4: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_5: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_6: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_7: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_8: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_9: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_10: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_15: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_20: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_25: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_30: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_35: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_45: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
        ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_55: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeCalculated]
    ADDITIONAL_REBAR_SIZE_CALCULATED_UNKNOWN: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_1: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_10: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_11: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_12: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_14: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_16: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_18: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_1p5: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_2: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_2p5: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_3: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_4: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_5: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_6: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_7: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_8: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_ACI_9: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_10: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_15: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_20: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_25: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_30: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_35: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_45: SurfaceReinforcement.AdditionalRebarSizeCalculated
    ADDITIONAL_REBAR_SIZE_CALCULATED_CSA_55: SurfaceReinforcement.AdditionalRebarSizeCalculated
    class AdditionalRebarSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ADDITIONAL_REBAR_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeAutoMinimum]
    ADDITIONAL_REBAR_SIZE_AUTO_MINIMUM_UNKNOWN: SurfaceReinforcement.AdditionalRebarSizeAutoMinimum
    class AdditionalRebarSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ADDITIONAL_REBAR_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[SurfaceReinforcement.AdditionalRebarSizeAutoMaximum]
    ADDITIONAL_REBAR_SIZE_AUTO_MAXIMUM_UNKNOWN: SurfaceReinforcement.AdditionalRebarSizeAutoMaximum
    class PolygonPointsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[SurfaceReinforcement.PolygonPointsRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[SurfaceReinforcement.PolygonPointsRow, _Mapping]]] = ...) -> None: ...
    class PolygonPointsRow(_message.Message):
        __slots__ = ("no", "description", "first_coordinate", "second_coordinate", "comment")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        FIRST_COORDINATE_FIELD_NUMBER: _ClassVar[int]
        SECOND_COORDINATE_FIELD_NUMBER: _ClassVar[int]
        COMMENT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        first_coordinate: float
        second_coordinate: float
        comment: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., first_coordinate: _Optional[float] = ..., second_coordinate: _Optional[float] = ..., comment: _Optional[str] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    LOCATION_TYPE_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_NAME_ENABLED_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    SURFACES_FIELD_NUMBER: _ClassVar[int]
    MATERIAL_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
    REBAR_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    REBAR_SIZE_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
    REBAR_SPACING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SIZE_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SPACING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    MESH_PRODUCT_RANGE_FIELD_NUMBER: _ClassVar[int]
    MESH_SHAPE_FIELD_NUMBER: _ClassVar[int]
    MESH_NAME_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_TRANSVERSE_REINFORCEMENT_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SIZE_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SPACING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    ALIGNMENT_TOP_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ALIGNMENT_BOTTOM_ENABLED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_OFFSET_TO_CONCRETE_COVER_TOP_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_OFFSET_TO_CONCRETE_COVER_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_DIRECTION_TYPE_FIELD_NUMBER: _ClassVar[int]
    DESIGN_REINFORCEMENT_DIRECTION_FIELD_NUMBER: _ClassVar[int]
    FIRST_DIRECTION_POINT_1_FIELD_NUMBER: _ClassVar[int]
    FIRST_DIRECTION_POINT_2_FIELD_NUMBER: _ClassVar[int]
    SECOND_DIRECTION_POINT_1_FIELD_NUMBER: _ClassVar[int]
    SECOND_DIRECTION_POINT_2_FIELD_NUMBER: _ClassVar[int]
    PROJECTION_COORDINATE_SYSTEM_FIELD_NUMBER: _ClassVar[int]
    PROJECTION_PLANE_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS1_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS2_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS1_TOP_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS2_TOP_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS1_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS2_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS_I_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS_I_PLUS_90_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS_I_TOP_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS_I_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS_I_PLUS_90_TOP_FIELD_NUMBER: _ClassVar[int]
    REINFORCEMENT_AREA_AS_I_PLUS_90_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_REINFORCEMENT_AREA_ASW_FIELD_NUMBER: _ClassVar[int]
    ACTING_REGION_FROM_FIELD_NUMBER: _ClassVar[int]
    ACTING_REGION_TO_FIELD_NUMBER: _ClassVar[int]
    LOCATION_RECTANGLE_TYPE_FIELD_NUMBER: _ClassVar[int]
    LOCATION_FIRST_X_FIELD_NUMBER: _ClassVar[int]
    LOCATION_FIRST_Y_FIELD_NUMBER: _ClassVar[int]
    LOCATION_SECOND_X_FIELD_NUMBER: _ClassVar[int]
    LOCATION_SECOND_Y_FIELD_NUMBER: _ClassVar[int]
    LOCATION_CENTER_X_FIELD_NUMBER: _ClassVar[int]
    LOCATION_CENTER_Y_FIELD_NUMBER: _ClassVar[int]
    LOCATION_CENTER_SIDE_A_FIELD_NUMBER: _ClassVar[int]
    LOCATION_CENTER_SIDE_B_FIELD_NUMBER: _ClassVar[int]
    LOCATION_ROTATION_FIELD_NUMBER: _ClassVar[int]
    LOCATION_RADIUS_FIELD_NUMBER: _ClassVar[int]
    POLYGON_POINTS_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    IS_GENERATED_FIELD_NUMBER: _ClassVar[int]
    GENERATING_OBJECT_INFO_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    STIRRUP_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    REBAR_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    REBAR_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    REBAR_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
    ADDITIONAL_REBAR_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    location_type: SurfaceReinforcement.LocationType
    user_defined_name_enabled: bool
    name: str
    surfaces: _containers.RepeatedScalarFieldContainer[int]
    material: int
    reinforcement_type: SurfaceReinforcement.ReinforcementType
    rebar_diameter: float
    rebar_diameter_auto_enabled: bool
    rebar_diameter_auto_minimum: float
    rebar_diameter_auto_maximum: float
    rebar_diameter_auto_diameters_enabled: bool
    rebar_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
    rebar_diameter_auto_priority: int
    rebar_diameter_calculated: float
    rebar_size: float
    rebar_spacing: float
    rebar_spacing_auto_enabled: bool
    rebar_spacing_auto_minimum: float
    rebar_spacing_auto_maximum: float
    rebar_spacing_auto_increment: float
    rebar_spacing_auto_priority: int
    rebar_spacing_calculated: float
    stirrup_diameter: float
    stirrup_diameter_auto_enabled: bool
    stirrup_diameter_auto_minimum: float
    stirrup_diameter_auto_maximum: float
    stirrup_diameter_auto_diameters_enabled: bool
    stirrup_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
    stirrup_diameter_auto_priority: int
    stirrup_diameter_calculated: float
    stirrup_size: float
    stirrup_spacing: float
    stirrup_spacing_auto_enabled: bool
    stirrup_spacing_auto_minimum: float
    stirrup_spacing_auto_maximum: float
    stirrup_spacing_auto_increment: float
    stirrup_spacing_auto_priority: int
    stirrup_spacing_calculated: float
    mesh_product_range: SurfaceReinforcement.MeshProductRange
    mesh_shape: SurfaceReinforcement.MeshShape
    mesh_name: str
    additional_transverse_reinforcement_enabled: bool
    additional_rebar_diameter: float
    additional_rebar_diameter_auto_enabled: bool
    additional_rebar_diameter_auto_minimum: float
    additional_rebar_diameter_auto_maximum: float
    additional_rebar_diameter_auto_diameters_enabled: bool
    additional_rebar_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
    additional_rebar_diameter_auto_priority: int
    additional_rebar_diameter_calculated: float
    additional_rebar_size: float
    additional_rebar_spacing: float
    additional_rebar_spacing_auto_enabled: bool
    additional_rebar_spacing_auto_minimum: float
    additional_rebar_spacing_auto_maximum: float
    additional_rebar_spacing_auto_increment: float
    additional_rebar_spacing_auto_priority: int
    additional_rebar_spacing_calculated: float
    alignment_top_enabled: bool
    alignment_bottom_enabled: bool
    additional_offset_to_concrete_cover_top: float
    additional_offset_to_concrete_cover_bottom: float
    reinforcement_direction_type: SurfaceReinforcement.ReinforcementDirectionType
    design_reinforcement_direction: SurfaceReinforcement.DesignReinforcementDirection
    first_direction_point_1: float
    first_direction_point_2: float
    second_direction_point_1: float
    second_direction_point_2: float
    projection_coordinate_system: int
    projection_plane: SurfaceReinforcement.ProjectionPlane
    reinforcement_area_as1: float
    reinforcement_area_as2: float
    reinforcement_area_as1_top: float
    reinforcement_area_as2_top: float
    reinforcement_area_as1_bottom: float
    reinforcement_area_as2_bottom: float
    reinforcement_area_as_i: float
    reinforcement_area_as_i_plus_90: float
    reinforcement_area_as_i_top: float
    reinforcement_area_as_i_bottom: float
    reinforcement_area_as_i_plus_90_top: float
    reinforcement_area_as_i_plus_90_bottom: float
    stirrup_reinforcement_area_asw: float
    acting_region_from: float
    acting_region_to: float
    location_rectangle_type: SurfaceReinforcement.LocationRectangleType
    location_first_x: float
    location_first_y: float
    location_second_x: float
    location_second_y: float
    location_center_x: float
    location_center_y: float
    location_center_side_a: float
    location_center_side_b: float
    location_rotation: float
    location_radius: float
    polygon_points: SurfaceReinforcement.PolygonPointsTable
    comment: str
    is_generated: bool
    generating_object_info: str
    stirrup_size_calculated: SurfaceReinforcement.StirrupSizeCalculated
    stirrup_size_auto_minimum: SurfaceReinforcement.StirrupSizeAutoMinimum
    stirrup_size_auto_maximum: SurfaceReinforcement.StirrupSizeAutoMaximum
    rebar_size_calculated: SurfaceReinforcement.RebarSizeCalculated
    rebar_size_auto_minimum: SurfaceReinforcement.RebarSizeAutoMinimum
    rebar_size_auto_maximum: SurfaceReinforcement.RebarSizeAutoMaximum
    additional_rebar_size_calculated: SurfaceReinforcement.AdditionalRebarSizeCalculated
    additional_rebar_size_auto_minimum: SurfaceReinforcement.AdditionalRebarSizeAutoMinimum
    additional_rebar_size_auto_maximum: SurfaceReinforcement.AdditionalRebarSizeAutoMaximum
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., location_type: _Optional[_Union[SurfaceReinforcement.LocationType, str]] = ..., user_defined_name_enabled: bool = ..., name: _Optional[str] = ..., surfaces: _Optional[_Iterable[int]] = ..., material: _Optional[int] = ..., reinforcement_type: _Optional[_Union[SurfaceReinforcement.ReinforcementType, str]] = ..., rebar_diameter: _Optional[float] = ..., rebar_diameter_auto_enabled: bool = ..., rebar_diameter_auto_minimum: _Optional[float] = ..., rebar_diameter_auto_maximum: _Optional[float] = ..., rebar_diameter_auto_diameters_enabled: bool = ..., rebar_diameter_auto_diameters: _Optional[_Iterable[int]] = ..., rebar_diameter_auto_priority: _Optional[int] = ..., rebar_diameter_calculated: _Optional[float] = ..., rebar_size: _Optional[float] = ..., rebar_spacing: _Optional[float] = ..., rebar_spacing_auto_enabled: bool = ..., rebar_spacing_auto_minimum: _Optional[float] = ..., rebar_spacing_auto_maximum: _Optional[float] = ..., rebar_spacing_auto_increment: _Optional[float] = ..., rebar_spacing_auto_priority: _Optional[int] = ..., rebar_spacing_calculated: _Optional[float] = ..., stirrup_diameter: _Optional[float] = ..., stirrup_diameter_auto_enabled: bool = ..., stirrup_diameter_auto_minimum: _Optional[float] = ..., stirrup_diameter_auto_maximum: _Optional[float] = ..., stirrup_diameter_auto_diameters_enabled: bool = ..., stirrup_diameter_auto_diameters: _Optional[_Iterable[int]] = ..., stirrup_diameter_auto_priority: _Optional[int] = ..., stirrup_diameter_calculated: _Optional[float] = ..., stirrup_size: _Optional[float] = ..., stirrup_spacing: _Optional[float] = ..., stirrup_spacing_auto_enabled: bool = ..., stirrup_spacing_auto_minimum: _Optional[float] = ..., stirrup_spacing_auto_maximum: _Optional[float] = ..., stirrup_spacing_auto_increment: _Optional[float] = ..., stirrup_spacing_auto_priority: _Optional[int] = ..., stirrup_spacing_calculated: _Optional[float] = ..., mesh_product_range: _Optional[_Union[SurfaceReinforcement.MeshProductRange, str]] = ..., mesh_shape: _Optional[_Union[SurfaceReinforcement.MeshShape, str]] = ..., mesh_name: _Optional[str] = ..., additional_transverse_reinforcement_enabled: bool = ..., additional_rebar_diameter: _Optional[float] = ..., additional_rebar_diameter_auto_enabled: bool = ..., additional_rebar_diameter_auto_minimum: _Optional[float] = ..., additional_rebar_diameter_auto_maximum: _Optional[float] = ..., additional_rebar_diameter_auto_diameters_enabled: bool = ..., additional_rebar_diameter_auto_diameters: _Optional[_Iterable[int]] = ..., additional_rebar_diameter_auto_priority: _Optional[int] = ..., additional_rebar_diameter_calculated: _Optional[float] = ..., additional_rebar_size: _Optional[float] = ..., additional_rebar_spacing: _Optional[float] = ..., additional_rebar_spacing_auto_enabled: bool = ..., additional_rebar_spacing_auto_minimum: _Optional[float] = ..., additional_rebar_spacing_auto_maximum: _Optional[float] = ..., additional_rebar_spacing_auto_increment: _Optional[float] = ..., additional_rebar_spacing_auto_priority: _Optional[int] = ..., additional_rebar_spacing_calculated: _Optional[float] = ..., alignment_top_enabled: bool = ..., alignment_bottom_enabled: bool = ..., additional_offset_to_concrete_cover_top: _Optional[float] = ..., additional_offset_to_concrete_cover_bottom: _Optional[float] = ..., reinforcement_direction_type: _Optional[_Union[SurfaceReinforcement.ReinforcementDirectionType, str]] = ..., design_reinforcement_direction: _Optional[_Union[SurfaceReinforcement.DesignReinforcementDirection, str]] = ..., first_direction_point_1: _Optional[float] = ..., first_direction_point_2: _Optional[float] = ..., second_direction_point_1: _Optional[float] = ..., second_direction_point_2: _Optional[float] = ..., projection_coordinate_system: _Optional[int] = ..., projection_plane: _Optional[_Union[SurfaceReinforcement.ProjectionPlane, str]] = ..., reinforcement_area_as1: _Optional[float] = ..., reinforcement_area_as2: _Optional[float] = ..., reinforcement_area_as1_top: _Optional[float] = ..., reinforcement_area_as2_top: _Optional[float] = ..., reinforcement_area_as1_bottom: _Optional[float] = ..., reinforcement_area_as2_bottom: _Optional[float] = ..., reinforcement_area_as_i: _Optional[float] = ..., reinforcement_area_as_i_plus_90: _Optional[float] = ..., reinforcement_area_as_i_top: _Optional[float] = ..., reinforcement_area_as_i_bottom: _Optional[float] = ..., reinforcement_area_as_i_plus_90_top: _Optional[float] = ..., reinforcement_area_as_i_plus_90_bottom: _Optional[float] = ..., stirrup_reinforcement_area_asw: _Optional[float] = ..., acting_region_from: _Optional[float] = ..., acting_region_to: _Optional[float] = ..., location_rectangle_type: _Optional[_Union[SurfaceReinforcement.LocationRectangleType, str]] = ..., location_first_x: _Optional[float] = ..., location_first_y: _Optional[float] = ..., location_second_x: _Optional[float] = ..., location_second_y: _Optional[float] = ..., location_center_x: _Optional[float] = ..., location_center_y: _Optional[float] = ..., location_center_side_a: _Optional[float] = ..., location_center_side_b: _Optional[float] = ..., location_rotation: _Optional[float] = ..., location_radius: _Optional[float] = ..., polygon_points: _Optional[_Union[SurfaceReinforcement.PolygonPointsTable, _Mapping]] = ..., comment: _Optional[str] = ..., is_generated: bool = ..., generating_object_info: _Optional[str] = ..., stirrup_size_calculated: _Optional[_Union[SurfaceReinforcement.StirrupSizeCalculated, str]] = ..., stirrup_size_auto_minimum: _Optional[_Union[SurfaceReinforcement.StirrupSizeAutoMinimum, str]] = ..., stirrup_size_auto_maximum: _Optional[_Union[SurfaceReinforcement.StirrupSizeAutoMaximum, str]] = ..., rebar_size_calculated: _Optional[_Union[SurfaceReinforcement.RebarSizeCalculated, str]] = ..., rebar_size_auto_minimum: _Optional[_Union[SurfaceReinforcement.RebarSizeAutoMinimum, str]] = ..., rebar_size_auto_maximum: _Optional[_Union[SurfaceReinforcement.RebarSizeAutoMaximum, str]] = ..., additional_rebar_size_calculated: _Optional[_Union[SurfaceReinforcement.AdditionalRebarSizeCalculated, str]] = ..., additional_rebar_size_auto_minimum: _Optional[_Union[SurfaceReinforcement.AdditionalRebarSizeAutoMinimum, str]] = ..., additional_rebar_size_auto_maximum: _Optional[_Union[SurfaceReinforcement.AdditionalRebarSizeAutoMaximum, str]] = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
