from dlubal.api.common import common_pb2 as _common_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class MemberSet(_message.Message):
    __slots__ = ("no", "user_defined_name_enabled", "name", "set_type", "length", "center_of_gravity", "center_of_gravity_x", "center_of_gravity_y", "center_of_gravity_z", "position", "position_short", "comment", "is_generated", "generating_object_info", "volume", "mass", "member_set_representative", "discontinuous_torsional_warping", "steel_effective_lengths", "steel_boundary_conditions", "steel_member_local_section_reductions", "member_steel_design_uls_configuration", "member_steel_design_sls_configuration", "member_steel_design_fr_configuration", "member_steel_design_seismic_configuration", "aluminum_effective_lengths", "aluminum_boundary_conditions", "aluminum_member_local_section_reductions", "aluminum_member_transverse_weld", "member_aluminum_design_uls_configuration", "member_aluminum_design_sls_configuration", "member_set_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled", "concrete_shear_reinforcement_spans", "concrete_longitudinal_reinforcement_items", "concrete_cover_user_defined_enabled", "concrete_cover_different_at_section_sides_enabled", "concrete_cover", "concrete_cover_top", "concrete_cover_bottom", "concrete_cover_left", "concrete_cover_right", "concrete_cover_min", "concrete_cover_min_top", "concrete_cover_min_bottom", "concrete_cover_min_left", "concrete_cover_min_right", "concrete_durability", "concrete_durability_top", "concrete_durability_bottom", "concrete_durability_left", "concrete_durability_right", "concrete_effective_lengths", "member_concrete_design_uls_configuration", "member_concrete_design_sls_configuration", "member_concrete_design_fr_configuration", "member_concrete_design_seismic_configuration", "timber_effective_lengths", "service_class_timber_design", "moisture_class_timber_design", "service_conditions_timber_design", "timber_local_section_reductions", "member_timber_design_fr_configuration", "member_timber_design_sls_configuration", "member_timber_design_uls_configuration", "support", "member_transverse_stiffener", "member_openings", "stress_analysis_configuration", "deflection_check_direction", "deflection_check_displacement_reference", "design_support_on_member_set_start", "design_support_on_member_set_end", "design_supports_on_internal_nodes", "members", "deflection_segments_defined_length_y_axis_enabled", "deflection_segments_defined_length_z_axis_enabled", "deflection_segments_y_axis", "deflection_segments_z_axis", "design_properties_activated", "id_for_export_import", "metadata_for_export_import")
    class SetType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SET_TYPE_CONTINUOUS: _ClassVar[MemberSet.SetType]
        SET_TYPE_GROUP: _ClassVar[MemberSet.SetType]
    SET_TYPE_CONTINUOUS: MemberSet.SetType
    SET_TYPE_GROUP: MemberSet.SetType
    class DeflectionCheckDirection(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z: _ClassVar[MemberSet.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Y: _ClassVar[MemberSet.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z: _ClassVar[MemberSet.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z_AND_Y: _ClassVar[MemberSet.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Y: _ClassVar[MemberSet.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z_AND_Y: _ClassVar[MemberSet.DeflectionCheckDirection]
        DEFLECTION_CHECK_DIRECTION_RESULTING_AXIS: _ClassVar[MemberSet.DeflectionCheckDirection]
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z: MemberSet.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Y: MemberSet.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z: MemberSet.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_AUXILIARY_LOCAL_AXIS_Z_AND_Y: MemberSet.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Y: MemberSet.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_LOCAL_AXIS_Z_AND_Y: MemberSet.DeflectionCheckDirection
    DEFLECTION_CHECK_DIRECTION_RESULTING_AXIS: MemberSet.DeflectionCheckDirection
    class DeflectionCheckDisplacementReference(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_SEGMENT_ENDS: _ClassVar[MemberSet.DeflectionCheckDisplacementReference]
        DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_UNDEFORMED_SYSTEM: _ClassVar[MemberSet.DeflectionCheckDisplacementReference]
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_SEGMENT_ENDS: MemberSet.DeflectionCheckDisplacementReference
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_DEFORMED_UNDEFORMED_SYSTEM: MemberSet.DeflectionCheckDisplacementReference
    class ConcreteShearReinforcementSpansTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberSet.ConcreteShearReinforcementSpansRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberSet.ConcreteShearReinforcementSpansRow, _Mapping]]] = ...) -> None: ...
    class ConcreteShearReinforcementSpansRow(_message.Message):
        __slots__ = ("no", "description", "name", "stirrup_type", "material", "stirrup_count", "stirrup_bar_size", "stirrup_bar_size_calculated", "stirrup_diameter", "stirrup_diameter_calculated", "stirrup_diameter_auto_enabled", "stirrup_bar_size_auto_minimum", "stirrup_diameter_auto_minimum", "stirrup_bar_size_auto_maximum", "stirrup_diameter_auto_maximum", "stirrup_diameter_auto_diameters_enabled", "stirrup_diameter_auto_diameters", "stirrup_diameter_auto_priority", "stirrup_distances", "stirrup_distances_calculated", "stirrup_distances_auto_enabled", "stirrup_distances_auto_minimum", "stirrup_distances_auto_maximum", "stirrup_distances_auto_increment", "stirrup_distances_auto_priority", "crossties_active", "crossties_diameter", "reinforcement_area", "horizontal_crosstie_reinforcement_area", "minimal_maximal_horizontal_crosstie_reinforcement_area", "vertical_crosstie_reinforcement_area", "minimal_maximal_vertical_crosstie_reinforcement_area", "total_horizontal_reinforcement_area", "minimal_maximal_total_horizontal_reinforcement_area", "total_vertical_reinforcement_area", "minimal_maximal_total_vertical_reinforcement_area", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "stirrup_layout_rule", "stirrup_start_offset", "stirrup_end_offset", "one_stirrup_length", "minimal_and_maximal_stirrup_length", "all_stirrups_length", "one_stirrup_weight", "minimal_and_maximal_stirrup_weight", "all_stirrups_weight", "one_crosstie_length", "minimal_and_maximal_crosstie_length", "all_crossties_lenght", "one_crosstie_weight", "minimal_and_maximal_crosstie_weight", "all_crossties_weight")
        class StirrupType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OPEN: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
            STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType]
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_135: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_135: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_CLOSED_HOOK_90: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_FOUR_LEGGED_OVERLAP_HOOK_180: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_135: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_CLOSED_HOOK_90: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_THREE_LEGGED_OVERLAP_HOOK_180: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_CLOSED_HOOK_90: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OPEN: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        STIRRUP_TYPE_TWO_LEGGED_OVERLAP_HOOK_180: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        class StirrupBarSizeCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
            STIRRUP_BAR_SIZE_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated]
        STIRRUP_BAR_SIZE_CALCULATED_UNKNOWN: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_10: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_11: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_12: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_14: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_16: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_18: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_1p5: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_2p5: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_3: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_4: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_5: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_6: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_7: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_8: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_ACI_9: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_10: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_15: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_20: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_25: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_30: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_35: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_45: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        STIRRUP_BAR_SIZE_CALCULATED_CSA_55: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        class StirrupBarSizeAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum
        class StirrupBarSizeAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        class StirrupLayoutRule(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STIRRUP_LAYOUT_RULE_START_EQUALS_END: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_DEFINED: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_DEFINED: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
            STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: _ClassVar[MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule]
        STIRRUP_LAYOUT_RULE_START_EQUALS_END: MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_DEFINED: MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_END_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_DEFINED: MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        STIRRUP_LAYOUT_RULE_START_EQUALS_REST_LENGTH_TO_STIRRUP_DISTANCED: MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_COUNT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_BAR_SIZE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DIAMETER_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_DISTANCES_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_ACTIVE_FIELD_NUMBER: _ClassVar[int]
        CROSSTIES_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_HORIZONTAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_VERTICAL_CROSSTIE_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_HORIZONTAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_MAXIMAL_TOTAL_VERTICAL_REINFORCEMENT_AREA_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_LAYOUT_RULE_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_START_OFFSET_FIELD_NUMBER: _ClassVar[int]
        STIRRUP_END_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_STIRRUP_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_STIRRUPS_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_LENGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MINIMAL_AND_MAXIMAL_CROSSTIE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ALL_CROSSTIES_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        stirrup_type: MemberSet.ConcreteShearReinforcementSpansRow.StirrupType
        material: int
        stirrup_count: int
        stirrup_bar_size: float
        stirrup_bar_size_calculated: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated
        stirrup_diameter: float
        stirrup_diameter_calculated: float
        stirrup_diameter_auto_enabled: bool
        stirrup_bar_size_auto_minimum: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum
        stirrup_diameter_auto_minimum: float
        stirrup_bar_size_auto_maximum: MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum
        stirrup_diameter_auto_maximum: float
        stirrup_diameter_auto_diameters_enabled: bool
        stirrup_diameter_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        stirrup_diameter_auto_priority: int
        stirrup_distances: float
        stirrup_distances_calculated: float
        stirrup_distances_auto_enabled: bool
        stirrup_distances_auto_minimum: float
        stirrup_distances_auto_maximum: float
        stirrup_distances_auto_increment: float
        stirrup_distances_auto_priority: int
        crossties_active: bool
        crossties_diameter: float
        reinforcement_area: float
        horizontal_crosstie_reinforcement_area: float
        minimal_maximal_horizontal_crosstie_reinforcement_area: str
        vertical_crosstie_reinforcement_area: float
        minimal_maximal_vertical_crosstie_reinforcement_area: str
        total_horizontal_reinforcement_area: float
        minimal_maximal_total_horizontal_reinforcement_area: str
        total_vertical_reinforcement_area: float
        minimal_maximal_total_vertical_reinforcement_area: str
        span_position_reference_type: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        stirrup_layout_rule: MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule
        stirrup_start_offset: float
        stirrup_end_offset: float
        one_stirrup_length: float
        minimal_and_maximal_stirrup_length: str
        all_stirrups_length: float
        one_stirrup_weight: float
        minimal_and_maximal_stirrup_weight: str
        all_stirrups_weight: float
        one_crosstie_length: float
        minimal_and_maximal_crosstie_length: str
        all_crossties_lenght: float
        one_crosstie_weight: float
        minimal_and_maximal_crosstie_weight: str
        all_crossties_weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., stirrup_type: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.StirrupType, str]] = ..., material: _Optional[int] = ..., stirrup_count: _Optional[int] = ..., stirrup_bar_size: _Optional[float] = ..., stirrup_bar_size_calculated: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeCalculated, str]] = ..., stirrup_diameter: _Optional[float] = ..., stirrup_diameter_calculated: _Optional[float] = ..., stirrup_diameter_auto_enabled: bool = ..., stirrup_bar_size_auto_minimum: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMinimum, str]] = ..., stirrup_diameter_auto_minimum: _Optional[float] = ..., stirrup_bar_size_auto_maximum: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.StirrupBarSizeAutoMaximum, str]] = ..., stirrup_diameter_auto_maximum: _Optional[float] = ..., stirrup_diameter_auto_diameters_enabled: bool = ..., stirrup_diameter_auto_diameters: _Optional[_Iterable[int]] = ..., stirrup_diameter_auto_priority: _Optional[int] = ..., stirrup_distances: _Optional[float] = ..., stirrup_distances_calculated: _Optional[float] = ..., stirrup_distances_auto_enabled: bool = ..., stirrup_distances_auto_minimum: _Optional[float] = ..., stirrup_distances_auto_maximum: _Optional[float] = ..., stirrup_distances_auto_increment: _Optional[float] = ..., stirrup_distances_auto_priority: _Optional[int] = ..., crossties_active: bool = ..., crossties_diameter: _Optional[float] = ..., reinforcement_area: _Optional[float] = ..., horizontal_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_horizontal_crosstie_reinforcement_area: _Optional[str] = ..., vertical_crosstie_reinforcement_area: _Optional[float] = ..., minimal_maximal_vertical_crosstie_reinforcement_area: _Optional[str] = ..., total_horizontal_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_horizontal_reinforcement_area: _Optional[str] = ..., total_vertical_reinforcement_area: _Optional[float] = ..., minimal_maximal_total_vertical_reinforcement_area: _Optional[str] = ..., span_position_reference_type: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., stirrup_layout_rule: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansRow.StirrupLayoutRule, str]] = ..., stirrup_start_offset: _Optional[float] = ..., stirrup_end_offset: _Optional[float] = ..., one_stirrup_length: _Optional[float] = ..., minimal_and_maximal_stirrup_length: _Optional[str] = ..., all_stirrups_length: _Optional[float] = ..., one_stirrup_weight: _Optional[float] = ..., minimal_and_maximal_stirrup_weight: _Optional[str] = ..., all_stirrups_weight: _Optional[float] = ..., one_crosstie_length: _Optional[float] = ..., minimal_and_maximal_crosstie_length: _Optional[str] = ..., all_crossties_lenght: _Optional[float] = ..., one_crosstie_weight: _Optional[float] = ..., minimal_and_maximal_crosstie_weight: _Optional[str] = ..., all_crossties_weight: _Optional[float] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementItemsTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberSet.ConcreteLongitudinalReinforcementItemsRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow, _Mapping]]] = ...) -> None: ...
    class ConcreteLongitudinalReinforcementItemsRow(_message.Message):
        __slots__ = ("no", "description", "name", "rebar_type", "material", "reinforcement_placed_in_bending_corner_enabled", "bar_count_symmetrical", "bar_count_symmetrical_calculated", "bar_count_symmetrical_auto_enabled", "bar_count_symmetrical_auto_minimum", "bar_count_symmetrical_auto_maximum", "bar_count_symmetrical_auto_increment", "bar_count_symmetrical_auto_priority", "bar_count_unsymmetrical_at_side", "bar_count_unsymmetrical_top_side", "bar_count_unsymmetrical_top_side_calculated", "bar_count_unsymmetrical_top_side_auto_enabled", "bar_count_unsymmetrical_top_side_auto_minimum", "bar_count_unsymmetrical_top_side_auto_maximum", "bar_count_unsymmetrical_top_side_auto_increment", "bar_count_unsymmetrical_top_side_auto_priority", "bar_count_unsymmetrical_bottom_side", "bar_count_unsymmetrical_bottom_side_calculated", "bar_count_unsymmetrical_bottom_side_auto_enabled", "bar_count_unsymmetrical_bottom_side_auto_minimum", "bar_count_unsymmetrical_bottom_side_auto_maximum", "bar_count_unsymmetrical_bottom_side_auto_increment", "bar_count_unsymmetrical_bottom_side_auto_priority", "bar_count_uniformly_surrounding", "bar_count_uniformly_surrounding_calculated", "bar_count_uniformly_surrounding_auto_enabled", "bar_count_uniformly_surrounding_auto_minimum", "bar_count_uniformly_surrounding_auto_maximum", "bar_count_uniformly_surrounding_auto_increment", "bar_count_uniformly_surrounding_auto_priority", "bar_count_line", "bar_count_line_calculated", "bar_count_line_auto_enabled", "bar_count_line_auto_minimum", "bar_count_line_auto_maximum", "bar_count_line_auto_increment", "bar_count_line_auto_priority", "bar_count_corner", "bar_size_designation_symmetrical", "bar_size_designation_symmetrical_calculated", "bar_diameter_symmetrical", "bar_diameter_symmetrical_calculated", "bar_diameter_symmetrical_auto_enabled", "bar_size_designation_symmetrical_auto_minimum", "bar_diameter_symmetrical_auto_minimum", "bar_size_designation_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_maximum", "bar_diameter_symmetrical_auto_diameters_enabled", "bar_diameter_symmetrical_auto_diameters", "bar_diameter_symmetrical_auto_priority", "bar_size_designation_unsymmetrical_at_side", "bar_diameter_unsymmetrical_at_side", "bar_size_designation_unsymmetrical_top_side", "bar_size_designation_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side", "bar_diameter_unsymmetrical_top_side_calculated", "bar_diameter_unsymmetrical_top_side_auto_enabled", "bar_size_designation_unsymmetrical_top_side_auto_minimum", "bar_diameter_unsymmetrical_top_side_auto_minimum", "bar_size_designation_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_maximum", "bar_diameter_unsymmetrical_top_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_top_side_auto_diameters", "bar_diameter_unsymmetrical_top_side_auto_priority", "bar_size_designation_unsymmetrical_bottom_side", "bar_size_designation_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side", "bar_diameter_unsymmetrical_bottom_side_calculated", "bar_diameter_unsymmetrical_bottom_side_auto_enabled", "bar_size_designation_unsymmetrical_bottom_side_auto_minimum", "bar_diameter_unsymmetrical_bottom_side_auto_minimum", "bar_size_designation_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_maximum", "bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled", "bar_diameter_unsymmetrical_bottom_side_auto_diameters", "bar_diameter_unsymmetrical_bottom_side_auto_priority", "bar_size_designation_uniformly_surrounding", "bar_size_designation_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding", "bar_diameter_uniformly_surrounding_calculated", "bar_diameter_uniformly_surrounding_auto_enabled", "bar_size_designation_uniformly_surrounding_auto_minimum", "bar_diameter_uniformly_surrounding_auto_minimum", "bar_size_designation_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_maximum", "bar_diameter_uniformly_surrounding_auto_diameters_enabled", "bar_diameter_uniformly_surrounding_auto_diameters", "bar_diameter_uniformly_surrounding_auto_priority", "bar_size_designation_line", "bar_size_designation_line_calculated", "bar_diameter_line", "bar_diameter_line_calculated", "bar_diameter_line_auto_enabled", "bar_size_designation_line_auto_minimum", "bar_diameter_line_auto_minimum", "bar_size_designation_line_auto_maximum", "bar_diameter_line_auto_maximum", "bar_diameter_line_auto_diameters_enabled", "bar_diameter_line_auto_diameters", "bar_diameter_line_auto_priority", "bar_size_designation_single", "bar_size_designation_single_calculated", "bar_diameter_single", "bar_diameter_single_calculated", "bar_diameter_single_auto_enabled", "bar_size_designation_single_auto_minimum", "bar_diameter_single_auto_minimum", "bar_size_designation_single_auto_maximum", "bar_diameter_single_auto_maximum", "bar_diameter_single_auto_diameters_enabled", "bar_diameter_single_auto_diameters", "bar_diameter_single_auto_priority", "bar_size_designation_corner", "bar_diameter_corner", "base_diamter_reduced_multi_edit", "corner_reinforcement_enabled", "reinforcement_area_symmetrical", "reinforcement_area_unsymmetrical_at_side", "reinforcement_area_unsymmetrical_top_side", "reinforcement_area_unsymmetrical_bottom_side", "reinforcement_area_uniformly_surrounding", "reinforcement_area_line", "reinforcement_area_single", "reinforcement_area_corner", "reinforcement_area_total", "span_position_reference_type", "span_position_reference_internal_node", "span_position_reference_x_location_relative", "span_position_reference_x_location_absolute", "span_position_definition_format", "span_start_relative", "span_start_absolute", "span_start_auto_enabled", "span_start_relative_auto_calculated", "span_start_relative_auto_minimum", "span_start_relative_auto_maximum", "span_start_absolute_auto_calculated", "span_start_absolute_auto_minimum", "span_start_absolute_auto_maximum", "span_end_relative", "span_end_absolute", "span_end_auto_enabled", "span_end_relative_auto_calculated", "span_end_relative_auto_minimum", "span_end_relative_auto_maximum", "span_end_absolute_auto_calculated", "span_end_absolute_auto_minimum", "span_end_absolute_auto_maximum", "span_location_auto_increment", "span_location_auto_priority", "span_length", "additional_offset_type", "additional_offset_type_single_line", "additional_offset_circle", "additional_offset_top_side", "additional_offset_bottom_side", "additional_offset_left_side", "additional_offset_right_side", "additional_offset_reference_type", "additional_offset_reference_type_at_start", "additional_offset_reference_type_at_end", "additional_horizontal_offset", "additional_horizontal_offset_at_start", "additional_horizontal_offset_at_end", "additional_vertical_offset", "additional_vertical_offset_at_start", "additional_vertical_offset_at_end", "anchorage_start_anchor_type", "anchorage_start_anchor_length", "anchorage_start_bending_diameter", "anchorage_end_anchor_type", "anchorage_end_anchor_length", "anchorage_end_bending_diameter", "one_rebar_length", "one_rebar_minimal_and_maximal_length", "one_rebar_unsymmetrical_at_side_length", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_top_side_length", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_length", "one_rebar_unsymmetrical_bottom_side_length", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length", "one_rebar_corner_length", "one_rebar_corner_minimal_and_maximal_length", "length", "one_rebar_weight", "one_rebar_minimal_and_maximal_weight", "one_rebar_unsymmetrical_at_side_weight", "one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_top_side_weight", "one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight", "one_rebar_unsymmetrical_bottom_side_weight", "one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight", "one_rebar_corner_weight", "one_rebar_corner_minimal_and_maximal_weight", "weight")
        class RebarType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            REBAR_TYPE_SYMMETRICAL: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_LINE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_SINGLE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_UNIFORMLY_SURROUNDING: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType]
            REBAR_TYPE_UNSYMMETRICAL: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType]
        REBAR_TYPE_SYMMETRICAL: MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_LINE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_SINGLE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_UNIFORMLY_SURROUNDING: MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType
        REBAR_TYPE_UNSYMMETRICAL: MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType
        class BarSizeDesignationSymmetricalCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
            BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_11: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_12: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_14: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_16: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_18: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_1p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_2p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_3: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_4: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_6: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_7: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_8: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_ACI_9: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_15: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_20: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_25: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_30: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_35: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_45: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_CSA_55: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        class BarSizeDesignationSymmetricalAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum
        class BarSizeDesignationSymmetricalAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum
        class BarSizeDesignationUnsymmetricalAtSide(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide
        class BarSizeDesignationUnsymmetricalTopSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_11: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_12: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_14: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_16: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_18: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_1p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_2p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_3: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_4: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_6: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_7: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_8: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_ACI_9: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_15: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_20: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_25: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_30: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_35: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_45: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_CSA_55: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        class BarSizeDesignationUnsymmetricalTopSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        class BarSizeDesignationUnsymmetricalTopSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        class BarSizeDesignationUnsymmetricalBottomSideCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_11: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_12: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_14: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_16: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_18: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_1p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_2p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_3: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_4: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_6: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_7: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_8: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_ACI_9: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_15: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_20: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_25: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_30: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_35: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_45: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_CSA_55: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        class BarSizeDesignationUnsymmetricalBottomSideAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        class BarSizeDesignationUnsymmetricalBottomSideAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        class BarSizeDesignationUniformlySurroundingCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_11: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_12: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_14: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_16: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_18: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_1p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_2p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_3: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_4: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_6: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_7: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_8: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_ACI_9: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_15: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_20: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_25: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_30: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_35: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_45: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_CSA_55: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        class BarSizeDesignationUniformlySurroundingAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        class BarSizeDesignationUniformlySurroundingAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        class BarSizeDesignationLineCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
            BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_11: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_12: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_14: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_16: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_18: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_1p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_2p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_3: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_4: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_6: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_7: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_8: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_ACI_9: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_15: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_20: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_25: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_30: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_35: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_45: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_CSA_55: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        class BarSizeDesignationLineAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum
        class BarSizeDesignationLineAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum
        class BarSizeDesignationSingleCalculated(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
            BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_11: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_12: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_14: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_16: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_18: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_1p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_2p5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_3: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_4: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_5: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_6: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_7: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_8: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_ACI_9: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_10: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_15: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_20: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_25: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_30: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_35: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_45: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_CSA_55: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        class BarSizeDesignationSingleAutoMinimum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum
        class BarSizeDesignationSingleAutoMaximum(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum
        class BarSizeDesignationCorner(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner]
        BAR_SIZE_DESIGNATION_CORNER_UNKNOWN: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner
        class SpanPositionReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_REFERENCE_TYPE_START: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_END: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
            SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType]
        SPAN_POSITION_REFERENCE_TYPE_START: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_END: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_INTERNAL_NODE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        SPAN_POSITION_REFERENCE_TYPE_X_LOCATION: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        class SpanPositionDefinitionFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat]
            SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat]
        SPAN_POSITION_DEFINITION_FORMAT_ABSOLUTE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        SPAN_POSITION_DEFINITION_FORMAT_RELATIVE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        class AdditionalOffsetType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_NONE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
            ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType]
        ADDITIONAL_OFFSET_TYPE_NONE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_CONCRETE_COVER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_SECTION_SURFACE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        ADDITIONAL_OFFSET_TYPE_FROM_STIRRUP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        class AdditionalOffsetTypeSingleLine(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
            ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_NONE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_CONCRETE_COVER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_SECTION_SURFACE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FROM_STIRRUP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        class AdditionalOffsetReferenceType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_CENTER_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_LEFT_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        ADDITIONAL_OFFSET_REFERENCE_TYPE_RIGHT_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        class AdditionalOffsetReferenceTypeAtStart(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_CENTER_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_LEFT_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_RIGHT_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        class AdditionalOffsetReferenceTypeAtEnd(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
            ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_CENTER_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_LEFT_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_BOTTOM: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_CENTER: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_RIGHT_TOP: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        class AnchorageStartAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_START_ANCHOR_TYPE_NONE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_BEND: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
            ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType]
        ANCHORAGE_START_ANCHOR_TYPE_NONE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_BEND: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        ANCHORAGE_START_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        class AnchorageEndAnchorType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            ANCHORAGE_END_ANCHOR_TYPE_NONE: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_BEND: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
            ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: _ClassVar[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType]
        ANCHORAGE_END_ANCHOR_TYPE_NONE: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_BEND: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_HOOK_WITH_TRANSVERSE_BAR: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TRANSVERSE_BAR: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        ANCHORAGE_END_ANCHOR_TYPE_STRAIGHT_WITH_TWO_TRANSVERSE_BARS: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NAME_FIELD_NUMBER: _ClassVar[int]
        REBAR_TYPE_FIELD_NUMBER: _ClassVar[int]
        MATERIAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_PLACED_IN_BENDING_CORNER_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_COUNT_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SYMMETRICAL_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_TOP_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNSYMMETRICAL_BOTTOM_SIDE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_UNIFORMLY_SURROUNDING_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_LINE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_ENABLED_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_DIAMETERS_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_SINGLE_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        BAR_SIZE_DESIGNATION_CORNER_FIELD_NUMBER: _ClassVar[int]
        BAR_DIAMETER_CORNER_FIELD_NUMBER: _ClassVar[int]
        BASE_DIAMTER_REDUCED_MULTI_EDIT_FIELD_NUMBER: _ClassVar[int]
        CORNER_REINFORCEMENT_ENABLED_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SYMMETRICAL_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_AT_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNSYMMETRICAL_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_UNIFORMLY_SURROUNDING_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_LINE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_SINGLE_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_CORNER_FIELD_NUMBER: _ClassVar[int]
        REINFORCEMENT_AREA_TOTAL_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_INTERNAL_NODE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_REFERENCE_X_LOCATION_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_POSITION_DEFINITION_FORMAT_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_START_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_AUTO_ENABLED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_RELATIVE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_CALCULATED_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MINIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_END_ABSOLUTE_AUTO_MAXIMUM_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_INCREMENT_FIELD_NUMBER: _ClassVar[int]
        SPAN_LOCATION_AUTO_PRIORITY_FIELD_NUMBER: _ClassVar[int]
        SPAN_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TYPE_SINGLE_LINE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_CIRCLE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_TOP_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_BOTTOM_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_LEFT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_RIGHT_SIDE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_OFFSET_REFERENCE_TYPE_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_HORIZONTAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_START_FIELD_NUMBER: _ClassVar[int]
        ADDITIONAL_VERTICAL_OFFSET_AT_END_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_START_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_TYPE_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_ANCHOR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ANCHORAGE_END_BENDING_DIAMETER_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_LENGTH_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_AT_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_TOP_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_UNSYMMETRICAL_BOTTOM_SIDE_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        ONE_REBAR_CORNER_MINIMAL_AND_MAXIMAL_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        WEIGHT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        name: str
        rebar_type: MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType
        material: int
        reinforcement_placed_in_bending_corner_enabled: bool
        bar_count_symmetrical: int
        bar_count_symmetrical_calculated: int
        bar_count_symmetrical_auto_enabled: bool
        bar_count_symmetrical_auto_minimum: int
        bar_count_symmetrical_auto_maximum: int
        bar_count_symmetrical_auto_increment: int
        bar_count_symmetrical_auto_priority: int
        bar_count_unsymmetrical_at_side: int
        bar_count_unsymmetrical_top_side: int
        bar_count_unsymmetrical_top_side_calculated: int
        bar_count_unsymmetrical_top_side_auto_enabled: bool
        bar_count_unsymmetrical_top_side_auto_minimum: int
        bar_count_unsymmetrical_top_side_auto_maximum: int
        bar_count_unsymmetrical_top_side_auto_increment: int
        bar_count_unsymmetrical_top_side_auto_priority: int
        bar_count_unsymmetrical_bottom_side: int
        bar_count_unsymmetrical_bottom_side_calculated: int
        bar_count_unsymmetrical_bottom_side_auto_enabled: bool
        bar_count_unsymmetrical_bottom_side_auto_minimum: int
        bar_count_unsymmetrical_bottom_side_auto_maximum: int
        bar_count_unsymmetrical_bottom_side_auto_increment: int
        bar_count_unsymmetrical_bottom_side_auto_priority: int
        bar_count_uniformly_surrounding: int
        bar_count_uniformly_surrounding_calculated: int
        bar_count_uniformly_surrounding_auto_enabled: bool
        bar_count_uniformly_surrounding_auto_minimum: int
        bar_count_uniformly_surrounding_auto_maximum: int
        bar_count_uniformly_surrounding_auto_increment: int
        bar_count_uniformly_surrounding_auto_priority: int
        bar_count_line: int
        bar_count_line_calculated: int
        bar_count_line_auto_enabled: bool
        bar_count_line_auto_minimum: int
        bar_count_line_auto_maximum: int
        bar_count_line_auto_increment: int
        bar_count_line_auto_priority: int
        bar_count_corner: int
        bar_size_designation_symmetrical: float
        bar_size_designation_symmetrical_calculated: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated
        bar_diameter_symmetrical: float
        bar_diameter_symmetrical_calculated: float
        bar_diameter_symmetrical_auto_enabled: bool
        bar_size_designation_symmetrical_auto_minimum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum
        bar_diameter_symmetrical_auto_minimum: float
        bar_size_designation_symmetrical_auto_maximum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum
        bar_diameter_symmetrical_auto_maximum: float
        bar_diameter_symmetrical_auto_diameters_enabled: bool
        bar_diameter_symmetrical_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_symmetrical_auto_priority: int
        bar_size_designation_unsymmetrical_at_side: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide
        bar_diameter_unsymmetrical_at_side: float
        bar_size_designation_unsymmetrical_top_side: float
        bar_size_designation_unsymmetrical_top_side_calculated: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated
        bar_diameter_unsymmetrical_top_side: float
        bar_diameter_unsymmetrical_top_side_calculated: float
        bar_diameter_unsymmetrical_top_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_top_side_auto_minimum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum
        bar_diameter_unsymmetrical_top_side_auto_minimum: float
        bar_size_designation_unsymmetrical_top_side_auto_maximum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum
        bar_diameter_unsymmetrical_top_side_auto_maximum: float
        bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_top_side_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_unsymmetrical_top_side_auto_priority: int
        bar_size_designation_unsymmetrical_bottom_side: float
        bar_size_designation_unsymmetrical_bottom_side_calculated: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated
        bar_diameter_unsymmetrical_bottom_side: float
        bar_diameter_unsymmetrical_bottom_side_calculated: float
        bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool
        bar_size_designation_unsymmetrical_bottom_side_auto_minimum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum
        bar_diameter_unsymmetrical_bottom_side_auto_minimum: float
        bar_size_designation_unsymmetrical_bottom_side_auto_maximum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum
        bar_diameter_unsymmetrical_bottom_side_auto_maximum: float
        bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool
        bar_diameter_unsymmetrical_bottom_side_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_unsymmetrical_bottom_side_auto_priority: int
        bar_size_designation_uniformly_surrounding: float
        bar_size_designation_uniformly_surrounding_calculated: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated
        bar_diameter_uniformly_surrounding: float
        bar_diameter_uniformly_surrounding_calculated: float
        bar_diameter_uniformly_surrounding_auto_enabled: bool
        bar_size_designation_uniformly_surrounding_auto_minimum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum
        bar_diameter_uniformly_surrounding_auto_minimum: float
        bar_size_designation_uniformly_surrounding_auto_maximum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum
        bar_diameter_uniformly_surrounding_auto_maximum: float
        bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool
        bar_diameter_uniformly_surrounding_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_uniformly_surrounding_auto_priority: int
        bar_size_designation_line: float
        bar_size_designation_line_calculated: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated
        bar_diameter_line: float
        bar_diameter_line_calculated: float
        bar_diameter_line_auto_enabled: bool
        bar_size_designation_line_auto_minimum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum
        bar_diameter_line_auto_minimum: float
        bar_size_designation_line_auto_maximum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum
        bar_diameter_line_auto_maximum: float
        bar_diameter_line_auto_diameters_enabled: bool
        bar_diameter_line_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_line_auto_priority: int
        bar_size_designation_single: float
        bar_size_designation_single_calculated: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated
        bar_diameter_single: float
        bar_diameter_single_calculated: float
        bar_diameter_single_auto_enabled: bool
        bar_size_designation_single_auto_minimum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum
        bar_diameter_single_auto_minimum: float
        bar_size_designation_single_auto_maximum: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum
        bar_diameter_single_auto_maximum: float
        bar_diameter_single_auto_diameters_enabled: bool
        bar_diameter_single_auto_diameters: _containers.RepeatedScalarFieldContainer[int]
        bar_diameter_single_auto_priority: int
        bar_size_designation_corner: MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner
        bar_diameter_corner: float
        base_diamter_reduced_multi_edit: float
        corner_reinforcement_enabled: bool
        reinforcement_area_symmetrical: float
        reinforcement_area_unsymmetrical_at_side: float
        reinforcement_area_unsymmetrical_top_side: float
        reinforcement_area_unsymmetrical_bottom_side: float
        reinforcement_area_uniformly_surrounding: float
        reinforcement_area_line: float
        reinforcement_area_single: float
        reinforcement_area_corner: float
        reinforcement_area_total: float
        span_position_reference_type: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType
        span_position_reference_internal_node: int
        span_position_reference_x_location_relative: float
        span_position_reference_x_location_absolute: float
        span_position_definition_format: MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat
        span_start_relative: float
        span_start_absolute: float
        span_start_auto_enabled: bool
        span_start_relative_auto_calculated: float
        span_start_relative_auto_minimum: float
        span_start_relative_auto_maximum: float
        span_start_absolute_auto_calculated: float
        span_start_absolute_auto_minimum: float
        span_start_absolute_auto_maximum: float
        span_end_relative: float
        span_end_absolute: float
        span_end_auto_enabled: bool
        span_end_relative_auto_calculated: float
        span_end_relative_auto_minimum: float
        span_end_relative_auto_maximum: float
        span_end_absolute_auto_calculated: float
        span_end_absolute_auto_minimum: float
        span_end_absolute_auto_maximum: float
        span_location_auto_increment: float
        span_location_auto_priority: int
        span_length: float
        additional_offset_type: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType
        additional_offset_type_single_line: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine
        additional_offset_circle: float
        additional_offset_top_side: float
        additional_offset_bottom_side: float
        additional_offset_left_side: float
        additional_offset_right_side: float
        additional_offset_reference_type: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType
        additional_offset_reference_type_at_start: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart
        additional_offset_reference_type_at_end: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd
        additional_horizontal_offset: float
        additional_horizontal_offset_at_start: float
        additional_horizontal_offset_at_end: float
        additional_vertical_offset: float
        additional_vertical_offset_at_start: float
        additional_vertical_offset_at_end: float
        anchorage_start_anchor_type: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType
        anchorage_start_anchor_length: float
        anchorage_start_bending_diameter: float
        anchorage_end_anchor_type: MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType
        anchorage_end_anchor_length: float
        anchorage_end_bending_diameter: float
        one_rebar_length: float
        one_rebar_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_at_side_length: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_top_side_length: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: str
        one_rebar_unsymmetrical_bottom_side_length: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: str
        one_rebar_corner_length: float
        one_rebar_corner_minimal_and_maximal_length: str
        length: float
        one_rebar_weight: float
        one_rebar_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_at_side_weight: float
        one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_top_side_weight: float
        one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: str
        one_rebar_unsymmetrical_bottom_side_weight: float
        one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: str
        one_rebar_corner_weight: float
        one_rebar_corner_minimal_and_maximal_weight: str
        weight: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., name: _Optional[str] = ..., rebar_type: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.RebarType, str]] = ..., material: _Optional[int] = ..., reinforcement_placed_in_bending_corner_enabled: bool = ..., bar_count_symmetrical: _Optional[int] = ..., bar_count_symmetrical_calculated: _Optional[int] = ..., bar_count_symmetrical_auto_enabled: bool = ..., bar_count_symmetrical_auto_minimum: _Optional[int] = ..., bar_count_symmetrical_auto_maximum: _Optional[int] = ..., bar_count_symmetrical_auto_increment: _Optional[int] = ..., bar_count_symmetrical_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_at_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side: _Optional[int] = ..., bar_count_unsymmetrical_top_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_enabled: bool = ..., bar_count_unsymmetrical_top_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_calculated: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_count_unsymmetrical_bottom_side_auto_minimum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_maximum: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_increment: _Optional[int] = ..., bar_count_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_count_uniformly_surrounding: _Optional[int] = ..., bar_count_uniformly_surrounding_calculated: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_enabled: bool = ..., bar_count_uniformly_surrounding_auto_minimum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_maximum: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_increment: _Optional[int] = ..., bar_count_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_count_line: _Optional[int] = ..., bar_count_line_calculated: _Optional[int] = ..., bar_count_line_auto_enabled: bool = ..., bar_count_line_auto_minimum: _Optional[int] = ..., bar_count_line_auto_maximum: _Optional[int] = ..., bar_count_line_auto_increment: _Optional[int] = ..., bar_count_line_auto_priority: _Optional[int] = ..., bar_count_corner: _Optional[int] = ..., bar_size_designation_symmetrical: _Optional[float] = ..., bar_size_designation_symmetrical_calculated: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalCalculated, str]] = ..., bar_diameter_symmetrical: _Optional[float] = ..., bar_diameter_symmetrical_calculated: _Optional[float] = ..., bar_diameter_symmetrical_auto_enabled: bool = ..., bar_size_designation_symmetrical_auto_minimum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMinimum, str]] = ..., bar_diameter_symmetrical_auto_minimum: _Optional[float] = ..., bar_size_designation_symmetrical_auto_maximum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSymmetricalAutoMaximum, str]] = ..., bar_diameter_symmetrical_auto_maximum: _Optional[float] = ..., bar_diameter_symmetrical_auto_diameters_enabled: bool = ..., bar_diameter_symmetrical_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_symmetrical_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_at_side: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalAtSide, str]] = ..., bar_diameter_unsymmetrical_at_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_calculated: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideCalculated, str]] = ..., bar_diameter_unsymmetrical_top_side: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_top_side_auto_minimum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_top_side_auto_maximum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalTopSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_top_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_top_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_top_side_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_unsymmetrical_top_side_auto_priority: _Optional[int] = ..., bar_size_designation_unsymmetrical_bottom_side: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_calculated: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideCalculated, str]] = ..., bar_diameter_unsymmetrical_bottom_side: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_calculated: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_enabled: bool = ..., bar_size_designation_unsymmetrical_bottom_side_auto_minimum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMinimum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_minimum: _Optional[float] = ..., bar_size_designation_unsymmetrical_bottom_side_auto_maximum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUnsymmetricalBottomSideAutoMaximum, str]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_maximum: _Optional[float] = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters_enabled: bool = ..., bar_diameter_unsymmetrical_bottom_side_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_unsymmetrical_bottom_side_auto_priority: _Optional[int] = ..., bar_size_designation_uniformly_surrounding: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_calculated: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingCalculated, str]] = ..., bar_diameter_uniformly_surrounding: _Optional[float] = ..., bar_diameter_uniformly_surrounding_calculated: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_enabled: bool = ..., bar_size_designation_uniformly_surrounding_auto_minimum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMinimum, str]] = ..., bar_diameter_uniformly_surrounding_auto_minimum: _Optional[float] = ..., bar_size_designation_uniformly_surrounding_auto_maximum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationUniformlySurroundingAutoMaximum, str]] = ..., bar_diameter_uniformly_surrounding_auto_maximum: _Optional[float] = ..., bar_diameter_uniformly_surrounding_auto_diameters_enabled: bool = ..., bar_diameter_uniformly_surrounding_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_uniformly_surrounding_auto_priority: _Optional[int] = ..., bar_size_designation_line: _Optional[float] = ..., bar_size_designation_line_calculated: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineCalculated, str]] = ..., bar_diameter_line: _Optional[float] = ..., bar_diameter_line_calculated: _Optional[float] = ..., bar_diameter_line_auto_enabled: bool = ..., bar_size_designation_line_auto_minimum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMinimum, str]] = ..., bar_diameter_line_auto_minimum: _Optional[float] = ..., bar_size_designation_line_auto_maximum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationLineAutoMaximum, str]] = ..., bar_diameter_line_auto_maximum: _Optional[float] = ..., bar_diameter_line_auto_diameters_enabled: bool = ..., bar_diameter_line_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_line_auto_priority: _Optional[int] = ..., bar_size_designation_single: _Optional[float] = ..., bar_size_designation_single_calculated: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleCalculated, str]] = ..., bar_diameter_single: _Optional[float] = ..., bar_diameter_single_calculated: _Optional[float] = ..., bar_diameter_single_auto_enabled: bool = ..., bar_size_designation_single_auto_minimum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMinimum, str]] = ..., bar_diameter_single_auto_minimum: _Optional[float] = ..., bar_size_designation_single_auto_maximum: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationSingleAutoMaximum, str]] = ..., bar_diameter_single_auto_maximum: _Optional[float] = ..., bar_diameter_single_auto_diameters_enabled: bool = ..., bar_diameter_single_auto_diameters: _Optional[_Iterable[int]] = ..., bar_diameter_single_auto_priority: _Optional[int] = ..., bar_size_designation_corner: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.BarSizeDesignationCorner, str]] = ..., bar_diameter_corner: _Optional[float] = ..., base_diamter_reduced_multi_edit: _Optional[float] = ..., corner_reinforcement_enabled: bool = ..., reinforcement_area_symmetrical: _Optional[float] = ..., reinforcement_area_unsymmetrical_at_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_top_side: _Optional[float] = ..., reinforcement_area_unsymmetrical_bottom_side: _Optional[float] = ..., reinforcement_area_uniformly_surrounding: _Optional[float] = ..., reinforcement_area_line: _Optional[float] = ..., reinforcement_area_single: _Optional[float] = ..., reinforcement_area_corner: _Optional[float] = ..., reinforcement_area_total: _Optional[float] = ..., span_position_reference_type: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionReferenceType, str]] = ..., span_position_reference_internal_node: _Optional[int] = ..., span_position_reference_x_location_relative: _Optional[float] = ..., span_position_reference_x_location_absolute: _Optional[float] = ..., span_position_definition_format: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.SpanPositionDefinitionFormat, str]] = ..., span_start_relative: _Optional[float] = ..., span_start_absolute: _Optional[float] = ..., span_start_auto_enabled: bool = ..., span_start_relative_auto_calculated: _Optional[float] = ..., span_start_relative_auto_minimum: _Optional[float] = ..., span_start_relative_auto_maximum: _Optional[float] = ..., span_start_absolute_auto_calculated: _Optional[float] = ..., span_start_absolute_auto_minimum: _Optional[float] = ..., span_start_absolute_auto_maximum: _Optional[float] = ..., span_end_relative: _Optional[float] = ..., span_end_absolute: _Optional[float] = ..., span_end_auto_enabled: bool = ..., span_end_relative_auto_calculated: _Optional[float] = ..., span_end_relative_auto_minimum: _Optional[float] = ..., span_end_relative_auto_maximum: _Optional[float] = ..., span_end_absolute_auto_calculated: _Optional[float] = ..., span_end_absolute_auto_minimum: _Optional[float] = ..., span_end_absolute_auto_maximum: _Optional[float] = ..., span_location_auto_increment: _Optional[float] = ..., span_location_auto_priority: _Optional[int] = ..., span_length: _Optional[float] = ..., additional_offset_type: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetType, str]] = ..., additional_offset_type_single_line: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetTypeSingleLine, str]] = ..., additional_offset_circle: _Optional[float] = ..., additional_offset_top_side: _Optional[float] = ..., additional_offset_bottom_side: _Optional[float] = ..., additional_offset_left_side: _Optional[float] = ..., additional_offset_right_side: _Optional[float] = ..., additional_offset_reference_type: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceType, str]] = ..., additional_offset_reference_type_at_start: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtStart, str]] = ..., additional_offset_reference_type_at_end: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AdditionalOffsetReferenceTypeAtEnd, str]] = ..., additional_horizontal_offset: _Optional[float] = ..., additional_horizontal_offset_at_start: _Optional[float] = ..., additional_horizontal_offset_at_end: _Optional[float] = ..., additional_vertical_offset: _Optional[float] = ..., additional_vertical_offset_at_start: _Optional[float] = ..., additional_vertical_offset_at_end: _Optional[float] = ..., anchorage_start_anchor_type: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageStartAnchorType, str]] = ..., anchorage_start_anchor_length: _Optional[float] = ..., anchorage_start_bending_diameter: _Optional[float] = ..., anchorage_end_anchor_type: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsRow.AnchorageEndAnchorType, str]] = ..., anchorage_end_anchor_length: _Optional[float] = ..., anchorage_end_bending_diameter: _Optional[float] = ..., one_rebar_length: _Optional[float] = ..., one_rebar_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_length: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_length: _Optional[str] = ..., one_rebar_corner_length: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_length: _Optional[str] = ..., length: _Optional[float] = ..., one_rebar_weight: _Optional[float] = ..., one_rebar_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_at_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_at_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_top_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_top_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_unsymmetrical_bottom_side_weight: _Optional[float] = ..., one_rebar_unsymmetrical_bottom_side_minimal_and_maximal_weight: _Optional[str] = ..., one_rebar_corner_weight: _Optional[float] = ..., one_rebar_corner_minimal_and_maximal_weight: _Optional[str] = ..., weight: _Optional[float] = ...) -> None: ...
    class DesignSupportsOnInternalNodesTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberSet.DesignSupportsOnInternalNodesRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberSet.DesignSupportsOnInternalNodesRow, _Mapping]]] = ...) -> None: ...
    class DesignSupportsOnInternalNodesRow(_message.Message):
        __slots__ = ("no", "description", "node", "design_support")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        NODE_FIELD_NUMBER: _ClassVar[int]
        DESIGN_SUPPORT_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        node: str
        design_support: int
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., node: _Optional[str] = ..., design_support: _Optional[int] = ...) -> None: ...
    class DeflectionSegmentsYAxisTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberSet.DeflectionSegmentsYAxisRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberSet.DeflectionSegmentsYAxisRow, _Mapping]]] = ...) -> None: ...
    class DeflectionSegmentsYAxisRow(_message.Message):
        __slots__ = ("no", "description", "active", "length", "precamber", "segment_type")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ACTIVE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        PRECAMBER_FIELD_NUMBER: _ClassVar[int]
        SEGMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        active: bool
        length: float
        precamber: float
        segment_type: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., active: bool = ..., length: _Optional[float] = ..., precamber: _Optional[float] = ..., segment_type: _Optional[str] = ...) -> None: ...
    class DeflectionSegmentsZAxisTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[MemberSet.DeflectionSegmentsZAxisRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[MemberSet.DeflectionSegmentsZAxisRow, _Mapping]]] = ...) -> None: ...
    class DeflectionSegmentsZAxisRow(_message.Message):
        __slots__ = ("no", "description", "active", "length", "precamber", "segment_type")
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        ACTIVE_FIELD_NUMBER: _ClassVar[int]
        LENGTH_FIELD_NUMBER: _ClassVar[int]
        PRECAMBER_FIELD_NUMBER: _ClassVar[int]
        SEGMENT_TYPE_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        active: bool
        length: float
        precamber: float
        segment_type: str
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., active: bool = ..., length: _Optional[float] = ..., precamber: _Optional[float] = ..., segment_type: _Optional[str] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_NAME_ENABLED_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    SET_TYPE_FIELD_NUMBER: _ClassVar[int]
    LENGTH_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_X_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_Y_FIELD_NUMBER: _ClassVar[int]
    CENTER_OF_GRAVITY_Z_FIELD_NUMBER: _ClassVar[int]
    POSITION_FIELD_NUMBER: _ClassVar[int]
    POSITION_SHORT_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    IS_GENERATED_FIELD_NUMBER: _ClassVar[int]
    GENERATING_OBJECT_INFO_FIELD_NUMBER: _ClassVar[int]
    VOLUME_FIELD_NUMBER: _ClassVar[int]
    MASS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_SET_REPRESENTATIVE_FIELD_NUMBER: _ClassVar[int]
    DISCONTINUOUS_TORSIONAL_WARPING_FIELD_NUMBER: _ClassVar[int]
    STEEL_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    STEEL_BOUNDARY_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    STEEL_MEMBER_LOCAL_SECTION_REDUCTIONS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_STEEL_DESIGN_SEISMIC_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_BOUNDARY_CONDITIONS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_MEMBER_LOCAL_SECTION_REDUCTIONS_FIELD_NUMBER: _ClassVar[int]
    ALUMINUM_MEMBER_TRANSVERSE_WELD_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ALUMINUM_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_ALUMINUM_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_SET_RIB_GENERATING_LONGITUDINAL_REINFORCEMENT_ITEMS_FROM_SURFACES_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_SHEAR_REINFORCEMENT_SPANS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_LONGITUDINAL_REINFORCEMENT_ITEMS_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_USER_DEFINED_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_DIFFERENT_AT_SECTION_SIDES_ENABLED_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_COVER_MIN_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_TOP_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_BOTTOM_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_LEFT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_DURABILITY_RIGHT_FIELD_NUMBER: _ClassVar[int]
    CONCRETE_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_CONCRETE_DESIGN_SEISMIC_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    TIMBER_EFFECTIVE_LENGTHS_FIELD_NUMBER: _ClassVar[int]
    SERVICE_CLASS_TIMBER_DESIGN_FIELD_NUMBER: _ClassVar[int]
    MOISTURE_CLASS_TIMBER_DESIGN_FIELD_NUMBER: _ClassVar[int]
    SERVICE_CONDITIONS_TIMBER_DESIGN_FIELD_NUMBER: _ClassVar[int]
    TIMBER_LOCAL_SECTION_REDUCTIONS_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_FR_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_SLS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TIMBER_DESIGN_ULS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    SUPPORT_FIELD_NUMBER: _ClassVar[int]
    MEMBER_TRANSVERSE_STIFFENER_FIELD_NUMBER: _ClassVar[int]
    MEMBER_OPENINGS_FIELD_NUMBER: _ClassVar[int]
    STRESS_ANALYSIS_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_CHECK_DIRECTION_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_CHECK_DISPLACEMENT_REFERENCE_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORT_ON_MEMBER_SET_START_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORT_ON_MEMBER_SET_END_FIELD_NUMBER: _ClassVar[int]
    DESIGN_SUPPORTS_ON_INTERNAL_NODES_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_DEFINED_LENGTH_Y_AXIS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_DEFINED_LENGTH_Z_AXIS_ENABLED_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_Y_AXIS_FIELD_NUMBER: _ClassVar[int]
    DEFLECTION_SEGMENTS_Z_AXIS_FIELD_NUMBER: _ClassVar[int]
    DESIGN_PROPERTIES_ACTIVATED_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    user_defined_name_enabled: bool
    name: str
    set_type: MemberSet.SetType
    length: float
    center_of_gravity: _common_pb2.Vector3d
    center_of_gravity_x: float
    center_of_gravity_y: float
    center_of_gravity_z: float
    position: str
    position_short: str
    comment: str
    is_generated: bool
    generating_object_info: str
    volume: float
    mass: float
    member_set_representative: int
    discontinuous_torsional_warping: bool
    steel_effective_lengths: int
    steel_boundary_conditions: int
    steel_member_local_section_reductions: int
    member_steel_design_uls_configuration: int
    member_steel_design_sls_configuration: int
    member_steel_design_fr_configuration: int
    member_steel_design_seismic_configuration: int
    aluminum_effective_lengths: int
    aluminum_boundary_conditions: int
    aluminum_member_local_section_reductions: int
    aluminum_member_transverse_weld: int
    member_aluminum_design_uls_configuration: int
    member_aluminum_design_sls_configuration: int
    member_set_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled: bool
    concrete_shear_reinforcement_spans: MemberSet.ConcreteShearReinforcementSpansTable
    concrete_longitudinal_reinforcement_items: MemberSet.ConcreteLongitudinalReinforcementItemsTable
    concrete_cover_user_defined_enabled: bool
    concrete_cover_different_at_section_sides_enabled: bool
    concrete_cover: float
    concrete_cover_top: float
    concrete_cover_bottom: float
    concrete_cover_left: float
    concrete_cover_right: float
    concrete_cover_min: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_top: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_bottom: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_left: _containers.RepeatedScalarFieldContainer[int]
    concrete_cover_min_right: _containers.RepeatedScalarFieldContainer[int]
    concrete_durability: int
    concrete_durability_top: int
    concrete_durability_bottom: int
    concrete_durability_left: int
    concrete_durability_right: int
    concrete_effective_lengths: int
    member_concrete_design_uls_configuration: int
    member_concrete_design_sls_configuration: int
    member_concrete_design_fr_configuration: int
    member_concrete_design_seismic_configuration: int
    timber_effective_lengths: int
    service_class_timber_design: int
    moisture_class_timber_design: int
    service_conditions_timber_design: int
    timber_local_section_reductions: int
    member_timber_design_fr_configuration: int
    member_timber_design_sls_configuration: int
    member_timber_design_uls_configuration: int
    support: int
    member_transverse_stiffener: int
    member_openings: int
    stress_analysis_configuration: int
    deflection_check_direction: MemberSet.DeflectionCheckDirection
    deflection_check_displacement_reference: MemberSet.DeflectionCheckDisplacementReference
    design_support_on_member_set_start: int
    design_support_on_member_set_end: int
    design_supports_on_internal_nodes: MemberSet.DesignSupportsOnInternalNodesTable
    members: _containers.RepeatedScalarFieldContainer[int]
    deflection_segments_defined_length_y_axis_enabled: bool
    deflection_segments_defined_length_z_axis_enabled: bool
    deflection_segments_y_axis: MemberSet.DeflectionSegmentsYAxisTable
    deflection_segments_z_axis: MemberSet.DeflectionSegmentsZAxisTable
    design_properties_activated: bool
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., user_defined_name_enabled: bool = ..., name: _Optional[str] = ..., set_type: _Optional[_Union[MemberSet.SetType, str]] = ..., length: _Optional[float] = ..., center_of_gravity: _Optional[_Union[_common_pb2.Vector3d, _Mapping]] = ..., center_of_gravity_x: _Optional[float] = ..., center_of_gravity_y: _Optional[float] = ..., center_of_gravity_z: _Optional[float] = ..., position: _Optional[str] = ..., position_short: _Optional[str] = ..., comment: _Optional[str] = ..., is_generated: bool = ..., generating_object_info: _Optional[str] = ..., volume: _Optional[float] = ..., mass: _Optional[float] = ..., member_set_representative: _Optional[int] = ..., discontinuous_torsional_warping: bool = ..., steel_effective_lengths: _Optional[int] = ..., steel_boundary_conditions: _Optional[int] = ..., steel_member_local_section_reductions: _Optional[int] = ..., member_steel_design_uls_configuration: _Optional[int] = ..., member_steel_design_sls_configuration: _Optional[int] = ..., member_steel_design_fr_configuration: _Optional[int] = ..., member_steel_design_seismic_configuration: _Optional[int] = ..., aluminum_effective_lengths: _Optional[int] = ..., aluminum_boundary_conditions: _Optional[int] = ..., aluminum_member_local_section_reductions: _Optional[int] = ..., aluminum_member_transverse_weld: _Optional[int] = ..., member_aluminum_design_uls_configuration: _Optional[int] = ..., member_aluminum_design_sls_configuration: _Optional[int] = ..., member_set_rib_generating_longitudinal_reinforcement_items_from_surfaces_enabled: bool = ..., concrete_shear_reinforcement_spans: _Optional[_Union[MemberSet.ConcreteShearReinforcementSpansTable, _Mapping]] = ..., concrete_longitudinal_reinforcement_items: _Optional[_Union[MemberSet.ConcreteLongitudinalReinforcementItemsTable, _Mapping]] = ..., concrete_cover_user_defined_enabled: bool = ..., concrete_cover_different_at_section_sides_enabled: bool = ..., concrete_cover: _Optional[float] = ..., concrete_cover_top: _Optional[float] = ..., concrete_cover_bottom: _Optional[float] = ..., concrete_cover_left: _Optional[float] = ..., concrete_cover_right: _Optional[float] = ..., concrete_cover_min: _Optional[_Iterable[int]] = ..., concrete_cover_min_top: _Optional[_Iterable[int]] = ..., concrete_cover_min_bottom: _Optional[_Iterable[int]] = ..., concrete_cover_min_left: _Optional[_Iterable[int]] = ..., concrete_cover_min_right: _Optional[_Iterable[int]] = ..., concrete_durability: _Optional[int] = ..., concrete_durability_top: _Optional[int] = ..., concrete_durability_bottom: _Optional[int] = ..., concrete_durability_left: _Optional[int] = ..., concrete_durability_right: _Optional[int] = ..., concrete_effective_lengths: _Optional[int] = ..., member_concrete_design_uls_configuration: _Optional[int] = ..., member_concrete_design_sls_configuration: _Optional[int] = ..., member_concrete_design_fr_configuration: _Optional[int] = ..., member_concrete_design_seismic_configuration: _Optional[int] = ..., timber_effective_lengths: _Optional[int] = ..., service_class_timber_design: _Optional[int] = ..., moisture_class_timber_design: _Optional[int] = ..., service_conditions_timber_design: _Optional[int] = ..., timber_local_section_reductions: _Optional[int] = ..., member_timber_design_fr_configuration: _Optional[int] = ..., member_timber_design_sls_configuration: _Optional[int] = ..., member_timber_design_uls_configuration: _Optional[int] = ..., support: _Optional[int] = ..., member_transverse_stiffener: _Optional[int] = ..., member_openings: _Optional[int] = ..., stress_analysis_configuration: _Optional[int] = ..., deflection_check_direction: _Optional[_Union[MemberSet.DeflectionCheckDirection, str]] = ..., deflection_check_displacement_reference: _Optional[_Union[MemberSet.DeflectionCheckDisplacementReference, str]] = ..., design_support_on_member_set_start: _Optional[int] = ..., design_support_on_member_set_end: _Optional[int] = ..., design_supports_on_internal_nodes: _Optional[_Union[MemberSet.DesignSupportsOnInternalNodesTable, _Mapping]] = ..., members: _Optional[_Iterable[int]] = ..., deflection_segments_defined_length_y_axis_enabled: bool = ..., deflection_segments_defined_length_z_axis_enabled: bool = ..., deflection_segments_y_axis: _Optional[_Union[MemberSet.DeflectionSegmentsYAxisTable, _Mapping]] = ..., deflection_segments_z_axis: _Optional[_Union[MemberSet.DeflectionSegmentsZAxisTable, _Mapping]] = ..., design_properties_activated: bool = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
