# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.workspace_service_account_list_response_model import WorkspaceServiceAccountListResponseModel
from .api_keys.client import ApiKeysClient, AsyncApiKeysClient
from .raw_client import AsyncRawServiceAccountsClient, RawServiceAccountsClient


class ServiceAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawServiceAccountsClient(client_wrapper=client_wrapper)
        self.api_keys = ApiKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawServiceAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawServiceAccountsClient
        """
        return self._raw_client

    def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceServiceAccountListResponseModel:
        """
        List all service accounts in the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceServiceAccountListResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.service_accounts.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data


class AsyncServiceAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawServiceAccountsClient(client_wrapper=client_wrapper)
        self.api_keys = AsyncApiKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawServiceAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawServiceAccountsClient
        """
        return self._raw_client

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceServiceAccountListResponseModel:
        """
        List all service accounts in the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceServiceAccountListResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.service_accounts.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data
