# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .agent_transfer import AgentTransfer
from .phone_number_transfer import PhoneNumberTransfer


class SystemToolConfigInputParams_EndCall(UncheckedBaseModel):
    system_tool_type: typing.Literal["end_call"] = "end_call"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class SystemToolConfigInputParams_LanguageDetection(UncheckedBaseModel):
    system_tool_type: typing.Literal["language_detection"] = "language_detection"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class SystemToolConfigInputParams_PlayKeypadTouchTone(UncheckedBaseModel):
    system_tool_type: typing.Literal["play_keypad_touch_tone"] = "play_keypad_touch_tone"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class SystemToolConfigInputParams_SkipTurn(UncheckedBaseModel):
    system_tool_type: typing.Literal["skip_turn"] = "skip_turn"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class SystemToolConfigInputParams_TransferToAgent(UncheckedBaseModel):
    system_tool_type: typing.Literal["transfer_to_agent"] = "transfer_to_agent"
    transfers: typing.List[AgentTransfer]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class SystemToolConfigInputParams_TransferToNumber(UncheckedBaseModel):
    system_tool_type: typing.Literal["transfer_to_number"] = "transfer_to_number"
    transfers: typing.List[PhoneNumberTransfer]
    enable_client_message: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class SystemToolConfigInputParams_VoicemailDetection(UncheckedBaseModel):
    system_tool_type: typing.Literal["voicemail_detection"] = "voicemail_detection"
    voicemail_message: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


SystemToolConfigInputParams = typing_extensions.Annotated[
    typing.Union[
        SystemToolConfigInputParams_EndCall,
        SystemToolConfigInputParams_LanguageDetection,
        SystemToolConfigInputParams_PlayKeypadTouchTone,
        SystemToolConfigInputParams_SkipTurn,
        SystemToolConfigInputParams_TransferToAgent,
        SystemToolConfigInputParams_TransferToNumber,
        SystemToolConfigInputParams_VoicemailDetection,
    ],
    UnionMetadata(discriminant="system_tool_type"),
]
