# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.card_api_response_details import CardApiResponseDetails
from cardscan_client.models.card_api_response_enriched_results import CardApiResponseEnrichedResults
from cardscan_client.models.card_api_response_images import CardApiResponseImages
from cardscan_client.models.card_response_metadata import CardResponseMetadata
from cardscan_client.models.card_state import CardState
from cardscan_client.models.model_error import ModelError
from cardscan_client.models.payer_match import PayerMatch

class CardApiResponse(BaseModel):
    """
    CardApiResponse
    """
    card_id: StrictStr
    state: CardState
    created_at: datetime = Field(description="The timestamp when the eligibility response was created.")
    error: Optional[ModelError] = None
    payer_match: Optional[PayerMatch] = None
    metadata: Optional[CardResponseMetadata] = None
    images: Optional[CardApiResponseImages] = None
    deleted: StrictBool
    enriched_results: Optional[CardApiResponseEnrichedResults] = None
    details: Optional[CardApiResponseDetails] = None
    __properties: ClassVar[List[str]] = ["card_id", "state", "created_at", "error", "payer_match", "metadata", "images", "deleted", "enriched_results", "details"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardApiResponse:
        """Create an instance of CardApiResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payer_match
        if self.payer_match:
            _dict['payer_match'] = self.payer_match.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of images
        if self.images:
            _dict['images'] = self.images.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enriched_results
        if self.enriched_results:
            _dict['enriched_results'] = self.enriched_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict['details'] = self.details.to_dict()
        # set to None if images (nullable) is None
        # and model_fields_set contains the field
        if self.images is None and "images" in self.model_fields_set:
            _dict['images'] = None

        # set to None if enriched_results (nullable) is None
        # and model_fields_set contains the field
        if self.enriched_results is None and "enriched_results" in self.model_fields_set:
            _dict['enriched_results'] = None

        # set to None if details (nullable) is None
        # and model_fields_set contains the field
        if self.details is None and "details" in self.model_fields_set:
            _dict['details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CardApiResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "card_id": obj.get("card_id"),
            "state": obj.get("state"),
            "created_at": obj.get("created_at"),
            "error": ModelError.from_dict(obj.get("error")) if obj.get("error") is not None else None,
            "payer_match": PayerMatch.from_dict(obj.get("payer_match")) if obj.get("payer_match") is not None else None,
            "metadata": CardResponseMetadata.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None,
            "images": CardApiResponseImages.from_dict(obj.get("images")) if obj.get("images") is not None else None,
            "deleted": obj.get("deleted"),
            "enriched_results": CardApiResponseEnrichedResults.from_dict(obj.get("enriched_results")) if obj.get("enriched_results") is not None else None,
            "details": CardApiResponseDetails.from_dict(obj.get("details")) if obj.get("details") is not None else None
        })
        return _obj


