# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.match_score import MatchScore

class CardApiResponseDetails(BaseModel):
    """
    CardApiResponseDetails
    """
    group_number: Optional[MatchScore] = None
    member_number: Optional[MatchScore] = None
    payer_name: Optional[MatchScore] = None
    rx_bin: Optional[MatchScore] = None
    rx_pcn: Optional[MatchScore] = None
    member_name: Optional[MatchScore] = None
    dependent_names: Optional[List[MatchScore]] = None
    plan_name: Optional[MatchScore] = None
    plan_id: Optional[MatchScore] = None
    card_specific_id: Optional[MatchScore] = None
    client_name: Optional[MatchScore] = None
    payer_id: Optional[MatchScore] = None
    plan_details: Optional[MatchScore] = None
    rx_id: Optional[MatchScore] = None
    rx_issuer: Optional[MatchScore] = None
    rx_plan: Optional[MatchScore] = None
    start_date: Optional[MatchScore] = None
    employer: Optional[MatchScore] = None
    medicare_medicaid_id: Optional[MatchScore] = None
    member_dob: Optional[MatchScore] = None
    member_gender: Optional[MatchScore] = None
    member_id_prefix: Optional[MatchScore] = None
    member_id_suffix: Optional[MatchScore] = None
    part_a_effective_date: Optional[MatchScore] = None
    part_b_effective_date: Optional[MatchScore] = None
    pharmacy_benefit_manager: Optional[MatchScore] = None
    plan_type: Optional[MatchScore] = None
    __properties: ClassVar[List[str]] = ["group_number", "member_number", "payer_name", "rx_bin", "rx_pcn", "member_name", "dependent_names", "plan_name", "plan_id", "card_specific_id", "client_name", "payer_id", "plan_details", "rx_id", "rx_issuer", "rx_plan", "start_date", "employer", "medicare_medicaid_id", "member_dob", "member_gender", "member_id_prefix", "member_id_suffix", "part_a_effective_date", "part_b_effective_date", "pharmacy_benefit_manager", "plan_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardApiResponseDetails:
        """Create an instance of CardApiResponseDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group_number
        if self.group_number:
            _dict['group_number'] = self.group_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member_number
        if self.member_number:
            _dict['member_number'] = self.member_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payer_name
        if self.payer_name:
            _dict['payer_name'] = self.payer_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rx_bin
        if self.rx_bin:
            _dict['rx_bin'] = self.rx_bin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rx_pcn
        if self.rx_pcn:
            _dict['rx_pcn'] = self.rx_pcn.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member_name
        if self.member_name:
            _dict['member_name'] = self.member_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dependent_names (list)
        _items = []
        if self.dependent_names:
            for _item in self.dependent_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dependent_names'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan_name
        if self.plan_name:
            _dict['plan_name'] = self.plan_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_id
        if self.plan_id:
            _dict['plan_id'] = self.plan_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of card_specific_id
        if self.card_specific_id:
            _dict['card_specific_id'] = self.card_specific_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of client_name
        if self.client_name:
            _dict['client_name'] = self.client_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payer_id
        if self.payer_id:
            _dict['payer_id'] = self.payer_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_details
        if self.plan_details:
            _dict['plan_details'] = self.plan_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rx_id
        if self.rx_id:
            _dict['rx_id'] = self.rx_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rx_issuer
        if self.rx_issuer:
            _dict['rx_issuer'] = self.rx_issuer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rx_plan
        if self.rx_plan:
            _dict['rx_plan'] = self.rx_plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of start_date
        if self.start_date:
            _dict['start_date'] = self.start_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of employer
        if self.employer:
            _dict['employer'] = self.employer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of medicare_medicaid_id
        if self.medicare_medicaid_id:
            _dict['medicare_medicaid_id'] = self.medicare_medicaid_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member_dob
        if self.member_dob:
            _dict['member_dob'] = self.member_dob.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member_gender
        if self.member_gender:
            _dict['member_gender'] = self.member_gender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member_id_prefix
        if self.member_id_prefix:
            _dict['member_id_prefix'] = self.member_id_prefix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member_id_suffix
        if self.member_id_suffix:
            _dict['member_id_suffix'] = self.member_id_suffix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of part_a_effective_date
        if self.part_a_effective_date:
            _dict['part_a_effective_date'] = self.part_a_effective_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of part_b_effective_date
        if self.part_b_effective_date:
            _dict['part_b_effective_date'] = self.part_b_effective_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pharmacy_benefit_manager
        if self.pharmacy_benefit_manager:
            _dict['pharmacy_benefit_manager'] = self.pharmacy_benefit_manager.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan_type
        if self.plan_type:
            _dict['plan_type'] = self.plan_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CardApiResponseDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "group_number": MatchScore.from_dict(obj.get("group_number")) if obj.get("group_number") is not None else None,
            "member_number": MatchScore.from_dict(obj.get("member_number")) if obj.get("member_number") is not None else None,
            "payer_name": MatchScore.from_dict(obj.get("payer_name")) if obj.get("payer_name") is not None else None,
            "rx_bin": MatchScore.from_dict(obj.get("rx_bin")) if obj.get("rx_bin") is not None else None,
            "rx_pcn": MatchScore.from_dict(obj.get("rx_pcn")) if obj.get("rx_pcn") is not None else None,
            "member_name": MatchScore.from_dict(obj.get("member_name")) if obj.get("member_name") is not None else None,
            "dependent_names": [MatchScore.from_dict(_item) for _item in obj.get("dependent_names")] if obj.get("dependent_names") is not None else None,
            "plan_name": MatchScore.from_dict(obj.get("plan_name")) if obj.get("plan_name") is not None else None,
            "plan_id": MatchScore.from_dict(obj.get("plan_id")) if obj.get("plan_id") is not None else None,
            "card_specific_id": MatchScore.from_dict(obj.get("card_specific_id")) if obj.get("card_specific_id") is not None else None,
            "client_name": MatchScore.from_dict(obj.get("client_name")) if obj.get("client_name") is not None else None,
            "payer_id": MatchScore.from_dict(obj.get("payer_id")) if obj.get("payer_id") is not None else None,
            "plan_details": MatchScore.from_dict(obj.get("plan_details")) if obj.get("plan_details") is not None else None,
            "rx_id": MatchScore.from_dict(obj.get("rx_id")) if obj.get("rx_id") is not None else None,
            "rx_issuer": MatchScore.from_dict(obj.get("rx_issuer")) if obj.get("rx_issuer") is not None else None,
            "rx_plan": MatchScore.from_dict(obj.get("rx_plan")) if obj.get("rx_plan") is not None else None,
            "start_date": MatchScore.from_dict(obj.get("start_date")) if obj.get("start_date") is not None else None,
            "employer": MatchScore.from_dict(obj.get("employer")) if obj.get("employer") is not None else None,
            "medicare_medicaid_id": MatchScore.from_dict(obj.get("medicare_medicaid_id")) if obj.get("medicare_medicaid_id") is not None else None,
            "member_dob": MatchScore.from_dict(obj.get("member_dob")) if obj.get("member_dob") is not None else None,
            "member_gender": MatchScore.from_dict(obj.get("member_gender")) if obj.get("member_gender") is not None else None,
            "member_id_prefix": MatchScore.from_dict(obj.get("member_id_prefix")) if obj.get("member_id_prefix") is not None else None,
            "member_id_suffix": MatchScore.from_dict(obj.get("member_id_suffix")) if obj.get("member_id_suffix") is not None else None,
            "part_a_effective_date": MatchScore.from_dict(obj.get("part_a_effective_date")) if obj.get("part_a_effective_date") is not None else None,
            "part_b_effective_date": MatchScore.from_dict(obj.get("part_b_effective_date")) if obj.get("part_b_effective_date") is not None else None,
            "pharmacy_benefit_manager": MatchScore.from_dict(obj.get("pharmacy_benefit_manager")) if obj.get("pharmacy_benefit_manager") is not None else None,
            "plan_type": MatchScore.from_dict(obj.get("plan_type")) if obj.get("plan_type") is not None else None
        })
        return _obj


