# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.enriched_address_result_inner import EnrichedAddressResultInner
from cardscan_client.models.enriched_copay_result_inner import EnrichedCopayResultInner
from cardscan_client.models.enriched_phone_number_result_inner import EnrichedPhoneNumberResultInner

class CardApiResponseEnrichedResults(BaseModel):
    """
    Enriched data extracted from the insurance card using AI processing  # noqa: E501
    """
    addresses: Optional[List[EnrichedAddressResultInner]] = None
    phone_numbers: Optional[List[EnrichedPhoneNumberResultInner]] = None
    copays_deductibles: Optional[List[EnrichedCopayResultInner]] = None
    processed_sides: Optional[StrictStr] = Field(default=None, description="Indicates which sides of the card were processed")
    __properties: ClassVar[List[str]] = ["addresses", "phone_numbers", "copays_deductibles", "processed_sides"]

    @field_validator('processed_sides')
    def processed_sides_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('front_only', 'both'):
            raise ValueError("must be one of enum values ('front_only', 'both')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardApiResponseEnrichedResults:
        """Create an instance of CardApiResponseEnrichedResults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item in self.addresses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in phone_numbers (list)
        _items = []
        if self.phone_numbers:
            for _item in self.phone_numbers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['phone_numbers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in copays_deductibles (list)
        _items = []
        if self.copays_deductibles:
            for _item in self.copays_deductibles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['copays_deductibles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CardApiResponseEnrichedResults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addresses": [EnrichedAddressResultInner.from_dict(_item) for _item in obj.get("addresses")] if obj.get("addresses") is not None else None,
            "phone_numbers": [EnrichedPhoneNumberResultInner.from_dict(_item) for _item in obj.get("phone_numbers")] if obj.get("phone_numbers") is not None else None,
            "copays_deductibles": [EnrichedCopayResultInner.from_dict(_item) for _item in obj.get("copays_deductibles")] if obj.get("copays_deductibles") is not None else None,
            "processed_sides": obj.get("processed_sides")
        })
        return _obj


