# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated

class CustomPayerRecord(BaseModel):
    """
    CustomPayerRecord
    """
    custom_payer_id: Optional[StrictStr] = None
    custom_payer_name: Optional[StrictStr] = None
    custom_payer_name_alt: Optional[StrictStr] = None
    score: Optional[StrictStr] = None
    source: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["custom_payer_id", "custom_payer_name", "custom_payer_name_alt", "score", "source"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomPayerRecord:
        """Create an instance of CustomPayerRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if custom_payer_name_alt (nullable) is None
        # and model_fields_set contains the field
        if self.custom_payer_name_alt is None and "custom_payer_name_alt" in self.model_fields_set:
            _dict['custom_payer_name_alt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomPayerRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "custom_payer_id": obj.get("custom_payer_id"),
            "custom_payer_name": obj.get("custom_payer_name"),
            "custom_payer_name_alt": obj.get("custom_payer_name_alt"),
            "score": obj.get("score"),
            "source": obj.get("source")
        })
        return _obj


