# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.eligibility_api_response import EligibilityApiResponse
from cardscan_client.models.response_metadata import ResponseMetadata

class ListEligibility200Response(BaseModel):
    """
    ListEligibility200Response
    """
    eligibility_requests: List[EligibilityApiResponse]
    response_metadata: ResponseMetadata
    __properties: ClassVar[List[str]] = ["eligibility_requests", "response_metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ListEligibility200Response:
        """Create an instance of ListEligibility200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in eligibility_requests (list)
        _items = []
        if self.eligibility_requests:
            for _item in self.eligibility_requests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['eligibility_requests'] = _items
        # override the default output from pydantic by calling `to_dict()` of response_metadata
        if self.response_metadata:
            _dict['response_metadata'] = self.response_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListEligibility200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eligibility_requests": [EligibilityApiResponse.from_dict(_item) for _item in obj.get("eligibility_requests")] if obj.get("eligibility_requests") is not None else None,
            "response_metadata": ResponseMetadata.from_dict(obj.get("response_metadata")) if obj.get("response_metadata") is not None else None
        })
        return _obj


