# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.payer_match_matches_inner_metadata import PayerMatchMatchesInnerMetadata

class PayerMatchMatchesInner(BaseModel):
    """
    PayerMatchMatchesInner
    """
    clearinghouse: Optional[StrictStr] = None
    payer_id: Optional[StrictStr] = None
    payer_name: Optional[StrictStr] = None
    score: Optional[StrictStr] = None
    cardscan_payer_id: Optional[StrictStr] = None
    transaction_type: Optional[StrictStr] = None
    metadata: Optional[PayerMatchMatchesInnerMetadata] = None
    __properties: ClassVar[List[str]] = ["clearinghouse", "payer_id", "payer_name", "score", "cardscan_payer_id", "transaction_type", "metadata"]

    @field_validator('transaction_type')
    def transaction_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('professional', 'institutional', 'dental', 'workerscomp'):
            raise ValueError("must be one of enum values ('professional', 'institutional', 'dental', 'workerscomp')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PayerMatchMatchesInner:
        """Create an instance of PayerMatchMatchesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # set to None if payer_id (nullable) is None
        # and model_fields_set contains the field
        if self.payer_id is None and "payer_id" in self.model_fields_set:
            _dict['payer_id'] = None

        # set to None if transaction_type (nullable) is None
        # and model_fields_set contains the field
        if self.transaction_type is None and "transaction_type" in self.model_fields_set:
            _dict['transaction_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PayerMatchMatchesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clearinghouse": obj.get("clearinghouse"),
            "payer_id": obj.get("payer_id"),
            "payer_name": obj.get("payer_name"),
            "score": obj.get("score"),
            "cardscan_payer_id": obj.get("cardscan_payer_id"),
            "transaction_type": obj.get("transaction_type"),
            "metadata": PayerMatchMatchesInnerMetadata.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None
        })
        return _obj


