# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated

class ProviderDto(BaseModel):
    """
    A valid provider record must include either an `organization_name` or both a `first_name` and `last_name`.  The `npi` must always be exactly 10 numeric digits.   # noqa: E501
    """
    first_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=35)]] = Field(default=None, description="The provider's first name. Required if `organization_name` is not provided.  Must contain 1-35 alphanumeric characters.  ")
    last_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=60)]] = Field(default=None, description="The provider's last name. Required if `organization_name` is not provided.  Must contain 1-60 alphanumeric characters. ")
    npi: Annotated[str, Field(strict=True)] = Field(description="The National Provider Identifier (NPI), assigned by the Centers for Medicare & Medicaid Services.  This identifier is always a 10-digit numeric value.  Use the [NPI Registry](https://npiregistry.cms.hhs.gov/search) to verify or look up NPI details. ")
    organization_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=60)]] = Field(default=None, description="The name of the provider's organization. Required if both `first_name` and `last_name` are not provided.  Must contain up to 60 characters. ")
    __properties: ClassVar[List[str]] = ["first_name", "last_name", "npi", "organization_name"]

    @field_validator('npi')
    def npi_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{10}$", value):
            raise ValueError(r"must validate the regular expression /^\d{10}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProviderDto:
        """Create an instance of ProviderDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProviderDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "npi": obj.get("npi"),
            "organization_name": obj.get("organization_name")
        })
        return _obj


