# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.scan_metadata_camera_capabilities_aspect_ratio import ScanMetadataCameraCapabilitiesAspectRatio

class ScanMetadataCameraCapabilities(BaseModel):
    """
    Camera capabilities  # noqa: E501
    """
    aspect_ratio: Optional[ScanMetadataCameraCapabilitiesAspectRatio] = Field(default=None, alias="aspectRatio")
    device_id: Optional[StrictStr] = Field(default=None, alias="deviceId")
    facing_mode: Optional[List[StrictStr]] = Field(default=None, alias="facingMode")
    frame_rate: Optional[ScanMetadataCameraCapabilitiesAspectRatio] = Field(default=None, alias="frameRate")
    group_id: Optional[StrictStr] = Field(default=None, alias="groupId")
    height: Optional[ScanMetadataCameraCapabilitiesAspectRatio] = None
    resize_mode: Optional[List[StrictStr]] = Field(default=None, alias="resizeMode")
    width: Optional[ScanMetadataCameraCapabilitiesAspectRatio] = None
    __properties: ClassVar[List[str]] = ["aspectRatio", "deviceId", "facingMode", "frameRate", "groupId", "height", "resizeMode", "width"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScanMetadataCameraCapabilities:
        """Create an instance of ScanMetadataCameraCapabilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aspect_ratio
        if self.aspect_ratio:
            _dict['aspectRatio'] = self.aspect_ratio.to_dict()
        # override the default output from pydantic by calling `to_dict()` of frame_rate
        if self.frame_rate:
            _dict['frameRate'] = self.frame_rate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of height
        if self.height:
            _dict['height'] = self.height.to_dict()
        # override the default output from pydantic by calling `to_dict()` of width
        if self.width:
            _dict['width'] = self.width.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScanMetadataCameraCapabilities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aspect_ratio": ScanMetadataCameraCapabilitiesAspectRatio.from_dict(obj.get("aspectRatio")) if obj.get("aspectRatio") is not None else None,
            "device_id": obj.get("deviceId"),
            "facing_mode": obj.get("facingMode"),
            "frame_rate": ScanMetadataCameraCapabilitiesAspectRatio.from_dict(obj.get("frameRate")) if obj.get("frameRate") is not None else None,
            "group_id": obj.get("groupId"),
            "height": ScanMetadataCameraCapabilitiesAspectRatio.from_dict(obj.get("height")) if obj.get("height") is not None else None,
            "resize_mode": obj.get("resizeMode"),
            "width": ScanMetadataCameraCapabilitiesAspectRatio.from_dict(obj.get("width")) if obj.get("width") is not None else None
        })
        return _obj


