# coding: utf-8

"""
    CardScan API

    The official documentation for the CardScan API Clients.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator, StrictBool, StrictStr, StrictInt, StrictFloat
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self, Annotated
from cardscan_client.models.co_insurance import CoInsurance
from cardscan_client.models.co_payment import CoPayment
from cardscan_client.models.deductible import Deductible
from cardscan_client.models.oop import OOP

class Service(BaseModel):
    """
    Service
    """
    individual_deductible_in_network: Optional[Deductible] = None
    individual_deductible_out_network: Optional[Deductible] = None
    individual_oop_in_network: Optional[OOP] = None
    individual_oop_out_network: Optional[OOP] = None
    family_deductible_in_network: Optional[Deductible] = None
    family_deductible_out_network: Optional[Deductible] = None
    family_oop_in_network: Optional[OOP] = None
    family_oop_out_network: Optional[OOP] = None
    co_insurance_in_network: Optional[CoInsurance] = None
    co_insurance_out_network: Optional[CoInsurance] = None
    co_payment_out_network: Optional[CoPayment] = None
    co_payment_in_network: Optional[CoPayment] = None
    service_code: Optional[StrictStr] = Field(default=None, description="The service code.")
    __properties: ClassVar[List[str]] = ["individual_deductible_in_network", "individual_deductible_out_network", "individual_oop_in_network", "individual_oop_out_network", "family_deductible_in_network", "family_deductible_out_network", "family_oop_in_network", "family_oop_out_network", "co_insurance_in_network", "co_insurance_out_network", "co_payment_out_network", "co_payment_in_network", "service_code"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def _json_serializer(self, obj):
        """JSON serializer function for datetime objects"""
        if isinstance(obj, datetime):
            return obj.isoformat()

        raise TypeError(f"Type {type(obj)} not serializable")

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Service:
        """Create an instance of Service from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([

        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of individual_deductible_in_network
        if self.individual_deductible_in_network:
            _dict['individual_deductible_in_network'] = self.individual_deductible_in_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of individual_deductible_out_network
        if self.individual_deductible_out_network:
            _dict['individual_deductible_out_network'] = self.individual_deductible_out_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of individual_oop_in_network
        if self.individual_oop_in_network:
            _dict['individual_oop_in_network'] = self.individual_oop_in_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of individual_oop_out_network
        if self.individual_oop_out_network:
            _dict['individual_oop_out_network'] = self.individual_oop_out_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of family_deductible_in_network
        if self.family_deductible_in_network:
            _dict['family_deductible_in_network'] = self.family_deductible_in_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of family_deductible_out_network
        if self.family_deductible_out_network:
            _dict['family_deductible_out_network'] = self.family_deductible_out_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of family_oop_in_network
        if self.family_oop_in_network:
            _dict['family_oop_in_network'] = self.family_oop_in_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of family_oop_out_network
        if self.family_oop_out_network:
            _dict['family_oop_out_network'] = self.family_oop_out_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of co_insurance_in_network
        if self.co_insurance_in_network:
            _dict['co_insurance_in_network'] = self.co_insurance_in_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of co_insurance_out_network
        if self.co_insurance_out_network:
            _dict['co_insurance_out_network'] = self.co_insurance_out_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of co_payment_out_network
        if self.co_payment_out_network:
            _dict['co_payment_out_network'] = self.co_payment_out_network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of co_payment_in_network
        if self.co_payment_in_network:
            _dict['co_payment_in_network'] = self.co_payment_in_network.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Service from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "individual_deductible_in_network": Deductible.from_dict(obj.get("individual_deductible_in_network")) if obj.get("individual_deductible_in_network") is not None else None,
            "individual_deductible_out_network": Deductible.from_dict(obj.get("individual_deductible_out_network")) if obj.get("individual_deductible_out_network") is not None else None,
            "individual_oop_in_network": OOP.from_dict(obj.get("individual_oop_in_network")) if obj.get("individual_oop_in_network") is not None else None,
            "individual_oop_out_network": OOP.from_dict(obj.get("individual_oop_out_network")) if obj.get("individual_oop_out_network") is not None else None,
            "family_deductible_in_network": Deductible.from_dict(obj.get("family_deductible_in_network")) if obj.get("family_deductible_in_network") is not None else None,
            "family_deductible_out_network": Deductible.from_dict(obj.get("family_deductible_out_network")) if obj.get("family_deductible_out_network") is not None else None,
            "family_oop_in_network": OOP.from_dict(obj.get("family_oop_in_network")) if obj.get("family_oop_in_network") is not None else None,
            "family_oop_out_network": OOP.from_dict(obj.get("family_oop_out_network")) if obj.get("family_oop_out_network") is not None else None,
            "co_insurance_in_network": CoInsurance.from_dict(obj.get("co_insurance_in_network")) if obj.get("co_insurance_in_network") is not None else None,
            "co_insurance_out_network": CoInsurance.from_dict(obj.get("co_insurance_out_network")) if obj.get("co_insurance_out_network") is not None else None,
            "co_payment_out_network": CoPayment.from_dict(obj.get("co_payment_out_network")) if obj.get("co_payment_out_network") is not None else None,
            "co_payment_in_network": CoPayment.from_dict(obj.get("co_payment_in_network")) if obj.get("co_payment_in_network") is not None else None,
            "service_code": obj.get("service_code")
        })
        return _obj


