import os
import argparse

def main():
	parser = argparse.ArgumentParser(prog='animageo', description='Converting GeoGebra construction file into SVG image.')
	parser.add_argument('ggbfile',
						help='GeoGebra file to convert')
	parser.add_argument('-o', '--output', type=str,
						help="SVG file to export into")
	parser.add_argument('-px', nargs=2,
						help="image width and height in px (values: num or auto)")
	parser.add_argument('-s', '--style', type=str, default='pandora.json',
						help="JSON file with style definitions")
	parser.add_argument('-d', '--debug', action='store_true',
						help="print options")

	args = parser.parse_args()

	def create_tempfile_for_manim():
		f = open('temp.py', 'w')
		f.write('''\
      
#this file has been autogenerated by AnimaGeo

from animageo import *

class Scene(AnimaGeoScene):
    def construct(self):
        self.loadGeoGebra(''' + "'" + args.ggbfile + "'" + ''', style_json_file = ''' + "'" + args.style + "'" + ''', px_size = ''' + str(args.px) + ''', debug = ''' + "'" + str(args.debug) + "'" + ''')
        #print(self.geo)
        self.exportSVG(''' + "'" + args.output + "')"
        
        )
		f.close()

	if 'ggbfile' in args:
		if not os.path.exists(args.ggbfile):
			print('not finded ggb file: ' + args.ggbfile)
			exit(-1)

		if args.style is None:
			args.__setattr__('style', 'default.json')

		if not os.path.exists(args.style):
			print('not finded style file: ' + args.style)
			exit(-1)
			
		if args.output is None:
			args.__setattr__('output', args.ggbfile.replace('.ggb', '.svg'))
			
		if args.px is None:
			args.__setattr__('px', [640, 480])

		create_tempfile_for_manim()
		
		if args.debug:
			print('FROM:  ', args.ggbfile)
			print('TO:    ', args.output)
			print('SIZE:  ', args.px)
			print('STYLE: ', args.style)
		
		print('Running manim... [be patient, first run may take a longer time]')
		os.system('manim temp.py Pandora')
		
		print('-----------------')
		print("SVG file exported: '" + args.ggbfile.replace('.ggb', '.svg') + "'\n\n")

if __name__ == '__main__':
    main()