"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)


DEFINITION = """
query DatabaseAccessManager {
  namespaces_v1 {
    name
    cluster {
      name
      serverUrl
      automationToken {
        path
        field
        version
        format
      }
      internal
    }
    externalResources {
      provider
      provisioner {
        name
      }
      ... on NamespaceTerraformProviderResourceAWS_v1 {
        resources {
          provider
          ... on NamespaceTerraformResourceRDS_v1 {
            region
            identifier
            defaults
            output_resource_name
            database_access {
              username
              name
              database
              delete
              access {
                grants
                target {
                  dbschema
                }
              }
            }
          }
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class VaultSecretV1(ConfiguredBaseModel):
    path: str = Field(..., alias="path")
    field: str = Field(..., alias="field")
    version: Optional[int] = Field(..., alias="version")
    q_format: Optional[str] = Field(..., alias="format")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server_url: str = Field(..., alias="serverUrl")
    automation_token: Optional[VaultSecretV1] = Field(..., alias="automationToken")
    internal: Optional[bool] = Field(..., alias="internal")


class ExternalResourcesProvisionerV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class NamespaceExternalResourceV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")
    provisioner: ExternalResourcesProvisionerV1 = Field(..., alias="provisioner")


class NamespaceTerraformResourceAWSV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class DatabaseAccessAccessGranteeV1(ConfiguredBaseModel):
    dbschema: str = Field(..., alias="dbschema")


class DatabaseAccessAccessV1(ConfiguredBaseModel):
    grants: list[str] = Field(..., alias="grants")
    target: DatabaseAccessAccessGranteeV1 = Field(..., alias="target")


class DatabaseAccessV1(ConfiguredBaseModel):
    username: str = Field(..., alias="username")
    name: str = Field(..., alias="name")
    database: str = Field(..., alias="database")
    delete: Optional[bool] = Field(..., alias="delete")
    access: Optional[list[DatabaseAccessAccessV1]] = Field(..., alias="access")


class NamespaceTerraformResourceRDSV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    database_access: Optional[list[DatabaseAccessV1]] = Field(..., alias="database_access")


class NamespaceTerraformProviderResourceAWSV1(NamespaceExternalResourceV1):
    resources: list[Union[NamespaceTerraformResourceRDSV1, NamespaceTerraformResourceAWSV1]] = Field(..., alias="resources")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    cluster: ClusterV1 = Field(..., alias="cluster")
    external_resources: Optional[list[Union[NamespaceTerraformProviderResourceAWSV1, NamespaceExternalResourceV1]]] = Field(..., alias="externalResources")


class DatabaseAccessManagerQueryData(ConfiguredBaseModel):
    namespaces_v1: Optional[list[NamespaceV1]] = Field(..., alias="namespaces_v1")


def query(query_func: Callable, **kwargs: Any) -> DatabaseAccessManagerQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        DatabaseAccessManagerQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return DatabaseAccessManagerQueryData(**raw_data)
