import dataclasses as dc
import typing as ta

from omlish import lang

from .... import minichain as mc
from ..base import Session


##


DEFAULT_CHAT_MODEL_BACKEND = 'openai'

CHAT_CHOICES_SERVICE_FACTORIES: ta.Mapping[str, ta.Callable[..., mc.ChatChoicesService]] = {}


##


ChatOption: ta.TypeAlias = mc.ChatChoicesOptions
ChatOptions = ta.NewType('ChatOptions', ta.Sequence[ChatOption])

ChatSessionConfigT = ta.TypeVar('ChatSessionConfigT', bound='ChatSession.Config')


class ChatSession(Session[ChatSessionConfigT], lang.Abstract, ta.Generic[ChatSessionConfigT]):  # noqa
    @dc.dataclass(frozen=True)
    class Config(Session.Config, lang.Abstract):
        pass

    def __init__(
            self,
            config: ChatSessionConfigT,
    ) -> None:
        super().__init__(config)
